# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ChannelCustomerManagedS3Args',
    'ChannelCustomerManagedS3ArgsDict',
    'ChannelRetentionPeriodArgs',
    'ChannelRetentionPeriodArgsDict',
    'ChannelServiceManagedS3Args',
    'ChannelServiceManagedS3ArgsDict',
    'ChannelStorageArgs',
    'ChannelStorageArgsDict',
    'DatasetActionArgs',
    'DatasetActionArgsDict',
    'DatasetContainerActionArgs',
    'DatasetContainerActionArgsDict',
    'DatasetContentDeliveryRuleDestinationArgs',
    'DatasetContentDeliveryRuleDestinationArgsDict',
    'DatasetContentDeliveryRuleArgs',
    'DatasetContentDeliveryRuleArgsDict',
    'DatasetContentVersionValueArgs',
    'DatasetContentVersionValueArgsDict',
    'DatasetDeltaTimeSessionWindowConfigurationArgs',
    'DatasetDeltaTimeSessionWindowConfigurationArgsDict',
    'DatasetDeltaTimeArgs',
    'DatasetDeltaTimeArgsDict',
    'DatasetFilterArgs',
    'DatasetFilterArgsDict',
    'DatasetGlueConfigurationArgs',
    'DatasetGlueConfigurationArgsDict',
    'DatasetIotEventsDestinationConfigurationArgs',
    'DatasetIotEventsDestinationConfigurationArgsDict',
    'DatasetLateDataRuleConfigurationArgs',
    'DatasetLateDataRuleConfigurationArgsDict',
    'DatasetLateDataRuleArgs',
    'DatasetLateDataRuleArgsDict',
    'DatasetOutputFileUriValueArgs',
    'DatasetOutputFileUriValueArgsDict',
    'DatasetQueryActionArgs',
    'DatasetQueryActionArgsDict',
    'DatasetResourceConfigurationArgs',
    'DatasetResourceConfigurationArgsDict',
    'DatasetRetentionPeriodArgs',
    'DatasetRetentionPeriodArgsDict',
    'DatasetS3DestinationConfigurationArgs',
    'DatasetS3DestinationConfigurationArgsDict',
    'DatasetScheduleArgs',
    'DatasetScheduleArgsDict',
    'DatasetTriggeringDatasetArgs',
    'DatasetTriggeringDatasetArgsDict',
    'DatasetTriggerArgs',
    'DatasetTriggerArgsDict',
    'DatasetVariableArgs',
    'DatasetVariableArgsDict',
    'DatasetVersioningConfigurationArgs',
    'DatasetVersioningConfigurationArgsDict',
    'DatastoreColumnArgs',
    'DatastoreColumnArgsDict',
    'DatastoreCustomerManagedS3StorageArgs',
    'DatastoreCustomerManagedS3StorageArgsDict',
    'DatastoreCustomerManagedS3Args',
    'DatastoreCustomerManagedS3ArgsDict',
    'DatastoreFileFormatConfigurationArgs',
    'DatastoreFileFormatConfigurationArgsDict',
    'DatastoreIotSiteWiseMultiLayerStorageArgs',
    'DatastoreIotSiteWiseMultiLayerStorageArgsDict',
    'DatastoreJsonConfigurationArgs',
    'DatastoreJsonConfigurationArgsDict',
    'DatastoreParquetConfigurationArgs',
    'DatastoreParquetConfigurationArgsDict',
    'DatastorePartitionsArgs',
    'DatastorePartitionsArgsDict',
    'DatastorePartitionArgs',
    'DatastorePartitionArgsDict',
    'DatastoreRetentionPeriodArgs',
    'DatastoreRetentionPeriodArgsDict',
    'DatastoreSchemaDefinitionArgs',
    'DatastoreSchemaDefinitionArgsDict',
    'DatastoreServiceManagedS3Args',
    'DatastoreServiceManagedS3ArgsDict',
    'DatastoreStorageArgs',
    'DatastoreStorageArgsDict',
    'DatastoreTimestampPartitionArgs',
    'DatastoreTimestampPartitionArgsDict',
    'PartitionArgs',
    'PartitionArgsDict',
    'PipelineActivityArgs',
    'PipelineActivityArgsDict',
    'PipelineAddAttributesArgs',
    'PipelineAddAttributesArgsDict',
    'PipelineChannelArgs',
    'PipelineChannelArgsDict',
    'PipelineDatastoreArgs',
    'PipelineDatastoreArgsDict',
    'PipelineDeviceRegistryEnrichArgs',
    'PipelineDeviceRegistryEnrichArgsDict',
    'PipelineDeviceShadowEnrichArgs',
    'PipelineDeviceShadowEnrichArgsDict',
    'PipelineFilterArgs',
    'PipelineFilterArgsDict',
    'PipelineLambdaArgs',
    'PipelineLambdaArgsDict',
    'PipelineMathArgs',
    'PipelineMathArgsDict',
    'PipelineRemoveAttributesArgs',
    'PipelineRemoveAttributesArgsDict',
    'PipelineSelectAttributesArgs',
    'PipelineSelectAttributesArgsDict',
]

MYPY = False

if not MYPY:
    class ChannelCustomerManagedS3ArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        The name of the S3 bucket in which channel data is stored.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
        """
        key_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        (Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a forward slash (/).
        """
elif False:
    ChannelCustomerManagedS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelCustomerManagedS3Args:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 key_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: The name of the S3 bucket in which channel data is stored.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
        :param pulumi.Input[builtins.str] key_prefix: (Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a forward slash (/).
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "role_arn", role_arn)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the S3 bucket in which channel data is stored.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a forward slash (/).
        """
        return pulumi.get(self, "key_prefix")

    @key_prefix.setter
    def key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_prefix", value)


if not MYPY:
    class ChannelRetentionPeriodArgsDict(TypedDict):
        number_of_days: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of days that message data is kept. The `unlimited` parameter must be false.
        """
        unlimited: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, message data is kept indefinitely.
        """
elif False:
    ChannelRetentionPeriodArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelRetentionPeriodArgs:
    def __init__(__self__, *,
                 number_of_days: Optional[pulumi.Input[builtins.int]] = None,
                 unlimited: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] number_of_days: The number of days that message data is kept. The `unlimited` parameter must be false.
        :param pulumi.Input[builtins.bool] unlimited: If true, message data is kept indefinitely.
        """
        if number_of_days is not None:
            pulumi.set(__self__, "number_of_days", number_of_days)
        if unlimited is not None:
            pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter(name="numberOfDays")
    def number_of_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days that message data is kept. The `unlimited` parameter must be false.
        """
        return pulumi.get(self, "number_of_days")

    @number_of_days.setter
    def number_of_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_days", value)

    @property
    @pulumi.getter
    def unlimited(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, message data is kept indefinitely.
        """
        return pulumi.get(self, "unlimited")

    @unlimited.setter
    def unlimited(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unlimited", value)


if not MYPY:
    class ChannelServiceManagedS3ArgsDict(TypedDict):
        pass
elif False:
    ChannelServiceManagedS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelServiceManagedS3Args:
    def __init__(__self__):
        pass


if not MYPY:
    class ChannelStorageArgsDict(TypedDict):
        customer_managed_s3: NotRequired[pulumi.Input['ChannelCustomerManagedS3ArgsDict']]
        """
        Used to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the `retentionPeriod` parameter is ignored. You can't change the choice of S3 storage after the data store is created.
        """
        service_managed_s3: NotRequired[pulumi.Input['ChannelServiceManagedS3ArgsDict']]
        """
        Used to store channel data in an S3 bucket managed by AWS IoT Analytics . You can't change the choice of S3 storage after the data store is created.
        """
elif False:
    ChannelStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelStorageArgs:
    def __init__(__self__, *,
                 customer_managed_s3: Optional[pulumi.Input['ChannelCustomerManagedS3Args']] = None,
                 service_managed_s3: Optional[pulumi.Input['ChannelServiceManagedS3Args']] = None):
        """
        :param pulumi.Input['ChannelCustomerManagedS3Args'] customer_managed_s3: Used to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the `retentionPeriod` parameter is ignored. You can't change the choice of S3 storage after the data store is created.
        :param pulumi.Input['ChannelServiceManagedS3Args'] service_managed_s3: Used to store channel data in an S3 bucket managed by AWS IoT Analytics . You can't change the choice of S3 storage after the data store is created.
        """
        if customer_managed_s3 is not None:
            pulumi.set(__self__, "customer_managed_s3", customer_managed_s3)
        if service_managed_s3 is not None:
            pulumi.set(__self__, "service_managed_s3", service_managed_s3)

    @property
    @pulumi.getter(name="customerManagedS3")
    def customer_managed_s3(self) -> Optional[pulumi.Input['ChannelCustomerManagedS3Args']]:
        """
        Used to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the `retentionPeriod` parameter is ignored. You can't change the choice of S3 storage after the data store is created.
        """
        return pulumi.get(self, "customer_managed_s3")

    @customer_managed_s3.setter
    def customer_managed_s3(self, value: Optional[pulumi.Input['ChannelCustomerManagedS3Args']]):
        pulumi.set(self, "customer_managed_s3", value)

    @property
    @pulumi.getter(name="serviceManagedS3")
    def service_managed_s3(self) -> Optional[pulumi.Input['ChannelServiceManagedS3Args']]:
        """
        Used to store channel data in an S3 bucket managed by AWS IoT Analytics . You can't change the choice of S3 storage after the data store is created.
        """
        return pulumi.get(self, "service_managed_s3")

    @service_managed_s3.setter
    def service_managed_s3(self, value: Optional[pulumi.Input['ChannelServiceManagedS3Args']]):
        pulumi.set(self, "service_managed_s3", value)


if not MYPY:
    class DatasetActionArgsDict(TypedDict):
        action_name: pulumi.Input[builtins.str]
        """
        The name of the data set action by which data set contents are automatically created.
        """
        container_action: NotRequired[pulumi.Input['DatasetContainerActionArgsDict']]
        """
        Information which allows the system to run a containerized application in order to create the data set contents. The application must be in a Docker container along with any needed support libraries.
        """
        query_action: NotRequired[pulumi.Input['DatasetQueryActionArgsDict']]
        """
        An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
        """
elif False:
    DatasetActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetActionArgs:
    def __init__(__self__, *,
                 action_name: pulumi.Input[builtins.str],
                 container_action: Optional[pulumi.Input['DatasetContainerActionArgs']] = None,
                 query_action: Optional[pulumi.Input['DatasetQueryActionArgs']] = None):
        """
        :param pulumi.Input[builtins.str] action_name: The name of the data set action by which data set contents are automatically created.
        :param pulumi.Input['DatasetContainerActionArgs'] container_action: Information which allows the system to run a containerized application in order to create the data set contents. The application must be in a Docker container along with any needed support libraries.
        :param pulumi.Input['DatasetQueryActionArgs'] query_action: An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
        """
        pulumi.set(__self__, "action_name", action_name)
        if container_action is not None:
            pulumi.set(__self__, "container_action", container_action)
        if query_action is not None:
            pulumi.set(__self__, "query_action", query_action)

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the data set action by which data set contents are automatically created.
        """
        return pulumi.get(self, "action_name")

    @action_name.setter
    def action_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action_name", value)

    @property
    @pulumi.getter(name="containerAction")
    def container_action(self) -> Optional[pulumi.Input['DatasetContainerActionArgs']]:
        """
        Information which allows the system to run a containerized application in order to create the data set contents. The application must be in a Docker container along with any needed support libraries.
        """
        return pulumi.get(self, "container_action")

    @container_action.setter
    def container_action(self, value: Optional[pulumi.Input['DatasetContainerActionArgs']]):
        pulumi.set(self, "container_action", value)

    @property
    @pulumi.getter(name="queryAction")
    def query_action(self) -> Optional[pulumi.Input['DatasetQueryActionArgs']]:
        """
        An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
        """
        return pulumi.get(self, "query_action")

    @query_action.setter
    def query_action(self, value: Optional[pulumi.Input['DatasetQueryActionArgs']]):
        pulumi.set(self, "query_action", value)


if not MYPY:
    class DatasetContainerActionArgsDict(TypedDict):
        execution_role_arn: pulumi.Input[builtins.str]
        """
        The ARN of the role which gives permission to the system to access needed resources in order to run the "containerAction". This includes, at minimum, permission to retrieve the data set contents which are the input to the containerized application.
        """
        image: pulumi.Input[builtins.str]
        """
        The ARN of the Docker container stored in your account. The Docker container contains an application and needed support libraries and is used to generate data set contents.
        """
        resource_configuration: pulumi.Input['DatasetResourceConfigurationArgsDict']
        """
        Configuration of the resource which executes the "containerAction".
        """
        variables: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatasetVariableArgsDict']]]]
        """
        The values of variables used within the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
        """
elif False:
    DatasetContainerActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetContainerActionArgs:
    def __init__(__self__, *,
                 execution_role_arn: pulumi.Input[builtins.str],
                 image: pulumi.Input[builtins.str],
                 resource_configuration: pulumi.Input['DatasetResourceConfigurationArgs'],
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetVariableArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] execution_role_arn: The ARN of the role which gives permission to the system to access needed resources in order to run the "containerAction". This includes, at minimum, permission to retrieve the data set contents which are the input to the containerized application.
        :param pulumi.Input[builtins.str] image: The ARN of the Docker container stored in your account. The Docker container contains an application and needed support libraries and is used to generate data set contents.
        :param pulumi.Input['DatasetResourceConfigurationArgs'] resource_configuration: Configuration of the resource which executes the "containerAction".
        :param pulumi.Input[Sequence[pulumi.Input['DatasetVariableArgs']]] variables: The values of variables used within the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
        """
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "resource_configuration", resource_configuration)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the role which gives permission to the system to access needed resources in order to run the "containerAction". This includes, at minimum, permission to retrieve the data set contents which are the input to the containerized application.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the Docker container stored in your account. The Docker container contains an application and needed support libraries and is used to generate data set contents.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="resourceConfiguration")
    def resource_configuration(self) -> pulumi.Input['DatasetResourceConfigurationArgs']:
        """
        Configuration of the resource which executes the "containerAction".
        """
        return pulumi.get(self, "resource_configuration")

    @resource_configuration.setter
    def resource_configuration(self, value: pulumi.Input['DatasetResourceConfigurationArgs']):
        pulumi.set(self, "resource_configuration", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetVariableArgs']]]]:
        """
        The values of variables used within the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetVariableArgs']]]]):
        pulumi.set(self, "variables", value)


if not MYPY:
    class DatasetContentDeliveryRuleDestinationArgsDict(TypedDict):
        iot_events_destination_configuration: NotRequired[pulumi.Input['DatasetIotEventsDestinationConfigurationArgsDict']]
        """
        Configuration information for delivery of dataset contents to AWS IoT Events .
        """
        s3_destination_configuration: NotRequired[pulumi.Input['DatasetS3DestinationConfigurationArgsDict']]
        """
        Configuration information for delivery of dataset contents to Amazon S3.
        """
elif False:
    DatasetContentDeliveryRuleDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetContentDeliveryRuleDestinationArgs:
    def __init__(__self__, *,
                 iot_events_destination_configuration: Optional[pulumi.Input['DatasetIotEventsDestinationConfigurationArgs']] = None,
                 s3_destination_configuration: Optional[pulumi.Input['DatasetS3DestinationConfigurationArgs']] = None):
        """
        :param pulumi.Input['DatasetIotEventsDestinationConfigurationArgs'] iot_events_destination_configuration: Configuration information for delivery of dataset contents to AWS IoT Events .
        :param pulumi.Input['DatasetS3DestinationConfigurationArgs'] s3_destination_configuration: Configuration information for delivery of dataset contents to Amazon S3.
        """
        if iot_events_destination_configuration is not None:
            pulumi.set(__self__, "iot_events_destination_configuration", iot_events_destination_configuration)
        if s3_destination_configuration is not None:
            pulumi.set(__self__, "s3_destination_configuration", s3_destination_configuration)

    @property
    @pulumi.getter(name="iotEventsDestinationConfiguration")
    def iot_events_destination_configuration(self) -> Optional[pulumi.Input['DatasetIotEventsDestinationConfigurationArgs']]:
        """
        Configuration information for delivery of dataset contents to AWS IoT Events .
        """
        return pulumi.get(self, "iot_events_destination_configuration")

    @iot_events_destination_configuration.setter
    def iot_events_destination_configuration(self, value: Optional[pulumi.Input['DatasetIotEventsDestinationConfigurationArgs']]):
        pulumi.set(self, "iot_events_destination_configuration", value)

    @property
    @pulumi.getter(name="s3DestinationConfiguration")
    def s3_destination_configuration(self) -> Optional[pulumi.Input['DatasetS3DestinationConfigurationArgs']]:
        """
        Configuration information for delivery of dataset contents to Amazon S3.
        """
        return pulumi.get(self, "s3_destination_configuration")

    @s3_destination_configuration.setter
    def s3_destination_configuration(self, value: Optional[pulumi.Input['DatasetS3DestinationConfigurationArgs']]):
        pulumi.set(self, "s3_destination_configuration", value)


if not MYPY:
    class DatasetContentDeliveryRuleArgsDict(TypedDict):
        destination: pulumi.Input['DatasetContentDeliveryRuleDestinationArgsDict']
        """
        The destination to which dataset contents are delivered.
        """
        entry_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the dataset content delivery rules entry.
        """
elif False:
    DatasetContentDeliveryRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetContentDeliveryRuleArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['DatasetContentDeliveryRuleDestinationArgs'],
                 entry_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['DatasetContentDeliveryRuleDestinationArgs'] destination: The destination to which dataset contents are delivered.
        :param pulumi.Input[builtins.str] entry_name: The name of the dataset content delivery rules entry.
        """
        pulumi.set(__self__, "destination", destination)
        if entry_name is not None:
            pulumi.set(__self__, "entry_name", entry_name)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['DatasetContentDeliveryRuleDestinationArgs']:
        """
        The destination to which dataset contents are delivered.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['DatasetContentDeliveryRuleDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="entryName")
    def entry_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the dataset content delivery rules entry.
        """
        return pulumi.get(self, "entry_name")

    @entry_name.setter
    def entry_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entry_name", value)


if not MYPY:
    class DatasetContentVersionValueArgsDict(TypedDict):
        dataset_name: pulumi.Input[builtins.str]
        """
        The name of the dataset whose latest contents are used as input to the notebook or application.
        """
elif False:
    DatasetContentVersionValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetContentVersionValueArgs:
    def __init__(__self__, *,
                 dataset_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] dataset_name: The name of the dataset whose latest contents are used as input to the notebook or application.
        """
        pulumi.set(__self__, "dataset_name", dataset_name)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the dataset whose latest contents are used as input to the notebook or application.
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset_name", value)


if not MYPY:
    class DatasetDeltaTimeSessionWindowConfigurationArgsDict(TypedDict):
        timeout_in_minutes: pulumi.Input[builtins.int]
        """
        A time interval. You can use `timeoutInMinutes` so that AWS IoT Analytics can batch up late data notifications that have been generated since the last execution. AWS IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.

        For more information about how to write a timestamp expression, see [Date and Time Functions and Operators](https://docs.aws.amazon.com/https://prestodb.io/docs/current/functions/datetime.html) , in the *Presto 0.172 Documentation* .
        """
elif False:
    DatasetDeltaTimeSessionWindowConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetDeltaTimeSessionWindowConfigurationArgs:
    def __init__(__self__, *,
                 timeout_in_minutes: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] timeout_in_minutes: A time interval. You can use `timeoutInMinutes` so that AWS IoT Analytics can batch up late data notifications that have been generated since the last execution. AWS IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.
               
               For more information about how to write a timestamp expression, see [Date and Time Functions and Operators](https://docs.aws.amazon.com/https://prestodb.io/docs/current/functions/datetime.html) , in the *Presto 0.172 Documentation* .
        """
        pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> pulumi.Input[builtins.int]:
        """
        A time interval. You can use `timeoutInMinutes` so that AWS IoT Analytics can batch up late data notifications that have been generated since the last execution. AWS IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.

        For more information about how to write a timestamp expression, see [Date and Time Functions and Operators](https://docs.aws.amazon.com/https://prestodb.io/docs/current/functions/datetime.html) , in the *Presto 0.172 Documentation* .
        """
        return pulumi.get(self, "timeout_in_minutes")

    @timeout_in_minutes.setter
    def timeout_in_minutes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "timeout_in_minutes", value)


if not MYPY:
    class DatasetDeltaTimeArgsDict(TypedDict):
        offset_seconds: pulumi.Input[builtins.int]
        """
        The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.
        """
        time_expression: pulumi.Input[builtins.str]
        """
        An expression by which the time of the message data might be determined. This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.
        """
elif False:
    DatasetDeltaTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetDeltaTimeArgs:
    def __init__(__self__, *,
                 offset_seconds: pulumi.Input[builtins.int],
                 time_expression: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.int] offset_seconds: The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.
        :param pulumi.Input[builtins.str] time_expression: An expression by which the time of the message data might be determined. This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.
        """
        pulumi.set(__self__, "offset_seconds", offset_seconds)
        pulumi.set(__self__, "time_expression", time_expression)

    @property
    @pulumi.getter(name="offsetSeconds")
    def offset_seconds(self) -> pulumi.Input[builtins.int]:
        """
        The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.
        """
        return pulumi.get(self, "offset_seconds")

    @offset_seconds.setter
    def offset_seconds(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "offset_seconds", value)

    @property
    @pulumi.getter(name="timeExpression")
    def time_expression(self) -> pulumi.Input[builtins.str]:
        """
        An expression by which the time of the message data might be determined. This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.
        """
        return pulumi.get(self, "time_expression")

    @time_expression.setter
    def time_expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_expression", value)


if not MYPY:
    class DatasetFilterArgsDict(TypedDict):
        delta_time: NotRequired[pulumi.Input['DatasetDeltaTimeArgsDict']]
        """
        Used to limit data to that which has arrived since the last execution of the action.
        """
elif False:
    DatasetFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetFilterArgs:
    def __init__(__self__, *,
                 delta_time: Optional[pulumi.Input['DatasetDeltaTimeArgs']] = None):
        """
        :param pulumi.Input['DatasetDeltaTimeArgs'] delta_time: Used to limit data to that which has arrived since the last execution of the action.
        """
        if delta_time is not None:
            pulumi.set(__self__, "delta_time", delta_time)

    @property
    @pulumi.getter(name="deltaTime")
    def delta_time(self) -> Optional[pulumi.Input['DatasetDeltaTimeArgs']]:
        """
        Used to limit data to that which has arrived since the last execution of the action.
        """
        return pulumi.get(self, "delta_time")

    @delta_time.setter
    def delta_time(self, value: Optional[pulumi.Input['DatasetDeltaTimeArgs']]):
        pulumi.set(self, "delta_time", value)


if not MYPY:
    class DatasetGlueConfigurationArgsDict(TypedDict):
        database_name: pulumi.Input[builtins.str]
        """
        The name of the database in your AWS Glue Data Catalog in which the table is located. An AWS Glue Data Catalog database contains metadata tables.
        """
        table_name: pulumi.Input[builtins.str]
        """
        The name of the table in your AWS Glue Data Catalog that is used to perform the ETL operations. An AWS Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.
        """
elif False:
    DatasetGlueConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetGlueConfigurationArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[builtins.str],
                 table_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] database_name: The name of the database in your AWS Glue Data Catalog in which the table is located. An AWS Glue Data Catalog database contains metadata tables.
        :param pulumi.Input[builtins.str] table_name: The name of the table in your AWS Glue Data Catalog that is used to perform the ETL operations. An AWS Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the database in your AWS Glue Data Catalog in which the table is located. An AWS Glue Data Catalog database contains metadata tables.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the table in your AWS Glue Data Catalog that is used to perform the ETL operations. An AWS Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_name", value)


if not MYPY:
    class DatasetIotEventsDestinationConfigurationArgsDict(TypedDict):
        input_name: pulumi.Input[builtins.str]
        """
        The name of the AWS IoT Events input to which dataset contents are delivered.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The ARN of the role that grants AWS IoT Analytics permission to deliver dataset contents to an AWS IoT Events input.
        """
elif False:
    DatasetIotEventsDestinationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetIotEventsDestinationConfigurationArgs:
    def __init__(__self__, *,
                 input_name: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] input_name: The name of the AWS IoT Events input to which dataset contents are delivered.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the role that grants AWS IoT Analytics permission to deliver dataset contents to an AWS IoT Events input.
        """
        pulumi.set(__self__, "input_name", input_name)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="inputName")
    def input_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the AWS IoT Events input to which dataset contents are delivered.
        """
        return pulumi.get(self, "input_name")

    @input_name.setter
    def input_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "input_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the role that grants AWS IoT Analytics permission to deliver dataset contents to an AWS IoT Events input.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class DatasetLateDataRuleConfigurationArgsDict(TypedDict):
        delta_time_session_window_configuration: NotRequired[pulumi.Input['DatasetDeltaTimeSessionWindowConfigurationArgsDict']]
        """
        The information needed to configure a delta time session window.
        """
elif False:
    DatasetLateDataRuleConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetLateDataRuleConfigurationArgs:
    def __init__(__self__, *,
                 delta_time_session_window_configuration: Optional[pulumi.Input['DatasetDeltaTimeSessionWindowConfigurationArgs']] = None):
        """
        :param pulumi.Input['DatasetDeltaTimeSessionWindowConfigurationArgs'] delta_time_session_window_configuration: The information needed to configure a delta time session window.
        """
        if delta_time_session_window_configuration is not None:
            pulumi.set(__self__, "delta_time_session_window_configuration", delta_time_session_window_configuration)

    @property
    @pulumi.getter(name="deltaTimeSessionWindowConfiguration")
    def delta_time_session_window_configuration(self) -> Optional[pulumi.Input['DatasetDeltaTimeSessionWindowConfigurationArgs']]:
        """
        The information needed to configure a delta time session window.
        """
        return pulumi.get(self, "delta_time_session_window_configuration")

    @delta_time_session_window_configuration.setter
    def delta_time_session_window_configuration(self, value: Optional[pulumi.Input['DatasetDeltaTimeSessionWindowConfigurationArgs']]):
        pulumi.set(self, "delta_time_session_window_configuration", value)


if not MYPY:
    class DatasetLateDataRuleArgsDict(TypedDict):
        rule_configuration: pulumi.Input['DatasetLateDataRuleConfigurationArgsDict']
        """
        The information needed to configure the late data rule.
        """
        rule_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the late data rule.
        """
elif False:
    DatasetLateDataRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetLateDataRuleArgs:
    def __init__(__self__, *,
                 rule_configuration: pulumi.Input['DatasetLateDataRuleConfigurationArgs'],
                 rule_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['DatasetLateDataRuleConfigurationArgs'] rule_configuration: The information needed to configure the late data rule.
        :param pulumi.Input[builtins.str] rule_name: The name of the late data rule.
        """
        pulumi.set(__self__, "rule_configuration", rule_configuration)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter(name="ruleConfiguration")
    def rule_configuration(self) -> pulumi.Input['DatasetLateDataRuleConfigurationArgs']:
        """
        The information needed to configure the late data rule.
        """
        return pulumi.get(self, "rule_configuration")

    @rule_configuration.setter
    def rule_configuration(self, value: pulumi.Input['DatasetLateDataRuleConfigurationArgs']):
        pulumi.set(self, "rule_configuration", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the late data rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)


if not MYPY:
    class DatasetOutputFileUriValueArgsDict(TypedDict):
        file_name: pulumi.Input[builtins.str]
        """
        The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket.
        """
elif False:
    DatasetOutputFileUriValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetOutputFileUriValueArgs:
    def __init__(__self__, *,
                 file_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] file_name: The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket.
        """
        pulumi.set(__self__, "file_name", file_name)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Input[builtins.str]:
        """
        The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "file_name", value)


if not MYPY:
    class DatasetQueryActionArgsDict(TypedDict):
        sql_query: pulumi.Input[builtins.str]
        """
        An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
        """
        filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatasetFilterArgsDict']]]]
        """
        Pre-filters applied to message data.
        """
elif False:
    DatasetQueryActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetQueryActionArgs:
    def __init__(__self__, *,
                 sql_query: pulumi.Input[builtins.str],
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetFilterArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] sql_query: An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetFilterArgs']]] filters: Pre-filters applied to message data.
        """
        pulumi.set(__self__, "sql_query", sql_query)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter(name="sqlQuery")
    def sql_query(self) -> pulumi.Input[builtins.str]:
        """
        An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
        """
        return pulumi.get(self, "sql_query")

    @sql_query.setter
    def sql_query(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sql_query", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetFilterArgs']]]]:
        """
        Pre-filters applied to message data.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetFilterArgs']]]]):
        pulumi.set(self, "filters", value)


if not MYPY:
    class DatasetResourceConfigurationArgsDict(TypedDict):
        compute_type: pulumi.Input['DatasetResourceConfigurationComputeType']
        """
        The type of the compute resource used to execute the `containerAction` . Possible values are: `ACU_1` (vCPU=4, memory=16 GiB) or `ACU_2` (vCPU=8, memory=32 GiB).
        """
        volume_size_in_gb: pulumi.Input[builtins.int]
        """
        The size, in GB, of the persistent storage available to the resource instance used to execute the `containerAction` (min: 1, max: 50).
        """
elif False:
    DatasetResourceConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetResourceConfigurationArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input['DatasetResourceConfigurationComputeType'],
                 volume_size_in_gb: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input['DatasetResourceConfigurationComputeType'] compute_type: The type of the compute resource used to execute the `containerAction` . Possible values are: `ACU_1` (vCPU=4, memory=16 GiB) or `ACU_2` (vCPU=8, memory=32 GiB).
        :param pulumi.Input[builtins.int] volume_size_in_gb: The size, in GB, of the persistent storage available to the resource instance used to execute the `containerAction` (min: 1, max: 50).
        """
        pulumi.set(__self__, "compute_type", compute_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input['DatasetResourceConfigurationComputeType']:
        """
        The type of the compute resource used to execute the `containerAction` . Possible values are: `ACU_1` (vCPU=4, memory=16 GiB) or `ACU_2` (vCPU=8, memory=32 GiB).
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input['DatasetResourceConfigurationComputeType']):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> pulumi.Input[builtins.int]:
        """
        The size, in GB, of the persistent storage available to the resource instance used to execute the `containerAction` (min: 1, max: 50).
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "volume_size_in_gb", value)


if not MYPY:
    class DatasetRetentionPeriodArgsDict(TypedDict):
        number_of_days: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of days that message data is kept. The `unlimited` parameter must be false.
        """
        unlimited: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, message data is kept indefinitely.
        """
elif False:
    DatasetRetentionPeriodArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetRetentionPeriodArgs:
    def __init__(__self__, *,
                 number_of_days: Optional[pulumi.Input[builtins.int]] = None,
                 unlimited: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] number_of_days: The number of days that message data is kept. The `unlimited` parameter must be false.
        :param pulumi.Input[builtins.bool] unlimited: If true, message data is kept indefinitely.
        """
        if number_of_days is not None:
            pulumi.set(__self__, "number_of_days", number_of_days)
        if unlimited is not None:
            pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter(name="numberOfDays")
    def number_of_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days that message data is kept. The `unlimited` parameter must be false.
        """
        return pulumi.get(self, "number_of_days")

    @number_of_days.setter
    def number_of_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_days", value)

    @property
    @pulumi.getter
    def unlimited(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, message data is kept indefinitely.
        """
        return pulumi.get(self, "unlimited")

    @unlimited.setter
    def unlimited(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unlimited", value)


if not MYPY:
    class DatasetS3DestinationConfigurationArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        The name of the S3 bucket to which dataset contents are delivered.
        """
        key: pulumi.Input[builtins.str]
        """
        The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.

        You can create a unique key with the following options:

        - Use `!{iotanalytics:scheduleTime}` to insert the time of a scheduled SQL query run.
        - Use `!{iotanalytics:versionId}` to insert a unique hash that identifies a dataset content.
        - Use `!{iotanalytics:creationTime}` to insert the creation time of a dataset content.

        The following example creates a unique key for a CSV file: `dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv`

        > If you don't use `!{iotanalytics:versionId}` to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same `scheduleTime` but different `versionId` s. This means that one dataset content overwrites the other.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 and AWS Glue resources.
        """
        glue_configuration: NotRequired[pulumi.Input['DatasetGlueConfigurationArgsDict']]
        """
        Configuration information for coordination with AWS Glue , a fully managed extract, transform and load (ETL) service.
        """
elif False:
    DatasetS3DestinationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetS3DestinationConfigurationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 glue_configuration: Optional[pulumi.Input['DatasetGlueConfigurationArgs']] = None):
        """
        :param pulumi.Input[builtins.str] bucket: The name of the S3 bucket to which dataset contents are delivered.
        :param pulumi.Input[builtins.str] key: The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.
               
               You can create a unique key with the following options:
               
               - Use `!{iotanalytics:scheduleTime}` to insert the time of a scheduled SQL query run.
               - Use `!{iotanalytics:versionId}` to insert a unique hash that identifies a dataset content.
               - Use `!{iotanalytics:creationTime}` to insert the creation time of a dataset content.
               
               The following example creates a unique key for a CSV file: `dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv`
               
               > If you don't use `!{iotanalytics:versionId}` to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same `scheduleTime` but different `versionId` s. This means that one dataset content overwrites the other.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 and AWS Glue resources.
        :param pulumi.Input['DatasetGlueConfigurationArgs'] glue_configuration: Configuration information for coordination with AWS Glue , a fully managed extract, transform and load (ETL) service.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if glue_configuration is not None:
            pulumi.set(__self__, "glue_configuration", glue_configuration)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the S3 bucket to which dataset contents are delivered.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.

        You can create a unique key with the following options:

        - Use `!{iotanalytics:scheduleTime}` to insert the time of a scheduled SQL query run.
        - Use `!{iotanalytics:versionId}` to insert a unique hash that identifies a dataset content.
        - Use `!{iotanalytics:creationTime}` to insert the creation time of a dataset content.

        The following example creates a unique key for a CSV file: `dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv`

        > If you don't use `!{iotanalytics:versionId}` to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same `scheduleTime` but different `versionId` s. This means that one dataset content overwrites the other.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 and AWS Glue resources.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="glueConfiguration")
    def glue_configuration(self) -> Optional[pulumi.Input['DatasetGlueConfigurationArgs']]:
        """
        Configuration information for coordination with AWS Glue , a fully managed extract, transform and load (ETL) service.
        """
        return pulumi.get(self, "glue_configuration")

    @glue_configuration.setter
    def glue_configuration(self, value: Optional[pulumi.Input['DatasetGlueConfigurationArgs']]):
        pulumi.set(self, "glue_configuration", value)


if not MYPY:
    class DatasetScheduleArgsDict(TypedDict):
        schedule_expression: pulumi.Input[builtins.str]
        """
        The expression that defines when to trigger an update. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) in the Amazon CloudWatch documentation.
        """
elif False:
    DatasetScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetScheduleArgs:
    def __init__(__self__, *,
                 schedule_expression: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] schedule_expression: The expression that defines when to trigger an update. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) in the Amazon CloudWatch documentation.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Input[builtins.str]:
        """
        The expression that defines when to trigger an update. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) in the Amazon CloudWatch documentation.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schedule_expression", value)


if not MYPY:
    class DatasetTriggeringDatasetArgsDict(TypedDict):
        dataset_name: pulumi.Input[builtins.str]
        """
        The name of the data set whose content generation triggers the new data set content generation.
        """
elif False:
    DatasetTriggeringDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetTriggeringDatasetArgs:
    def __init__(__self__, *,
                 dataset_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] dataset_name: The name of the data set whose content generation triggers the new data set content generation.
        """
        pulumi.set(__self__, "dataset_name", dataset_name)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the data set whose content generation triggers the new data set content generation.
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset_name", value)


if not MYPY:
    class DatasetTriggerArgsDict(TypedDict):
        schedule: NotRequired[pulumi.Input['DatasetScheduleArgsDict']]
        """
        The "Schedule" when the trigger is initiated.
        """
        triggering_dataset: NotRequired[pulumi.Input['DatasetTriggeringDatasetArgsDict']]
        """
        Information about the data set whose content generation triggers the new data set content generation.
        """
elif False:
    DatasetTriggerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetTriggerArgs:
    def __init__(__self__, *,
                 schedule: Optional[pulumi.Input['DatasetScheduleArgs']] = None,
                 triggering_dataset: Optional[pulumi.Input['DatasetTriggeringDatasetArgs']] = None):
        """
        :param pulumi.Input['DatasetScheduleArgs'] schedule: The "Schedule" when the trigger is initiated.
        :param pulumi.Input['DatasetTriggeringDatasetArgs'] triggering_dataset: Information about the data set whose content generation triggers the new data set content generation.
        """
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if triggering_dataset is not None:
            pulumi.set(__self__, "triggering_dataset", triggering_dataset)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['DatasetScheduleArgs']]:
        """
        The "Schedule" when the trigger is initiated.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['DatasetScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="triggeringDataset")
    def triggering_dataset(self) -> Optional[pulumi.Input['DatasetTriggeringDatasetArgs']]:
        """
        Information about the data set whose content generation triggers the new data set content generation.
        """
        return pulumi.get(self, "triggering_dataset")

    @triggering_dataset.setter
    def triggering_dataset(self, value: Optional[pulumi.Input['DatasetTriggeringDatasetArgs']]):
        pulumi.set(self, "triggering_dataset", value)


if not MYPY:
    class DatasetVariableArgsDict(TypedDict):
        variable_name: pulumi.Input[builtins.str]
        """
        The name of the variable.
        """
        dataset_content_version_value: NotRequired[pulumi.Input['DatasetContentVersionValueArgsDict']]
        """
        The value of the variable as a structure that specifies a dataset content version.
        """
        double_value: NotRequired[pulumi.Input[builtins.float]]
        """
        The value of the variable as a double (numeric).
        """
        output_file_uri_value: NotRequired[pulumi.Input['DatasetOutputFileUriValueArgsDict']]
        """
        The value of the variable as a structure that specifies an output file URI.
        """
        string_value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the variable as a string.
        """
elif False:
    DatasetVariableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetVariableArgs:
    def __init__(__self__, *,
                 variable_name: pulumi.Input[builtins.str],
                 dataset_content_version_value: Optional[pulumi.Input['DatasetContentVersionValueArgs']] = None,
                 double_value: Optional[pulumi.Input[builtins.float]] = None,
                 output_file_uri_value: Optional[pulumi.Input['DatasetOutputFileUriValueArgs']] = None,
                 string_value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] variable_name: The name of the variable.
        :param pulumi.Input['DatasetContentVersionValueArgs'] dataset_content_version_value: The value of the variable as a structure that specifies a dataset content version.
        :param pulumi.Input[builtins.float] double_value: The value of the variable as a double (numeric).
        :param pulumi.Input['DatasetOutputFileUriValueArgs'] output_file_uri_value: The value of the variable as a structure that specifies an output file URI.
        :param pulumi.Input[builtins.str] string_value: The value of the variable as a string.
        """
        pulumi.set(__self__, "variable_name", variable_name)
        if dataset_content_version_value is not None:
            pulumi.set(__self__, "dataset_content_version_value", dataset_content_version_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if output_file_uri_value is not None:
            pulumi.set(__self__, "output_file_uri_value", output_file_uri_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "variable_name")

    @variable_name.setter
    def variable_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "variable_name", value)

    @property
    @pulumi.getter(name="datasetContentVersionValue")
    def dataset_content_version_value(self) -> Optional[pulumi.Input['DatasetContentVersionValueArgs']]:
        """
        The value of the variable as a structure that specifies a dataset content version.
        """
        return pulumi.get(self, "dataset_content_version_value")

    @dataset_content_version_value.setter
    def dataset_content_version_value(self, value: Optional[pulumi.Input['DatasetContentVersionValueArgs']]):
        pulumi.set(self, "dataset_content_version_value", value)

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value of the variable as a double (numeric).
        """
        return pulumi.get(self, "double_value")

    @double_value.setter
    def double_value(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "double_value", value)

    @property
    @pulumi.getter(name="outputFileUriValue")
    def output_file_uri_value(self) -> Optional[pulumi.Input['DatasetOutputFileUriValueArgs']]:
        """
        The value of the variable as a structure that specifies an output file URI.
        """
        return pulumi.get(self, "output_file_uri_value")

    @output_file_uri_value.setter
    def output_file_uri_value(self, value: Optional[pulumi.Input['DatasetOutputFileUriValueArgs']]):
        pulumi.set(self, "output_file_uri_value", value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the variable as a string.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "string_value", value)


if not MYPY:
    class DatasetVersioningConfigurationArgsDict(TypedDict):
        max_versions: NotRequired[pulumi.Input[builtins.int]]
        """
        How many versions of dataset contents are kept. The `unlimited` parameter must be `false` .
        """
        unlimited: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, unlimited versions of dataset contents are kept.
        """
elif False:
    DatasetVersioningConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetVersioningConfigurationArgs:
    def __init__(__self__, *,
                 max_versions: Optional[pulumi.Input[builtins.int]] = None,
                 unlimited: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] max_versions: How many versions of dataset contents are kept. The `unlimited` parameter must be `false` .
        :param pulumi.Input[builtins.bool] unlimited: If true, unlimited versions of dataset contents are kept.
        """
        if max_versions is not None:
            pulumi.set(__self__, "max_versions", max_versions)
        if unlimited is not None:
            pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter(name="maxVersions")
    def max_versions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        How many versions of dataset contents are kept. The `unlimited` parameter must be `false` .
        """
        return pulumi.get(self, "max_versions")

    @max_versions.setter
    def max_versions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_versions", value)

    @property
    @pulumi.getter
    def unlimited(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, unlimited versions of dataset contents are kept.
        """
        return pulumi.get(self, "unlimited")

    @unlimited.setter
    def unlimited(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unlimited", value)


if not MYPY:
    class DatastoreColumnArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the column.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of data. For more information about the supported data types, see [Common data types](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html) in the *AWS Glue Developer Guide* .
        """
elif False:
    DatastoreColumnArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreColumnArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: The name of the column.
        :param pulumi.Input[builtins.str] type: The type of data. For more information about the supported data types, see [Common data types](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html) in the *AWS Glue Developer Guide* .
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the column.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of data. For more information about the supported data types, see [Common data types](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html) in the *AWS Glue Developer Guide* .
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DatastoreCustomerManagedS3StorageArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        The name of the Amazon S3 bucket where your data is stored.
        """
        key_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
        """
elif False:
    DatastoreCustomerManagedS3StorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreCustomerManagedS3StorageArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: The name of the Amazon S3 bucket where your data is stored.
        :param pulumi.Input[builtins.str] key_prefix: (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
        """
        pulumi.set(__self__, "bucket", bucket)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Amazon S3 bucket where your data is stored.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
        """
        return pulumi.get(self, "key_prefix")

    @key_prefix.setter
    def key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_prefix", value)


if not MYPY:
    class DatastoreCustomerManagedS3ArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        The name of the Amazon S3 bucket where your data is stored.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
        """
        key_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
        """
elif False:
    DatastoreCustomerManagedS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreCustomerManagedS3Args:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 key_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: The name of the Amazon S3 bucket where your data is stored.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
        :param pulumi.Input[builtins.str] key_prefix: (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "role_arn", role_arn)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Amazon S3 bucket where your data is stored.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
        """
        return pulumi.get(self, "key_prefix")

    @key_prefix.setter
    def key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_prefix", value)


if not MYPY:
    class DatastoreFileFormatConfigurationArgsDict(TypedDict):
        json_configuration: NotRequired[pulumi.Input['DatastoreJsonConfigurationArgsDict']]
        """
        Contains the configuration information of the JSON format.
        """
        parquet_configuration: NotRequired[pulumi.Input['DatastoreParquetConfigurationArgsDict']]
        """
        Contains the configuration information of the Parquet format.
        """
elif False:
    DatastoreFileFormatConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreFileFormatConfigurationArgs:
    def __init__(__self__, *,
                 json_configuration: Optional[pulumi.Input['DatastoreJsonConfigurationArgs']] = None,
                 parquet_configuration: Optional[pulumi.Input['DatastoreParquetConfigurationArgs']] = None):
        """
        :param pulumi.Input['DatastoreJsonConfigurationArgs'] json_configuration: Contains the configuration information of the JSON format.
        :param pulumi.Input['DatastoreParquetConfigurationArgs'] parquet_configuration: Contains the configuration information of the Parquet format.
        """
        if json_configuration is not None:
            pulumi.set(__self__, "json_configuration", json_configuration)
        if parquet_configuration is not None:
            pulumi.set(__self__, "parquet_configuration", parquet_configuration)

    @property
    @pulumi.getter(name="jsonConfiguration")
    def json_configuration(self) -> Optional[pulumi.Input['DatastoreJsonConfigurationArgs']]:
        """
        Contains the configuration information of the JSON format.
        """
        return pulumi.get(self, "json_configuration")

    @json_configuration.setter
    def json_configuration(self, value: Optional[pulumi.Input['DatastoreJsonConfigurationArgs']]):
        pulumi.set(self, "json_configuration", value)

    @property
    @pulumi.getter(name="parquetConfiguration")
    def parquet_configuration(self) -> Optional[pulumi.Input['DatastoreParquetConfigurationArgs']]:
        """
        Contains the configuration information of the Parquet format.
        """
        return pulumi.get(self, "parquet_configuration")

    @parquet_configuration.setter
    def parquet_configuration(self, value: Optional[pulumi.Input['DatastoreParquetConfigurationArgs']]):
        pulumi.set(self, "parquet_configuration", value)


if not MYPY:
    class DatastoreIotSiteWiseMultiLayerStorageArgsDict(TypedDict):
        customer_managed_s3_storage: NotRequired[pulumi.Input['DatastoreCustomerManagedS3StorageArgsDict']]
        """
        Stores data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
        """
elif False:
    DatastoreIotSiteWiseMultiLayerStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreIotSiteWiseMultiLayerStorageArgs:
    def __init__(__self__, *,
                 customer_managed_s3_storage: Optional[pulumi.Input['DatastoreCustomerManagedS3StorageArgs']] = None):
        """
        :param pulumi.Input['DatastoreCustomerManagedS3StorageArgs'] customer_managed_s3_storage: Stores data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
        """
        if customer_managed_s3_storage is not None:
            pulumi.set(__self__, "customer_managed_s3_storage", customer_managed_s3_storage)

    @property
    @pulumi.getter(name="customerManagedS3Storage")
    def customer_managed_s3_storage(self) -> Optional[pulumi.Input['DatastoreCustomerManagedS3StorageArgs']]:
        """
        Stores data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
        """
        return pulumi.get(self, "customer_managed_s3_storage")

    @customer_managed_s3_storage.setter
    def customer_managed_s3_storage(self, value: Optional[pulumi.Input['DatastoreCustomerManagedS3StorageArgs']]):
        pulumi.set(self, "customer_managed_s3_storage", value)


if not MYPY:
    class DatastoreJsonConfigurationArgsDict(TypedDict):
        pass
elif False:
    DatastoreJsonConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreJsonConfigurationArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class DatastoreParquetConfigurationArgsDict(TypedDict):
        schema_definition: NotRequired[pulumi.Input['DatastoreSchemaDefinitionArgsDict']]
        """
        Information needed to define a schema.
        """
elif False:
    DatastoreParquetConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreParquetConfigurationArgs:
    def __init__(__self__, *,
                 schema_definition: Optional[pulumi.Input['DatastoreSchemaDefinitionArgs']] = None):
        """
        :param pulumi.Input['DatastoreSchemaDefinitionArgs'] schema_definition: Information needed to define a schema.
        """
        if schema_definition is not None:
            pulumi.set(__self__, "schema_definition", schema_definition)

    @property
    @pulumi.getter(name="schemaDefinition")
    def schema_definition(self) -> Optional[pulumi.Input['DatastoreSchemaDefinitionArgs']]:
        """
        Information needed to define a schema.
        """
        return pulumi.get(self, "schema_definition")

    @schema_definition.setter
    def schema_definition(self, value: Optional[pulumi.Input['DatastoreSchemaDefinitionArgs']]):
        pulumi.set(self, "schema_definition", value)


if not MYPY:
    class DatastorePartitionsArgsDict(TypedDict):
        partitions: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatastorePartitionArgsDict']]]]
        """
        A list of partition dimensions in a data store.
        """
elif False:
    DatastorePartitionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastorePartitionsArgs:
    def __init__(__self__, *,
                 partitions: Optional[pulumi.Input[Sequence[pulumi.Input['DatastorePartitionArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DatastorePartitionArgs']]] partitions: A list of partition dimensions in a data store.
        """
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)

    @property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatastorePartitionArgs']]]]:
        """
        A list of partition dimensions in a data store.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatastorePartitionArgs']]]]):
        pulumi.set(self, "partitions", value)


if not MYPY:
    class DatastorePartitionArgsDict(TypedDict):
        partition: NotRequired[pulumi.Input['PartitionArgsDict']]
        """
        A partition dimension defined by an attribute.
        """
        timestamp_partition: NotRequired[pulumi.Input['DatastoreTimestampPartitionArgsDict']]
        """
        A partition dimension defined by a timestamp attribute.
        """
elif False:
    DatastorePartitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastorePartitionArgs:
    def __init__(__self__, *,
                 partition: Optional[pulumi.Input['PartitionArgs']] = None,
                 timestamp_partition: Optional[pulumi.Input['DatastoreTimestampPartitionArgs']] = None):
        """
        :param pulumi.Input['PartitionArgs'] partition: A partition dimension defined by an attribute.
        :param pulumi.Input['DatastoreTimestampPartitionArgs'] timestamp_partition: A partition dimension defined by a timestamp attribute.
        """
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if timestamp_partition is not None:
            pulumi.set(__self__, "timestamp_partition", timestamp_partition)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input['PartitionArgs']]:
        """
        A partition dimension defined by an attribute.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input['PartitionArgs']]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="timestampPartition")
    def timestamp_partition(self) -> Optional[pulumi.Input['DatastoreTimestampPartitionArgs']]:
        """
        A partition dimension defined by a timestamp attribute.
        """
        return pulumi.get(self, "timestamp_partition")

    @timestamp_partition.setter
    def timestamp_partition(self, value: Optional[pulumi.Input['DatastoreTimestampPartitionArgs']]):
        pulumi.set(self, "timestamp_partition", value)


if not MYPY:
    class DatastoreRetentionPeriodArgsDict(TypedDict):
        number_of_days: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of days that message data is kept. The `unlimited` parameter must be false.
        """
        unlimited: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, message data is kept indefinitely.
        """
elif False:
    DatastoreRetentionPeriodArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreRetentionPeriodArgs:
    def __init__(__self__, *,
                 number_of_days: Optional[pulumi.Input[builtins.int]] = None,
                 unlimited: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] number_of_days: The number of days that message data is kept. The `unlimited` parameter must be false.
        :param pulumi.Input[builtins.bool] unlimited: If true, message data is kept indefinitely.
        """
        if number_of_days is not None:
            pulumi.set(__self__, "number_of_days", number_of_days)
        if unlimited is not None:
            pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter(name="numberOfDays")
    def number_of_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days that message data is kept. The `unlimited` parameter must be false.
        """
        return pulumi.get(self, "number_of_days")

    @number_of_days.setter
    def number_of_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_days", value)

    @property
    @pulumi.getter
    def unlimited(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, message data is kept indefinitely.
        """
        return pulumi.get(self, "unlimited")

    @unlimited.setter
    def unlimited(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unlimited", value)


if not MYPY:
    class DatastoreSchemaDefinitionArgsDict(TypedDict):
        columns: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatastoreColumnArgsDict']]]]
        """
        Specifies one or more columns that store your data.

        Each schema can have up to 100 columns. Each column can have up to 100 nested types.
        """
elif False:
    DatastoreSchemaDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreSchemaDefinitionArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['DatastoreColumnArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DatastoreColumnArgs']]] columns: Specifies one or more columns that store your data.
               
               Each schema can have up to 100 columns. Each column can have up to 100 nested types.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatastoreColumnArgs']]]]:
        """
        Specifies one or more columns that store your data.

        Each schema can have up to 100 columns. Each column can have up to 100 nested types.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatastoreColumnArgs']]]]):
        pulumi.set(self, "columns", value)


if not MYPY:
    class DatastoreServiceManagedS3ArgsDict(TypedDict):
        pass
elif False:
    DatastoreServiceManagedS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreServiceManagedS3Args:
    def __init__(__self__):
        pass


if not MYPY:
    class DatastoreStorageArgsDict(TypedDict):
        customer_managed_s3: NotRequired[pulumi.Input['DatastoreCustomerManagedS3ArgsDict']]
        """
        Use this to store data store data in an S3 bucket that you manage. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
        """
        iot_site_wise_multi_layer_storage: NotRequired[pulumi.Input['DatastoreIotSiteWiseMultiLayerStorageArgsDict']]
        """
        Use this to store data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of Amazon S3 storage after your data store is created.
        """
        service_managed_s3: NotRequired[pulumi.Input['DatastoreServiceManagedS3ArgsDict']]
        """
        Use this to store data store data in an S3 bucket managed by the AWS IoT Analytics service. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
        """
elif False:
    DatastoreStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreStorageArgs:
    def __init__(__self__, *,
                 customer_managed_s3: Optional[pulumi.Input['DatastoreCustomerManagedS3Args']] = None,
                 iot_site_wise_multi_layer_storage: Optional[pulumi.Input['DatastoreIotSiteWiseMultiLayerStorageArgs']] = None,
                 service_managed_s3: Optional[pulumi.Input['DatastoreServiceManagedS3Args']] = None):
        """
        :param pulumi.Input['DatastoreCustomerManagedS3Args'] customer_managed_s3: Use this to store data store data in an S3 bucket that you manage. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
        :param pulumi.Input['DatastoreIotSiteWiseMultiLayerStorageArgs'] iot_site_wise_multi_layer_storage: Use this to store data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of Amazon S3 storage after your data store is created.
        :param pulumi.Input['DatastoreServiceManagedS3Args'] service_managed_s3: Use this to store data store data in an S3 bucket managed by the AWS IoT Analytics service. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
        """
        if customer_managed_s3 is not None:
            pulumi.set(__self__, "customer_managed_s3", customer_managed_s3)
        if iot_site_wise_multi_layer_storage is not None:
            pulumi.set(__self__, "iot_site_wise_multi_layer_storage", iot_site_wise_multi_layer_storage)
        if service_managed_s3 is not None:
            pulumi.set(__self__, "service_managed_s3", service_managed_s3)

    @property
    @pulumi.getter(name="customerManagedS3")
    def customer_managed_s3(self) -> Optional[pulumi.Input['DatastoreCustomerManagedS3Args']]:
        """
        Use this to store data store data in an S3 bucket that you manage. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
        """
        return pulumi.get(self, "customer_managed_s3")

    @customer_managed_s3.setter
    def customer_managed_s3(self, value: Optional[pulumi.Input['DatastoreCustomerManagedS3Args']]):
        pulumi.set(self, "customer_managed_s3", value)

    @property
    @pulumi.getter(name="iotSiteWiseMultiLayerStorage")
    def iot_site_wise_multi_layer_storage(self) -> Optional[pulumi.Input['DatastoreIotSiteWiseMultiLayerStorageArgs']]:
        """
        Use this to store data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of Amazon S3 storage after your data store is created.
        """
        return pulumi.get(self, "iot_site_wise_multi_layer_storage")

    @iot_site_wise_multi_layer_storage.setter
    def iot_site_wise_multi_layer_storage(self, value: Optional[pulumi.Input['DatastoreIotSiteWiseMultiLayerStorageArgs']]):
        pulumi.set(self, "iot_site_wise_multi_layer_storage", value)

    @property
    @pulumi.getter(name="serviceManagedS3")
    def service_managed_s3(self) -> Optional[pulumi.Input['DatastoreServiceManagedS3Args']]:
        """
        Use this to store data store data in an S3 bucket managed by the AWS IoT Analytics service. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
        """
        return pulumi.get(self, "service_managed_s3")

    @service_managed_s3.setter
    def service_managed_s3(self, value: Optional[pulumi.Input['DatastoreServiceManagedS3Args']]):
        pulumi.set(self, "service_managed_s3", value)


if not MYPY:
    class DatastoreTimestampPartitionArgsDict(TypedDict):
        attribute_name: pulumi.Input[builtins.str]
        """
        The attribute name of the partition defined by a timestamp.
        """
        timestamp_format: NotRequired[pulumi.Input[builtins.str]]
        """
        The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch (January 1, 1970 at midnight UTC time).
        """
elif False:
    DatastoreTimestampPartitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatastoreTimestampPartitionArgs:
    def __init__(__self__, *,
                 attribute_name: pulumi.Input[builtins.str],
                 timestamp_format: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] attribute_name: The attribute name of the partition defined by a timestamp.
        :param pulumi.Input[builtins.str] timestamp_format: The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch (January 1, 1970 at midnight UTC time).
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> pulumi.Input[builtins.str]:
        """
        The attribute name of the partition defined by a timestamp.
        """
        return pulumi.get(self, "attribute_name")

    @attribute_name.setter
    def attribute_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute_name", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch (January 1, 1970 at midnight UTC time).
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timestamp_format", value)


if not MYPY:
    class PartitionArgsDict(TypedDict):
        attribute_name: pulumi.Input[builtins.str]
        """
        The name of the attribute that defines a partition dimension.
        """
elif False:
    PartitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PartitionArgs:
    def __init__(__self__, *,
                 attribute_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] attribute_name: The name of the attribute that defines a partition dimension.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the attribute that defines a partition dimension.
        """
        return pulumi.get(self, "attribute_name")

    @attribute_name.setter
    def attribute_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute_name", value)


if not MYPY:
    class PipelineActivityArgsDict(TypedDict):
        add_attributes: NotRequired[pulumi.Input['PipelineAddAttributesArgsDict']]
        """
        Adds other attributes based on existing attributes in the message.
        """
        channel: NotRequired[pulumi.Input['PipelineChannelArgsDict']]
        """
        Determines the source of the messages to be processed.
        """
        datastore: NotRequired[pulumi.Input['PipelineDatastoreArgsDict']]
        """
        Specifies where to store the processed message data.
        """
        device_registry_enrich: NotRequired[pulumi.Input['PipelineDeviceRegistryEnrichArgsDict']]
        """
        Adds data from the AWS IoT device registry to your message.
        """
        device_shadow_enrich: NotRequired[pulumi.Input['PipelineDeviceShadowEnrichArgsDict']]
        """
        Adds information from the AWS IoT Device Shadows service to a message.
        """
        filter: NotRequired[pulumi.Input['PipelineFilterArgsDict']]
        """
        Filters a message based on its attributes.
        """
        lambda_: NotRequired[pulumi.Input['PipelineLambdaArgsDict']]
        """
        Runs a Lambda function to modify the message.
        """
        math: NotRequired[pulumi.Input['PipelineMathArgsDict']]
        """
        Computes an arithmetic expression using the message's attributes and adds it to the message.
        """
        remove_attributes: NotRequired[pulumi.Input['PipelineRemoveAttributesArgsDict']]
        """
        Removes attributes from a message.
        """
        select_attributes: NotRequired[pulumi.Input['PipelineSelectAttributesArgsDict']]
        """
        Creates a new message using only the specified attributes from the original message.
        """
elif False:
    PipelineActivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineActivityArgs:
    def __init__(__self__, *,
                 add_attributes: Optional[pulumi.Input['PipelineAddAttributesArgs']] = None,
                 channel: Optional[pulumi.Input['PipelineChannelArgs']] = None,
                 datastore: Optional[pulumi.Input['PipelineDatastoreArgs']] = None,
                 device_registry_enrich: Optional[pulumi.Input['PipelineDeviceRegistryEnrichArgs']] = None,
                 device_shadow_enrich: Optional[pulumi.Input['PipelineDeviceShadowEnrichArgs']] = None,
                 filter: Optional[pulumi.Input['PipelineFilterArgs']] = None,
                 lambda_: Optional[pulumi.Input['PipelineLambdaArgs']] = None,
                 math: Optional[pulumi.Input['PipelineMathArgs']] = None,
                 remove_attributes: Optional[pulumi.Input['PipelineRemoveAttributesArgs']] = None,
                 select_attributes: Optional[pulumi.Input['PipelineSelectAttributesArgs']] = None):
        """
        :param pulumi.Input['PipelineAddAttributesArgs'] add_attributes: Adds other attributes based on existing attributes in the message.
        :param pulumi.Input['PipelineChannelArgs'] channel: Determines the source of the messages to be processed.
        :param pulumi.Input['PipelineDatastoreArgs'] datastore: Specifies where to store the processed message data.
        :param pulumi.Input['PipelineDeviceRegistryEnrichArgs'] device_registry_enrich: Adds data from the AWS IoT device registry to your message.
        :param pulumi.Input['PipelineDeviceShadowEnrichArgs'] device_shadow_enrich: Adds information from the AWS IoT Device Shadows service to a message.
        :param pulumi.Input['PipelineFilterArgs'] filter: Filters a message based on its attributes.
        :param pulumi.Input['PipelineLambdaArgs'] lambda_: Runs a Lambda function to modify the message.
        :param pulumi.Input['PipelineMathArgs'] math: Computes an arithmetic expression using the message's attributes and adds it to the message.
        :param pulumi.Input['PipelineRemoveAttributesArgs'] remove_attributes: Removes attributes from a message.
        :param pulumi.Input['PipelineSelectAttributesArgs'] select_attributes: Creates a new message using only the specified attributes from the original message.
        """
        if add_attributes is not None:
            pulumi.set(__self__, "add_attributes", add_attributes)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if device_registry_enrich is not None:
            pulumi.set(__self__, "device_registry_enrich", device_registry_enrich)
        if device_shadow_enrich is not None:
            pulumi.set(__self__, "device_shadow_enrich", device_shadow_enrich)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if math is not None:
            pulumi.set(__self__, "math", math)
        if remove_attributes is not None:
            pulumi.set(__self__, "remove_attributes", remove_attributes)
        if select_attributes is not None:
            pulumi.set(__self__, "select_attributes", select_attributes)

    @property
    @pulumi.getter(name="addAttributes")
    def add_attributes(self) -> Optional[pulumi.Input['PipelineAddAttributesArgs']]:
        """
        Adds other attributes based on existing attributes in the message.
        """
        return pulumi.get(self, "add_attributes")

    @add_attributes.setter
    def add_attributes(self, value: Optional[pulumi.Input['PipelineAddAttributesArgs']]):
        pulumi.set(self, "add_attributes", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input['PipelineChannelArgs']]:
        """
        Determines the source of the messages to be processed.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input['PipelineChannelArgs']]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['PipelineDatastoreArgs']]:
        """
        Specifies where to store the processed message data.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['PipelineDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter(name="deviceRegistryEnrich")
    def device_registry_enrich(self) -> Optional[pulumi.Input['PipelineDeviceRegistryEnrichArgs']]:
        """
        Adds data from the AWS IoT device registry to your message.
        """
        return pulumi.get(self, "device_registry_enrich")

    @device_registry_enrich.setter
    def device_registry_enrich(self, value: Optional[pulumi.Input['PipelineDeviceRegistryEnrichArgs']]):
        pulumi.set(self, "device_registry_enrich", value)

    @property
    @pulumi.getter(name="deviceShadowEnrich")
    def device_shadow_enrich(self) -> Optional[pulumi.Input['PipelineDeviceShadowEnrichArgs']]:
        """
        Adds information from the AWS IoT Device Shadows service to a message.
        """
        return pulumi.get(self, "device_shadow_enrich")

    @device_shadow_enrich.setter
    def device_shadow_enrich(self, value: Optional[pulumi.Input['PipelineDeviceShadowEnrichArgs']]):
        pulumi.set(self, "device_shadow_enrich", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['PipelineFilterArgs']]:
        """
        Filters a message based on its attributes.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['PipelineFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[pulumi.Input['PipelineLambdaArgs']]:
        """
        Runs a Lambda function to modify the message.
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: Optional[pulumi.Input['PipelineLambdaArgs']]):
        pulumi.set(self, "lambda_", value)

    @property
    @pulumi.getter
    def math(self) -> Optional[pulumi.Input['PipelineMathArgs']]:
        """
        Computes an arithmetic expression using the message's attributes and adds it to the message.
        """
        return pulumi.get(self, "math")

    @math.setter
    def math(self, value: Optional[pulumi.Input['PipelineMathArgs']]):
        pulumi.set(self, "math", value)

    @property
    @pulumi.getter(name="removeAttributes")
    def remove_attributes(self) -> Optional[pulumi.Input['PipelineRemoveAttributesArgs']]:
        """
        Removes attributes from a message.
        """
        return pulumi.get(self, "remove_attributes")

    @remove_attributes.setter
    def remove_attributes(self, value: Optional[pulumi.Input['PipelineRemoveAttributesArgs']]):
        pulumi.set(self, "remove_attributes", value)

    @property
    @pulumi.getter(name="selectAttributes")
    def select_attributes(self) -> Optional[pulumi.Input['PipelineSelectAttributesArgs']]:
        """
        Creates a new message using only the specified attributes from the original message.
        """
        return pulumi.get(self, "select_attributes")

    @select_attributes.setter
    def select_attributes(self, value: Optional[pulumi.Input['PipelineSelectAttributesArgs']]):
        pulumi.set(self, "select_attributes", value)


if not MYPY:
    class PipelineAddAttributesArgsDict(TypedDict):
        attributes: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]
        """
        A list of 1-50 "AttributeNameMapping" objects that map an existing attribute to a new attribute.

        > The existing attributes remain in the message, so if you want to remove the originals, use "RemoveAttributeActivity".
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'addAttributes' activity.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineAddAttributesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineAddAttributesArgs:
    def __init__(__self__, *,
                 attributes: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attributes: A list of 1-50 "AttributeNameMapping" objects that map an existing attribute to a new attribute.
               
               > The existing attributes remain in the message, so if you want to remove the originals, use "RemoveAttributeActivity".
        :param pulumi.Input[builtins.str] name: The name of the 'addAttributes' activity.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        A list of 1-50 "AttributeNameMapping" objects that map an existing attribute to a new attribute.

        > The existing attributes remain in the message, so if you want to remove the originals, use "RemoveAttributeActivity".
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'addAttributes' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


if not MYPY:
    class PipelineChannelArgsDict(TypedDict):
        channel_name: pulumi.Input[builtins.str]
        """
        The name of the channel from which the messages are processed.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'channel' activity.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineChannelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] channel_name: The name of the channel from which the messages are processed.
        :param pulumi.Input[builtins.str] name: The name of the 'channel' activity.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "channel_name", channel_name)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the channel from which the messages are processed.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'channel' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


if not MYPY:
    class PipelineDatastoreArgsDict(TypedDict):
        datastore_name: pulumi.Input[builtins.str]
        """
        The name of the data store where processed messages are stored.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the datastore activity.
        """
elif False:
    PipelineDatastoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDatastoreArgs:
    def __init__(__self__, *,
                 datastore_name: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] datastore_name: The name of the data store where processed messages are stored.
        :param pulumi.Input[builtins.str] name: The name of the datastore activity.
        """
        pulumi.set(__self__, "datastore_name", datastore_name)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="datastoreName")
    def datastore_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the data store where processed messages are stored.
        """
        return pulumi.get(self, "datastore_name")

    @datastore_name.setter
    def datastore_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "datastore_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the datastore activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class PipelineDeviceRegistryEnrichArgsDict(TypedDict):
        attribute: pulumi.Input[builtins.str]
        """
        The name of the attribute that is added to the message.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'deviceRegistryEnrich' activity.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The ARN of the role that allows access to the device's registry information.
        """
        thing_name: pulumi.Input[builtins.str]
        """
        The name of the IoT device whose registry information is added to the message.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineDeviceRegistryEnrichArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDeviceRegistryEnrichArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 thing_name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] attribute: The name of the attribute that is added to the message.
        :param pulumi.Input[builtins.str] name: The name of the 'deviceRegistryEnrich' activity.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the role that allows access to the device's registry information.
        :param pulumi.Input[builtins.str] thing_name: The name of the IoT device whose registry information is added to the message.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "thing_name", thing_name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[builtins.str]:
        """
        The name of the attribute that is added to the message.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'deviceRegistryEnrich' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the role that allows access to the device's registry information.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="thingName")
    def thing_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the IoT device whose registry information is added to the message.
        """
        return pulumi.get(self, "thing_name")

    @thing_name.setter
    def thing_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "thing_name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


if not MYPY:
    class PipelineDeviceShadowEnrichArgsDict(TypedDict):
        attribute: pulumi.Input[builtins.str]
        """
        The name of the attribute that is added to the message.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'deviceShadowEnrich' activity.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The ARN of the role that allows access to the device's shadow.
        """
        thing_name: pulumi.Input[builtins.str]
        """
        The name of the IoT device whose shadow information is added to the message.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineDeviceShadowEnrichArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDeviceShadowEnrichArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 thing_name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] attribute: The name of the attribute that is added to the message.
        :param pulumi.Input[builtins.str] name: The name of the 'deviceShadowEnrich' activity.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the role that allows access to the device's shadow.
        :param pulumi.Input[builtins.str] thing_name: The name of the IoT device whose shadow information is added to the message.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "thing_name", thing_name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[builtins.str]:
        """
        The name of the attribute that is added to the message.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'deviceShadowEnrich' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the role that allows access to the device's shadow.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="thingName")
    def thing_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the IoT device whose shadow information is added to the message.
        """
        return pulumi.get(self, "thing_name")

    @thing_name.setter
    def thing_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "thing_name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


if not MYPY:
    class PipelineFilterArgsDict(TypedDict):
        filter: pulumi.Input[builtins.str]
        """
        An expression that looks like an SQL WHERE clause that must return a Boolean value.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'filter' activity.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] filter: An expression that looks like an SQL WHERE clause that must return a Boolean value.
        :param pulumi.Input[builtins.str] name: The name of the 'filter' activity.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[builtins.str]:
        """
        An expression that looks like an SQL WHERE clause that must return a Boolean value.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'filter' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


if not MYPY:
    class PipelineLambdaArgsDict(TypedDict):
        batch_size: pulumi.Input[builtins.int]
        """
        The number of messages passed to the Lambda function for processing.

        The AWS Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.
        """
        lambda_name: pulumi.Input[builtins.str]
        """
        The name of the Lambda function that is run on the message.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'lambda' activity.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineLambdaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineLambdaArgs:
    def __init__(__self__, *,
                 batch_size: pulumi.Input[builtins.int],
                 lambda_name: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] batch_size: The number of messages passed to the Lambda function for processing.
               
               The AWS Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.
        :param pulumi.Input[builtins.str] lambda_name: The name of the Lambda function that is run on the message.
        :param pulumi.Input[builtins.str] name: The name of the 'lambda' activity.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "batch_size", batch_size)
        pulumi.set(__self__, "lambda_name", lambda_name)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> pulumi.Input[builtins.int]:
        """
        The number of messages passed to the Lambda function for processing.

        The AWS Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="lambdaName")
    def lambda_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Lambda function that is run on the message.
        """
        return pulumi.get(self, "lambda_name")

    @lambda_name.setter
    def lambda_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lambda_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'lambda' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


if not MYPY:
    class PipelineMathArgsDict(TypedDict):
        attribute: pulumi.Input[builtins.str]
        """
        The name of the attribute that contains the result of the math operation.
        """
        math: pulumi.Input[builtins.str]
        """
        An expression that uses one or more existing attributes and must return an integer value.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'math' activity.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineMathArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineMathArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[builtins.str],
                 math: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] attribute: The name of the attribute that contains the result of the math operation.
        :param pulumi.Input[builtins.str] math: An expression that uses one or more existing attributes and must return an integer value.
        :param pulumi.Input[builtins.str] name: The name of the 'math' activity.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "math", math)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[builtins.str]:
        """
        The name of the attribute that contains the result of the math operation.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def math(self) -> pulumi.Input[builtins.str]:
        """
        An expression that uses one or more existing attributes and must return an integer value.
        """
        return pulumi.get(self, "math")

    @math.setter
    def math(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "math", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'math' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


if not MYPY:
    class PipelineRemoveAttributesArgsDict(TypedDict):
        attributes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of 1-50 attributes to remove from the message.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'removeAttributes' activity.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineRemoveAttributesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineRemoveAttributesArgs:
    def __init__(__self__, *,
                 attributes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attributes: A list of 1-50 attributes to remove from the message.
        :param pulumi.Input[builtins.str] name: The name of the 'removeAttributes' activity.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of 1-50 attributes to remove from the message.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'removeAttributes' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


if not MYPY:
    class PipelineSelectAttributesArgsDict(TypedDict):
        attributes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of the attributes to select from the message.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the 'selectAttributes' activity.
        """
        next: NotRequired[pulumi.Input[builtins.str]]
        """
        The next activity in the pipeline.
        """
elif False:
    PipelineSelectAttributesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineSelectAttributesArgs:
    def __init__(__self__, *,
                 attributes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name: pulumi.Input[builtins.str],
                 next: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attributes: A list of the attributes to select from the message.
        :param pulumi.Input[builtins.str] name: The name of the 'selectAttributes' activity.
        :param pulumi.Input[builtins.str] next: The next activity in the pipeline.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of the attributes to select from the message.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the 'selectAttributes' activity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next activity in the pipeline.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next", value)


