# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['ThingGroupArgs', 'ThingGroup']

@pulumi.input_type
class ThingGroupArgs:
    def __init__(__self__, *,
                 parent_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 thing_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 thing_group_properties: Optional[pulumi.Input['ThingGroupPropertiesPropertiesArgs']] = None):
        """
        The set of arguments for constructing a ThingGroup resource.
        :param pulumi.Input[builtins.str] parent_group_name: The parent thing group name.
               
               A Dynamic Thing Group does not have `parentGroupName` defined.
        :param pulumi.Input[builtins.str] query_string: The dynamic thing group search query string.
               
               The `queryString` attribute *is* required for `CreateDynamicThingGroup` . The `queryString` attribute *is not* required for `CreateThingGroup` .
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] thing_group_name: The thing group name.
        :param pulumi.Input['ThingGroupPropertiesPropertiesArgs'] thing_group_properties: Thing group properties.
        """
        if parent_group_name is not None:
            pulumi.set(__self__, "parent_group_name", parent_group_name)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if thing_group_name is not None:
            pulumi.set(__self__, "thing_group_name", thing_group_name)
        if thing_group_properties is not None:
            pulumi.set(__self__, "thing_group_properties", thing_group_properties)

    @property
    @pulumi.getter(name="parentGroupName")
    def parent_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent thing group name.

        A Dynamic Thing Group does not have `parentGroupName` defined.
        """
        return pulumi.get(self, "parent_group_name")

    @parent_group_name.setter
    def parent_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_group_name", value)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The dynamic thing group search query string.

        The `queryString` attribute *is* required for `CreateDynamicThingGroup` . The `queryString` attribute *is not* required for `CreateThingGroup` .
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="thingGroupName")
    def thing_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The thing group name.
        """
        return pulumi.get(self, "thing_group_name")

    @thing_group_name.setter
    def thing_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thing_group_name", value)

    @property
    @pulumi.getter(name="thingGroupProperties")
    def thing_group_properties(self) -> Optional[pulumi.Input['ThingGroupPropertiesPropertiesArgs']]:
        """
        Thing group properties.
        """
        return pulumi.get(self, "thing_group_properties")

    @thing_group_properties.setter
    def thing_group_properties(self, value: Optional[pulumi.Input['ThingGroupPropertiesPropertiesArgs']]):
        pulumi.set(self, "thing_group_properties", value)


@pulumi.type_token("aws-native:iot:ThingGroup")
class ThingGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parent_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 thing_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 thing_group_properties: Optional[pulumi.Input[Union['ThingGroupPropertiesPropertiesArgs', 'ThingGroupPropertiesPropertiesArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::IoT::ThingGroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] parent_group_name: The parent thing group name.
               
               A Dynamic Thing Group does not have `parentGroupName` defined.
        :param pulumi.Input[builtins.str] query_string: The dynamic thing group search query string.
               
               The `queryString` attribute *is* required for `CreateDynamicThingGroup` . The `queryString` attribute *is not* required for `CreateThingGroup` .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] thing_group_name: The thing group name.
        :param pulumi.Input[Union['ThingGroupPropertiesPropertiesArgs', 'ThingGroupPropertiesPropertiesArgsDict']] thing_group_properties: Thing group properties.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ThingGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::IoT::ThingGroup

        :param str resource_name: The name of the resource.
        :param ThingGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThingGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parent_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 thing_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 thing_group_properties: Optional[pulumi.Input[Union['ThingGroupPropertiesPropertiesArgs', 'ThingGroupPropertiesPropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThingGroupArgs.__new__(ThingGroupArgs)

            __props__.__dict__["parent_group_name"] = parent_group_name
            __props__.__dict__["query_string"] = query_string
            __props__.__dict__["tags"] = tags
            __props__.__dict__["thing_group_name"] = thing_group_name
            __props__.__dict__["thing_group_properties"] = thing_group_properties
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["parentGroupName", "thingGroupName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ThingGroup, __self__).__init__(
            'aws-native:iot:ThingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ThingGroup':
        """
        Get an existing ThingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ThingGroupArgs.__new__(ThingGroupArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["parent_group_name"] = None
        __props__.__dict__["query_string"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["thing_group_name"] = None
        __props__.__dict__["thing_group_properties"] = None
        return ThingGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The thing group ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The thing group ID.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="parentGroupName")
    def parent_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The parent thing group name.

        A Dynamic Thing Group does not have `parentGroupName` defined.
        """
        return pulumi.get(self, "parent_group_name")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The dynamic thing group search query string.

        The `queryString` attribute *is* required for `CreateDynamicThingGroup` . The `queryString` attribute *is not* required for `CreateThingGroup` .
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="thingGroupName")
    def thing_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The thing group name.
        """
        return pulumi.get(self, "thing_group_name")

    @property
    @pulumi.getter(name="thingGroupProperties")
    def thing_group_properties(self) -> pulumi.Output[Optional['outputs.ThingGroupPropertiesProperties']]:
        """
        Thing group properties.
        """
        return pulumi.get(self, "thing_group_properties")

