# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ThingArgs', 'Thing']

@pulumi.input_type
class ThingArgs:
    def __init__(__self__, *,
                 attribute_payload: Optional[pulumi.Input['ThingAttributePayloadArgs']] = None,
                 thing_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Thing resource.
        :param pulumi.Input['ThingAttributePayloadArgs'] attribute_payload: A string that contains up to three key value pairs. Maximum length of 800. Duplicates not allowed.
        :param pulumi.Input[builtins.str] thing_name: The name of the thing to update.
               
               You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
        """
        if attribute_payload is not None:
            pulumi.set(__self__, "attribute_payload", attribute_payload)
        if thing_name is not None:
            pulumi.set(__self__, "thing_name", thing_name)

    @property
    @pulumi.getter(name="attributePayload")
    def attribute_payload(self) -> Optional[pulumi.Input['ThingAttributePayloadArgs']]:
        """
        A string that contains up to three key value pairs. Maximum length of 800. Duplicates not allowed.
        """
        return pulumi.get(self, "attribute_payload")

    @attribute_payload.setter
    def attribute_payload(self, value: Optional[pulumi.Input['ThingAttributePayloadArgs']]):
        pulumi.set(self, "attribute_payload", value)

    @property
    @pulumi.getter(name="thingName")
    def thing_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the thing to update.

        You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
        """
        return pulumi.get(self, "thing_name")

    @thing_name.setter
    def thing_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thing_name", value)


@pulumi.type_token("aws-native:iot:Thing")
class Thing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_payload: Optional[pulumi.Input[Union['ThingAttributePayloadArgs', 'ThingAttributePayloadArgsDict']]] = None,
                 thing_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::IoT::Thing

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        name_parameter = config.require("nameParameter")
        my_attribute_value_a = config.get("myAttributeValueA")
        if my_attribute_value_a is None:
            my_attribute_value_a = "myStringA123"
        my_attribute_value_b = config.get("myAttributeValueB")
        if my_attribute_value_b is None:
            my_attribute_value_b = "myStringB123"
        my_attribute_value_c = config.get("myAttributeValueC")
        if my_attribute_value_c is None:
            my_attribute_value_c = "myStringC123"
        my_thing = aws_native.iot.Thing("myThing",
            thing_name=name_parameter,
            attribute_payload={
                "attributes": {
                    "myAttributeA": my_attribute_value_a,
                    "myAttributeB": my_attribute_value_b,
                    "myAttributeC": my_attribute_value_c,
                },
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ThingAttributePayloadArgs', 'ThingAttributePayloadArgsDict']] attribute_payload: A string that contains up to three key value pairs. Maximum length of 800. Duplicates not allowed.
        :param pulumi.Input[builtins.str] thing_name: The name of the thing to update.
               
               You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ThingArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::IoT::Thing

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        name_parameter = config.require("nameParameter")
        my_attribute_value_a = config.get("myAttributeValueA")
        if my_attribute_value_a is None:
            my_attribute_value_a = "myStringA123"
        my_attribute_value_b = config.get("myAttributeValueB")
        if my_attribute_value_b is None:
            my_attribute_value_b = "myStringB123"
        my_attribute_value_c = config.get("myAttributeValueC")
        if my_attribute_value_c is None:
            my_attribute_value_c = "myStringC123"
        my_thing = aws_native.iot.Thing("myThing",
            thing_name=name_parameter,
            attribute_payload={
                "attributes": {
                    "myAttributeA": my_attribute_value_a,
                    "myAttributeB": my_attribute_value_b,
                    "myAttributeC": my_attribute_value_c,
                },
            })

        ```

        :param str resource_name: The name of the resource.
        :param ThingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_payload: Optional[pulumi.Input[Union['ThingAttributePayloadArgs', 'ThingAttributePayloadArgsDict']]] = None,
                 thing_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThingArgs.__new__(ThingArgs)

            __props__.__dict__["attribute_payload"] = attribute_payload
            __props__.__dict__["thing_name"] = thing_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["thingName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Thing, __self__).__init__(
            'aws-native:iot:Thing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Thing':
        """
        Get an existing Thing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ThingArgs.__new__(ThingArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["attribute_payload"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["thing_name"] = None
        return Thing(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS IoT thing, such as `arn:aws:iot:us-east-2:123456789012:thing/MyThing` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="attributePayload")
    def attribute_payload(self) -> pulumi.Output[Optional['outputs.ThingAttributePayload']]:
        """
        A string that contains up to three key value pairs. Maximum length of 800. Duplicates not allowed.
        """
        return pulumi.get(self, "attribute_payload")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The Id of this thing.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="thingName")
    def thing_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the thing to update.

        You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
        """
        return pulumi.get(self, "thing_name")

