# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['SoftwarePackageVersionArgs', 'SoftwarePackageVersion']

@pulumi.input_type
class SoftwarePackageVersionArgs:
    def __init__(__self__, *,
                 package_name: pulumi.Input[builtins.str],
                 artifact: Optional[pulumi.Input['SoftwarePackageVersionPackageVersionArtifactArgs']] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 recipe: Optional[pulumi.Input[builtins.str]] = None,
                 sbom: Optional[pulumi.Input['SoftwarePackageVersionSbomArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SoftwarePackageVersion resource.
        :param pulumi.Input[builtins.str] package_name: The name of the associated software package.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attributes: Metadata that can be used to define a package version’s configuration. For example, the S3 file location, configuration options that are being sent to the device or fleet.
               
               The combined size of all the attributes on a package version is limited to 3KB.
        :param pulumi.Input[builtins.str] description: A summary of the package version being created. This can be used to outline the package's contents or purpose.
        :param pulumi.Input[builtins.str] recipe: The inline json job document associated with a software package version
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] version_name: The name of the new package version.
        """
        pulumi.set(__self__, "package_name", package_name)
        if artifact is not None:
            pulumi.set(__self__, "artifact", artifact)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if recipe is not None:
            pulumi.set(__self__, "recipe", recipe)
        if sbom is not None:
            pulumi.set(__self__, "sbom", sbom)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the associated software package.
        """
        return pulumi.get(self, "package_name")

    @package_name.setter
    def package_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "package_name", value)

    @property
    @pulumi.getter
    def artifact(self) -> Optional[pulumi.Input['SoftwarePackageVersionPackageVersionArtifactArgs']]:
        return pulumi.get(self, "artifact")

    @artifact.setter
    def artifact(self, value: Optional[pulumi.Input['SoftwarePackageVersionPackageVersionArtifactArgs']]):
        pulumi.set(self, "artifact", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata that can be used to define a package version’s configuration. For example, the S3 file location, configuration options that are being sent to the device or fleet.

        The combined size of all the attributes on a package version is limited to 3KB.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A summary of the package version being created. This can be used to outline the package's contents or purpose.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def recipe(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The inline json job document associated with a software package version
        """
        return pulumi.get(self, "recipe")

    @recipe.setter
    def recipe(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recipe", value)

    @property
    @pulumi.getter
    def sbom(self) -> Optional[pulumi.Input['SoftwarePackageVersionSbomArgs']]:
        return pulumi.get(self, "sbom")

    @sbom.setter
    def sbom(self, value: Optional[pulumi.Input['SoftwarePackageVersionSbomArgs']]):
        pulumi.set(self, "sbom", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the new package version.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_name", value)


@pulumi.type_token("aws-native:iot:SoftwarePackageVersion")
class SoftwarePackageVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact: Optional[pulumi.Input[Union['SoftwarePackageVersionPackageVersionArtifactArgs', 'SoftwarePackageVersionPackageVersionArtifactArgsDict']]] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 package_name: Optional[pulumi.Input[builtins.str]] = None,
                 recipe: Optional[pulumi.Input[builtins.str]] = None,
                 sbom: Optional[pulumi.Input[Union['SoftwarePackageVersionSbomArgs', 'SoftwarePackageVersionSbomArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        resource definition

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attributes: Metadata that can be used to define a package version’s configuration. For example, the S3 file location, configuration options that are being sent to the device or fleet.
               
               The combined size of all the attributes on a package version is limited to 3KB.
        :param pulumi.Input[builtins.str] description: A summary of the package version being created. This can be used to outline the package's contents or purpose.
        :param pulumi.Input[builtins.str] package_name: The name of the associated software package.
        :param pulumi.Input[builtins.str] recipe: The inline json job document associated with a software package version
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] version_name: The name of the new package version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SoftwarePackageVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        resource definition

        :param str resource_name: The name of the resource.
        :param SoftwarePackageVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SoftwarePackageVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact: Optional[pulumi.Input[Union['SoftwarePackageVersionPackageVersionArtifactArgs', 'SoftwarePackageVersionPackageVersionArtifactArgsDict']]] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 package_name: Optional[pulumi.Input[builtins.str]] = None,
                 recipe: Optional[pulumi.Input[builtins.str]] = None,
                 sbom: Optional[pulumi.Input[Union['SoftwarePackageVersionSbomArgs', 'SoftwarePackageVersionSbomArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SoftwarePackageVersionArgs.__new__(SoftwarePackageVersionArgs)

            __props__.__dict__["artifact"] = artifact
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["description"] = description
            if package_name is None and not opts.urn:
                raise TypeError("Missing required property 'package_name'")
            __props__.__dict__["package_name"] = package_name
            __props__.__dict__["recipe"] = recipe
            __props__.__dict__["sbom"] = sbom
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version_name"] = version_name
            __props__.__dict__["error_reason"] = None
            __props__.__dict__["package_version_arn"] = None
            __props__.__dict__["sbom_validation_status"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["packageName", "versionName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SoftwarePackageVersion, __self__).__init__(
            'aws-native:iot:SoftwarePackageVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SoftwarePackageVersion':
        """
        Get an existing SoftwarePackageVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SoftwarePackageVersionArgs.__new__(SoftwarePackageVersionArgs)

        __props__.__dict__["artifact"] = None
        __props__.__dict__["attributes"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["error_reason"] = None
        __props__.__dict__["package_name"] = None
        __props__.__dict__["package_version_arn"] = None
        __props__.__dict__["recipe"] = None
        __props__.__dict__["sbom"] = None
        __props__.__dict__["sbom_validation_status"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["version_name"] = None
        return SoftwarePackageVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def artifact(self) -> pulumi.Output[Optional['outputs.SoftwarePackageVersionPackageVersionArtifact']]:
        return pulumi.get(self, "artifact")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Metadata that can be used to define a package version’s configuration. For example, the S3 file location, configuration options that are being sent to the device or fleet.

        The combined size of all the attributes on a package version is limited to 3KB.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A summary of the package version being created. This can be used to outline the package's contents or purpose.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="errorReason")
    def error_reason(self) -> pulumi.Output[builtins.str]:
        """
        Error reason for a package version failure during creation or update.
        """
        return pulumi.get(self, "error_reason")

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the associated software package.
        """
        return pulumi.get(self, "package_name")

    @property
    @pulumi.getter(name="packageVersionArn")
    def package_version_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the package.
        """
        return pulumi.get(self, "package_version_arn")

    @property
    @pulumi.getter
    def recipe(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The inline json job document associated with a software package version
        """
        return pulumi.get(self, "recipe")

    @property
    @pulumi.getter
    def sbom(self) -> pulumi.Output[Optional['outputs.SoftwarePackageVersionSbom']]:
        return pulumi.get(self, "sbom")

    @property
    @pulumi.getter(name="sbomValidationStatus")
    def sbom_validation_status(self) -> pulumi.Output['SoftwarePackageVersionSbomValidationStatus']:
        return pulumi.get(self, "sbom_validation_status")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['SoftwarePackageVersionPackageVersionStatus']:
        """
        The status of the package version. For more information, see [Package version lifecycle](https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle) .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the new package version.
        """
        return pulumi.get(self, "version_name")

