# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ProvisioningTemplateArgs', 'ProvisioningTemplate']

@pulumi.input_type
class ProvisioningTemplateArgs:
    def __init__(__self__, *,
                 provisioning_role_arn: pulumi.Input[builtins.str],
                 template_body: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pre_provisioning_hook: Optional[pulumi.Input['ProvisioningTemplateProvisioningHookArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input['ProvisioningTemplateTemplateType']] = None):
        """
        The set of arguments for constructing a ProvisioningTemplate resource.
        :param pulumi.Input[builtins.str] provisioning_role_arn: The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
        :param pulumi.Input[builtins.str] template_body: The JSON formatted contents of the fleet provisioning template version.
        :param pulumi.Input[builtins.str] description: The description of the fleet provisioning template.
        :param pulumi.Input[builtins.bool] enabled: True to enable the fleet provisioning template, otherwise false.
        :param pulumi.Input['ProvisioningTemplateProvisioningHookArgs'] pre_provisioning_hook: Creates a pre-provisioning hook template.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Metadata that can be used to manage the fleet provisioning template.
        :param pulumi.Input[builtins.str] template_name: The name of the fleet provisioning template.
        :param pulumi.Input['ProvisioningTemplateTemplateType'] template_type: The type of the provisioning template.
        """
        pulumi.set(__self__, "provisioning_role_arn", provisioning_role_arn)
        pulumi.set(__self__, "template_body", template_body)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if pre_provisioning_hook is not None:
            pulumi.set(__self__, "pre_provisioning_hook", pre_provisioning_hook)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)

    @property
    @pulumi.getter(name="provisioningRoleArn")
    def provisioning_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
        """
        return pulumi.get(self, "provisioning_role_arn")

    @provisioning_role_arn.setter
    def provisioning_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "provisioning_role_arn", value)

    @property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> pulumi.Input[builtins.str]:
        """
        The JSON formatted contents of the fleet provisioning template version.
        """
        return pulumi.get(self, "template_body")

    @template_body.setter
    def template_body(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "template_body", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the fleet provisioning template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True to enable the fleet provisioning template, otherwise false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="preProvisioningHook")
    def pre_provisioning_hook(self) -> Optional[pulumi.Input['ProvisioningTemplateProvisioningHookArgs']]:
        """
        Creates a pre-provisioning hook template.
        """
        return pulumi.get(self, "pre_provisioning_hook")

    @pre_provisioning_hook.setter
    def pre_provisioning_hook(self, value: Optional[pulumi.Input['ProvisioningTemplateProvisioningHookArgs']]):
        pulumi.set(self, "pre_provisioning_hook", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Metadata that can be used to manage the fleet provisioning template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the fleet provisioning template.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input['ProvisioningTemplateTemplateType']]:
        """
        The type of the provisioning template.
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input['ProvisioningTemplateTemplateType']]):
        pulumi.set(self, "template_type", value)


@pulumi.type_token("aws-native:iot:ProvisioningTemplate")
class ProvisioningTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pre_provisioning_hook: Optional[pulumi.Input[Union['ProvisioningTemplateProvisioningHookArgs', 'ProvisioningTemplateProvisioningHookArgsDict']]] = None,
                 provisioning_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 template_body: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input['ProvisioningTemplateTemplateType']] = None,
                 __props__=None):
        """
        Creates a fleet provisioning template.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the fleet provisioning template.
        :param pulumi.Input[builtins.bool] enabled: True to enable the fleet provisioning template, otherwise false.
        :param pulumi.Input[Union['ProvisioningTemplateProvisioningHookArgs', 'ProvisioningTemplateProvisioningHookArgsDict']] pre_provisioning_hook: Creates a pre-provisioning hook template.
        :param pulumi.Input[builtins.str] provisioning_role_arn: The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Metadata that can be used to manage the fleet provisioning template.
        :param pulumi.Input[builtins.str] template_body: The JSON formatted contents of the fleet provisioning template version.
        :param pulumi.Input[builtins.str] template_name: The name of the fleet provisioning template.
        :param pulumi.Input['ProvisioningTemplateTemplateType'] template_type: The type of the provisioning template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProvisioningTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a fleet provisioning template.

        :param str resource_name: The name of the resource.
        :param ProvisioningTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProvisioningTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pre_provisioning_hook: Optional[pulumi.Input[Union['ProvisioningTemplateProvisioningHookArgs', 'ProvisioningTemplateProvisioningHookArgsDict']]] = None,
                 provisioning_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 template_body: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input['ProvisioningTemplateTemplateType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProvisioningTemplateArgs.__new__(ProvisioningTemplateArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["pre_provisioning_hook"] = pre_provisioning_hook
            if provisioning_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'provisioning_role_arn'")
            __props__.__dict__["provisioning_role_arn"] = provisioning_role_arn
            __props__.__dict__["tags"] = tags
            if template_body is None and not opts.urn:
                raise TypeError("Missing required property 'template_body'")
            __props__.__dict__["template_body"] = template_body
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["template_type"] = template_type
            __props__.__dict__["template_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["templateName", "templateType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ProvisioningTemplate, __self__).__init__(
            'aws-native:iot:ProvisioningTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ProvisioningTemplate':
        """
        Get an existing ProvisioningTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ProvisioningTemplateArgs.__new__(ProvisioningTemplateArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["pre_provisioning_hook"] = None
        __props__.__dict__["provisioning_role_arn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["template_arn"] = None
        __props__.__dict__["template_body"] = None
        __props__.__dict__["template_name"] = None
        __props__.__dict__["template_type"] = None
        return ProvisioningTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the fleet provisioning template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        True to enable the fleet provisioning template, otherwise false.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="preProvisioningHook")
    def pre_provisioning_hook(self) -> pulumi.Output[Optional['outputs.ProvisioningTemplateProvisioningHook']]:
        """
        Creates a pre-provisioning hook template.
        """
        return pulumi.get(self, "pre_provisioning_hook")

    @property
    @pulumi.getter(name="provisioningRoleArn")
    def provisioning_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
        """
        return pulumi.get(self, "provisioning_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Metadata that can be used to manage the fleet provisioning template.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN that identifies the provisioning template.
        """
        return pulumi.get(self, "template_arn")

    @property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> pulumi.Output[builtins.str]:
        """
        The JSON formatted contents of the fleet provisioning template version.
        """
        return pulumi.get(self, "template_body")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the fleet provisioning template.
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[Optional['ProvisioningTemplateTemplateType']]:
        """
        The type of the provisioning template.
        """
        return pulumi.get(self, "template_type")

