# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetThingTypeResult',
    'AwaitableGetThingTypeResult',
    'get_thing_type',
    'get_thing_type_output',
]

@pulumi.output_type
class GetThingTypeResult:
    def __init__(__self__, arn=None, deprecate_thing_type=None, id=None, tags=None, thing_type_properties=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if deprecate_thing_type and not isinstance(deprecate_thing_type, bool):
            raise TypeError("Expected argument 'deprecate_thing_type' to be a bool")
        pulumi.set(__self__, "deprecate_thing_type", deprecate_thing_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if thing_type_properties and not isinstance(thing_type_properties, dict):
            raise TypeError("Expected argument 'thing_type_properties' to be a dict")
        pulumi.set(__self__, "thing_type_properties", thing_type_properties)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The thing type arn.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deprecateThingType")
    def deprecate_thing_type(self) -> Optional[builtins.bool]:
        """
        Deprecates a thing type. You can not associate new things with deprecated thing type.

        Requires permission to access the [DeprecateThingType](https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
        """
        return pulumi.get(self, "deprecate_thing_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The thing type id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="thingTypeProperties")
    def thing_type_properties(self) -> Optional['outputs.ThingTypePropertiesProperties']:
        """
        The thing type properties for the thing type to create. It contains information about the new thing type including a description, a list of searchable thing attribute names, and a list of propagating attributes. After a thing type is created, you can only update `Mqtt5Configuration` .
        """
        return pulumi.get(self, "thing_type_properties")


class AwaitableGetThingTypeResult(GetThingTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetThingTypeResult(
            arn=self.arn,
            deprecate_thing_type=self.deprecate_thing_type,
            id=self.id,
            tags=self.tags,
            thing_type_properties=self.thing_type_properties)


def get_thing_type(thing_type_name: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetThingTypeResult:
    """
    Resource Type definition for AWS::IoT::ThingType


    :param builtins.str thing_type_name: The name of the thing type.
    """
    __args__ = dict()
    __args__['thingTypeName'] = thing_type_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iot:getThingType', __args__, opts=opts, typ=GetThingTypeResult).value

    return AwaitableGetThingTypeResult(
        arn=pulumi.get(__ret__, 'arn'),
        deprecate_thing_type=pulumi.get(__ret__, 'deprecate_thing_type'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'),
        thing_type_properties=pulumi.get(__ret__, 'thing_type_properties'))
def get_thing_type_output(thing_type_name: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetThingTypeResult]:
    """
    Resource Type definition for AWS::IoT::ThingType


    :param builtins.str thing_type_name: The name of the thing type.
    """
    __args__ = dict()
    __args__['thingTypeName'] = thing_type_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iot:getThingType', __args__, opts=opts, typ=GetThingTypeResult)
    return __ret__.apply(lambda __response__: GetThingTypeResult(
        arn=pulumi.get(__response__, 'arn'),
        deprecate_thing_type=pulumi.get(__response__, 'deprecate_thing_type'),
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags'),
        thing_type_properties=pulumi.get(__response__, 'thing_type_properties')))
