# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetThingGroupResult',
    'AwaitableGetThingGroupResult',
    'get_thing_group',
    'get_thing_group_output',
]

@pulumi.output_type
class GetThingGroupResult:
    def __init__(__self__, arn=None, id=None, query_string=None, tags=None, thing_group_properties=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if query_string and not isinstance(query_string, str):
            raise TypeError("Expected argument 'query_string' to be a str")
        pulumi.set(__self__, "query_string", query_string)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if thing_group_properties and not isinstance(thing_group_properties, dict):
            raise TypeError("Expected argument 'thing_group_properties' to be a dict")
        pulumi.set(__self__, "thing_group_properties", thing_group_properties)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The thing group ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The thing group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[builtins.str]:
        """
        The dynamic thing group search query string.

        The `queryString` attribute *is* required for `CreateDynamicThingGroup` . The `queryString` attribute *is not* required for `CreateThingGroup` .
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="thingGroupProperties")
    def thing_group_properties(self) -> Optional['outputs.ThingGroupPropertiesProperties']:
        """
        Thing group properties.
        """
        return pulumi.get(self, "thing_group_properties")


class AwaitableGetThingGroupResult(GetThingGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetThingGroupResult(
            arn=self.arn,
            id=self.id,
            query_string=self.query_string,
            tags=self.tags,
            thing_group_properties=self.thing_group_properties)


def get_thing_group(thing_group_name: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetThingGroupResult:
    """
    Resource Type definition for AWS::IoT::ThingGroup


    :param builtins.str thing_group_name: The thing group name.
    """
    __args__ = dict()
    __args__['thingGroupName'] = thing_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iot:getThingGroup', __args__, opts=opts, typ=GetThingGroupResult).value

    return AwaitableGetThingGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        query_string=pulumi.get(__ret__, 'query_string'),
        tags=pulumi.get(__ret__, 'tags'),
        thing_group_properties=pulumi.get(__ret__, 'thing_group_properties'))
def get_thing_group_output(thing_group_name: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetThingGroupResult]:
    """
    Resource Type definition for AWS::IoT::ThingGroup


    :param builtins.str thing_group_name: The thing group name.
    """
    __args__ = dict()
    __args__['thingGroupName'] = thing_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iot:getThingGroup', __args__, opts=opts, typ=GetThingGroupResult)
    return __ret__.apply(lambda __response__: GetThingGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        query_string=pulumi.get(__response__, 'query_string'),
        tags=pulumi.get(__response__, 'tags'),
        thing_group_properties=pulumi.get(__response__, 'thing_group_properties')))
