# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetSoftwarePackageResult',
    'AwaitableGetSoftwarePackageResult',
    'get_software_package',
    'get_software_package_output',
]

@pulumi.output_type
class GetSoftwarePackageResult:
    def __init__(__self__, description=None, package_arn=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if package_arn and not isinstance(package_arn, str):
            raise TypeError("Expected argument 'package_arn' to be a str")
        pulumi.set(__self__, "package_arn", package_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A summary of the package being created. This can be used to outline the package's contents or purpose.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="packageArn")
    def package_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the package.
        """
        return pulumi.get(self, "package_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSoftwarePackageResult(GetSoftwarePackageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwarePackageResult(
            description=self.description,
            package_arn=self.package_arn,
            tags=self.tags)


def get_software_package(package_name: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwarePackageResult:
    """
    resource definition


    :param builtins.str package_name: The name of the new software package.
    """
    __args__ = dict()
    __args__['packageName'] = package_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iot:getSoftwarePackage', __args__, opts=opts, typ=GetSoftwarePackageResult).value

    return AwaitableGetSoftwarePackageResult(
        description=pulumi.get(__ret__, 'description'),
        package_arn=pulumi.get(__ret__, 'package_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_software_package_output(package_name: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSoftwarePackageResult]:
    """
    resource definition


    :param builtins.str package_name: The name of the new software package.
    """
    __args__ = dict()
    __args__['packageName'] = package_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iot:getSoftwarePackage', __args__, opts=opts, typ=GetSoftwarePackageResult)
    return __ret__.apply(lambda __response__: GetSoftwarePackageResult(
        description=pulumi.get(__response__, 'description'),
        package_arn=pulumi.get(__response__, 'package_arn'),
        tags=pulumi.get(__response__, 'tags')))
