# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetSecurityProfileResult',
    'AwaitableGetSecurityProfileResult',
    'get_security_profile',
    'get_security_profile_output',
]

@pulumi.output_type
class GetSecurityProfileResult:
    def __init__(__self__, additional_metrics_to_retain_v2=None, alert_targets=None, behaviors=None, metrics_export_config=None, security_profile_arn=None, security_profile_description=None, tags=None, target_arns=None):
        if additional_metrics_to_retain_v2 and not isinstance(additional_metrics_to_retain_v2, list):
            raise TypeError("Expected argument 'additional_metrics_to_retain_v2' to be a list")
        pulumi.set(__self__, "additional_metrics_to_retain_v2", additional_metrics_to_retain_v2)
        if alert_targets and not isinstance(alert_targets, dict):
            raise TypeError("Expected argument 'alert_targets' to be a dict")
        pulumi.set(__self__, "alert_targets", alert_targets)
        if behaviors and not isinstance(behaviors, list):
            raise TypeError("Expected argument 'behaviors' to be a list")
        pulumi.set(__self__, "behaviors", behaviors)
        if metrics_export_config and not isinstance(metrics_export_config, dict):
            raise TypeError("Expected argument 'metrics_export_config' to be a dict")
        pulumi.set(__self__, "metrics_export_config", metrics_export_config)
        if security_profile_arn and not isinstance(security_profile_arn, str):
            raise TypeError("Expected argument 'security_profile_arn' to be a str")
        pulumi.set(__self__, "security_profile_arn", security_profile_arn)
        if security_profile_description and not isinstance(security_profile_description, str):
            raise TypeError("Expected argument 'security_profile_description' to be a str")
        pulumi.set(__self__, "security_profile_description", security_profile_description)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target_arns and not isinstance(target_arns, list):
            raise TypeError("Expected argument 'target_arns' to be a list")
        pulumi.set(__self__, "target_arns", target_arns)

    @property
    @pulumi.getter(name="additionalMetricsToRetainV2")
    def additional_metrics_to_retain_v2(self) -> Optional[Sequence['outputs.SecurityProfileMetricToRetain']]:
        """
        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here.
        """
        return pulumi.get(self, "additional_metrics_to_retain_v2")

    @property
    @pulumi.getter(name="alertTargets")
    def alert_targets(self) -> Optional[Mapping[str, 'outputs.SecurityProfileAlertTarget']]:
        """
        Specifies the destinations to which alerts are sent.
        """
        return pulumi.get(self, "alert_targets")

    @property
    @pulumi.getter
    def behaviors(self) -> Optional[Sequence['outputs.SecurityProfileBehavior']]:
        """
        Specifies the behaviors that, when violated by a device (thing), cause an alert.
        """
        return pulumi.get(self, "behaviors")

    @property
    @pulumi.getter(name="metricsExportConfig")
    def metrics_export_config(self) -> Optional['outputs.MetricsExportConfigProperties']:
        """
        A structure containing the mqtt topic for metrics export.
        """
        return pulumi.get(self, "metrics_export_config")

    @property
    @pulumi.getter(name="securityProfileArn")
    def security_profile_arn(self) -> Optional[builtins.str]:
        """
        The ARN (Amazon resource name) of the created security profile.
        """
        return pulumi.get(self, "security_profile_arn")

    @property
    @pulumi.getter(name="securityProfileDescription")
    def security_profile_description(self) -> Optional[builtins.str]:
        """
        A description of the security profile.
        """
        return pulumi.get(self, "security_profile_description")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Metadata that can be used to manage the security profile.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetArns")
    def target_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        A set of target ARNs that the security profile is attached to.
        """
        return pulumi.get(self, "target_arns")


class AwaitableGetSecurityProfileResult(GetSecurityProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityProfileResult(
            additional_metrics_to_retain_v2=self.additional_metrics_to_retain_v2,
            alert_targets=self.alert_targets,
            behaviors=self.behaviors,
            metrics_export_config=self.metrics_export_config,
            security_profile_arn=self.security_profile_arn,
            security_profile_description=self.security_profile_description,
            tags=self.tags,
            target_arns=self.target_arns)


def get_security_profile(security_profile_name: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityProfileResult:
    """
    A security profile defines a set of expected behaviors for devices in your account.


    :param builtins.str security_profile_name: A unique identifier for the security profile.
    """
    __args__ = dict()
    __args__['securityProfileName'] = security_profile_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iot:getSecurityProfile', __args__, opts=opts, typ=GetSecurityProfileResult).value

    return AwaitableGetSecurityProfileResult(
        additional_metrics_to_retain_v2=pulumi.get(__ret__, 'additional_metrics_to_retain_v2'),
        alert_targets=pulumi.get(__ret__, 'alert_targets'),
        behaviors=pulumi.get(__ret__, 'behaviors'),
        metrics_export_config=pulumi.get(__ret__, 'metrics_export_config'),
        security_profile_arn=pulumi.get(__ret__, 'security_profile_arn'),
        security_profile_description=pulumi.get(__ret__, 'security_profile_description'),
        tags=pulumi.get(__ret__, 'tags'),
        target_arns=pulumi.get(__ret__, 'target_arns'))
def get_security_profile_output(security_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityProfileResult]:
    """
    A security profile defines a set of expected behaviors for devices in your account.


    :param builtins.str security_profile_name: A unique identifier for the security profile.
    """
    __args__ = dict()
    __args__['securityProfileName'] = security_profile_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iot:getSecurityProfile', __args__, opts=opts, typ=GetSecurityProfileResult)
    return __ret__.apply(lambda __response__: GetSecurityProfileResult(
        additional_metrics_to_retain_v2=pulumi.get(__response__, 'additional_metrics_to_retain_v2'),
        alert_targets=pulumi.get(__response__, 'alert_targets'),
        behaviors=pulumi.get(__response__, 'behaviors'),
        metrics_export_config=pulumi.get(__response__, 'metrics_export_config'),
        security_profile_arn=pulumi.get(__response__, 'security_profile_arn'),
        security_profile_description=pulumi.get(__response__, 'security_profile_description'),
        tags=pulumi.get(__response__, 'tags'),
        target_arns=pulumi.get(__response__, 'target_arns')))
