# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetCommandResult',
    'AwaitableGetCommandResult',
    'get_command',
    'get_command_output',
]

@pulumi.output_type
class GetCommandResult:
    def __init__(__self__, command_arn=None, created_at=None, deprecated=None, description=None, display_name=None, mandatory_parameters=None, namespace=None, payload=None, pending_deletion=None, role_arn=None, tags=None):
        if command_arn and not isinstance(command_arn, str):
            raise TypeError("Expected argument 'command_arn' to be a str")
        pulumi.set(__self__, "command_arn", command_arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deprecated and not isinstance(deprecated, bool):
            raise TypeError("Expected argument 'deprecated' to be a bool")
        pulumi.set(__self__, "deprecated", deprecated)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if mandatory_parameters and not isinstance(mandatory_parameters, list):
            raise TypeError("Expected argument 'mandatory_parameters' to be a list")
        pulumi.set(__self__, "mandatory_parameters", mandatory_parameters)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if payload and not isinstance(payload, dict):
            raise TypeError("Expected argument 'payload' to be a dict")
        pulumi.set(__self__, "payload", payload)
        if pending_deletion and not isinstance(pending_deletion, bool):
            raise TypeError("Expected argument 'pending_deletion' to be a bool")
        pulumi.set(__self__, "pending_deletion", pending_deletion)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="commandArn")
    def command_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the command.
        """
        return pulumi.get(self, "command_arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The date and time when the command was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def deprecated(self) -> Optional[builtins.bool]:
        """
        A flag indicating whether the command is deprecated.
        """
        return pulumi.get(self, "deprecated")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the command.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The display name for the command.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="mandatoryParameters")
    def mandatory_parameters(self) -> Optional[Sequence['outputs.CommandParameter']]:
        """
        The list of mandatory parameters for the command.
        """
        return pulumi.get(self, "mandatory_parameters")

    @property
    @pulumi.getter
    def namespace(self) -> Optional['CommandNamespace']:
        """
        The namespace to which the command belongs.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.CommandPayload']:
        """
        The payload associated with the command.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="pendingDeletion")
    def pending_deletion(self) -> Optional[builtins.bool]:
        """
        A flag indicating whether the command is pending deletion.
        """
        return pulumi.get(self, "pending_deletion")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The customer role associated with the command.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to be associated with the command.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCommandResult(GetCommandResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCommandResult(
            command_arn=self.command_arn,
            created_at=self.created_at,
            deprecated=self.deprecated,
            description=self.description,
            display_name=self.display_name,
            mandatory_parameters=self.mandatory_parameters,
            namespace=self.namespace,
            payload=self.payload,
            pending_deletion=self.pending_deletion,
            role_arn=self.role_arn,
            tags=self.tags)


def get_command(command_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCommandResult:
    """
    Represents the resource definition of AWS IoT Command.


    :param builtins.str command_id: The unique identifier for the command.
    """
    __args__ = dict()
    __args__['commandId'] = command_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iot:getCommand', __args__, opts=opts, typ=GetCommandResult).value

    return AwaitableGetCommandResult(
        command_arn=pulumi.get(__ret__, 'command_arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deprecated=pulumi.get(__ret__, 'deprecated'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        mandatory_parameters=pulumi.get(__ret__, 'mandatory_parameters'),
        namespace=pulumi.get(__ret__, 'namespace'),
        payload=pulumi.get(__ret__, 'payload'),
        pending_deletion=pulumi.get(__ret__, 'pending_deletion'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_command_output(command_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCommandResult]:
    """
    Represents the resource definition of AWS IoT Command.


    :param builtins.str command_id: The unique identifier for the command.
    """
    __args__ = dict()
    __args__['commandId'] = command_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iot:getCommand', __args__, opts=opts, typ=GetCommandResult)
    return __ret__.apply(lambda __response__: GetCommandResult(
        command_arn=pulumi.get(__response__, 'command_arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        deprecated=pulumi.get(__response__, 'deprecated'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        mandatory_parameters=pulumi.get(__response__, 'mandatory_parameters'),
        namespace=pulumi.get(__response__, 'namespace'),
        payload=pulumi.get(__response__, 'payload'),
        pending_deletion=pulumi.get(__response__, 'pending_deletion'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        tags=pulumi.get(__response__, 'tags')))
