# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccountAuditConfigurationResult',
    'AwaitableGetAccountAuditConfigurationResult',
    'get_account_audit_configuration',
    'get_account_audit_configuration_output',
]

@pulumi.output_type
class GetAccountAuditConfigurationResult:
    def __init__(__self__, audit_check_configurations=None, audit_notification_target_configurations=None, role_arn=None):
        if audit_check_configurations and not isinstance(audit_check_configurations, dict):
            raise TypeError("Expected argument 'audit_check_configurations' to be a dict")
        pulumi.set(__self__, "audit_check_configurations", audit_check_configurations)
        if audit_notification_target_configurations and not isinstance(audit_notification_target_configurations, dict):
            raise TypeError("Expected argument 'audit_notification_target_configurations' to be a dict")
        pulumi.set(__self__, "audit_notification_target_configurations", audit_notification_target_configurations)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="auditCheckConfigurations")
    def audit_check_configurations(self) -> Optional['outputs.AccountAuditConfigurationAuditCheckConfigurations']:
        """
        Specifies which audit checks are enabled and disabled for this account.

        Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the `Enabled:` key to `false` .

        If an enabled check is removed from the template, it will also be disabled.

        You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.

        For more information on available audit checks see [AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html)
        """
        return pulumi.get(self, "audit_check_configurations")

    @property
    @pulumi.getter(name="auditNotificationTargetConfigurations")
    def audit_notification_target_configurations(self) -> Optional['outputs.AccountAuditConfigurationAuditNotificationTargetConfigurations']:
        """
        Information about the targets to which audit notifications are sent.
        """
        return pulumi.get(self, "audit_notification_target_configurations")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role that grants permission to AWS IoT to access information about your devices, policies, certificates and other items as required when performing an audit.
        """
        return pulumi.get(self, "role_arn")


class AwaitableGetAccountAuditConfigurationResult(GetAccountAuditConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountAuditConfigurationResult(
            audit_check_configurations=self.audit_check_configurations,
            audit_notification_target_configurations=self.audit_notification_target_configurations,
            role_arn=self.role_arn)


def get_account_audit_configuration(account_id: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountAuditConfigurationResult:
    """
    Configures the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.


    :param builtins.str account_id: Your 12-digit account ID (used as the primary identifier for the CloudFormation resource).
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iot:getAccountAuditConfiguration', __args__, opts=opts, typ=GetAccountAuditConfigurationResult).value

    return AwaitableGetAccountAuditConfigurationResult(
        audit_check_configurations=pulumi.get(__ret__, 'audit_check_configurations'),
        audit_notification_target_configurations=pulumi.get(__ret__, 'audit_notification_target_configurations'),
        role_arn=pulumi.get(__ret__, 'role_arn'))
def get_account_audit_configuration_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountAuditConfigurationResult]:
    """
    Configures the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.


    :param builtins.str account_id: Your 12-digit account ID (used as the primary identifier for the CloudFormation resource).
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iot:getAccountAuditConfiguration', __args__, opts=opts, typ=GetAccountAuditConfigurationResult)
    return __ret__.apply(lambda __response__: GetAccountAuditConfigurationResult(
        audit_check_configurations=pulumi.get(__response__, 'audit_check_configurations'),
        audit_notification_target_configurations=pulumi.get(__response__, 'audit_notification_target_configurations'),
        role_arn=pulumi.get(__response__, 'role_arn')))
