# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['CommandArgs', 'Command']

@pulumi.input_type
class CommandArgs:
    def __init__(__self__, *,
                 command_id: pulumi.Input[builtins.str],
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 deprecated: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 mandatory_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['CommandParameterArgs']]]] = None,
                 namespace: Optional[pulumi.Input['CommandNamespace']] = None,
                 payload: Optional[pulumi.Input['CommandPayloadArgs']] = None,
                 pending_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Command resource.
        :param pulumi.Input[builtins.str] command_id: The unique identifier for the command.
        :param pulumi.Input[builtins.str] created_at: The date and time when the command was created.
        :param pulumi.Input[builtins.bool] deprecated: A flag indicating whether the command is deprecated.
        :param pulumi.Input[builtins.str] description: The description of the command.
        :param pulumi.Input[builtins.str] display_name: The display name for the command.
        :param pulumi.Input[builtins.str] last_updated_at: The date and time when the command was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['CommandParameterArgs']]] mandatory_parameters: The list of mandatory parameters for the command.
        :param pulumi.Input['CommandNamespace'] namespace: The namespace to which the command belongs.
        :param pulumi.Input['CommandPayloadArgs'] payload: The payload associated with the command.
        :param pulumi.Input[builtins.bool] pending_deletion: A flag indicating whether the command is pending deletion.
        :param pulumi.Input[builtins.str] role_arn: The customer role associated with the command.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to be associated with the command.
        """
        pulumi.set(__self__, "command_id", command_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deprecated is not None:
            pulumi.set(__self__, "deprecated", deprecated)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if last_updated_at is not None:
            pulumi.set(__self__, "last_updated_at", last_updated_at)
        if mandatory_parameters is not None:
            pulumi.set(__self__, "mandatory_parameters", mandatory_parameters)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if pending_deletion is not None:
            pulumi.set(__self__, "pending_deletion", pending_deletion)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the command.
        """
        return pulumi.get(self, "command_id")

    @command_id.setter
    def command_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "command_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the command was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def deprecated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag indicating whether the command is deprecated.
        """
        return pulumi.get(self, "deprecated")

    @deprecated.setter
    def deprecated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deprecated", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the command.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name for the command.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the command was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @last_updated_at.setter
    def last_updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_updated_at", value)

    @property
    @pulumi.getter(name="mandatoryParameters")
    def mandatory_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CommandParameterArgs']]]]:
        """
        The list of mandatory parameters for the command.
        """
        return pulumi.get(self, "mandatory_parameters")

    @mandatory_parameters.setter
    def mandatory_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CommandParameterArgs']]]]):
        pulumi.set(self, "mandatory_parameters", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input['CommandNamespace']]:
        """
        The namespace to which the command belongs.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input['CommandNamespace']]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['CommandPayloadArgs']]:
        """
        The payload associated with the command.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['CommandPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="pendingDeletion")
    def pending_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag indicating whether the command is pending deletion.
        """
        return pulumi.get(self, "pending_deletion")

    @pending_deletion.setter
    def pending_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "pending_deletion", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The customer role associated with the command.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to be associated with the command.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:iot:Command")
class Command(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 deprecated: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 mandatory_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CommandParameterArgs', 'CommandParameterArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input['CommandNamespace']] = None,
                 payload: Optional[pulumi.Input[Union['CommandPayloadArgs', 'CommandPayloadArgsDict']]] = None,
                 pending_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents the resource definition of AWS IoT Command.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] command_id: The unique identifier for the command.
        :param pulumi.Input[builtins.str] created_at: The date and time when the command was created.
        :param pulumi.Input[builtins.bool] deprecated: A flag indicating whether the command is deprecated.
        :param pulumi.Input[builtins.str] description: The description of the command.
        :param pulumi.Input[builtins.str] display_name: The display name for the command.
        :param pulumi.Input[builtins.str] last_updated_at: The date and time when the command was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CommandParameterArgs', 'CommandParameterArgsDict']]]] mandatory_parameters: The list of mandatory parameters for the command.
        :param pulumi.Input['CommandNamespace'] namespace: The namespace to which the command belongs.
        :param pulumi.Input[Union['CommandPayloadArgs', 'CommandPayloadArgsDict']] payload: The payload associated with the command.
        :param pulumi.Input[builtins.bool] pending_deletion: A flag indicating whether the command is pending deletion.
        :param pulumi.Input[builtins.str] role_arn: The customer role associated with the command.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to be associated with the command.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CommandArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents the resource definition of AWS IoT Command.

        :param str resource_name: The name of the resource.
        :param CommandArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CommandArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 deprecated: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 mandatory_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CommandParameterArgs', 'CommandParameterArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input['CommandNamespace']] = None,
                 payload: Optional[pulumi.Input[Union['CommandPayloadArgs', 'CommandPayloadArgsDict']]] = None,
                 pending_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CommandArgs.__new__(CommandArgs)

            if command_id is None and not opts.urn:
                raise TypeError("Missing required property 'command_id'")
            __props__.__dict__["command_id"] = command_id
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["deprecated"] = deprecated
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["last_updated_at"] = last_updated_at
            __props__.__dict__["mandatory_parameters"] = mandatory_parameters
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["payload"] = payload
            __props__.__dict__["pending_deletion"] = pending_deletion
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["command_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["commandId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Command, __self__).__init__(
            'aws-native:iot:Command',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Command':
        """
        Get an existing Command resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CommandArgs.__new__(CommandArgs)

        __props__.__dict__["command_arn"] = None
        __props__.__dict__["command_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["deprecated"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["last_updated_at"] = None
        __props__.__dict__["mandatory_parameters"] = None
        __props__.__dict__["namespace"] = None
        __props__.__dict__["payload"] = None
        __props__.__dict__["pending_deletion"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["tags"] = None
        return Command(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="commandArn")
    def command_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the command.
        """
        return pulumi.get(self, "command_arn")

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the command.
        """
        return pulumi.get(self, "command_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The date and time when the command was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def deprecated(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A flag indicating whether the command is deprecated.
        """
        return pulumi.get(self, "deprecated")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the command.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The display name for the command.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The date and time when the command was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter(name="mandatoryParameters")
    def mandatory_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.CommandParameter']]]:
        """
        The list of mandatory parameters for the command.
        """
        return pulumi.get(self, "mandatory_parameters")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional['CommandNamespace']]:
        """
        The namespace to which the command belongs.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def payload(self) -> pulumi.Output[Optional['outputs.CommandPayload']]:
        """
        The payload associated with the command.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="pendingDeletion")
    def pending_deletion(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A flag indicating whether the command is pending deletion.
        """
        return pulumi.get(self, "pending_deletion")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The customer role associated with the command.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to be associated with the command.
        """
        return pulumi.get(self, "tags")

