# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['BillingGroupArgs', 'BillingGroup']

@pulumi.input_type
class BillingGroupArgs:
    def __init__(__self__, *,
                 billing_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 billing_group_properties: Optional[pulumi.Input['BillingGroupPropertiesPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a BillingGroup resource.
        :param pulumi.Input[builtins.str] billing_group_name: The name of the billing group.
        :param pulumi.Input['BillingGroupPropertiesPropertiesArgs'] billing_group_properties: The properties of the billing group.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        if billing_group_name is not None:
            pulumi.set(__self__, "billing_group_name", billing_group_name)
        if billing_group_properties is not None:
            pulumi.set(__self__, "billing_group_properties", billing_group_properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="billingGroupName")
    def billing_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the billing group.
        """
        return pulumi.get(self, "billing_group_name")

    @billing_group_name.setter
    def billing_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_group_name", value)

    @property
    @pulumi.getter(name="billingGroupProperties")
    def billing_group_properties(self) -> Optional[pulumi.Input['BillingGroupPropertiesPropertiesArgs']]:
        """
        The properties of the billing group.
        """
        return pulumi.get(self, "billing_group_properties")

    @billing_group_properties.setter
    def billing_group_properties(self, value: Optional[pulumi.Input['BillingGroupPropertiesPropertiesArgs']]):
        pulumi.set(self, "billing_group_properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:iot:BillingGroup")
class BillingGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 billing_group_properties: Optional[pulumi.Input[Union['BillingGroupPropertiesPropertiesArgs', 'BillingGroupPropertiesPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::IoT::BillingGroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] billing_group_name: The name of the billing group.
        :param pulumi.Input[Union['BillingGroupPropertiesPropertiesArgs', 'BillingGroupPropertiesPropertiesArgsDict']] billing_group_properties: The properties of the billing group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BillingGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::IoT::BillingGroup

        :param str resource_name: The name of the resource.
        :param BillingGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BillingGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 billing_group_properties: Optional[pulumi.Input[Union['BillingGroupPropertiesPropertiesArgs', 'BillingGroupPropertiesPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BillingGroupArgs.__new__(BillingGroupArgs)

            __props__.__dict__["billing_group_name"] = billing_group_name
            __props__.__dict__["billing_group_properties"] = billing_group_properties
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["billingGroupName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(BillingGroup, __self__).__init__(
            'aws-native:iot:BillingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BillingGroup':
        """
        Get an existing BillingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BillingGroupArgs.__new__(BillingGroupArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["billing_group_name"] = None
        __props__.__dict__["billing_group_properties"] = None
        __props__.__dict__["tags"] = None
        return BillingGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the billing group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the billing group.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="billingGroupName")
    def billing_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the billing group.
        """
        return pulumi.get(self, "billing_group_name")

    @property
    @pulumi.getter(name="billingGroupProperties")
    def billing_group_properties(self) -> pulumi.Output[Optional['outputs.BillingGroupPropertiesProperties']]:
        """
        The properties of the billing group.
        """
        return pulumi.get(self, "billing_group_properties")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

