# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['InvoiceUnitArgs', 'InvoiceUnit']

@pulumi.input_type
class InvoiceUnitArgs:
    def __init__(__self__, *,
                 invoice_receiver: pulumi.Input[builtins.str],
                 rule: pulumi.Input['InvoiceUnitRuleArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 tax_inheritance_disabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a InvoiceUnit resource.
        :param pulumi.Input[builtins.str] invoice_receiver: The account that receives invoices related to the invoice unit.
        :param pulumi.Input['InvoiceUnitRuleArgs'] rule: An `InvoiceUnitRule` object used the categorize invoice units.
        :param pulumi.Input[builtins.str] description: The assigned description for an invoice unit. This information can't be modified or deleted.
        :param pulumi.Input[builtins.str] name: A unique name that is distinctive within your AWS .
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] resource_tags: The tag structure that contains a tag key and value.
        :param pulumi.Input[builtins.bool] tax_inheritance_disabled: Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
        """
        pulumi.set(__self__, "invoice_receiver", invoice_receiver)
        pulumi.set(__self__, "rule", rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if tax_inheritance_disabled is not None:
            pulumi.set(__self__, "tax_inheritance_disabled", tax_inheritance_disabled)

    @property
    @pulumi.getter(name="invoiceReceiver")
    def invoice_receiver(self) -> pulumi.Input[builtins.str]:
        """
        The account that receives invoices related to the invoice unit.
        """
        return pulumi.get(self, "invoice_receiver")

    @invoice_receiver.setter
    def invoice_receiver(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "invoice_receiver", value)

    @property
    @pulumi.getter
    def rule(self) -> pulumi.Input['InvoiceUnitRuleArgs']:
        """
        An `InvoiceUnitRule` object used the categorize invoice units.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: pulumi.Input['InvoiceUnitRuleArgs']):
        pulumi.set(self, "rule", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The assigned description for an invoice unit. This information can't be modified or deleted.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name that is distinctive within your AWS .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tag structure that contains a tag key and value.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "resource_tags", value)

    @property
    @pulumi.getter(name="taxInheritanceDisabled")
    def tax_inheritance_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
        """
        return pulumi.get(self, "tax_inheritance_disabled")

    @tax_inheritance_disabled.setter
    def tax_inheritance_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tax_inheritance_disabled", value)


@pulumi.type_token("aws-native:invoicing:InvoiceUnit")
class InvoiceUnit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invoice_receiver: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 rule: Optional[pulumi.Input[Union['InvoiceUnitRuleArgs', 'InvoiceUnitRuleArgsDict']]] = None,
                 tax_inheritance_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        An invoice unit is a set of mutually exclusive accounts that correspond to your business entity. Invoice units allow you to separate AWS account costs and configures your invoice for each business entity.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The assigned description for an invoice unit. This information can't be modified or deleted.
        :param pulumi.Input[builtins.str] invoice_receiver: The account that receives invoices related to the invoice unit.
        :param pulumi.Input[builtins.str] name: A unique name that is distinctive within your AWS .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] resource_tags: The tag structure that contains a tag key and value.
        :param pulumi.Input[Union['InvoiceUnitRuleArgs', 'InvoiceUnitRuleArgsDict']] rule: An `InvoiceUnitRule` object used the categorize invoice units.
        :param pulumi.Input[builtins.bool] tax_inheritance_disabled: Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InvoiceUnitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An invoice unit is a set of mutually exclusive accounts that correspond to your business entity. Invoice units allow you to separate AWS account costs and configures your invoice for each business entity.

        :param str resource_name: The name of the resource.
        :param InvoiceUnitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InvoiceUnitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invoice_receiver: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 rule: Optional[pulumi.Input[Union['InvoiceUnitRuleArgs', 'InvoiceUnitRuleArgsDict']]] = None,
                 tax_inheritance_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InvoiceUnitArgs.__new__(InvoiceUnitArgs)

            __props__.__dict__["description"] = description
            if invoice_receiver is None and not opts.urn:
                raise TypeError("Missing required property 'invoice_receiver'")
            __props__.__dict__["invoice_receiver"] = invoice_receiver
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_tags"] = resource_tags
            if rule is None and not opts.urn:
                raise TypeError("Missing required property 'rule'")
            __props__.__dict__["rule"] = rule
            __props__.__dict__["tax_inheritance_disabled"] = tax_inheritance_disabled
            __props__.__dict__["invoice_unit_arn"] = None
            __props__.__dict__["last_modified"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["invoiceReceiver", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InvoiceUnit, __self__).__init__(
            'aws-native:invoicing:InvoiceUnit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InvoiceUnit':
        """
        Get an existing InvoiceUnit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InvoiceUnitArgs.__new__(InvoiceUnitArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["invoice_receiver"] = None
        __props__.__dict__["invoice_unit_arn"] = None
        __props__.__dict__["last_modified"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["resource_tags"] = None
        __props__.__dict__["rule"] = None
        __props__.__dict__["tax_inheritance_disabled"] = None
        return InvoiceUnit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The assigned description for an invoice unit. This information can't be modified or deleted.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="invoiceReceiver")
    def invoice_receiver(self) -> pulumi.Output[builtins.str]:
        """
        The account that receives invoices related to the invoice unit.
        """
        return pulumi.get(self, "invoice_receiver")

    @property
    @pulumi.getter(name="invoiceUnitArn")
    def invoice_unit_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN to identify an invoice unit. This information can't be modified or deleted.
        """
        return pulumi.get(self, "invoice_unit_arn")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[builtins.float]:
        """
        The last time the invoice unit was updated. This is important to determine the version of invoice unit configuration used to create the invoices. Any invoice created after this modified time will use this invoice unit configuration.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name that is distinctive within your AWS .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tag structure that contains a tag key and value.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter
    def rule(self) -> pulumi.Output['outputs.InvoiceUnitRule']:
        """
        An `InvoiceUnitRule` object used the categorize invoice units.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter(name="taxInheritanceDisabled")
    def tax_inheritance_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
        """
        return pulumi.get(self, "tax_inheritance_disabled")

