# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetInvoiceUnitResult',
    'AwaitableGetInvoiceUnitResult',
    'get_invoice_unit',
    'get_invoice_unit_output',
]

@pulumi.output_type
class GetInvoiceUnitResult:
    def __init__(__self__, description=None, invoice_unit_arn=None, last_modified=None, resource_tags=None, rule=None, tax_inheritance_disabled=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if invoice_unit_arn and not isinstance(invoice_unit_arn, str):
            raise TypeError("Expected argument 'invoice_unit_arn' to be a str")
        pulumi.set(__self__, "invoice_unit_arn", invoice_unit_arn)
        if last_modified and not isinstance(last_modified, float):
            raise TypeError("Expected argument 'last_modified' to be a float")
        pulumi.set(__self__, "last_modified", last_modified)
        if resource_tags and not isinstance(resource_tags, list):
            raise TypeError("Expected argument 'resource_tags' to be a list")
        pulumi.set(__self__, "resource_tags", resource_tags)
        if rule and not isinstance(rule, dict):
            raise TypeError("Expected argument 'rule' to be a dict")
        pulumi.set(__self__, "rule", rule)
        if tax_inheritance_disabled and not isinstance(tax_inheritance_disabled, bool):
            raise TypeError("Expected argument 'tax_inheritance_disabled' to be a bool")
        pulumi.set(__self__, "tax_inheritance_disabled", tax_inheritance_disabled)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The assigned description for an invoice unit. This information can't be modified or deleted.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="invoiceUnitArn")
    def invoice_unit_arn(self) -> Optional[builtins.str]:
        """
        The ARN to identify an invoice unit. This information can't be modified or deleted.
        """
        return pulumi.get(self, "invoice_unit_arn")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[builtins.float]:
        """
        The last time the invoice unit was updated. This is important to determine the version of invoice unit configuration used to create the invoices. Any invoice created after this modified time will use this invoice unit configuration.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tag structure that contains a tag key and value.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter
    def rule(self) -> Optional['outputs.InvoiceUnitRule']:
        """
        An `InvoiceUnitRule` object used the categorize invoice units.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter(name="taxInheritanceDisabled")
    def tax_inheritance_disabled(self) -> Optional[builtins.bool]:
        """
        Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
        """
        return pulumi.get(self, "tax_inheritance_disabled")


class AwaitableGetInvoiceUnitResult(GetInvoiceUnitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInvoiceUnitResult(
            description=self.description,
            invoice_unit_arn=self.invoice_unit_arn,
            last_modified=self.last_modified,
            resource_tags=self.resource_tags,
            rule=self.rule,
            tax_inheritance_disabled=self.tax_inheritance_disabled)


def get_invoice_unit(invoice_unit_arn: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInvoiceUnitResult:
    """
    An invoice unit is a set of mutually exclusive accounts that correspond to your business entity. Invoice units allow you to separate AWS account costs and configures your invoice for each business entity.


    :param builtins.str invoice_unit_arn: The ARN to identify an invoice unit. This information can't be modified or deleted.
    """
    __args__ = dict()
    __args__['invoiceUnitArn'] = invoice_unit_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:invoicing:getInvoiceUnit', __args__, opts=opts, typ=GetInvoiceUnitResult).value

    return AwaitableGetInvoiceUnitResult(
        description=pulumi.get(__ret__, 'description'),
        invoice_unit_arn=pulumi.get(__ret__, 'invoice_unit_arn'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        resource_tags=pulumi.get(__ret__, 'resource_tags'),
        rule=pulumi.get(__ret__, 'rule'),
        tax_inheritance_disabled=pulumi.get(__ret__, 'tax_inheritance_disabled'))
def get_invoice_unit_output(invoice_unit_arn: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInvoiceUnitResult]:
    """
    An invoice unit is a set of mutually exclusive accounts that correspond to your business entity. Invoice units allow you to separate AWS account costs and configures your invoice for each business entity.


    :param builtins.str invoice_unit_arn: The ARN to identify an invoice unit. This information can't be modified or deleted.
    """
    __args__ = dict()
    __args__['invoiceUnitArn'] = invoice_unit_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:invoicing:getInvoiceUnit', __args__, opts=opts, typ=GetInvoiceUnitResult)
    return __ret__.apply(lambda __response__: GetInvoiceUnitResult(
        description=pulumi.get(__response__, 'description'),
        invoice_unit_arn=pulumi.get(__response__, 'invoice_unit_arn'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        resource_tags=pulumi.get(__response__, 'resource_tags'),
        rule=pulumi.get(__response__, 'rule'),
        tax_inheritance_disabled=pulumi.get(__response__, 'tax_inheritance_disabled')))
