# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'MonitorHealthEventsConfigArgs',
    'MonitorHealthEventsConfigArgsDict',
    'MonitorInternetMeasurementsLogDeliveryArgs',
    'MonitorInternetMeasurementsLogDeliveryArgsDict',
    'MonitorLocalHealthEventsConfigArgs',
    'MonitorLocalHealthEventsConfigArgsDict',
    'MonitorS3ConfigArgs',
    'MonitorS3ConfigArgsDict',
]

MYPY = False

if not MYPY:
    class MonitorHealthEventsConfigArgsDict(TypedDict):
        availability_local_health_events_config: NotRequired[pulumi.Input['MonitorLocalHealthEventsConfigArgsDict']]
        """
        The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.
        """
        availability_score_threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        The health event threshold percentage set for availability scores. When the overall availability score is at or below this percentage, Internet Monitor creates a health event.
        """
        performance_local_health_events_config: NotRequired[pulumi.Input['MonitorLocalHealthEventsConfigArgsDict']]
        """
        The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.
        """
        performance_score_threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        The health event threshold percentage set for performance scores. When the overall performance score is at or below this percentage, Internet Monitor creates a health event.
        """
elif False:
    MonitorHealthEventsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorHealthEventsConfigArgs:
    def __init__(__self__, *,
                 availability_local_health_events_config: Optional[pulumi.Input['MonitorLocalHealthEventsConfigArgs']] = None,
                 availability_score_threshold: Optional[pulumi.Input[builtins.float]] = None,
                 performance_local_health_events_config: Optional[pulumi.Input['MonitorLocalHealthEventsConfigArgs']] = None,
                 performance_score_threshold: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input['MonitorLocalHealthEventsConfigArgs'] availability_local_health_events_config: The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.
        :param pulumi.Input[builtins.float] availability_score_threshold: The health event threshold percentage set for availability scores. When the overall availability score is at or below this percentage, Internet Monitor creates a health event.
        :param pulumi.Input['MonitorLocalHealthEventsConfigArgs'] performance_local_health_events_config: The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.
        :param pulumi.Input[builtins.float] performance_score_threshold: The health event threshold percentage set for performance scores. When the overall performance score is at or below this percentage, Internet Monitor creates a health event.
        """
        if availability_local_health_events_config is not None:
            pulumi.set(__self__, "availability_local_health_events_config", availability_local_health_events_config)
        if availability_score_threshold is not None:
            pulumi.set(__self__, "availability_score_threshold", availability_score_threshold)
        if performance_local_health_events_config is not None:
            pulumi.set(__self__, "performance_local_health_events_config", performance_local_health_events_config)
        if performance_score_threshold is not None:
            pulumi.set(__self__, "performance_score_threshold", performance_score_threshold)

    @property
    @pulumi.getter(name="availabilityLocalHealthEventsConfig")
    def availability_local_health_events_config(self) -> Optional[pulumi.Input['MonitorLocalHealthEventsConfigArgs']]:
        """
        The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.
        """
        return pulumi.get(self, "availability_local_health_events_config")

    @availability_local_health_events_config.setter
    def availability_local_health_events_config(self, value: Optional[pulumi.Input['MonitorLocalHealthEventsConfigArgs']]):
        pulumi.set(self, "availability_local_health_events_config", value)

    @property
    @pulumi.getter(name="availabilityScoreThreshold")
    def availability_score_threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The health event threshold percentage set for availability scores. When the overall availability score is at or below this percentage, Internet Monitor creates a health event.
        """
        return pulumi.get(self, "availability_score_threshold")

    @availability_score_threshold.setter
    def availability_score_threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "availability_score_threshold", value)

    @property
    @pulumi.getter(name="performanceLocalHealthEventsConfig")
    def performance_local_health_events_config(self) -> Optional[pulumi.Input['MonitorLocalHealthEventsConfigArgs']]:
        """
        The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.
        """
        return pulumi.get(self, "performance_local_health_events_config")

    @performance_local_health_events_config.setter
    def performance_local_health_events_config(self, value: Optional[pulumi.Input['MonitorLocalHealthEventsConfigArgs']]):
        pulumi.set(self, "performance_local_health_events_config", value)

    @property
    @pulumi.getter(name="performanceScoreThreshold")
    def performance_score_threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The health event threshold percentage set for performance scores. When the overall performance score is at or below this percentage, Internet Monitor creates a health event.
        """
        return pulumi.get(self, "performance_score_threshold")

    @performance_score_threshold.setter
    def performance_score_threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "performance_score_threshold", value)


if not MYPY:
    class MonitorInternetMeasurementsLogDeliveryArgsDict(TypedDict):
        s3_config: NotRequired[pulumi.Input['MonitorS3ConfigArgsDict']]
        """
        The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3.
        """
elif False:
    MonitorInternetMeasurementsLogDeliveryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorInternetMeasurementsLogDeliveryArgs:
    def __init__(__self__, *,
                 s3_config: Optional[pulumi.Input['MonitorS3ConfigArgs']] = None):
        """
        :param pulumi.Input['MonitorS3ConfigArgs'] s3_config: The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3.
        """
        if s3_config is not None:
            pulumi.set(__self__, "s3_config", s3_config)

    @property
    @pulumi.getter(name="s3Config")
    def s3_config(self) -> Optional[pulumi.Input['MonitorS3ConfigArgs']]:
        """
        The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3.
        """
        return pulumi.get(self, "s3_config")

    @s3_config.setter
    def s3_config(self, value: Optional[pulumi.Input['MonitorS3ConfigArgs']]):
        pulumi.set(self, "s3_config", value)


if not MYPY:
    class MonitorLocalHealthEventsConfigArgsDict(TypedDict):
        health_score_threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        The health event threshold percentage set for a local health score.
        """
        min_traffic_impact: NotRequired[pulumi.Input[builtins.float]]
        """
        The minimum percentage of overall traffic for an application that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.

        If you don't set a minimum traffic impact threshold, the default value is 0.01%.
        """
        status: NotRequired[pulumi.Input['MonitorLocalHealthEventsConfigStatus']]
        """
        The status of whether Internet Monitor creates a health event based on a threshold percentage set for a local health score. The status can be `ENABLED` or `DISABLED` .
        """
elif False:
    MonitorLocalHealthEventsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorLocalHealthEventsConfigArgs:
    def __init__(__self__, *,
                 health_score_threshold: Optional[pulumi.Input[builtins.float]] = None,
                 min_traffic_impact: Optional[pulumi.Input[builtins.float]] = None,
                 status: Optional[pulumi.Input['MonitorLocalHealthEventsConfigStatus']] = None):
        """
        :param pulumi.Input[builtins.float] health_score_threshold: The health event threshold percentage set for a local health score.
        :param pulumi.Input[builtins.float] min_traffic_impact: The minimum percentage of overall traffic for an application that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.
               
               If you don't set a minimum traffic impact threshold, the default value is 0.01%.
        :param pulumi.Input['MonitorLocalHealthEventsConfigStatus'] status: The status of whether Internet Monitor creates a health event based on a threshold percentage set for a local health score. The status can be `ENABLED` or `DISABLED` .
        """
        if health_score_threshold is not None:
            pulumi.set(__self__, "health_score_threshold", health_score_threshold)
        if min_traffic_impact is not None:
            pulumi.set(__self__, "min_traffic_impact", min_traffic_impact)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="healthScoreThreshold")
    def health_score_threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The health event threshold percentage set for a local health score.
        """
        return pulumi.get(self, "health_score_threshold")

    @health_score_threshold.setter
    def health_score_threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "health_score_threshold", value)

    @property
    @pulumi.getter(name="minTrafficImpact")
    def min_traffic_impact(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The minimum percentage of overall traffic for an application that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.

        If you don't set a minimum traffic impact threshold, the default value is 0.01%.
        """
        return pulumi.get(self, "min_traffic_impact")

    @min_traffic_impact.setter
    def min_traffic_impact(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_traffic_impact", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['MonitorLocalHealthEventsConfigStatus']]:
        """
        The status of whether Internet Monitor creates a health event based on a threshold percentage set for a local health score. The status can be `ENABLED` or `DISABLED` .
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['MonitorLocalHealthEventsConfigStatus']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class MonitorS3ConfigArgsDict(TypedDict):
        bucket_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon S3 bucket name for internet measurements publishing.
        """
        bucket_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        An optional Amazon S3 bucket prefix for internet measurements publishing.
        """
        log_delivery_status: NotRequired[pulumi.Input['MonitorS3ConfigLogDeliveryStatus']]
        """
        The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket. The delivery status is `ENABLED` if you choose to deliver internet measurements to an S3 bucket, and `DISABLED` otherwise.
        """
elif False:
    MonitorS3ConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorS3ConfigArgs:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 log_delivery_status: Optional[pulumi.Input['MonitorS3ConfigLogDeliveryStatus']] = None):
        """
        :param pulumi.Input[builtins.str] bucket_name: The Amazon S3 bucket name for internet measurements publishing.
        :param pulumi.Input[builtins.str] bucket_prefix: An optional Amazon S3 bucket prefix for internet measurements publishing.
        :param pulumi.Input['MonitorS3ConfigLogDeliveryStatus'] log_delivery_status: The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket. The delivery status is `ENABLED` if you choose to deliver internet measurements to an S3 bucket, and `DISABLED` otherwise.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if log_delivery_status is not None:
            pulumi.set(__self__, "log_delivery_status", log_delivery_status)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 bucket name for internet measurements publishing.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional Amazon S3 bucket prefix for internet measurements publishing.
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)

    @property
    @pulumi.getter(name="logDeliveryStatus")
    def log_delivery_status(self) -> Optional[pulumi.Input['MonitorS3ConfigLogDeliveryStatus']]:
        """
        The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket. The delivery status is `ENABLED` if you choose to deliver internet measurements to an S3 bucket, and `DISABLED` otherwise.
        """
        return pulumi.get(self, "log_delivery_status")

    @log_delivery_status.setter
    def log_delivery_status(self, value: Optional[pulumi.Input['MonitorS3ConfigLogDeliveryStatus']]):
        pulumi.set(self, "log_delivery_status", value)


