# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ContainerRecipeComponentConfiguration',
    'ContainerRecipeComponentParameter',
    'ContainerRecipeEbsInstanceBlockDeviceSpecification',
    'ContainerRecipeInstanceBlockDeviceMapping',
    'ContainerRecipeInstanceConfiguration',
    'ContainerRecipeTargetContainerRepository',
    'DistributionConfigurationAmiDistributionConfiguration',
    'DistributionConfigurationContainerDistributionConfiguration',
    'DistributionConfigurationDistribution',
    'DistributionConfigurationFastLaunchConfiguration',
    'DistributionConfigurationFastLaunchLaunchTemplateSpecification',
    'DistributionConfigurationFastLaunchSnapshotConfiguration',
    'DistributionConfigurationLaunchPermissionConfiguration',
    'DistributionConfigurationLaunchTemplateConfiguration',
    'DistributionConfigurationSsmParameterConfiguration',
    'DistributionConfigurationTargetContainerRepository',
    'ImageEcrConfiguration',
    'ImagePipelineEcrConfiguration',
    'ImagePipelineImageScanningConfiguration',
    'ImagePipelineImageTestsConfiguration',
    'ImagePipelineSchedule',
    'ImagePipelineWorkflowConfiguration',
    'ImagePipelineWorkflowParameter',
    'ImageRecipeAdditionalInstanceConfiguration',
    'ImageRecipeComponentConfiguration',
    'ImageRecipeComponentParameter',
    'ImageRecipeEbsInstanceBlockDeviceSpecification',
    'ImageRecipeInstanceBlockDeviceMapping',
    'ImageRecipeSystemsManagerAgent',
    'ImageScanningConfiguration',
    'ImageTestsConfiguration',
    'ImageWorkflowConfiguration',
    'ImageWorkflowParameter',
    'InfrastructureConfigurationInstanceMetadataOptions',
    'InfrastructureConfigurationLogging',
    'InfrastructureConfigurationPlacement',
    'InfrastructureConfigurationS3Logs',
    'LifecyclePolicyAction',
    'LifecyclePolicyAmiExclusionRules',
    'LifecyclePolicyExclusionRules',
    'LifecyclePolicyFilter',
    'LifecyclePolicyIncludeResources',
    'LifecyclePolicyLastLaunched',
    'LifecyclePolicyPolicyDetail',
    'LifecyclePolicyRecipeSelection',
    'LifecyclePolicyResourceSelection',
]

@pulumi.output_type
class ContainerRecipeComponentConfiguration(dict):
    """
    Configuration details of the component.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentArn":
            suggest = "component_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeComponentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeComponentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeComponentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_arn: Optional[builtins.str] = None,
                 parameters: Optional[Sequence['outputs.ContainerRecipeComponentParameter']] = None):
        """
        Configuration details of the component.
        :param builtins.str component_arn: The Amazon Resource Name (ARN) of the component.
        :param Sequence['ContainerRecipeComponentParameter'] parameters: A group of parameter settings that are used to configure the component for a specific recipe.
        """
        if component_arn is not None:
            pulumi.set(__self__, "component_arn", component_arn)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the component.
        """
        return pulumi.get(self, "component_arn")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ContainerRecipeComponentParameter']]:
        """
        A group of parameter settings that are used to configure the component for a specific recipe.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ContainerRecipeComponentParameter(dict):
    """
    Contains a key/value pair that sets the named component parameter.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 value: Sequence[builtins.str]):
        """
        Contains a key/value pair that sets the named component parameter.
        :param builtins.str name: The name of the component parameter to set.
        :param Sequence[builtins.str] value: Sets the value for the named component parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the component parameter to set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Sequence[builtins.str]:
        """
        Sets the value for the named component parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerRecipeEbsInstanceBlockDeviceSpecification(dict):
    """
    Amazon EBS-specific block device mapping specifications. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeEbsInstanceBlockDeviceSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeEbsInstanceBlockDeviceSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeEbsInstanceBlockDeviceSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[builtins.bool] = None,
                 encrypted: Optional[builtins.bool] = None,
                 iops: Optional[builtins.int] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 snapshot_id: Optional[builtins.str] = None,
                 throughput: Optional[builtins.int] = None,
                 volume_size: Optional[builtins.int] = None,
                 volume_type: Optional['ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType'] = None):
        """
        Amazon EBS-specific block device mapping specifications. 
        :param builtins.bool delete_on_termination: Use to configure delete on termination of the associated device.
        :param builtins.bool encrypted: Use to configure device encryption.
        :param builtins.int iops: Use to configure device IOPS.
        :param builtins.str kms_key_id: Use to configure the KMS key to use when encrypting the device.
        :param builtins.str snapshot_id: The snapshot that defines the device contents.
        :param builtins.int throughput: For GP3 volumes only - The throughput in MiB/s that the volume supports.
        :param builtins.int volume_size: Use to override the device's volume size.
        :param 'ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType' volume_type: Use to override the device's volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[builtins.bool]:
        """
        Use to configure delete on termination of the associated device.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[builtins.bool]:
        """
        Use to configure device encryption.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.int]:
        """
        Use to configure device IOPS.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        Use to configure the KMS key to use when encrypting the device.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[builtins.str]:
        """
        The snapshot that defines the device contents.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[builtins.int]:
        """
        For GP3 volumes only - The throughput in MiB/s that the volume supports.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[builtins.int]:
        """
        Use to override the device's volume size.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional['ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType']:
        """
        Use to override the device's volume type.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ContainerRecipeInstanceBlockDeviceMapping(dict):
    """
    Defines block device mappings for the instance used to configure your image. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeInstanceBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeInstanceBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeInstanceBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[builtins.str] = None,
                 ebs: Optional['outputs.ContainerRecipeEbsInstanceBlockDeviceSpecification'] = None,
                 no_device: Optional[builtins.str] = None,
                 virtual_name: Optional[builtins.str] = None):
        """
        Defines block device mappings for the instance used to configure your image. 
        :param builtins.str device_name: The device to which these mappings apply.
        :param 'ContainerRecipeEbsInstanceBlockDeviceSpecification' ebs: Use to manage Amazon EBS-specific configuration for this mapping.
        :param builtins.str no_device: Use to remove a mapping from the parent image.
        :param builtins.str virtual_name: Use to manage instance ephemeral devices.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[builtins.str]:
        """
        The device to which these mappings apply.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.ContainerRecipeEbsInstanceBlockDeviceSpecification']:
        """
        Use to manage Amazon EBS-specific configuration for this mapping.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[builtins.str]:
        """
        Use to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[builtins.str]:
        """
        Use to manage instance ephemeral devices.
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class ContainerRecipeInstanceConfiguration(dict):
    """
    A group of options that can be used to configure an instance for building and testing container images.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockDeviceMappings":
            suggest = "block_device_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeInstanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeInstanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeInstanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_device_mappings: Optional[Sequence['outputs.ContainerRecipeInstanceBlockDeviceMapping']] = None,
                 image: Optional[builtins.str] = None):
        """
        A group of options that can be used to configure an instance for building and testing container images.
        :param Sequence['ContainerRecipeInstanceBlockDeviceMapping'] block_device_mappings: Defines the block devices to attach for building an instance from this Image Builder AMI.
        :param builtins.str image: The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
        """
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[Sequence['outputs.ContainerRecipeInstanceBlockDeviceMapping']]:
        """
        Defines the block devices to attach for building an instance from this Image Builder AMI.
        """
        return pulumi.get(self, "block_device_mappings")

    @property
    @pulumi.getter
    def image(self) -> Optional[builtins.str]:
        """
        The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class ContainerRecipeTargetContainerRepository(dict):
    """
    The container repository where the output container image is stored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryName":
            suggest = "repository_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeTargetContainerRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeTargetContainerRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeTargetContainerRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_name: Optional[builtins.str] = None,
                 service: Optional['ContainerRecipeTargetContainerRepositoryService'] = None):
        """
        The container repository where the output container image is stored.
        :param builtins.str repository_name: The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        :param 'ContainerRecipeTargetContainerRepositoryService' service: Specifies the service in which this image was registered.
        """
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[builtins.str]:
        """
        The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter
    def service(self) -> Optional['ContainerRecipeTargetContainerRepositoryService']:
        """
        Specifies the service in which this image was registered.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class DistributionConfigurationAmiDistributionConfiguration(dict):
    """
    The specific AMI settings (for example, launch permissions, AMI tags).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiTags":
            suggest = "ami_tags"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "launchPermissionConfiguration":
            suggest = "launch_permission_configuration"
        elif key == "targetAccountIds":
            suggest = "target_account_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationAmiDistributionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationAmiDistributionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationAmiDistributionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ami_tags: Optional[Mapping[str, builtins.str]] = None,
                 description: Optional[builtins.str] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 launch_permission_configuration: Optional['outputs.DistributionConfigurationLaunchPermissionConfiguration'] = None,
                 name: Optional[builtins.str] = None,
                 target_account_ids: Optional[Sequence[builtins.str]] = None):
        """
        The specific AMI settings (for example, launch permissions, AMI tags).
        :param Mapping[str, builtins.str] ami_tags: The tags to apply to AMIs distributed to this Region.
        :param builtins.str description: The description of the AMI distribution configuration.
        :param builtins.str kms_key_id: The KMS key identifier used to encrypt the distributed image.
        :param 'DistributionConfigurationLaunchPermissionConfiguration' launch_permission_configuration: Launch permissions can be used to configure which AWS account s can use the AMI to launch instances.
        :param builtins.str name: The name of the AMI distribution configuration.
        :param Sequence[builtins.str] target_account_ids: The ID of accounts to which you want to distribute an image.
        """
        if ami_tags is not None:
            pulumi.set(__self__, "ami_tags", ami_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if launch_permission_configuration is not None:
            pulumi.set(__self__, "launch_permission_configuration", launch_permission_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_account_ids is not None:
            pulumi.set(__self__, "target_account_ids", target_account_ids)

    @property
    @pulumi.getter(name="amiTags")
    def ami_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags to apply to AMIs distributed to this Region.
        """
        return pulumi.get(self, "ami_tags")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the AMI distribution configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        The KMS key identifier used to encrypt the distributed image.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="launchPermissionConfiguration")
    def launch_permission_configuration(self) -> Optional['outputs.DistributionConfigurationLaunchPermissionConfiguration']:
        """
        Launch permissions can be used to configure which AWS account s can use the AMI to launch instances.
        """
        return pulumi.get(self, "launch_permission_configuration")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the AMI distribution configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetAccountIds")
    def target_account_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The ID of accounts to which you want to distribute an image.
        """
        return pulumi.get(self, "target_account_ids")


@pulumi.output_type
class DistributionConfigurationContainerDistributionConfiguration(dict):
    """
    Container distribution settings for encryption, licensing, and sharing in a specific Region.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerTags":
            suggest = "container_tags"
        elif key == "targetRepository":
            suggest = "target_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationContainerDistributionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationContainerDistributionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationContainerDistributionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_tags: Optional[Sequence[builtins.str]] = None,
                 description: Optional[builtins.str] = None,
                 target_repository: Optional['outputs.DistributionConfigurationTargetContainerRepository'] = None):
        """
        Container distribution settings for encryption, licensing, and sharing in a specific Region.
        :param Sequence[builtins.str] container_tags: Tags that are attached to the container distribution configuration.
        :param builtins.str description: The description of the container distribution configuration.
        :param 'DistributionConfigurationTargetContainerRepository' target_repository: The destination repository for the container distribution configuration.
        """
        if container_tags is not None:
            pulumi.set(__self__, "container_tags", container_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if target_repository is not None:
            pulumi.set(__self__, "target_repository", target_repository)

    @property
    @pulumi.getter(name="containerTags")
    def container_tags(self) -> Optional[Sequence[builtins.str]]:
        """
        Tags that are attached to the container distribution configuration.
        """
        return pulumi.get(self, "container_tags")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the container distribution configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="targetRepository")
    def target_repository(self) -> Optional['outputs.DistributionConfigurationTargetContainerRepository']:
        """
        The destination repository for the container distribution configuration.
        """
        return pulumi.get(self, "target_repository")


@pulumi.output_type
class DistributionConfigurationDistribution(dict):
    """
    The distributions of the distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiDistributionConfiguration":
            suggest = "ami_distribution_configuration"
        elif key == "containerDistributionConfiguration":
            suggest = "container_distribution_configuration"
        elif key == "fastLaunchConfigurations":
            suggest = "fast_launch_configurations"
        elif key == "launchTemplateConfigurations":
            suggest = "launch_template_configurations"
        elif key == "licenseConfigurationArns":
            suggest = "license_configuration_arns"
        elif key == "ssmParameterConfigurations":
            suggest = "ssm_parameter_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationDistribution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationDistribution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationDistribution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: builtins.str,
                 ami_distribution_configuration: Optional['outputs.DistributionConfigurationAmiDistributionConfiguration'] = None,
                 container_distribution_configuration: Optional['outputs.DistributionConfigurationContainerDistributionConfiguration'] = None,
                 fast_launch_configurations: Optional[Sequence['outputs.DistributionConfigurationFastLaunchConfiguration']] = None,
                 launch_template_configurations: Optional[Sequence['outputs.DistributionConfigurationLaunchTemplateConfiguration']] = None,
                 license_configuration_arns: Optional[Sequence[builtins.str]] = None,
                 ssm_parameter_configurations: Optional[Sequence['outputs.DistributionConfigurationSsmParameterConfiguration']] = None):
        """
        The distributions of the distribution configuration.
        :param builtins.str region: region
        :param 'DistributionConfigurationAmiDistributionConfiguration' ami_distribution_configuration: The specific AMI settings, such as launch permissions and AMI tags. For details, see example schema below.
        :param 'DistributionConfigurationContainerDistributionConfiguration' container_distribution_configuration: Container distribution settings for encryption, licensing, and sharing in a specific Region. For details, see example schema below.
        :param Sequence['DistributionConfigurationFastLaunchConfiguration'] fast_launch_configurations: The Windows faster-launching configurations to use for AMI distribution.
        :param Sequence['DistributionConfigurationLaunchTemplateConfiguration'] launch_template_configurations: A group of launchTemplateConfiguration settings that apply to image distribution.
        :param Sequence[builtins.str] license_configuration_arns: The License Manager Configuration to associate with the AMI in the specified Region.
        :param Sequence['DistributionConfigurationSsmParameterConfiguration'] ssm_parameter_configurations: The SSM parameter configurations to use for AMI distribution.
        """
        pulumi.set(__self__, "region", region)
        if ami_distribution_configuration is not None:
            pulumi.set(__self__, "ami_distribution_configuration", ami_distribution_configuration)
        if container_distribution_configuration is not None:
            pulumi.set(__self__, "container_distribution_configuration", container_distribution_configuration)
        if fast_launch_configurations is not None:
            pulumi.set(__self__, "fast_launch_configurations", fast_launch_configurations)
        if launch_template_configurations is not None:
            pulumi.set(__self__, "launch_template_configurations", launch_template_configurations)
        if license_configuration_arns is not None:
            pulumi.set(__self__, "license_configuration_arns", license_configuration_arns)
        if ssm_parameter_configurations is not None:
            pulumi.set(__self__, "ssm_parameter_configurations", ssm_parameter_configurations)

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="amiDistributionConfiguration")
    def ami_distribution_configuration(self) -> Optional['outputs.DistributionConfigurationAmiDistributionConfiguration']:
        """
        The specific AMI settings, such as launch permissions and AMI tags. For details, see example schema below.
        """
        return pulumi.get(self, "ami_distribution_configuration")

    @property
    @pulumi.getter(name="containerDistributionConfiguration")
    def container_distribution_configuration(self) -> Optional['outputs.DistributionConfigurationContainerDistributionConfiguration']:
        """
        Container distribution settings for encryption, licensing, and sharing in a specific Region. For details, see example schema below.
        """
        return pulumi.get(self, "container_distribution_configuration")

    @property
    @pulumi.getter(name="fastLaunchConfigurations")
    def fast_launch_configurations(self) -> Optional[Sequence['outputs.DistributionConfigurationFastLaunchConfiguration']]:
        """
        The Windows faster-launching configurations to use for AMI distribution.
        """
        return pulumi.get(self, "fast_launch_configurations")

    @property
    @pulumi.getter(name="launchTemplateConfigurations")
    def launch_template_configurations(self) -> Optional[Sequence['outputs.DistributionConfigurationLaunchTemplateConfiguration']]:
        """
        A group of launchTemplateConfiguration settings that apply to image distribution.
        """
        return pulumi.get(self, "launch_template_configurations")

    @property
    @pulumi.getter(name="licenseConfigurationArns")
    def license_configuration_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The License Manager Configuration to associate with the AMI in the specified Region.
        """
        return pulumi.get(self, "license_configuration_arns")

    @property
    @pulumi.getter(name="ssmParameterConfigurations")
    def ssm_parameter_configurations(self) -> Optional[Sequence['outputs.DistributionConfigurationSsmParameterConfiguration']]:
        """
        The SSM parameter configurations to use for AMI distribution.
        """
        return pulumi.get(self, "ssm_parameter_configurations")


@pulumi.output_type
class DistributionConfigurationFastLaunchConfiguration(dict):
    """
    The Windows faster-launching configuration to use for AMI distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "launchTemplate":
            suggest = "launch_template"
        elif key == "maxParallelLaunches":
            suggest = "max_parallel_launches"
        elif key == "snapshotConfiguration":
            suggest = "snapshot_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationFastLaunchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationFastLaunchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationFastLaunchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[builtins.str] = None,
                 enabled: Optional[builtins.bool] = None,
                 launch_template: Optional['outputs.DistributionConfigurationFastLaunchLaunchTemplateSpecification'] = None,
                 max_parallel_launches: Optional[builtins.int] = None,
                 snapshot_configuration: Optional['outputs.DistributionConfigurationFastLaunchSnapshotConfiguration'] = None):
        """
        The Windows faster-launching configuration to use for AMI distribution.
        :param builtins.str account_id: The owner account ID for the fast-launch enabled Windows AMI.
        :param builtins.bool enabled: A Boolean that represents the current state of faster launching for the Windows AMI. Set to true to start using Windows faster launching, or false to stop using it.
        :param 'DistributionConfigurationFastLaunchLaunchTemplateSpecification' launch_template: The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
        :param builtins.int max_parallel_launches: The maximum number of parallel instances that are launched for creating resources.
        :param 'DistributionConfigurationFastLaunchSnapshotConfiguration' snapshot_configuration: Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if max_parallel_launches is not None:
            pulumi.set(__self__, "max_parallel_launches", max_parallel_launches)
        if snapshot_configuration is not None:
            pulumi.set(__self__, "snapshot_configuration", snapshot_configuration)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The owner account ID for the fast-launch enabled Windows AMI.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        A Boolean that represents the current state of faster launching for the Windows AMI. Set to true to start using Windows faster launching, or false to stop using it.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional['outputs.DistributionConfigurationFastLaunchLaunchTemplateSpecification']:
        """
        The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="maxParallelLaunches")
    def max_parallel_launches(self) -> Optional[builtins.int]:
        """
        The maximum number of parallel instances that are launched for creating resources.
        """
        return pulumi.get(self, "max_parallel_launches")

    @property
    @pulumi.getter(name="snapshotConfiguration")
    def snapshot_configuration(self) -> Optional['outputs.DistributionConfigurationFastLaunchSnapshotConfiguration']:
        """
        Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
        """
        return pulumi.get(self, "snapshot_configuration")


@pulumi.output_type
class DistributionConfigurationFastLaunchLaunchTemplateSpecification(dict):
    """
    The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"
        elif key == "launchTemplateVersion":
            suggest = "launch_template_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationFastLaunchLaunchTemplateSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationFastLaunchLaunchTemplateSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationFastLaunchLaunchTemplateSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[builtins.str] = None,
                 launch_template_name: Optional[builtins.str] = None,
                 launch_template_version: Optional[builtins.str] = None):
        """
        The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
        :param builtins.str launch_template_id: The ID of the launch template to use for faster launching for a Windows AMI.
        :param builtins.str launch_template_name: The name of the launch template to use for faster launching for a Windows AMI.
        :param builtins.str launch_template_version: The version of the launch template to use for faster launching for a Windows AMI.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[builtins.str]:
        """
        The ID of the launch template to use for faster launching for a Windows AMI.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[builtins.str]:
        """
        The name of the launch template to use for faster launching for a Windows AMI.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[builtins.str]:
        """
        The version of the launch template to use for faster launching for a Windows AMI.
        """
        return pulumi.get(self, "launch_template_version")


@pulumi.output_type
class DistributionConfigurationFastLaunchSnapshotConfiguration(dict):
    """
    Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetResourceCount":
            suggest = "target_resource_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationFastLaunchSnapshotConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationFastLaunchSnapshotConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationFastLaunchSnapshotConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_resource_count: Optional[builtins.int] = None):
        """
        Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
        :param builtins.int target_resource_count: The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
        """
        if target_resource_count is not None:
            pulumi.set(__self__, "target_resource_count", target_resource_count)

    @property
    @pulumi.getter(name="targetResourceCount")
    def target_resource_count(self) -> Optional[builtins.int]:
        """
        The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
        """
        return pulumi.get(self, "target_resource_count")


@pulumi.output_type
class DistributionConfigurationLaunchPermissionConfiguration(dict):
    """
    Launch permissions can be used to configure which AWS accounts can use the AMI to launch instances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "organizationArns":
            suggest = "organization_arns"
        elif key == "organizationalUnitArns":
            suggest = "organizational_unit_arns"
        elif key == "userGroups":
            suggest = "user_groups"
        elif key == "userIds":
            suggest = "user_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationLaunchPermissionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationLaunchPermissionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationLaunchPermissionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 organization_arns: Optional[Sequence[builtins.str]] = None,
                 organizational_unit_arns: Optional[Sequence[builtins.str]] = None,
                 user_groups: Optional[Sequence[builtins.str]] = None,
                 user_ids: Optional[Sequence[builtins.str]] = None):
        """
        Launch permissions can be used to configure which AWS accounts can use the AMI to launch instances.
        :param Sequence[builtins.str] organization_arns: The ARN for an Amazon Web Services Organization that you want to share your AMI with.
        :param Sequence[builtins.str] organizational_unit_arns: The ARN for an Organizations organizational unit (OU) that you want to share your AMI with.
        :param Sequence[builtins.str] user_groups: The name of the group.
        :param Sequence[builtins.str] user_ids: The AWS account ID.
        """
        if organization_arns is not None:
            pulumi.set(__self__, "organization_arns", organization_arns)
        if organizational_unit_arns is not None:
            pulumi.set(__self__, "organizational_unit_arns", organizational_unit_arns)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="organizationArns")
    def organization_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The ARN for an Amazon Web Services Organization that you want to share your AMI with.
        """
        return pulumi.get(self, "organization_arns")

    @property
    @pulumi.getter(name="organizationalUnitArns")
    def organizational_unit_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The ARN for an Organizations organizational unit (OU) that you want to share your AMI with.
        """
        return pulumi.get(self, "organizational_unit_arns")

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The name of the group.
        """
        return pulumi.get(self, "user_groups")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The AWS account ID.
        """
        return pulumi.get(self, "user_ids")


@pulumi.output_type
class DistributionConfigurationLaunchTemplateConfiguration(dict):
    """
    launchTemplateConfiguration settings that apply to image distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "setDefaultVersion":
            suggest = "set_default_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationLaunchTemplateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationLaunchTemplateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationLaunchTemplateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[builtins.str] = None,
                 launch_template_id: Optional[builtins.str] = None,
                 set_default_version: Optional[builtins.bool] = None):
        """
        launchTemplateConfiguration settings that apply to image distribution.
        :param builtins.str account_id: The account ID that this configuration applies to.
        :param builtins.str launch_template_id: Identifies the EC2 launch template to use.
        :param builtins.bool set_default_version: Set the specified EC2 launch template as the default launch template for the specified account.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if set_default_version is not None:
            pulumi.set(__self__, "set_default_version", set_default_version)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The account ID that this configuration applies to.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[builtins.str]:
        """
        Identifies the EC2 launch template to use.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="setDefaultVersion")
    def set_default_version(self) -> Optional[builtins.bool]:
        """
        Set the specified EC2 launch template as the default launch template for the specified account.
        """
        return pulumi.get(self, "set_default_version")


@pulumi.output_type
class DistributionConfigurationSsmParameterConfiguration(dict):
    """
    The SSM parameter configuration for AMI distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "amiAccountId":
            suggest = "ami_account_id"
        elif key == "dataType":
            suggest = "data_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationSsmParameterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationSsmParameterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationSsmParameterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: builtins.str,
                 ami_account_id: Optional[builtins.str] = None,
                 data_type: Optional['DistributionConfigurationSsmParameterConfigurationDataType'] = None):
        """
        The SSM parameter configuration for AMI distribution.
        :param builtins.str parameter_name: The name of the SSM parameter.
        :param builtins.str ami_account_id: The account ID for the AMI to update the parameter with.
        :param 'DistributionConfigurationSsmParameterConfigurationDataType' data_type: The data type of the SSM parameter.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        if ami_account_id is not None:
            pulumi.set(__self__, "ami_account_id", ami_account_id)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> builtins.str:
        """
        The name of the SSM parameter.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="amiAccountId")
    def ami_account_id(self) -> Optional[builtins.str]:
        """
        The account ID for the AMI to update the parameter with.
        """
        return pulumi.get(self, "ami_account_id")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional['DistributionConfigurationSsmParameterConfigurationDataType']:
        """
        The data type of the SSM parameter.
        """
        return pulumi.get(self, "data_type")


@pulumi.output_type
class DistributionConfigurationTargetContainerRepository(dict):
    """
    The destination repository for the container image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryName":
            suggest = "repository_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationTargetContainerRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationTargetContainerRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationTargetContainerRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_name: Optional[builtins.str] = None,
                 service: Optional['DistributionConfigurationTargetContainerRepositoryService'] = None):
        """
        The destination repository for the container image.
        :param builtins.str repository_name: The repository name of target container repository.
        :param 'DistributionConfigurationTargetContainerRepositoryService' service: The service of target container repository.
        """
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[builtins.str]:
        """
        The repository name of target container repository.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter
    def service(self) -> Optional['DistributionConfigurationTargetContainerRepositoryService']:
        """
        The service of target container repository.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ImageEcrConfiguration(dict):
    """
    Settings for Image Builder to configure the ECR repository and output container images that are scanned.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerTags":
            suggest = "container_tags"
        elif key == "repositoryName":
            suggest = "repository_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageEcrConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageEcrConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageEcrConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_tags: Optional[Sequence[builtins.str]] = None,
                 repository_name: Optional[builtins.str] = None):
        """
        Settings for Image Builder to configure the ECR repository and output container images that are scanned.
        :param Sequence[builtins.str] container_tags: Tags for Image Builder to apply the output container image that is scanned. Tags can help you identify and manage your scanned images.
        :param builtins.str repository_name: The name of the container repository that Amazon Inspector scans to identify findings for your container images. The name includes the path for the repository location. If you don’t provide this information, Image Builder creates a repository in your account named image-builder-image-scanning-repository to use for vulnerability scans for your output container images.
        """
        if container_tags is not None:
            pulumi.set(__self__, "container_tags", container_tags)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter(name="containerTags")
    def container_tags(self) -> Optional[Sequence[builtins.str]]:
        """
        Tags for Image Builder to apply the output container image that is scanned. Tags can help you identify and manage your scanned images.
        """
        return pulumi.get(self, "container_tags")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[builtins.str]:
        """
        The name of the container repository that Amazon Inspector scans to identify findings for your container images. The name includes the path for the repository location. If you don’t provide this information, Image Builder creates a repository in your account named image-builder-image-scanning-repository to use for vulnerability scans for your output container images.
        """
        return pulumi.get(self, "repository_name")


@pulumi.output_type
class ImagePipelineEcrConfiguration(dict):
    """
    Settings for Image Builder to configure the ECR repository and output container images that are scanned.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerTags":
            suggest = "container_tags"
        elif key == "repositoryName":
            suggest = "repository_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineEcrConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineEcrConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineEcrConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_tags: Optional[Sequence[builtins.str]] = None,
                 repository_name: Optional[builtins.str] = None):
        """
        Settings for Image Builder to configure the ECR repository and output container images that are scanned.
        :param Sequence[builtins.str] container_tags: Tags for Image Builder to apply the output container image that is scanned. Tags can help you identify and manage your scanned images.
        :param builtins.str repository_name: The name of the container repository that Amazon Inspector scans to identify findings for your container images. The name includes the path for the repository location. If you don't provide this information, Image Builder creates a repository in your account named image-builder-image-scanning-repository to use for vulnerability scans for your output container images.
        """
        if container_tags is not None:
            pulumi.set(__self__, "container_tags", container_tags)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter(name="containerTags")
    def container_tags(self) -> Optional[Sequence[builtins.str]]:
        """
        Tags for Image Builder to apply the output container image that is scanned. Tags can help you identify and manage your scanned images.
        """
        return pulumi.get(self, "container_tags")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[builtins.str]:
        """
        The name of the container repository that Amazon Inspector scans to identify findings for your container images. The name includes the path for the repository location. If you don't provide this information, Image Builder creates a repository in your account named image-builder-image-scanning-repository to use for vulnerability scans for your output container images.
        """
        return pulumi.get(self, "repository_name")


@pulumi.output_type
class ImagePipelineImageScanningConfiguration(dict):
    """
    Determines if tests should run after building the image. Image Builder defaults to enable tests to run following the image build, before image distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ecrConfiguration":
            suggest = "ecr_configuration"
        elif key == "imageScanningEnabled":
            suggest = "image_scanning_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineImageScanningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineImageScanningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineImageScanningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ecr_configuration: Optional['outputs.ImagePipelineEcrConfiguration'] = None,
                 image_scanning_enabled: Optional[builtins.bool] = None):
        """
        Determines if tests should run after building the image. Image Builder defaults to enable tests to run following the image build, before image distribution.
        :param 'ImagePipelineEcrConfiguration' ecr_configuration: Contains ECR settings for vulnerability scans.
        :param builtins.bool image_scanning_enabled: This sets whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image.
        """
        if ecr_configuration is not None:
            pulumi.set(__self__, "ecr_configuration", ecr_configuration)
        if image_scanning_enabled is not None:
            pulumi.set(__self__, "image_scanning_enabled", image_scanning_enabled)

    @property
    @pulumi.getter(name="ecrConfiguration")
    def ecr_configuration(self) -> Optional['outputs.ImagePipelineEcrConfiguration']:
        """
        Contains ECR settings for vulnerability scans.
        """
        return pulumi.get(self, "ecr_configuration")

    @property
    @pulumi.getter(name="imageScanningEnabled")
    def image_scanning_enabled(self) -> Optional[builtins.bool]:
        """
        This sets whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image.
        """
        return pulumi.get(self, "image_scanning_enabled")


@pulumi.output_type
class ImagePipelineImageTestsConfiguration(dict):
    """
    Image tests configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageTestsEnabled":
            suggest = "image_tests_enabled"
        elif key == "timeoutMinutes":
            suggest = "timeout_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineImageTestsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineImageTestsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineImageTestsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_tests_enabled: Optional[builtins.bool] = None,
                 timeout_minutes: Optional[builtins.int] = None):
        """
        Image tests configuration.
        :param builtins.bool image_tests_enabled: Defines if tests should be executed when building this image.
        :param builtins.int timeout_minutes: The maximum time in minutes that tests are permitted to run.
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[builtins.bool]:
        """
        Defines if tests should be executed when building this image.
        """
        return pulumi.get(self, "image_tests_enabled")

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[builtins.int]:
        """
        The maximum time in minutes that tests are permitted to run.
        """
        return pulumi.get(self, "timeout_minutes")


@pulumi.output_type
class ImagePipelineSchedule(dict):
    """
    The schedule of the image pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineExecutionStartCondition":
            suggest = "pipeline_execution_start_condition"
        elif key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_execution_start_condition: Optional['ImagePipelineSchedulePipelineExecutionStartCondition'] = None,
                 schedule_expression: Optional[builtins.str] = None):
        """
        The schedule of the image pipeline.
        :param 'ImagePipelineSchedulePipelineExecutionStartCondition' pipeline_execution_start_condition: The condition configures when the pipeline should trigger a new image build.
        :param builtins.str schedule_expression: The expression determines how often EC2 Image Builder evaluates your pipelineExecutionStartCondition.
        """
        if pipeline_execution_start_condition is not None:
            pulumi.set(__self__, "pipeline_execution_start_condition", pipeline_execution_start_condition)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="pipelineExecutionStartCondition")
    def pipeline_execution_start_condition(self) -> Optional['ImagePipelineSchedulePipelineExecutionStartCondition']:
        """
        The condition configures when the pipeline should trigger a new image build.
        """
        return pulumi.get(self, "pipeline_execution_start_condition")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[builtins.str]:
        """
        The expression determines how often EC2 Image Builder evaluates your pipelineExecutionStartCondition.
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class ImagePipelineWorkflowConfiguration(dict):
    """
    The workflow configuration of the image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"
        elif key == "parallelGroup":
            suggest = "parallel_group"
        elif key == "workflowArn":
            suggest = "workflow_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineWorkflowConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineWorkflowConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineWorkflowConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['ImagePipelineWorkflowConfigurationOnFailure'] = None,
                 parallel_group: Optional[builtins.str] = None,
                 parameters: Optional[Sequence['outputs.ImagePipelineWorkflowParameter']] = None,
                 workflow_arn: Optional[builtins.str] = None):
        """
        The workflow configuration of the image
        :param 'ImagePipelineWorkflowConfigurationOnFailure' on_failure: Define execution decision in case of workflow failure
        :param builtins.str parallel_group: The parallel group name
        :param Sequence['ImagePipelineWorkflowParameter'] parameters: The parameters associated with the workflow
        :param builtins.str workflow_arn: The Amazon Resource Name (ARN) of the workflow
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if parallel_group is not None:
            pulumi.set(__self__, "parallel_group", parallel_group)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if workflow_arn is not None:
            pulumi.set(__self__, "workflow_arn", workflow_arn)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['ImagePipelineWorkflowConfigurationOnFailure']:
        """
        Define execution decision in case of workflow failure
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="parallelGroup")
    def parallel_group(self) -> Optional[builtins.str]:
        """
        The parallel group name
        """
        return pulumi.get(self, "parallel_group")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ImagePipelineWorkflowParameter']]:
        """
        The parameters associated with the workflow
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="workflowArn")
    def workflow_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the workflow
        """
        return pulumi.get(self, "workflow_arn")


@pulumi.output_type
class ImagePipelineWorkflowParameter(dict):
    """
    A parameter associated with the workflow
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[Sequence[builtins.str]] = None):
        """
        A parameter associated with the workflow
        :param builtins.str name: The name of the workflow parameter to set.
        :param Sequence[builtins.str] value: Sets the value for the named workflow parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the workflow parameter to set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[Sequence[builtins.str]]:
        """
        Sets the value for the named workflow parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ImageRecipeAdditionalInstanceConfiguration(dict):
    """
    Specify additional settings and launch scripts for your build instances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemsManagerAgent":
            suggest = "systems_manager_agent"
        elif key == "userDataOverride":
            suggest = "user_data_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeAdditionalInstanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeAdditionalInstanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeAdditionalInstanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 systems_manager_agent: Optional['outputs.ImageRecipeSystemsManagerAgent'] = None,
                 user_data_override: Optional[builtins.str] = None):
        """
        Specify additional settings and launch scripts for your build instances.
        :param 'ImageRecipeSystemsManagerAgent' systems_manager_agent: Contains settings for the SSM agent on your build instance.
        :param builtins.str user_data_override: Use this property to provide commands or a command script to run when you launch your build instance.
        """
        if systems_manager_agent is not None:
            pulumi.set(__self__, "systems_manager_agent", systems_manager_agent)
        if user_data_override is not None:
            pulumi.set(__self__, "user_data_override", user_data_override)

    @property
    @pulumi.getter(name="systemsManagerAgent")
    def systems_manager_agent(self) -> Optional['outputs.ImageRecipeSystemsManagerAgent']:
        """
        Contains settings for the SSM agent on your build instance.
        """
        return pulumi.get(self, "systems_manager_agent")

    @property
    @pulumi.getter(name="userDataOverride")
    def user_data_override(self) -> Optional[builtins.str]:
        """
        Use this property to provide commands or a command script to run when you launch your build instance.
        """
        return pulumi.get(self, "user_data_override")


@pulumi.output_type
class ImageRecipeComponentConfiguration(dict):
    """
    Configuration details of the component.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentArn":
            suggest = "component_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeComponentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeComponentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeComponentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_arn: Optional[builtins.str] = None,
                 parameters: Optional[Sequence['outputs.ImageRecipeComponentParameter']] = None):
        """
        Configuration details of the component.
        :param builtins.str component_arn: The Amazon Resource Name (ARN) of the component.
        :param Sequence['ImageRecipeComponentParameter'] parameters: A group of parameter settings that are used to configure the component for a specific recipe.
        """
        if component_arn is not None:
            pulumi.set(__self__, "component_arn", component_arn)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the component.
        """
        return pulumi.get(self, "component_arn")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ImageRecipeComponentParameter']]:
        """
        A group of parameter settings that are used to configure the component for a specific recipe.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ImageRecipeComponentParameter(dict):
    """
    Contains a key/value pair that sets the named component parameter.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 value: Sequence[builtins.str]):
        """
        Contains a key/value pair that sets the named component parameter.
        :param builtins.str name: The name of the component parameter to set.
        :param Sequence[builtins.str] value: Sets the value for the named component parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the component parameter to set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Sequence[builtins.str]:
        """
        Sets the value for the named component parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ImageRecipeEbsInstanceBlockDeviceSpecification(dict):
    """
    Amazon EBS-specific block device mapping specifications. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeEbsInstanceBlockDeviceSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeEbsInstanceBlockDeviceSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeEbsInstanceBlockDeviceSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[builtins.bool] = None,
                 encrypted: Optional[builtins.bool] = None,
                 iops: Optional[builtins.int] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 snapshot_id: Optional[builtins.str] = None,
                 throughput: Optional[builtins.int] = None,
                 volume_size: Optional[builtins.int] = None,
                 volume_type: Optional['ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType'] = None):
        """
        Amazon EBS-specific block device mapping specifications. 
        :param builtins.bool delete_on_termination: Use to configure delete on termination of the associated device.
        :param builtins.bool encrypted: Use to configure device encryption.
        :param builtins.int iops: Use to configure device IOPS.
        :param builtins.str kms_key_id: Use to configure the KMS key to use when encrypting the device.
        :param builtins.str snapshot_id: The snapshot that defines the device contents.
        :param builtins.int throughput: For GP3 volumes only - The throughput in MiB/s that the volume supports.
        :param builtins.int volume_size: Use to override the device's volume size.
        :param 'ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType' volume_type: Use to override the device's volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[builtins.bool]:
        """
        Use to configure delete on termination of the associated device.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[builtins.bool]:
        """
        Use to configure device encryption.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.int]:
        """
        Use to configure device IOPS.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        Use to configure the KMS key to use when encrypting the device.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[builtins.str]:
        """
        The snapshot that defines the device contents.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[builtins.int]:
        """
        For GP3 volumes only - The throughput in MiB/s that the volume supports.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[builtins.int]:
        """
        Use to override the device's volume size.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional['ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType']:
        """
        Use to override the device's volume type.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ImageRecipeInstanceBlockDeviceMapping(dict):
    """
    Defines block device mappings for the instance used to configure your image. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeInstanceBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeInstanceBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeInstanceBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[builtins.str] = None,
                 ebs: Optional['outputs.ImageRecipeEbsInstanceBlockDeviceSpecification'] = None,
                 no_device: Optional[builtins.str] = None,
                 virtual_name: Optional[builtins.str] = None):
        """
        Defines block device mappings for the instance used to configure your image. 
        :param builtins.str device_name: The device to which these mappings apply.
        :param 'ImageRecipeEbsInstanceBlockDeviceSpecification' ebs: Use to manage Amazon EBS-specific configuration for this mapping.
        :param builtins.str no_device: Use to remove a mapping from the parent image.
        :param builtins.str virtual_name: Use to manage instance ephemeral devices.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[builtins.str]:
        """
        The device to which these mappings apply.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.ImageRecipeEbsInstanceBlockDeviceSpecification']:
        """
        Use to manage Amazon EBS-specific configuration for this mapping.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[builtins.str]:
        """
        Use to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[builtins.str]:
        """
        Use to manage instance ephemeral devices.
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class ImageRecipeSystemsManagerAgent(dict):
    """
    Contains settings for the SSM agent on your build instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "uninstallAfterBuild":
            suggest = "uninstall_after_build"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeSystemsManagerAgent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeSystemsManagerAgent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeSystemsManagerAgent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uninstall_after_build: Optional[builtins.bool] = None):
        """
        Contains settings for the SSM agent on your build instance.
        :param builtins.bool uninstall_after_build: Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If this is set to true, then the agent is removed from the final image. If it's set to false, then the agent is left in, so that it is included in the new AMI. The default value is false.
        """
        if uninstall_after_build is not None:
            pulumi.set(__self__, "uninstall_after_build", uninstall_after_build)

    @property
    @pulumi.getter(name="uninstallAfterBuild")
    def uninstall_after_build(self) -> Optional[builtins.bool]:
        """
        Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If this is set to true, then the agent is removed from the final image. If it's set to false, then the agent is left in, so that it is included in the new AMI. The default value is false.
        """
        return pulumi.get(self, "uninstall_after_build")


@pulumi.output_type
class ImageScanningConfiguration(dict):
    """
    Contains settings for Image Builder image resource and container image scans.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ecrConfiguration":
            suggest = "ecr_configuration"
        elif key == "imageScanningEnabled":
            suggest = "image_scanning_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageScanningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageScanningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageScanningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ecr_configuration: Optional['outputs.ImageEcrConfiguration'] = None,
                 image_scanning_enabled: Optional[builtins.bool] = None):
        """
        Contains settings for Image Builder image resource and container image scans.
        :param 'ImageEcrConfiguration' ecr_configuration: Contains ECR settings for vulnerability scans.
        :param builtins.bool image_scanning_enabled: This sets whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image.
        """
        if ecr_configuration is not None:
            pulumi.set(__self__, "ecr_configuration", ecr_configuration)
        if image_scanning_enabled is not None:
            pulumi.set(__self__, "image_scanning_enabled", image_scanning_enabled)

    @property
    @pulumi.getter(name="ecrConfiguration")
    def ecr_configuration(self) -> Optional['outputs.ImageEcrConfiguration']:
        """
        Contains ECR settings for vulnerability scans.
        """
        return pulumi.get(self, "ecr_configuration")

    @property
    @pulumi.getter(name="imageScanningEnabled")
    def image_scanning_enabled(self) -> Optional[builtins.bool]:
        """
        This sets whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image.
        """
        return pulumi.get(self, "image_scanning_enabled")


@pulumi.output_type
class ImageTestsConfiguration(dict):
    """
    The image tests configuration used when creating this image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageTestsEnabled":
            suggest = "image_tests_enabled"
        elif key == "timeoutMinutes":
            suggest = "timeout_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTestsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTestsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTestsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_tests_enabled: Optional[builtins.bool] = None,
                 timeout_minutes: Optional[builtins.int] = None):
        """
        The image tests configuration used when creating this image.
        :param builtins.bool image_tests_enabled: ImageTestsEnabled
        :param builtins.int timeout_minutes: TimeoutMinutes
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[builtins.bool]:
        """
        ImageTestsEnabled
        """
        return pulumi.get(self, "image_tests_enabled")

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[builtins.int]:
        """
        TimeoutMinutes
        """
        return pulumi.get(self, "timeout_minutes")


@pulumi.output_type
class ImageWorkflowConfiguration(dict):
    """
    The workflow configuration of the image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"
        elif key == "parallelGroup":
            suggest = "parallel_group"
        elif key == "workflowArn":
            suggest = "workflow_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageWorkflowConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageWorkflowConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageWorkflowConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['ImageWorkflowConfigurationOnFailure'] = None,
                 parallel_group: Optional[builtins.str] = None,
                 parameters: Optional[Sequence['outputs.ImageWorkflowParameter']] = None,
                 workflow_arn: Optional[builtins.str] = None):
        """
        The workflow configuration of the image
        :param 'ImageWorkflowConfigurationOnFailure' on_failure: Define execution decision in case of workflow failure
        :param builtins.str parallel_group: The parallel group name
        :param Sequence['ImageWorkflowParameter'] parameters: The parameters associated with the workflow
        :param builtins.str workflow_arn: The Amazon Resource Name (ARN) of the workflow
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if parallel_group is not None:
            pulumi.set(__self__, "parallel_group", parallel_group)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if workflow_arn is not None:
            pulumi.set(__self__, "workflow_arn", workflow_arn)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['ImageWorkflowConfigurationOnFailure']:
        """
        Define execution decision in case of workflow failure
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="parallelGroup")
    def parallel_group(self) -> Optional[builtins.str]:
        """
        The parallel group name
        """
        return pulumi.get(self, "parallel_group")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ImageWorkflowParameter']]:
        """
        The parameters associated with the workflow
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="workflowArn")
    def workflow_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the workflow
        """
        return pulumi.get(self, "workflow_arn")


@pulumi.output_type
class ImageWorkflowParameter(dict):
    """
    A parameter associated with the workflow
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[Sequence[builtins.str]] = None):
        """
        A parameter associated with the workflow
        :param builtins.str name: The name of the workflow parameter to set.
        :param Sequence[builtins.str] value: Sets the value for the named workflow parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the workflow parameter to set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[Sequence[builtins.str]]:
        """
        Sets the value for the named workflow parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InfrastructureConfigurationInstanceMetadataOptions(dict):
    """
    The instance metadata option settings for the infrastructure configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"
        elif key == "httpTokens":
            suggest = "http_tokens"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureConfigurationInstanceMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureConfigurationInstanceMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureConfigurationInstanceMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_put_response_hop_limit: Optional[builtins.int] = None,
                 http_tokens: Optional['InfrastructureConfigurationInstanceMetadataOptionsHttpTokens'] = None):
        """
        The instance metadata option settings for the infrastructure configuration.
        :param builtins.int http_put_response_hop_limit: Limit the number of hops that an instance metadata request can traverse to reach its destination.
        :param 'InfrastructureConfigurationInstanceMetadataOptionsHttpTokens' http_tokens: Indicates whether a signed token header is required for instance metadata retrieval requests. The values affect the response as follows: 
        """
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[builtins.int]:
        """
        Limit the number of hops that an instance metadata request can traverse to reach its destination.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional['InfrastructureConfigurationInstanceMetadataOptionsHttpTokens']:
        """
        Indicates whether a signed token header is required for instance metadata retrieval requests. The values affect the response as follows: 
        """
        return pulumi.get(self, "http_tokens")


@pulumi.output_type
class InfrastructureConfigurationLogging(dict):
    """
    The logging configuration of the infrastructure configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Logs":
            suggest = "s3_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureConfigurationLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureConfigurationLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureConfigurationLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_logs: Optional['outputs.InfrastructureConfigurationS3Logs'] = None):
        """
        The logging configuration of the infrastructure configuration.
        :param 'InfrastructureConfigurationS3Logs' s3_logs: The Amazon S3 logging configuration.
        """
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional['outputs.InfrastructureConfigurationS3Logs']:
        """
        The Amazon S3 logging configuration.
        """
        return pulumi.get(self, "s3_logs")


@pulumi.output_type
class InfrastructureConfigurationPlacement(dict):
    """
    The placement options
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "hostId":
            suggest = "host_id"
        elif key == "hostResourceGroupArn":
            suggest = "host_resource_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureConfigurationPlacement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureConfigurationPlacement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureConfigurationPlacement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[builtins.str] = None,
                 host_id: Optional[builtins.str] = None,
                 host_resource_group_arn: Optional[builtins.str] = None,
                 tenancy: Optional['InfrastructureConfigurationPlacementTenancy'] = None):
        """
        The placement options
        :param builtins.str availability_zone: AvailabilityZone
        :param builtins.str host_id: HostId
        :param builtins.str host_resource_group_arn: HostResourceGroupArn
        :param 'InfrastructureConfigurationPlacementTenancy' tenancy: Tenancy
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if host_resource_group_arn is not None:
            pulumi.set(__self__, "host_resource_group_arn", host_resource_group_arn)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[builtins.str]:
        """
        AvailabilityZone
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[builtins.str]:
        """
        HostId
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> Optional[builtins.str]:
        """
        HostResourceGroupArn
        """
        return pulumi.get(self, "host_resource_group_arn")

    @property
    @pulumi.getter
    def tenancy(self) -> Optional['InfrastructureConfigurationPlacementTenancy']:
        """
        Tenancy
        """
        return pulumi.get(self, "tenancy")


@pulumi.output_type
class InfrastructureConfigurationS3Logs(dict):
    """
    The S3 path in which to store the logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureConfigurationS3Logs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureConfigurationS3Logs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureConfigurationS3Logs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: Optional[builtins.str] = None,
                 s3_key_prefix: Optional[builtins.str] = None):
        """
        The S3 path in which to store the logs.
        :param builtins.str s3_bucket_name: S3BucketName
        :param builtins.str s3_key_prefix: S3KeyPrefix
        """
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[builtins.str]:
        """
        S3BucketName
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[builtins.str]:
        """
        S3KeyPrefix
        """
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class LifecyclePolicyAction(dict):
    """
    The action of the policy detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeResources":
            suggest = "include_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'LifecyclePolicyActionType',
                 include_resources: Optional['outputs.LifecyclePolicyIncludeResources'] = None):
        """
        The action of the policy detail.
        :param 'LifecyclePolicyActionType' type: The action type of the policy detail.
        :param 'LifecyclePolicyIncludeResources' include_resources: Specifies the resources that the lifecycle policy applies to.
        """
        pulumi.set(__self__, "type", type)
        if include_resources is not None:
            pulumi.set(__self__, "include_resources", include_resources)

    @property
    @pulumi.getter
    def type(self) -> 'LifecyclePolicyActionType':
        """
        The action type of the policy detail.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="includeResources")
    def include_resources(self) -> Optional['outputs.LifecyclePolicyIncludeResources']:
        """
        Specifies the resources that the lifecycle policy applies to.
        """
        return pulumi.get(self, "include_resources")


@pulumi.output_type
class LifecyclePolicyAmiExclusionRules(dict):
    """
    The AMI exclusion rules for the policy detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPublic":
            suggest = "is_public"
        elif key == "lastLaunched":
            suggest = "last_launched"
        elif key == "sharedAccounts":
            suggest = "shared_accounts"
        elif key == "tagMap":
            suggest = "tag_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyAmiExclusionRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyAmiExclusionRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyAmiExclusionRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_public: Optional[builtins.bool] = None,
                 last_launched: Optional['outputs.LifecyclePolicyLastLaunched'] = None,
                 regions: Optional[Sequence[builtins.str]] = None,
                 shared_accounts: Optional[Sequence[builtins.str]] = None,
                 tag_map: Optional[Mapping[str, builtins.str]] = None):
        """
        The AMI exclusion rules for the policy detail.
        :param builtins.bool is_public: Use to apply lifecycle policy actions on whether the AMI is public.
        :param 'LifecyclePolicyLastLaunched' last_launched: Use to apply lifecycle policy actions on AMIs launched before a certain time.
        :param Sequence[builtins.str] regions: Use to apply lifecycle policy actions on AMIs distributed to a set of regions.
        :param Sequence[builtins.str] shared_accounts: Use to apply lifecycle policy actions on AMIs shared with a set of regions.
        :param Mapping[str, builtins.str] tag_map: The AMIs to select by tag.
        """
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if last_launched is not None:
            pulumi.set(__self__, "last_launched", last_launched)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if shared_accounts is not None:
            pulumi.set(__self__, "shared_accounts", shared_accounts)
        if tag_map is not None:
            pulumi.set(__self__, "tag_map", tag_map)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[builtins.bool]:
        """
        Use to apply lifecycle policy actions on whether the AMI is public.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter(name="lastLaunched")
    def last_launched(self) -> Optional['outputs.LifecyclePolicyLastLaunched']:
        """
        Use to apply lifecycle policy actions on AMIs launched before a certain time.
        """
        return pulumi.get(self, "last_launched")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[builtins.str]]:
        """
        Use to apply lifecycle policy actions on AMIs distributed to a set of regions.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="sharedAccounts")
    def shared_accounts(self) -> Optional[Sequence[builtins.str]]:
        """
        Use to apply lifecycle policy actions on AMIs shared with a set of regions.
        """
        return pulumi.get(self, "shared_accounts")

    @property
    @pulumi.getter(name="tagMap")
    def tag_map(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The AMIs to select by tag.
        """
        return pulumi.get(self, "tag_map")


@pulumi.output_type
class LifecyclePolicyExclusionRules(dict):
    """
    The exclusion rules to apply of the policy detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagMap":
            suggest = "tag_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyExclusionRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyExclusionRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyExclusionRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amis: Optional['outputs.LifecyclePolicyAmiExclusionRules'] = None,
                 tag_map: Optional[Mapping[str, builtins.str]] = None):
        """
        The exclusion rules to apply of the policy detail.
        :param 'LifecyclePolicyAmiExclusionRules' amis: Lists configuration values that apply to AMIs that Image Builder should exclude from the lifecycle action.
        :param Mapping[str, builtins.str] tag_map: The Image Builder tags to filter on.
        """
        if amis is not None:
            pulumi.set(__self__, "amis", amis)
        if tag_map is not None:
            pulumi.set(__self__, "tag_map", tag_map)

    @property
    @pulumi.getter
    def amis(self) -> Optional['outputs.LifecyclePolicyAmiExclusionRules']:
        """
        Lists configuration values that apply to AMIs that Image Builder should exclude from the lifecycle action.
        """
        return pulumi.get(self, "amis")

    @property
    @pulumi.getter(name="tagMap")
    def tag_map(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The Image Builder tags to filter on.
        """
        return pulumi.get(self, "tag_map")


@pulumi.output_type
class LifecyclePolicyFilter(dict):
    """
    The filters to apply of the policy detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainAtLeast":
            suggest = "retain_at_least"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'LifecyclePolicyFilterType',
                 value: builtins.int,
                 retain_at_least: Optional[builtins.int] = None,
                 unit: Optional['LifecyclePolicyTimeUnit'] = None):
        """
        The filters to apply of the policy detail.
        :param 'LifecyclePolicyFilterType' type: The filter type.
        :param builtins.int value: The filter value.
        :param builtins.int retain_at_least: The minimum number of Image Builder resources to retain.
        :param 'LifecyclePolicyTimeUnit' unit: The value's time unit.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if retain_at_least is not None:
            pulumi.set(__self__, "retain_at_least", retain_at_least)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def type(self) -> 'LifecyclePolicyFilterType':
        """
        The filter type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        """
        The filter value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="retainAtLeast")
    def retain_at_least(self) -> Optional[builtins.int]:
        """
        The minimum number of Image Builder resources to retain.
        """
        return pulumi.get(self, "retain_at_least")

    @property
    @pulumi.getter
    def unit(self) -> Optional['LifecyclePolicyTimeUnit']:
        """
        The value's time unit.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class LifecyclePolicyIncludeResources(dict):
    """
    The included resources of the policy detail.
    """
    def __init__(__self__, *,
                 amis: Optional[builtins.bool] = None,
                 containers: Optional[builtins.bool] = None,
                 snapshots: Optional[builtins.bool] = None):
        """
        The included resources of the policy detail.
        :param builtins.bool amis: Use to configure lifecycle actions on AMIs.
        :param builtins.bool containers: Use to configure lifecycle actions on containers.
        :param builtins.bool snapshots: Use to configure lifecycle actions on snapshots.
        """
        if amis is not None:
            pulumi.set(__self__, "amis", amis)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if snapshots is not None:
            pulumi.set(__self__, "snapshots", snapshots)

    @property
    @pulumi.getter
    def amis(self) -> Optional[builtins.bool]:
        """
        Use to configure lifecycle actions on AMIs.
        """
        return pulumi.get(self, "amis")

    @property
    @pulumi.getter
    def containers(self) -> Optional[builtins.bool]:
        """
        Use to configure lifecycle actions on containers.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter
    def snapshots(self) -> Optional[builtins.bool]:
        """
        Use to configure lifecycle actions on snapshots.
        """
        return pulumi.get(self, "snapshots")


@pulumi.output_type
class LifecyclePolicyLastLaunched(dict):
    """
    The last launched time of a resource.
    """
    def __init__(__self__, *,
                 unit: 'LifecyclePolicyTimeUnit',
                 value: builtins.int):
        """
        The last launched time of a resource.
        :param 'LifecyclePolicyTimeUnit' unit: The value's time unit.
        :param builtins.int value: The last launched value.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> 'LifecyclePolicyTimeUnit':
        """
        The value's time unit.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        """
        The last launched value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LifecyclePolicyPolicyDetail(dict):
    """
    The policy detail of the lifecycle policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionRules":
            suggest = "exclusion_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'outputs.LifecyclePolicyAction',
                 filter: 'outputs.LifecyclePolicyFilter',
                 exclusion_rules: Optional['outputs.LifecyclePolicyExclusionRules'] = None):
        """
        The policy detail of the lifecycle policy.
        :param 'LifecyclePolicyAction' action: Configuration details for the policy action.
        :param 'LifecyclePolicyFilter' filter: Specifies the resources that the lifecycle policy applies to.
        :param 'LifecyclePolicyExclusionRules' exclusion_rules: Additional rules to specify resources that should be exempt from policy actions.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "filter", filter)
        if exclusion_rules is not None:
            pulumi.set(__self__, "exclusion_rules", exclusion_rules)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.LifecyclePolicyAction':
        """
        Configuration details for the policy action.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def filter(self) -> 'outputs.LifecyclePolicyFilter':
        """
        Specifies the resources that the lifecycle policy applies to.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> Optional['outputs.LifecyclePolicyExclusionRules']:
        """
        Additional rules to specify resources that should be exempt from policy actions.
        """
        return pulumi.get(self, "exclusion_rules")


@pulumi.output_type
class LifecyclePolicyRecipeSelection(dict):
    """
    The recipe to apply the lifecycle policy for.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "semanticVersion":
            suggest = "semantic_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyRecipeSelection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyRecipeSelection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyRecipeSelection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 semantic_version: builtins.str):
        """
        The recipe to apply the lifecycle policy for.
        :param builtins.str name: The recipe name.
        :param builtins.str semantic_version: The recipe version.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "semantic_version", semantic_version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The recipe name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="semanticVersion")
    def semantic_version(self) -> builtins.str:
        """
        The recipe version.
        """
        return pulumi.get(self, "semantic_version")


@pulumi.output_type
class LifecyclePolicyResourceSelection(dict):
    """
    The resource selection for the lifecycle policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagMap":
            suggest = "tag_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyResourceSelection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyResourceSelection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyResourceSelection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recipes: Optional[Sequence['outputs.LifecyclePolicyRecipeSelection']] = None,
                 tag_map: Optional[Mapping[str, builtins.str]] = None):
        """
        The resource selection for the lifecycle policy.
        :param Sequence['LifecyclePolicyRecipeSelection'] recipes: The recipes to select.
        :param Mapping[str, builtins.str] tag_map: The Image Builder resources to select by tag.
        """
        if recipes is not None:
            pulumi.set(__self__, "recipes", recipes)
        if tag_map is not None:
            pulumi.set(__self__, "tag_map", tag_map)

    @property
    @pulumi.getter
    def recipes(self) -> Optional[Sequence['outputs.LifecyclePolicyRecipeSelection']]:
        """
        The recipes to select.
        """
        return pulumi.get(self, "recipes")

    @property
    @pulumi.getter(name="tagMap")
    def tag_map(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The Image Builder resources to select by tag.
        """
        return pulumi.get(self, "tag_map")


