# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ImageRecipeArgs', 'ImageRecipe']

@pulumi.input_type
class ImageRecipeArgs:
    def __init__(__self__, *,
                 components: pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentConfigurationArgs']]],
                 parent_image: pulumi.Input[builtins.str],
                 version: pulumi.Input[builtins.str],
                 additional_instance_configuration: Optional[pulumi.Input['ImageRecipeAdditionalInstanceConfigurationArgs']] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeInstanceBlockDeviceMappingArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 working_directory: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ImageRecipe resource.
        :param pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentConfigurationArgs']]] components: The components of the image recipe.
        :param pulumi.Input[builtins.str] parent_image: The parent image of the image recipe.
        :param pulumi.Input[builtins.str] version: The version of the image recipe.
        :param pulumi.Input['ImageRecipeAdditionalInstanceConfigurationArgs'] additional_instance_configuration: Specify additional settings and launch scripts for your build instances.
        :param pulumi.Input[Sequence[pulumi.Input['ImageRecipeInstanceBlockDeviceMappingArgs']]] block_device_mappings: The block device mappings to apply when creating images from this recipe.
        :param pulumi.Input[builtins.str] description: The description of the image recipe.
        :param pulumi.Input[builtins.str] name: The name of the image recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The tags of the image recipe.
        :param pulumi.Input[builtins.str] working_directory: The working directory to be used during build and test workflows.
        """
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "parent_image", parent_image)
        pulumi.set(__self__, "version", version)
        if additional_instance_configuration is not None:
            pulumi.set(__self__, "additional_instance_configuration", additional_instance_configuration)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def components(self) -> pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentConfigurationArgs']]]:
        """
        The components of the image recipe.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentConfigurationArgs']]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter(name="parentImage")
    def parent_image(self) -> pulumi.Input[builtins.str]:
        """
        The parent image of the image recipe.
        """
        return pulumi.get(self, "parent_image")

    @parent_image.setter
    def parent_image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent_image", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the image recipe.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="additionalInstanceConfiguration")
    def additional_instance_configuration(self) -> Optional[pulumi.Input['ImageRecipeAdditionalInstanceConfigurationArgs']]:
        """
        Specify additional settings and launch scripts for your build instances.
        """
        return pulumi.get(self, "additional_instance_configuration")

    @additional_instance_configuration.setter
    def additional_instance_configuration(self, value: Optional[pulumi.Input['ImageRecipeAdditionalInstanceConfigurationArgs']]):
        pulumi.set(self, "additional_instance_configuration", value)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeInstanceBlockDeviceMappingArgs']]]]:
        """
        The block device mappings to apply when creating images from this recipe.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeInstanceBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the image recipe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the image recipe.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags of the image recipe.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The working directory to be used during build and test workflows.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.type_token("aws-native:imagebuilder:ImageRecipe")
class ImageRecipe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_instance_configuration: Optional[pulumi.Input[Union['ImageRecipeAdditionalInstanceConfigurationArgs', 'ImageRecipeAdditionalInstanceConfigurationArgsDict']]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageRecipeInstanceBlockDeviceMappingArgs', 'ImageRecipeInstanceBlockDeviceMappingArgsDict']]]]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageRecipeComponentConfigurationArgs', 'ImageRecipeComponentConfigurationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_image: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::ImageBuilder::ImageRecipe

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ImageRecipeAdditionalInstanceConfigurationArgs', 'ImageRecipeAdditionalInstanceConfigurationArgsDict']] additional_instance_configuration: Specify additional settings and launch scripts for your build instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageRecipeInstanceBlockDeviceMappingArgs', 'ImageRecipeInstanceBlockDeviceMappingArgsDict']]]] block_device_mappings: The block device mappings to apply when creating images from this recipe.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageRecipeComponentConfigurationArgs', 'ImageRecipeComponentConfigurationArgsDict']]]] components: The components of the image recipe.
        :param pulumi.Input[builtins.str] description: The description of the image recipe.
        :param pulumi.Input[builtins.str] name: The name of the image recipe.
        :param pulumi.Input[builtins.str] parent_image: The parent image of the image recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The tags of the image recipe.
        :param pulumi.Input[builtins.str] version: The version of the image recipe.
        :param pulumi.Input[builtins.str] working_directory: The working directory to be used during build and test workflows.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageRecipeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::ImageBuilder::ImageRecipe

        :param str resource_name: The name of the resource.
        :param ImageRecipeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageRecipeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_instance_configuration: Optional[pulumi.Input[Union['ImageRecipeAdditionalInstanceConfigurationArgs', 'ImageRecipeAdditionalInstanceConfigurationArgsDict']]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageRecipeInstanceBlockDeviceMappingArgs', 'ImageRecipeInstanceBlockDeviceMappingArgsDict']]]]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageRecipeComponentConfigurationArgs', 'ImageRecipeComponentConfigurationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_image: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageRecipeArgs.__new__(ImageRecipeArgs)

            __props__.__dict__["additional_instance_configuration"] = additional_instance_configuration
            __props__.__dict__["block_device_mappings"] = block_device_mappings
            if components is None and not opts.urn:
                raise TypeError("Missing required property 'components'")
            __props__.__dict__["components"] = components
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if parent_image is None and not opts.urn:
                raise TypeError("Missing required property 'parent_image'")
            __props__.__dict__["parent_image"] = parent_image
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["working_directory"] = working_directory
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["blockDeviceMappings[*]", "components[*]", "description", "name", "parentImage", "tags.*", "version", "workingDirectory"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ImageRecipe, __self__).__init__(
            'aws-native:imagebuilder:ImageRecipe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ImageRecipe':
        """
        Get an existing ImageRecipe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ImageRecipeArgs.__new__(ImageRecipeArgs)

        __props__.__dict__["additional_instance_configuration"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["block_device_mappings"] = None
        __props__.__dict__["components"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["parent_image"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["version"] = None
        __props__.__dict__["working_directory"] = None
        return ImageRecipe(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalInstanceConfiguration")
    def additional_instance_configuration(self) -> pulumi.Output[Optional['outputs.ImageRecipeAdditionalInstanceConfiguration']]:
        """
        Specify additional settings and launch scripts for your build instances.
        """
        return pulumi.get(self, "additional_instance_configuration")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the image recipe.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.ImageRecipeInstanceBlockDeviceMapping']]]:
        """
        The block device mappings to apply when creating images from this recipe.
        """
        return pulumi.get(self, "block_device_mappings")

    @property
    @pulumi.getter
    def components(self) -> pulumi.Output[Sequence['outputs.ImageRecipeComponentConfiguration']]:
        """
        The components of the image recipe.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the image recipe.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the image recipe.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentImage")
    def parent_image(self) -> pulumi.Output[builtins.str]:
        """
        The parent image of the image recipe.
        """
        return pulumi.get(self, "parent_image")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The tags of the image recipe.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the image recipe.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The working directory to be used during build and test workflows.
        """
        return pulumi.get(self, "working_directory")

