# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetLifecyclePolicyResult',
    'AwaitableGetLifecyclePolicyResult',
    'get_lifecycle_policy',
    'get_lifecycle_policy_output',
]

@pulumi.output_type
class GetLifecyclePolicyResult:
    def __init__(__self__, arn=None, description=None, execution_role=None, policy_details=None, resource_selection=None, resource_type=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if execution_role and not isinstance(execution_role, str):
            raise TypeError("Expected argument 'execution_role' to be a str")
        pulumi.set(__self__, "execution_role", execution_role)
        if policy_details and not isinstance(policy_details, list):
            raise TypeError("Expected argument 'policy_details' to be a list")
        pulumi.set(__self__, "policy_details", policy_details)
        if resource_selection and not isinstance(resource_selection, dict):
            raise TypeError("Expected argument 'resource_selection' to be a dict")
        pulumi.set(__self__, "resource_selection", resource_selection)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the lifecycle policy.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the lifecycle policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[builtins.str]:
        """
        The execution role of the lifecycle policy.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="policyDetails")
    def policy_details(self) -> Optional[Sequence['outputs.LifecyclePolicyPolicyDetail']]:
        """
        The policy details of the lifecycle policy.
        """
        return pulumi.get(self, "policy_details")

    @property
    @pulumi.getter(name="resourceSelection")
    def resource_selection(self) -> Optional['outputs.LifecyclePolicyResourceSelection']:
        """
        The resource selection of the lifecycle policy.
        """
        return pulumi.get(self, "resource_selection")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional['LifecyclePolicyResourceType']:
        """
        The resource type of the lifecycle policy.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> Optional['LifecyclePolicyStatus']:
        """
        The status of the lifecycle policy.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags associated with the lifecycle policy.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLifecyclePolicyResult(GetLifecyclePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLifecyclePolicyResult(
            arn=self.arn,
            description=self.description,
            execution_role=self.execution_role,
            policy_details=self.policy_details,
            resource_selection=self.resource_selection,
            resource_type=self.resource_type,
            status=self.status,
            tags=self.tags)


def get_lifecycle_policy(arn: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLifecyclePolicyResult:
    """
    Resource schema for AWS::ImageBuilder::LifecyclePolicy


    :param builtins.str arn: The Amazon Resource Name (ARN) of the lifecycle policy.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:imagebuilder:getLifecyclePolicy', __args__, opts=opts, typ=GetLifecyclePolicyResult).value

    return AwaitableGetLifecyclePolicyResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        execution_role=pulumi.get(__ret__, 'execution_role'),
        policy_details=pulumi.get(__ret__, 'policy_details'),
        resource_selection=pulumi.get(__ret__, 'resource_selection'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_lifecycle_policy_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLifecyclePolicyResult]:
    """
    Resource schema for AWS::ImageBuilder::LifecyclePolicy


    :param builtins.str arn: The Amazon Resource Name (ARN) of the lifecycle policy.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:imagebuilder:getLifecyclePolicy', __args__, opts=opts, typ=GetLifecyclePolicyResult)
    return __ret__.apply(lambda __response__: GetLifecyclePolicyResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        execution_role=pulumi.get(__response__, 'execution_role'),
        policy_details=pulumi.get(__response__, 'policy_details'),
        resource_selection=pulumi.get(__response__, 'resource_selection'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
