# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGroupMembershipResult',
    'AwaitableGetGroupMembershipResult',
    'get_group_membership',
    'get_group_membership_output',
]

@pulumi.output_type
class GetGroupMembershipResult:
    def __init__(__self__, membership_id=None):
        if membership_id and not isinstance(membership_id, str):
            raise TypeError("Expected argument 'membership_id' to be a str")
        pulumi.set(__self__, "membership_id", membership_id)

    @property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> Optional[builtins.str]:
        """
        The identifier for a GroupMembership in the identity store.
        """
        return pulumi.get(self, "membership_id")


class AwaitableGetGroupMembershipResult(GetGroupMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupMembershipResult(
            membership_id=self.membership_id)


def get_group_membership(identity_store_id: Optional[builtins.str] = None,
                         membership_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupMembershipResult:
    """
    Resource Type Definition for AWS:IdentityStore::GroupMembership


    :param builtins.str identity_store_id: The globally unique identifier for the identity store.
    :param builtins.str membership_id: The identifier for a GroupMembership in the identity store.
    """
    __args__ = dict()
    __args__['identityStoreId'] = identity_store_id
    __args__['membershipId'] = membership_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:identitystore:getGroupMembership', __args__, opts=opts, typ=GetGroupMembershipResult).value

    return AwaitableGetGroupMembershipResult(
        membership_id=pulumi.get(__ret__, 'membership_id'))
def get_group_membership_output(identity_store_id: Optional[pulumi.Input[builtins.str]] = None,
                                membership_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupMembershipResult]:
    """
    Resource Type Definition for AWS:IdentityStore::GroupMembership


    :param builtins.str identity_store_id: The globally unique identifier for the identity store.
    :param builtins.str membership_id: The identifier for a GroupMembership in the identity store.
    """
    __args__ = dict()
    __args__['identityStoreId'] = identity_store_id
    __args__['membershipId'] = membership_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:identitystore:getGroupMembership', __args__, opts=opts, typ=GetGroupMembershipResult)
    return __ret__.apply(lambda __response__: GetGroupMembershipResult(
        membership_id=pulumi.get(__response__, 'membership_id')))
