# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['SamlProviderArgs', 'SamlProvider']

@pulumi.input_type
class SamlProviderArgs:
    def __init__(__self__, *,
                 add_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 assertion_encryption_mode: Optional[pulumi.Input['SamlProviderAssertionEncryptionMode']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_list: Optional[pulumi.Input[Sequence[pulumi.Input['SamlProviderSamlPrivateKeyArgs']]]] = None,
                 remove_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 saml_metadata_document: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a SamlProvider resource.
        :param pulumi.Input[builtins.str] add_private_key: The private key from your external identity provider
        :param pulumi.Input['SamlProviderAssertionEncryptionMode'] assertion_encryption_mode: The encryption setting for the SAML provider
        :param pulumi.Input[builtins.str] name: The name of the provider to create.
               
               This parameter allows (through its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex) ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
        :param pulumi.Input[Sequence[pulumi.Input['SamlProviderSamlPrivateKeyArgs']]] private_key_list: The private key metadata for the SAML provider.
        :param pulumi.Input[builtins.str] remove_private_key: The Key ID of the private key to remove
        :param pulumi.Input[builtins.str] saml_metadata_document: An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.
               
               For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the *IAM User Guide*
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of tags that you want to attach to the new IAM SAML provider. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide* .
               
               > If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
        """
        if add_private_key is not None:
            pulumi.set(__self__, "add_private_key", add_private_key)
        if assertion_encryption_mode is not None:
            pulumi.set(__self__, "assertion_encryption_mode", assertion_encryption_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key_list is not None:
            pulumi.set(__self__, "private_key_list", private_key_list)
        if remove_private_key is not None:
            pulumi.set(__self__, "remove_private_key", remove_private_key)
        if saml_metadata_document is not None:
            pulumi.set(__self__, "saml_metadata_document", saml_metadata_document)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addPrivateKey")
    def add_private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private key from your external identity provider
        """
        return pulumi.get(self, "add_private_key")

    @add_private_key.setter
    def add_private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "add_private_key", value)

    @property
    @pulumi.getter(name="assertionEncryptionMode")
    def assertion_encryption_mode(self) -> Optional[pulumi.Input['SamlProviderAssertionEncryptionMode']]:
        """
        The encryption setting for the SAML provider
        """
        return pulumi.get(self, "assertion_encryption_mode")

    @assertion_encryption_mode.setter
    def assertion_encryption_mode(self, value: Optional[pulumi.Input['SamlProviderAssertionEncryptionMode']]):
        pulumi.set(self, "assertion_encryption_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the provider to create.

        This parameter allows (through its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex) ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateKeyList")
    def private_key_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlProviderSamlPrivateKeyArgs']]]]:
        """
        The private key metadata for the SAML provider.
        """
        return pulumi.get(self, "private_key_list")

    @private_key_list.setter
    def private_key_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlProviderSamlPrivateKeyArgs']]]]):
        pulumi.set(self, "private_key_list", value)

    @property
    @pulumi.getter(name="removePrivateKey")
    def remove_private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Key ID of the private key to remove
        """
        return pulumi.get(self, "remove_private_key")

    @remove_private_key.setter
    def remove_private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_private_key", value)

    @property
    @pulumi.getter(name="samlMetadataDocument")
    def saml_metadata_document(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.

        For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the *IAM User Guide*
        """
        return pulumi.get(self, "saml_metadata_document")

    @saml_metadata_document.setter
    def saml_metadata_document(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "saml_metadata_document", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of tags that you want to attach to the new IAM SAML provider. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide* .

        > If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:iam:SamlProvider")
class SamlProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 assertion_encryption_mode: Optional[pulumi.Input['SamlProviderAssertionEncryptionMode']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_list: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlProviderSamlPrivateKeyArgs', 'SamlProviderSamlPrivateKeyArgsDict']]]]] = None,
                 remove_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 saml_metadata_document: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::IAM::SAMLProvider

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] add_private_key: The private key from your external identity provider
        :param pulumi.Input['SamlProviderAssertionEncryptionMode'] assertion_encryption_mode: The encryption setting for the SAML provider
        :param pulumi.Input[builtins.str] name: The name of the provider to create.
               
               This parameter allows (through its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex) ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
        :param pulumi.Input[Sequence[pulumi.Input[Union['SamlProviderSamlPrivateKeyArgs', 'SamlProviderSamlPrivateKeyArgsDict']]]] private_key_list: The private key metadata for the SAML provider.
        :param pulumi.Input[builtins.str] remove_private_key: The Key ID of the private key to remove
        :param pulumi.Input[builtins.str] saml_metadata_document: An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.
               
               For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the *IAM User Guide*
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of tags that you want to attach to the new IAM SAML provider. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide* .
               
               > If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SamlProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::IAM::SAMLProvider

        :param str resource_name: The name of the resource.
        :param SamlProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SamlProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 assertion_encryption_mode: Optional[pulumi.Input['SamlProviderAssertionEncryptionMode']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_list: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlProviderSamlPrivateKeyArgs', 'SamlProviderSamlPrivateKeyArgsDict']]]]] = None,
                 remove_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 saml_metadata_document: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SamlProviderArgs.__new__(SamlProviderArgs)

            __props__.__dict__["add_private_key"] = add_private_key
            __props__.__dict__["assertion_encryption_mode"] = assertion_encryption_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["private_key_list"] = private_key_list
            __props__.__dict__["remove_private_key"] = remove_private_key
            __props__.__dict__["saml_metadata_document"] = saml_metadata_document
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["saml_provider_uuid"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["addPrivateKey", "name", "removePrivateKey"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SamlProvider, __self__).__init__(
            'aws-native:iam:SamlProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SamlProvider':
        """
        Get an existing SamlProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SamlProviderArgs.__new__(SamlProviderArgs)

        __props__.__dict__["add_private_key"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["assertion_encryption_mode"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["private_key_list"] = None
        __props__.__dict__["remove_private_key"] = None
        __props__.__dict__["saml_metadata_document"] = None
        __props__.__dict__["saml_provider_uuid"] = None
        __props__.__dict__["tags"] = None
        return SamlProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addPrivateKey")
    def add_private_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The private key from your external identity provider
        """
        return pulumi.get(self, "add_private_key")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the SAML provider
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assertionEncryptionMode")
    def assertion_encryption_mode(self) -> pulumi.Output[Optional['SamlProviderAssertionEncryptionMode']]:
        """
        The encryption setting for the SAML provider
        """
        return pulumi.get(self, "assertion_encryption_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the provider to create.

        This parameter allows (through its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex) ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateKeyList")
    def private_key_list(self) -> pulumi.Output[Optional[Sequence['outputs.SamlProviderSamlPrivateKey']]]:
        """
        The private key metadata for the SAML provider.
        """
        return pulumi.get(self, "private_key_list")

    @property
    @pulumi.getter(name="removePrivateKey")
    def remove_private_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Key ID of the private key to remove
        """
        return pulumi.get(self, "remove_private_key")

    @property
    @pulumi.getter(name="samlMetadataDocument")
    def saml_metadata_document(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.

        For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the *IAM User Guide*
        """
        return pulumi.get(self, "saml_metadata_document")

    @property
    @pulumi.getter(name="samlProviderUuid")
    def saml_provider_uuid(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier assigned to the SAML provider
        """
        return pulumi.get(self, "saml_provider_uuid")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of tags that you want to attach to the new IAM SAML provider. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide* .

        > If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
        """
        return pulumi.get(self, "tags")

