# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GroupPolicy',
    'RolePolicy',
    'SamlProviderSamlPrivateKey',
    'UserLoginProfile',
    'UserPolicy',
]

@pulumi.output_type
class GroupPolicy(dict):
    """
    Contains information about an attached policy.
     An attached policy is a managed policy that has been attached to a user, group, or role.
     For more information about managed policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDocument":
            suggest = "policy_document"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: builtins.str):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The policy document.
        :param builtins.str policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The policy document.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> builtins.str:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class RolePolicy(dict):
    """
    Contains information about an attached policy.
     An attached policy is a managed policy that has been attached to a user, group, or role.
     For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDocument":
            suggest = "policy_document"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: builtins.str):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        :param builtins.str policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> builtins.str:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class SamlProviderSamlPrivateKey(dict):
    """
    The private key metadata for the SAML provider
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamlProviderSamlPrivateKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamlProviderSamlPrivateKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamlProviderSamlPrivateKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: builtins.str,
                 timestamp: builtins.str):
        """
        The private key metadata for the SAML provider
        :param builtins.str key_id: The unique identifier for the SAML private key.
        :param builtins.str timestamp: The date and time, in <a href=\\"http://www.iso.org/iso/iso8601\\">ISO 8601 date-time </a> format, when the private key was uploaded.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> builtins.str:
        """
        The unique identifier for the SAML private key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def timestamp(self) -> builtins.str:
        """
        The date and time, in <a href=\\"http://www.iso.org/iso/iso8601\\">ISO 8601 date-time </a> format, when the private key was uploaded.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class UserLoginProfile(dict):
    """
    Creates a password for the specified user, giving the user the ability to access AWS services through the console. For more information about managing passwords, see [Managing Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordResetRequired":
            suggest = "password_reset_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserLoginProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserLoginProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserLoginProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: builtins.str,
                 password_reset_required: Optional[builtins.bool] = None):
        """
        Creates a password for the specified user, giving the user the ability to access AWS services through the console. For more information about managing passwords, see [Managing Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *User Guide*.
        :param builtins.str password: The user's password.
        :param builtins.bool password_reset_required: Specifies whether the user is required to set a new password on next sign-in.
        """
        pulumi.set(__self__, "password", password)
        if password_reset_required is not None:
            pulumi.set(__self__, "password_reset_required", password_reset_required)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The user's password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordResetRequired")
    def password_reset_required(self) -> Optional[builtins.bool]:
        """
        Specifies whether the user is required to set a new password on next sign-in.
        """
        return pulumi.get(self, "password_reset_required")


@pulumi.output_type
class UserPolicy(dict):
    """
    Contains information about an attached policy.
     An attached policy is a managed policy that has been attached to a user, group, or role.
     For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDocument":
            suggest = "policy_document"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: builtins.str):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        :param builtins.str policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> builtins.str:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")


