# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetSamlProviderResult',
    'AwaitableGetSamlProviderResult',
    'get_saml_provider',
    'get_saml_provider_output',
]

@pulumi.output_type
class GetSamlProviderResult:
    def __init__(__self__, arn=None, assertion_encryption_mode=None, private_key_list=None, saml_metadata_document=None, saml_provider_uuid=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if assertion_encryption_mode and not isinstance(assertion_encryption_mode, str):
            raise TypeError("Expected argument 'assertion_encryption_mode' to be a str")
        pulumi.set(__self__, "assertion_encryption_mode", assertion_encryption_mode)
        if private_key_list and not isinstance(private_key_list, list):
            raise TypeError("Expected argument 'private_key_list' to be a list")
        pulumi.set(__self__, "private_key_list", private_key_list)
        if saml_metadata_document and not isinstance(saml_metadata_document, str):
            raise TypeError("Expected argument 'saml_metadata_document' to be a str")
        pulumi.set(__self__, "saml_metadata_document", saml_metadata_document)
        if saml_provider_uuid and not isinstance(saml_provider_uuid, str):
            raise TypeError("Expected argument 'saml_provider_uuid' to be a str")
        pulumi.set(__self__, "saml_provider_uuid", saml_provider_uuid)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of the SAML provider
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assertionEncryptionMode")
    def assertion_encryption_mode(self) -> Optional['SamlProviderAssertionEncryptionMode']:
        """
        The encryption setting for the SAML provider
        """
        return pulumi.get(self, "assertion_encryption_mode")

    @property
    @pulumi.getter(name="privateKeyList")
    def private_key_list(self) -> Optional[Sequence['outputs.SamlProviderSamlPrivateKey']]:
        """
        The private key metadata for the SAML provider.
        """
        return pulumi.get(self, "private_key_list")

    @property
    @pulumi.getter(name="samlMetadataDocument")
    def saml_metadata_document(self) -> Optional[builtins.str]:
        """
        An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.

        For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the *IAM User Guide*
        """
        return pulumi.get(self, "saml_metadata_document")

    @property
    @pulumi.getter(name="samlProviderUuid")
    def saml_provider_uuid(self) -> Optional[builtins.str]:
        """
        The unique identifier assigned to the SAML provider
        """
        return pulumi.get(self, "saml_provider_uuid")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags that you want to attach to the new IAM SAML provider. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide* .

        > If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSamlProviderResult(GetSamlProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSamlProviderResult(
            arn=self.arn,
            assertion_encryption_mode=self.assertion_encryption_mode,
            private_key_list=self.private_key_list,
            saml_metadata_document=self.saml_metadata_document,
            saml_provider_uuid=self.saml_provider_uuid,
            tags=self.tags)


def get_saml_provider(arn: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSamlProviderResult:
    """
    Resource Type definition for AWS::IAM::SAMLProvider


    :param builtins.str arn: Amazon Resource Name (ARN) of the SAML provider
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iam:getSamlProvider', __args__, opts=opts, typ=GetSamlProviderResult).value

    return AwaitableGetSamlProviderResult(
        arn=pulumi.get(__ret__, 'arn'),
        assertion_encryption_mode=pulumi.get(__ret__, 'assertion_encryption_mode'),
        private_key_list=pulumi.get(__ret__, 'private_key_list'),
        saml_metadata_document=pulumi.get(__ret__, 'saml_metadata_document'),
        saml_provider_uuid=pulumi.get(__ret__, 'saml_provider_uuid'),
        tags=pulumi.get(__ret__, 'tags'))
def get_saml_provider_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSamlProviderResult]:
    """
    Resource Type definition for AWS::IAM::SAMLProvider


    :param builtins.str arn: Amazon Resource Name (ARN) of the SAML provider
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iam:getSamlProvider', __args__, opts=opts, typ=GetSamlProviderResult)
    return __ret__.apply(lambda __response__: GetSamlProviderResult(
        arn=pulumi.get(__response__, 'arn'),
        assertion_encryption_mode=pulumi.get(__response__, 'assertion_encryption_mode'),
        private_key_list=pulumi.get(__response__, 'private_key_list'),
        saml_metadata_document=pulumi.get(__response__, 'saml_metadata_document'),
        saml_provider_uuid=pulumi.get(__response__, 'saml_provider_uuid'),
        tags=pulumi.get(__response__, 'tags')))
