# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetOidcProviderResult',
    'AwaitableGetOidcProviderResult',
    'get_oidc_provider',
    'get_oidc_provider_output',
]

@pulumi.output_type
class GetOidcProviderResult:
    def __init__(__self__, arn=None, client_id_list=None, tags=None, thumbprint_list=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if client_id_list and not isinstance(client_id_list, list):
            raise TypeError("Expected argument 'client_id_list' to be a list")
        pulumi.set(__self__, "client_id_list", client_id_list)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if thumbprint_list and not isinstance(thumbprint_list, list):
            raise TypeError("Expected argument 'thumbprint_list' to be a list")
        pulumi.set(__self__, "thumbprint_list", thumbprint_list)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of the OIDC provider
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clientIdList")
    def client_id_list(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object. For more information, see [CreateOpenIDConnectProvider](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html) .
        """
        return pulumi.get(self, "client_id_list")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags that are attached to the specified IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide* .
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="thumbprintList")
    def thumbprint_list(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. For more information, see [CreateOpenIDConnectProvider](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html) .

        This property is optional. If it is not included, IAM will retrieve and use the top intermediate certificate authority (CA) thumbprint of the OpenID Connect identity provider server certificate.
        """
        return pulumi.get(self, "thumbprint_list")


class AwaitableGetOidcProviderResult(GetOidcProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOidcProviderResult(
            arn=self.arn,
            client_id_list=self.client_id_list,
            tags=self.tags,
            thumbprint_list=self.thumbprint_list)


def get_oidc_provider(arn: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOidcProviderResult:
    """
    Resource Type definition for AWS::IAM::OIDCProvider


    :param builtins.str arn: Amazon Resource Name (ARN) of the OIDC provider
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iam:getOidcProvider', __args__, opts=opts, typ=GetOidcProviderResult).value

    return AwaitableGetOidcProviderResult(
        arn=pulumi.get(__ret__, 'arn'),
        client_id_list=pulumi.get(__ret__, 'client_id_list'),
        tags=pulumi.get(__ret__, 'tags'),
        thumbprint_list=pulumi.get(__ret__, 'thumbprint_list'))
def get_oidc_provider_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOidcProviderResult]:
    """
    Resource Type definition for AWS::IAM::OIDCProvider


    :param builtins.str arn: Amazon Resource Name (ARN) of the OIDC provider
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iam:getOidcProvider', __args__, opts=opts, typ=GetOidcProviderResult)
    return __ret__.apply(lambda __response__: GetOidcProviderResult(
        arn=pulumi.get(__response__, 'arn'),
        client_id_list=pulumi.get(__response__, 'client_id_list'),
        tags=pulumi.get(__response__, 'tags'),
        thumbprint_list=pulumi.get(__response__, 'thumbprint_list')))
