# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GroupPolicyArgs',
    'GroupPolicyArgsDict',
    'RolePolicyArgs',
    'RolePolicyArgsDict',
    'SamlProviderSamlPrivateKeyArgs',
    'SamlProviderSamlPrivateKeyArgsDict',
    'UserLoginProfileArgs',
    'UserLoginProfileArgsDict',
    'UserPolicyArgs',
    'UserPolicyArgsDict',
]

MYPY = False

if not MYPY:
    class GroupPolicyArgsDict(TypedDict):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        """
        policy_document: Any
        """
        The policy document.
        """
        policy_name: pulumi.Input[builtins.str]
        """
        The friendly name (not ARN) identifying the policy.
        """
elif False:
    GroupPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GroupPolicyArgs:
    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: pulumi.Input[builtins.str]):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The policy document.
        :param pulumi.Input[builtins.str] policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The policy document.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Any):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[builtins.str]:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_name", value)


if not MYPY:
    class RolePolicyArgsDict(TypedDict):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        """
        policy_document: Any
        """
        The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        """
        policy_name: pulumi.Input[builtins.str]
        """
        The friendly name (not ARN) identifying the policy.
        """
elif False:
    RolePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RolePolicyArgs:
    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: pulumi.Input[builtins.str]):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        :param pulumi.Input[builtins.str] policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Any):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[builtins.str]:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_name", value)


if not MYPY:
    class SamlProviderSamlPrivateKeyArgsDict(TypedDict):
        """
        The private key metadata for the SAML provider
        """
        key_id: pulumi.Input[builtins.str]
        """
        The unique identifier for the SAML private key.
        """
        timestamp: pulumi.Input[builtins.str]
        """
        The date and time, in <a href=\\"http://www.iso.org/iso/iso8601\\">ISO 8601 date-time </a> format, when the private key was uploaded.
        """
elif False:
    SamlProviderSamlPrivateKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SamlProviderSamlPrivateKeyArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[builtins.str],
                 timestamp: pulumi.Input[builtins.str]):
        """
        The private key metadata for the SAML provider
        :param pulumi.Input[builtins.str] key_id: The unique identifier for the SAML private key.
        :param pulumi.Input[builtins.str] timestamp: The date and time, in <a href=\\"http://www.iso.org/iso/iso8601\\">ISO 8601 date-time </a> format, when the private key was uploaded.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the SAML private key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def timestamp(self) -> pulumi.Input[builtins.str]:
        """
        The date and time, in <a href=\\"http://www.iso.org/iso/iso8601\\">ISO 8601 date-time </a> format, when the private key was uploaded.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "timestamp", value)


if not MYPY:
    class UserLoginProfileArgsDict(TypedDict):
        """
        Creates a password for the specified user, giving the user the ability to access AWS services through the console. For more information about managing passwords, see [Managing Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *User Guide*.
        """
        password: pulumi.Input[builtins.str]
        """
        The user's password.
        """
        password_reset_required: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether the user is required to set a new password on next sign-in.
        """
elif False:
    UserLoginProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserLoginProfileArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[builtins.str],
                 password_reset_required: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Creates a password for the specified user, giving the user the ability to access AWS services through the console. For more information about managing passwords, see [Managing Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *User Guide*.
        :param pulumi.Input[builtins.str] password: The user's password.
        :param pulumi.Input[builtins.bool] password_reset_required: Specifies whether the user is required to set a new password on next sign-in.
        """
        pulumi.set(__self__, "password", password)
        if password_reset_required is not None:
            pulumi.set(__self__, "password_reset_required", password_reset_required)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The user's password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordResetRequired")
    def password_reset_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the user is required to set a new password on next sign-in.
        """
        return pulumi.get(self, "password_reset_required")

    @password_reset_required.setter
    def password_reset_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "password_reset_required", value)


if not MYPY:
    class UserPolicyArgsDict(TypedDict):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        """
        policy_document: Any
        """
        The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        """
        policy_name: pulumi.Input[builtins.str]
        """
        The friendly name (not ARN) identifying the policy.
        """
elif False:
    UserPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserPolicyArgs:
    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: pulumi.Input[builtins.str]):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        :param pulumi.Input[builtins.str] policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Any):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[builtins.str]:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_name", value)


