# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetFhirDatastoreResult',
    'AwaitableGetFhirDatastoreResult',
    'get_fhir_datastore',
    'get_fhir_datastore_output',
]

@pulumi.output_type
class GetFhirDatastoreResult:
    def __init__(__self__, created_at=None, datastore_arn=None, datastore_endpoint=None, datastore_id=None, datastore_status=None, tags=None):
        if created_at and not isinstance(created_at, dict):
            raise TypeError("Expected argument 'created_at' to be a dict")
        pulumi.set(__self__, "created_at", created_at)
        if datastore_arn and not isinstance(datastore_arn, str):
            raise TypeError("Expected argument 'datastore_arn' to be a str")
        pulumi.set(__self__, "datastore_arn", datastore_arn)
        if datastore_endpoint and not isinstance(datastore_endpoint, str):
            raise TypeError("Expected argument 'datastore_endpoint' to be a str")
        pulumi.set(__self__, "datastore_endpoint", datastore_endpoint)
        if datastore_id and not isinstance(datastore_id, str):
            raise TypeError("Expected argument 'datastore_id' to be a str")
        pulumi.set(__self__, "datastore_id", datastore_id)
        if datastore_status and not isinstance(datastore_status, str):
            raise TypeError("Expected argument 'datastore_status' to be a str")
        pulumi.set(__self__, "datastore_status", datastore_status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional['outputs.FhirDatastoreCreatedAt']:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="datastoreArn")
    def datastore_arn(self) -> Optional[builtins.str]:
        """
        The Data Store ARN is generated during the creation of the Data Store and can be found in the output from the initial Data Store creation request.
        """
        return pulumi.get(self, "datastore_arn")

    @property
    @pulumi.getter(name="datastoreEndpoint")
    def datastore_endpoint(self) -> Optional[builtins.str]:
        """
        The endpoint for the created Data Store.
        """
        return pulumi.get(self, "datastore_endpoint")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[builtins.str]:
        """
        The Amazon generated Data Store id. This id is in the output from the initial Data Store creation call.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter(name="datastoreStatus")
    def datastore_status(self) -> Optional['FhirDatastoreDatastoreStatus']:
        """
        The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
        """
        return pulumi.get(self, "datastore_status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")


class AwaitableGetFhirDatastoreResult(GetFhirDatastoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFhirDatastoreResult(
            created_at=self.created_at,
            datastore_arn=self.datastore_arn,
            datastore_endpoint=self.datastore_endpoint,
            datastore_id=self.datastore_id,
            datastore_status=self.datastore_status,
            tags=self.tags)


def get_fhir_datastore(datastore_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFhirDatastoreResult:
    """
    HealthLake FHIR Datastore


    :param builtins.str datastore_id: The Amazon generated Data Store id. This id is in the output from the initial Data Store creation call.
    """
    __args__ = dict()
    __args__['datastoreId'] = datastore_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:healthlake:getFhirDatastore', __args__, opts=opts, typ=GetFhirDatastoreResult).value

    return AwaitableGetFhirDatastoreResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        datastore_arn=pulumi.get(__ret__, 'datastore_arn'),
        datastore_endpoint=pulumi.get(__ret__, 'datastore_endpoint'),
        datastore_id=pulumi.get(__ret__, 'datastore_id'),
        datastore_status=pulumi.get(__ret__, 'datastore_status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_fhir_datastore_output(datastore_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFhirDatastoreResult]:
    """
    HealthLake FHIR Datastore


    :param builtins.str datastore_id: The Amazon generated Data Store id. This id is in the output from the initial Data Store creation call.
    """
    __args__ = dict()
    __args__['datastoreId'] = datastore_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:healthlake:getFhirDatastore', __args__, opts=opts, typ=GetFhirDatastoreResult)
    return __ret__.apply(lambda __response__: GetFhirDatastoreResult(
        created_at=pulumi.get(__response__, 'created_at'),
        datastore_arn=pulumi.get(__response__, 'datastore_arn'),
        datastore_endpoint=pulumi.get(__response__, 'datastore_endpoint'),
        datastore_id=pulumi.get(__response__, 'datastore_id'),
        datastore_status=pulumi.get(__response__, 'datastore_status'),
        tags=pulumi.get(__response__, 'tags')))
