# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['PublishingDestinationArgs', 'PublishingDestination']

@pulumi.input_type
class PublishingDestinationArgs:
    def __init__(__self__, *,
                 destination_properties: pulumi.Input['PublishingDestinationCfnDestinationPropertiesArgs'],
                 destination_type: pulumi.Input[builtins.str],
                 detector_id: pulumi.Input[builtins.str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a PublishingDestination resource.
        :param pulumi.Input['PublishingDestinationCfnDestinationPropertiesArgs'] destination_properties: Contains the Amazon Resource Name (ARN) of the resource to publish to, such as an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
        :param pulumi.Input[builtins.str] destination_type: The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
        :param pulumi.Input[builtins.str] detector_id: The ID of the GuardDuty detector associated with the publishing destination.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Describes a tag.
        """
        pulumi.set(__self__, "destination_properties", destination_properties)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "detector_id", detector_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="destinationProperties")
    def destination_properties(self) -> pulumi.Input['PublishingDestinationCfnDestinationPropertiesArgs']:
        """
        Contains the Amazon Resource Name (ARN) of the resource to publish to, such as an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
        """
        return pulumi.get(self, "destination_properties")

    @destination_properties.setter
    def destination_properties(self, value: pulumi.Input['PublishingDestinationCfnDestinationPropertiesArgs']):
        pulumi.set(self, "destination_properties", value)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_type", value)

    @property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the GuardDuty detector associated with the publishing destination.
        """
        return pulumi.get(self, "detector_id")

    @detector_id.setter
    def detector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "detector_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Describes a tag.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:guardduty:PublishingDestination")
class PublishingDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_properties: Optional[pulumi.Input[Union['PublishingDestinationCfnDestinationPropertiesArgs', 'PublishingDestinationCfnDestinationPropertiesArgsDict']]] = None,
                 destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 detector_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::GuardDuty::PublishingDestination.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PublishingDestinationCfnDestinationPropertiesArgs', 'PublishingDestinationCfnDestinationPropertiesArgsDict']] destination_properties: Contains the Amazon Resource Name (ARN) of the resource to publish to, such as an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
        :param pulumi.Input[builtins.str] destination_type: The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
        :param pulumi.Input[builtins.str] detector_id: The ID of the GuardDuty detector associated with the publishing destination.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Describes a tag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublishingDestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::GuardDuty::PublishingDestination.

        :param str resource_name: The name of the resource.
        :param PublishingDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublishingDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_properties: Optional[pulumi.Input[Union['PublishingDestinationCfnDestinationPropertiesArgs', 'PublishingDestinationCfnDestinationPropertiesArgsDict']]] = None,
                 destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 detector_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublishingDestinationArgs.__new__(PublishingDestinationArgs)

            if destination_properties is None and not opts.urn:
                raise TypeError("Missing required property 'destination_properties'")
            __props__.__dict__["destination_properties"] = destination_properties
            if destination_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_type'")
            __props__.__dict__["destination_type"] = destination_type
            if detector_id is None and not opts.urn:
                raise TypeError("Missing required property 'detector_id'")
            __props__.__dict__["detector_id"] = detector_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["publishing_failure_start_timestamp"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["detectorId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PublishingDestination, __self__).__init__(
            'aws-native:guardduty:PublishingDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PublishingDestination':
        """
        Get an existing PublishingDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PublishingDestinationArgs.__new__(PublishingDestinationArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["destination_properties"] = None
        __props__.__dict__["destination_type"] = None
        __props__.__dict__["detector_id"] = None
        __props__.__dict__["publishing_failure_start_timestamp"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return PublishingDestination(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the publishing destination.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="destinationProperties")
    def destination_properties(self) -> pulumi.Output['outputs.PublishingDestinationCfnDestinationProperties']:
        """
        Contains the Amazon Resource Name (ARN) of the resource to publish to, such as an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
        """
        return pulumi.get(self, "destination_properties")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
        """
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the GuardDuty detector associated with the publishing destination.
        """
        return pulumi.get(self, "detector_id")

    @property
    @pulumi.getter(name="publishingFailureStartTimestamp")
    def publishing_failure_start_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The time, in epoch millisecond format, at which GuardDuty was first unable to publish findings to the destination.
        """
        return pulumi.get(self, "publishing_failure_start_timestamp")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the publishing destination.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Describes a tag.
        """
        return pulumi.get(self, "tags")

