# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MemberArgs', 'Member']

@pulumi.input_type
class MemberArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[builtins.str],
                 detector_id: Optional[pulumi.Input[builtins.str]] = None,
                 disable_email_notification: Optional[pulumi.Input[builtins.bool]] = None,
                 member_id: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Member resource.
        :param pulumi.Input[builtins.str] email: The email address associated with the member account.
        :param pulumi.Input[builtins.str] detector_id: The ID of the detector associated with the GuardDuty service to add the member to.
        :param pulumi.Input[builtins.bool] disable_email_notification: Specifies whether or not to disable email notification for the member account that you invite.
        :param pulumi.Input[builtins.str] member_id: The AWS account ID of the account to designate as a member.
        :param pulumi.Input[builtins.str] message: The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.
        :param pulumi.Input[builtins.str] status: You can use the `Status` property to update the status of the relationship between the member account and its administrator account. Valid values are `Created` and `Invited` when using an `AWS::GuardDuty::Member` resource. If the value for this property is not provided or set to `Created` , a member account is created but not invited. If the value of this property is set to `Invited` , a member account is created and invited.
        """
        pulumi.set(__self__, "email", email)
        if detector_id is not None:
            pulumi.set(__self__, "detector_id", detector_id)
        if disable_email_notification is not None:
            pulumi.set(__self__, "disable_email_notification", disable_email_notification)
        if member_id is not None:
            pulumi.set(__self__, "member_id", member_id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        The email address associated with the member account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the detector associated with the GuardDuty service to add the member to.
        """
        return pulumi.get(self, "detector_id")

    @detector_id.setter
    def detector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "detector_id", value)

    @property
    @pulumi.getter(name="disableEmailNotification")
    def disable_email_notification(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether or not to disable email notification for the member account that you invite.
        """
        return pulumi.get(self, "disable_email_notification")

    @disable_email_notification.setter
    def disable_email_notification(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_email_notification", value)

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account ID of the account to designate as a member.
        """
        return pulumi.get(self, "member_id")

    @member_id.setter
    def member_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "member_id", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        You can use the `Status` property to update the status of the relationship between the member account and its administrator account. Valid values are `Created` and `Invited` when using an `AWS::GuardDuty::Member` resource. If the value for this property is not provided or set to `Created` , a member account is created but not invited. If the value of this property is set to `Invited` , a member account is created and invited.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("aws-native:guardduty:Member")
class Member(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 detector_id: Optional[pulumi.Input[builtins.str]] = None,
                 disable_email_notification: Optional[pulumi.Input[builtins.bool]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 member_id: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::GuardDuty::Member

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] detector_id: The ID of the detector associated with the GuardDuty service to add the member to.
        :param pulumi.Input[builtins.bool] disable_email_notification: Specifies whether or not to disable email notification for the member account that you invite.
        :param pulumi.Input[builtins.str] email: The email address associated with the member account.
        :param pulumi.Input[builtins.str] member_id: The AWS account ID of the account to designate as a member.
        :param pulumi.Input[builtins.str] message: The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.
        :param pulumi.Input[builtins.str] status: You can use the `Status` property to update the status of the relationship between the member account and its administrator account. Valid values are `Created` and `Invited` when using an `AWS::GuardDuty::Member` resource. If the value for this property is not provided or set to `Created` , a member account is created but not invited. If the value of this property is set to `Invited` , a member account is created and invited.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::GuardDuty::Member

        :param str resource_name: The name of the resource.
        :param MemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 detector_id: Optional[pulumi.Input[builtins.str]] = None,
                 disable_email_notification: Optional[pulumi.Input[builtins.bool]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 member_id: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MemberArgs.__new__(MemberArgs)

            __props__.__dict__["detector_id"] = detector_id
            __props__.__dict__["disable_email_notification"] = disable_email_notification
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["member_id"] = member_id
            __props__.__dict__["message"] = message
            __props__.__dict__["status"] = status
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["detectorId", "memberId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Member, __self__).__init__(
            'aws-native:guardduty:Member',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Member':
        """
        Get an existing Member resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MemberArgs.__new__(MemberArgs)

        __props__.__dict__["detector_id"] = None
        __props__.__dict__["disable_email_notification"] = None
        __props__.__dict__["email"] = None
        __props__.__dict__["member_id"] = None
        __props__.__dict__["message"] = None
        __props__.__dict__["status"] = None
        return Member(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the detector associated with the GuardDuty service to add the member to.
        """
        return pulumi.get(self, "detector_id")

    @property
    @pulumi.getter(name="disableEmailNotification")
    def disable_email_notification(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether or not to disable email notification for the member account that you invite.
        """
        return pulumi.get(self, "disable_email_notification")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The email address associated with the member account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS account ID of the account to designate as a member.
        """
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        You can use the `Status` property to update the status of the relationship between the member account and its administrator account. Valid values are `Created` and `Invited` when using an `AWS::GuardDuty::Member` resource. If the value for this property is not provided or set to `Created` , a member account is created but not invited. If the value of this property is set to `Invited` , a member account is created and invited.
        """
        return pulumi.get(self, "status")

