# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['MalwareProtectionPlanArgs', 'MalwareProtectionPlan']

@pulumi.input_type
class MalwareProtectionPlanArgs:
    def __init__(__self__, *,
                 protected_resource: pulumi.Input['MalwareProtectionPlanCfnProtectedResourceArgs'],
                 role: pulumi.Input[builtins.str],
                 actions: Optional[pulumi.Input['MalwareProtectionPlanCfnActionsArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a MalwareProtectionPlan resource.
        :param pulumi.Input['MalwareProtectionPlanCfnProtectedResourceArgs'] protected_resource: Information about the protected resource. Presently, S3Bucket is the only supported protected resource.
        :param pulumi.Input[builtins.str] role: IAM role that includes the permissions required to scan and (optionally) add tags to the associated protected resource.
        :param pulumi.Input['MalwareProtectionPlanCfnActionsArgs'] actions: Specifies the action that is to be applied to the Malware Protection plan resource.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to be added to the created Malware Protection plan resource. Each tag consists of a key and an optional value, both of which you need to specify.
        """
        pulumi.set(__self__, "protected_resource", protected_resource)
        pulumi.set(__self__, "role", role)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="protectedResource")
    def protected_resource(self) -> pulumi.Input['MalwareProtectionPlanCfnProtectedResourceArgs']:
        """
        Information about the protected resource. Presently, S3Bucket is the only supported protected resource.
        """
        return pulumi.get(self, "protected_resource")

    @protected_resource.setter
    def protected_resource(self, value: pulumi.Input['MalwareProtectionPlanCfnProtectedResourceArgs']):
        pulumi.set(self, "protected_resource", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[builtins.str]:
        """
        IAM role that includes the permissions required to scan and (optionally) add tags to the associated protected resource.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['MalwareProtectionPlanCfnActionsArgs']]:
        """
        Specifies the action that is to be applied to the Malware Protection plan resource.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['MalwareProtectionPlanCfnActionsArgs']]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to be added to the created Malware Protection plan resource. Each tag consists of a key and an optional value, both of which you need to specify.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:guardduty:MalwareProtectionPlan")
class MalwareProtectionPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Union['MalwareProtectionPlanCfnActionsArgs', 'MalwareProtectionPlanCfnActionsArgsDict']]] = None,
                 protected_resource: Optional[pulumi.Input[Union['MalwareProtectionPlanCfnProtectedResourceArgs', 'MalwareProtectionPlanCfnProtectedResourceArgsDict']]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::GuardDuty::MalwareProtectionPlan

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MalwareProtectionPlanCfnActionsArgs', 'MalwareProtectionPlanCfnActionsArgsDict']] actions: Specifies the action that is to be applied to the Malware Protection plan resource.
        :param pulumi.Input[Union['MalwareProtectionPlanCfnProtectedResourceArgs', 'MalwareProtectionPlanCfnProtectedResourceArgsDict']] protected_resource: Information about the protected resource. Presently, S3Bucket is the only supported protected resource.
        :param pulumi.Input[builtins.str] role: IAM role that includes the permissions required to scan and (optionally) add tags to the associated protected resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to be added to the created Malware Protection plan resource. Each tag consists of a key and an optional value, both of which you need to specify.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MalwareProtectionPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::GuardDuty::MalwareProtectionPlan

        :param str resource_name: The name of the resource.
        :param MalwareProtectionPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MalwareProtectionPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Union['MalwareProtectionPlanCfnActionsArgs', 'MalwareProtectionPlanCfnActionsArgsDict']]] = None,
                 protected_resource: Optional[pulumi.Input[Union['MalwareProtectionPlanCfnProtectedResourceArgs', 'MalwareProtectionPlanCfnProtectedResourceArgsDict']]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MalwareProtectionPlanArgs.__new__(MalwareProtectionPlanArgs)

            __props__.__dict__["actions"] = actions
            if protected_resource is None and not opts.urn:
                raise TypeError("Missing required property 'protected_resource'")
            __props__.__dict__["protected_resource"] = protected_resource
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["malware_protection_plan_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reasons"] = None
        super(MalwareProtectionPlan, __self__).__init__(
            'aws-native:guardduty:MalwareProtectionPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MalwareProtectionPlan':
        """
        Get an existing MalwareProtectionPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MalwareProtectionPlanArgs.__new__(MalwareProtectionPlanArgs)

        __props__.__dict__["actions"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["malware_protection_plan_id"] = None
        __props__.__dict__["protected_resource"] = None
        __props__.__dict__["role"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["status_reasons"] = None
        __props__.__dict__["tags"] = None
        return MalwareProtectionPlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Optional['outputs.MalwareProtectionPlanCfnActions']]:
        """
        Specifies the action that is to be applied to the Malware Protection plan resource.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the protected resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the Malware Protection plan resource was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="malwareProtectionPlanId")
    def malware_protection_plan_id(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier associated with Malware Protection plan resource.
        """
        return pulumi.get(self, "malware_protection_plan_id")

    @property
    @pulumi.getter(name="protectedResource")
    def protected_resource(self) -> pulumi.Output['outputs.MalwareProtectionPlanCfnProtectedResource']:
        """
        Information about the protected resource. Presently, S3Bucket is the only supported protected resource.
        """
        return pulumi.get(self, "protected_resource")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        IAM role that includes the permissions required to scan and (optionally) add tags to the associated protected resource.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the Malware Protection plan resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReasons")
    def status_reasons(self) -> pulumi.Output[Sequence['outputs.MalwareProtectionPlanCfnStatusReasons']]:
        """
        Status details associated with the Malware Protection plan resource status.
        """
        return pulumi.get(self, "status_reasons")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to be added to the created Malware Protection plan resource. Each tag consists of a key and an optional value, both of which you need to specify.
        """
        return pulumi.get(self, "tags")

