# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DetectorArgs', 'Detector']

@pulumi.input_type
class DetectorArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[builtins.bool],
                 data_sources: Optional[pulumi.Input['DetectorCfnDataSourceConfigurationsArgs']] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureConfigurationArgs']]]] = None,
                 finding_publishing_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Detector resource.
        :param pulumi.Input[builtins.bool] enable: Specifies whether the detector is to be enabled on creation.
        :param pulumi.Input['DetectorCfnDataSourceConfigurationsArgs'] data_sources: Describes which data sources will be enabled for the detector.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureConfigurationArgs']]] features: A list of features that will be configured for the detector.
        :param pulumi.Input[builtins.str] finding_publishing_frequency: Specifies how frequently updated findings are exported.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Specifies tags added to a new detector resource. Each tag consists of a key and an optional value, both of which you define.
               
               Currently, support is available only for creating and deleting a tag. No support exists for updating the tags.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        pulumi.set(__self__, "enable", enable)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if finding_publishing_frequency is not None:
            pulumi.set(__self__, "finding_publishing_frequency", finding_publishing_frequency)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether the detector is to be enabled on creation.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input['DetectorCfnDataSourceConfigurationsArgs']]:
        """
        Describes which data sources will be enabled for the detector.
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input['DetectorCfnDataSourceConfigurationsArgs']]):
        pulumi.set(self, "data_sources", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureConfigurationArgs']]]]:
        """
        A list of features that will be configured for the detector.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureConfigurationArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="findingPublishingFrequency")
    def finding_publishing_frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how frequently updated findings are exported.
        """
        return pulumi.get(self, "finding_publishing_frequency")

    @finding_publishing_frequency.setter
    def finding_publishing_frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "finding_publishing_frequency", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Specifies tags added to a new detector resource. Each tag consists of a key and an optional value, both of which you define.

        Currently, support is available only for creating and deleting a tag. No support exists for updating the tags.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:guardduty:Detector")
class Detector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_sources: Optional[pulumi.Input[Union['DetectorCfnDataSourceConfigurationsArgs', 'DetectorCfnDataSourceConfigurationsArgsDict']]] = None,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorCfnFeatureConfigurationArgs', 'DetectorCfnFeatureConfigurationArgsDict']]]]] = None,
                 finding_publishing_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::GuardDuty::Detector

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DetectorCfnDataSourceConfigurationsArgs', 'DetectorCfnDataSourceConfigurationsArgsDict']] data_sources: Describes which data sources will be enabled for the detector.
        :param pulumi.Input[builtins.bool] enable: Specifies whether the detector is to be enabled on creation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DetectorCfnFeatureConfigurationArgs', 'DetectorCfnFeatureConfigurationArgsDict']]]] features: A list of features that will be configured for the detector.
        :param pulumi.Input[builtins.str] finding_publishing_frequency: Specifies how frequently updated findings are exported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Specifies tags added to a new detector resource. Each tag consists of a key and an optional value, both of which you define.
               
               Currently, support is available only for creating and deleting a tag. No support exists for updating the tags.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DetectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::GuardDuty::Detector

        :param str resource_name: The name of the resource.
        :param DetectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DetectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_sources: Optional[pulumi.Input[Union['DetectorCfnDataSourceConfigurationsArgs', 'DetectorCfnDataSourceConfigurationsArgsDict']]] = None,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorCfnFeatureConfigurationArgs', 'DetectorCfnFeatureConfigurationArgsDict']]]]] = None,
                 finding_publishing_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DetectorArgs.__new__(DetectorArgs)

            __props__.__dict__["data_sources"] = data_sources
            if enable is None and not opts.urn:
                raise TypeError("Missing required property 'enable'")
            __props__.__dict__["enable"] = enable
            __props__.__dict__["features"] = features
            __props__.__dict__["finding_publishing_frequency"] = finding_publishing_frequency
            __props__.__dict__["tags"] = tags
            __props__.__dict__["aws_id"] = None
        super(Detector, __self__).__init__(
            'aws-native:guardduty:Detector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Detector':
        """
        Get an existing Detector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DetectorArgs.__new__(DetectorArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["data_sources"] = None
        __props__.__dict__["enable"] = None
        __props__.__dict__["features"] = None
        __props__.__dict__["finding_publishing_frequency"] = None
        __props__.__dict__["tags"] = None
        return Detector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique ID of the detector.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> pulumi.Output[Optional['outputs.DetectorCfnDataSourceConfigurations']]:
        """
        Describes which data sources will be enabled for the detector.
        """
        return pulumi.get(self, "data_sources")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the detector is to be enabled on creation.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def features(self) -> pulumi.Output[Optional[Sequence['outputs.DetectorCfnFeatureConfiguration']]]:
        """
        A list of features that will be configured for the detector.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="findingPublishingFrequency")
    def finding_publishing_frequency(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies how frequently updated findings are exported.
        """
        return pulumi.get(self, "finding_publishing_frequency")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Specifies tags added to a new detector resource. Each tag consists of a key and an optional value, both of which you define.

        Currently, support is available only for creating and deleting a tag. No support exists for updating the tags.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")

