# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConfigAntennaDownlinkConfig',
    'ConfigAntennaDownlinkDemodDecodeConfig',
    'ConfigAntennaUplinkConfig',
    'ConfigData',
    'ConfigDataflowEndpointConfig',
    'ConfigDecodeConfig',
    'ConfigDemodulationConfig',
    'ConfigEirp',
    'ConfigFrequency',
    'ConfigFrequencyBandwidth',
    'ConfigS3RecordingConfig',
    'ConfigSpectrumConfig',
    'ConfigTrackingConfig',
    'ConfigUplinkEchoConfig',
    'ConfigUplinkSpectrumConfig',
    'DataflowEndpointGroupAwsGroundStationAgentEndpoint',
    'DataflowEndpointGroupConnectionDetails',
    'DataflowEndpointGroupDataflowEndpoint',
    'DataflowEndpointGroupEndpointDetails',
    'DataflowEndpointGroupIntegerRange',
    'DataflowEndpointGroupRangedConnectionDetails',
    'DataflowEndpointGroupRangedSocketAddress',
    'DataflowEndpointGroupSecurityDetails',
    'DataflowEndpointGroupSocketAddress',
    'MissionProfileDataflowEdge',
    'MissionProfileStreamsKmsKey',
]

@pulumi.output_type
class ConfigAntennaDownlinkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spectrumConfig":
            suggest = "spectrum_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigAntennaDownlinkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigAntennaDownlinkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigAntennaDownlinkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spectrum_config: Optional['outputs.ConfigSpectrumConfig'] = None):
        """
        :param 'ConfigSpectrumConfig' spectrum_config: Defines the spectrum configuration.
        """
        if spectrum_config is not None:
            pulumi.set(__self__, "spectrum_config", spectrum_config)

    @property
    @pulumi.getter(name="spectrumConfig")
    def spectrum_config(self) -> Optional['outputs.ConfigSpectrumConfig']:
        """
        Defines the spectrum configuration.
        """
        return pulumi.get(self, "spectrum_config")


@pulumi.output_type
class ConfigAntennaDownlinkDemodDecodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "decodeConfig":
            suggest = "decode_config"
        elif key == "demodulationConfig":
            suggest = "demodulation_config"
        elif key == "spectrumConfig":
            suggest = "spectrum_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigAntennaDownlinkDemodDecodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigAntennaDownlinkDemodDecodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigAntennaDownlinkDemodDecodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 decode_config: Optional['outputs.ConfigDecodeConfig'] = None,
                 demodulation_config: Optional['outputs.ConfigDemodulationConfig'] = None,
                 spectrum_config: Optional['outputs.ConfigSpectrumConfig'] = None):
        """
        :param 'ConfigDecodeConfig' decode_config: Defines how the RF signal will be decoded.
        :param 'ConfigDemodulationConfig' demodulation_config: Defines how the RF signal will be demodulated.
        :param 'ConfigSpectrumConfig' spectrum_config: Defines the spectrum configuration.
        """
        if decode_config is not None:
            pulumi.set(__self__, "decode_config", decode_config)
        if demodulation_config is not None:
            pulumi.set(__self__, "demodulation_config", demodulation_config)
        if spectrum_config is not None:
            pulumi.set(__self__, "spectrum_config", spectrum_config)

    @property
    @pulumi.getter(name="decodeConfig")
    def decode_config(self) -> Optional['outputs.ConfigDecodeConfig']:
        """
        Defines how the RF signal will be decoded.
        """
        return pulumi.get(self, "decode_config")

    @property
    @pulumi.getter(name="demodulationConfig")
    def demodulation_config(self) -> Optional['outputs.ConfigDemodulationConfig']:
        """
        Defines how the RF signal will be demodulated.
        """
        return pulumi.get(self, "demodulation_config")

    @property
    @pulumi.getter(name="spectrumConfig")
    def spectrum_config(self) -> Optional['outputs.ConfigSpectrumConfig']:
        """
        Defines the spectrum configuration.
        """
        return pulumi.get(self, "spectrum_config")


@pulumi.output_type
class ConfigAntennaUplinkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spectrumConfig":
            suggest = "spectrum_config"
        elif key == "targetEirp":
            suggest = "target_eirp"
        elif key == "transmitDisabled":
            suggest = "transmit_disabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigAntennaUplinkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigAntennaUplinkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigAntennaUplinkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spectrum_config: Optional['outputs.ConfigUplinkSpectrumConfig'] = None,
                 target_eirp: Optional['outputs.ConfigEirp'] = None,
                 transmit_disabled: Optional[builtins.bool] = None):
        """
        :param 'ConfigUplinkSpectrumConfig' spectrum_config: Defines the spectrum configuration.
        :param 'ConfigEirp' target_eirp: The equivalent isotropically radiated power (EIRP) to use for uplink transmissions. Valid values are between 20.0 to 50.0 dBW.
        :param builtins.bool transmit_disabled: Whether or not uplink transmit is disabled.
        """
        if spectrum_config is not None:
            pulumi.set(__self__, "spectrum_config", spectrum_config)
        if target_eirp is not None:
            pulumi.set(__self__, "target_eirp", target_eirp)
        if transmit_disabled is not None:
            pulumi.set(__self__, "transmit_disabled", transmit_disabled)

    @property
    @pulumi.getter(name="spectrumConfig")
    def spectrum_config(self) -> Optional['outputs.ConfigUplinkSpectrumConfig']:
        """
        Defines the spectrum configuration.
        """
        return pulumi.get(self, "spectrum_config")

    @property
    @pulumi.getter(name="targetEirp")
    def target_eirp(self) -> Optional['outputs.ConfigEirp']:
        """
        The equivalent isotropically radiated power (EIRP) to use for uplink transmissions. Valid values are between 20.0 to 50.0 dBW.
        """
        return pulumi.get(self, "target_eirp")

    @property
    @pulumi.getter(name="transmitDisabled")
    def transmit_disabled(self) -> Optional[builtins.bool]:
        """
        Whether or not uplink transmit is disabled.
        """
        return pulumi.get(self, "transmit_disabled")


@pulumi.output_type
class ConfigData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "antennaDownlinkConfig":
            suggest = "antenna_downlink_config"
        elif key == "antennaDownlinkDemodDecodeConfig":
            suggest = "antenna_downlink_demod_decode_config"
        elif key == "antennaUplinkConfig":
            suggest = "antenna_uplink_config"
        elif key == "dataflowEndpointConfig":
            suggest = "dataflow_endpoint_config"
        elif key == "s3RecordingConfig":
            suggest = "s3_recording_config"
        elif key == "trackingConfig":
            suggest = "tracking_config"
        elif key == "uplinkEchoConfig":
            suggest = "uplink_echo_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 antenna_downlink_config: Optional['outputs.ConfigAntennaDownlinkConfig'] = None,
                 antenna_downlink_demod_decode_config: Optional['outputs.ConfigAntennaDownlinkDemodDecodeConfig'] = None,
                 antenna_uplink_config: Optional['outputs.ConfigAntennaUplinkConfig'] = None,
                 dataflow_endpoint_config: Optional['outputs.ConfigDataflowEndpointConfig'] = None,
                 s3_recording_config: Optional['outputs.ConfigS3RecordingConfig'] = None,
                 tracking_config: Optional['outputs.ConfigTrackingConfig'] = None,
                 uplink_echo_config: Optional['outputs.ConfigUplinkEchoConfig'] = None):
        """
        :param 'ConfigAntennaDownlinkConfig' antenna_downlink_config: Provides information for an antenna downlink config object. Antenna downlink config objects are used to provide parameters for downlinks where no demodulation or decoding is performed by Ground Station (RF over IP downlinks).
        :param 'ConfigAntennaDownlinkDemodDecodeConfig' antenna_downlink_demod_decode_config: Provides information for a downlink demod decode config object. Downlink demod decode config objects are used to provide parameters for downlinks where the Ground Station service will demodulate and decode the downlinked data.
        :param 'ConfigAntennaUplinkConfig' antenna_uplink_config: Provides information for an uplink config object. Uplink config objects are used to provide parameters for uplink contacts.
        :param 'ConfigDataflowEndpointConfig' dataflow_endpoint_config: Provides information for a dataflow endpoint config object. Dataflow endpoint config objects are used to provide parameters about which IP endpoint(s) to use during a contact. Dataflow endpoints are where Ground Station sends data during a downlink contact and where Ground Station receives data to send to the satellite during an uplink contact.
        :param 'ConfigS3RecordingConfig' s3_recording_config: Provides information for an S3 recording config object. S3 recording config objects are used to provide parameters for S3 recording during downlink contacts.
        :param 'ConfigTrackingConfig' tracking_config: Provides information for a tracking config object. Tracking config objects are used to provide parameters about how to track the satellite through the sky during a contact.
        :param 'ConfigUplinkEchoConfig' uplink_echo_config: Provides information for an uplink echo config object. Uplink echo config objects are used to provide parameters for uplink echo during uplink contacts.
        """
        if antenna_downlink_config is not None:
            pulumi.set(__self__, "antenna_downlink_config", antenna_downlink_config)
        if antenna_downlink_demod_decode_config is not None:
            pulumi.set(__self__, "antenna_downlink_demod_decode_config", antenna_downlink_demod_decode_config)
        if antenna_uplink_config is not None:
            pulumi.set(__self__, "antenna_uplink_config", antenna_uplink_config)
        if dataflow_endpoint_config is not None:
            pulumi.set(__self__, "dataflow_endpoint_config", dataflow_endpoint_config)
        if s3_recording_config is not None:
            pulumi.set(__self__, "s3_recording_config", s3_recording_config)
        if tracking_config is not None:
            pulumi.set(__self__, "tracking_config", tracking_config)
        if uplink_echo_config is not None:
            pulumi.set(__self__, "uplink_echo_config", uplink_echo_config)

    @property
    @pulumi.getter(name="antennaDownlinkConfig")
    def antenna_downlink_config(self) -> Optional['outputs.ConfigAntennaDownlinkConfig']:
        """
        Provides information for an antenna downlink config object. Antenna downlink config objects are used to provide parameters for downlinks where no demodulation or decoding is performed by Ground Station (RF over IP downlinks).
        """
        return pulumi.get(self, "antenna_downlink_config")

    @property
    @pulumi.getter(name="antennaDownlinkDemodDecodeConfig")
    def antenna_downlink_demod_decode_config(self) -> Optional['outputs.ConfigAntennaDownlinkDemodDecodeConfig']:
        """
        Provides information for a downlink demod decode config object. Downlink demod decode config objects are used to provide parameters for downlinks where the Ground Station service will demodulate and decode the downlinked data.
        """
        return pulumi.get(self, "antenna_downlink_demod_decode_config")

    @property
    @pulumi.getter(name="antennaUplinkConfig")
    def antenna_uplink_config(self) -> Optional['outputs.ConfigAntennaUplinkConfig']:
        """
        Provides information for an uplink config object. Uplink config objects are used to provide parameters for uplink contacts.
        """
        return pulumi.get(self, "antenna_uplink_config")

    @property
    @pulumi.getter(name="dataflowEndpointConfig")
    def dataflow_endpoint_config(self) -> Optional['outputs.ConfigDataflowEndpointConfig']:
        """
        Provides information for a dataflow endpoint config object. Dataflow endpoint config objects are used to provide parameters about which IP endpoint(s) to use during a contact. Dataflow endpoints are where Ground Station sends data during a downlink contact and where Ground Station receives data to send to the satellite during an uplink contact.
        """
        return pulumi.get(self, "dataflow_endpoint_config")

    @property
    @pulumi.getter(name="s3RecordingConfig")
    def s3_recording_config(self) -> Optional['outputs.ConfigS3RecordingConfig']:
        """
        Provides information for an S3 recording config object. S3 recording config objects are used to provide parameters for S3 recording during downlink contacts.
        """
        return pulumi.get(self, "s3_recording_config")

    @property
    @pulumi.getter(name="trackingConfig")
    def tracking_config(self) -> Optional['outputs.ConfigTrackingConfig']:
        """
        Provides information for a tracking config object. Tracking config objects are used to provide parameters about how to track the satellite through the sky during a contact.
        """
        return pulumi.get(self, "tracking_config")

    @property
    @pulumi.getter(name="uplinkEchoConfig")
    def uplink_echo_config(self) -> Optional['outputs.ConfigUplinkEchoConfig']:
        """
        Provides information for an uplink echo config object. Uplink echo config objects are used to provide parameters for uplink echo during uplink contacts.
        """
        return pulumi.get(self, "uplink_echo_config")


@pulumi.output_type
class ConfigDataflowEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataflowEndpointName":
            suggest = "dataflow_endpoint_name"
        elif key == "dataflowEndpointRegion":
            suggest = "dataflow_endpoint_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigDataflowEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigDataflowEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigDataflowEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataflow_endpoint_name: Optional[builtins.str] = None,
                 dataflow_endpoint_region: Optional[builtins.str] = None):
        """
        :param builtins.str dataflow_endpoint_name: The name of the dataflow endpoint to use during contacts.
        :param builtins.str dataflow_endpoint_region: The region of the dataflow endpoint to use during contacts. When omitted, Ground Station will use the region of the contact.
        """
        if dataflow_endpoint_name is not None:
            pulumi.set(__self__, "dataflow_endpoint_name", dataflow_endpoint_name)
        if dataflow_endpoint_region is not None:
            pulumi.set(__self__, "dataflow_endpoint_region", dataflow_endpoint_region)

    @property
    @pulumi.getter(name="dataflowEndpointName")
    def dataflow_endpoint_name(self) -> Optional[builtins.str]:
        """
        The name of the dataflow endpoint to use during contacts.
        """
        return pulumi.get(self, "dataflow_endpoint_name")

    @property
    @pulumi.getter(name="dataflowEndpointRegion")
    def dataflow_endpoint_region(self) -> Optional[builtins.str]:
        """
        The region of the dataflow endpoint to use during contacts. When omitted, Ground Station will use the region of the contact.
        """
        return pulumi.get(self, "dataflow_endpoint_region")


@pulumi.output_type
class ConfigDecodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unvalidatedJson":
            suggest = "unvalidated_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigDecodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigDecodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigDecodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unvalidated_json: Optional[builtins.str] = None):
        """
        :param builtins.str unvalidated_json: The decoding settings are in JSON format and define a set of steps to perform to decode the data.
        """
        if unvalidated_json is not None:
            pulumi.set(__self__, "unvalidated_json", unvalidated_json)

    @property
    @pulumi.getter(name="unvalidatedJson")
    def unvalidated_json(self) -> Optional[builtins.str]:
        """
        The decoding settings are in JSON format and define a set of steps to perform to decode the data.
        """
        return pulumi.get(self, "unvalidated_json")


@pulumi.output_type
class ConfigDemodulationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unvalidatedJson":
            suggest = "unvalidated_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigDemodulationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigDemodulationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigDemodulationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unvalidated_json: Optional[builtins.str] = None):
        """
        :param builtins.str unvalidated_json: The demodulation settings are in JSON format and define parameters for demodulation, for example which modulation scheme (e.g. PSK, QPSK, etc.) and matched filter to use.
        """
        if unvalidated_json is not None:
            pulumi.set(__self__, "unvalidated_json", unvalidated_json)

    @property
    @pulumi.getter(name="unvalidatedJson")
    def unvalidated_json(self) -> Optional[builtins.str]:
        """
        The demodulation settings are in JSON format and define parameters for demodulation, for example which modulation scheme (e.g. PSK, QPSK, etc.) and matched filter to use.
        """
        return pulumi.get(self, "unvalidated_json")


@pulumi.output_type
class ConfigEirp(dict):
    def __init__(__self__, *,
                 units: Optional['ConfigEirpUnits'] = None,
                 value: Optional[builtins.float] = None):
        """
        :param 'ConfigEirpUnits' units: The units of the EIRP.
        :param builtins.float value: The value of the EIRP. Valid values are between 20.0 to 50.0 dBW.
        """
        if units is not None:
            pulumi.set(__self__, "units", units)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def units(self) -> Optional['ConfigEirpUnits']:
        """
        The units of the EIRP.
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.float]:
        """
        The value of the EIRP. Valid values are between 20.0 to 50.0 dBW.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConfigFrequency(dict):
    def __init__(__self__, *,
                 units: Optional['ConfigFrequencyUnits'] = None,
                 value: Optional[builtins.float] = None):
        """
        :param 'ConfigFrequencyUnits' units: The units of the frequency.
        :param builtins.float value: The value of the frequency. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        if units is not None:
            pulumi.set(__self__, "units", units)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def units(self) -> Optional['ConfigFrequencyUnits']:
        """
        The units of the frequency.
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.float]:
        """
        The value of the frequency. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConfigFrequencyBandwidth(dict):
    def __init__(__self__, *,
                 units: Optional['ConfigBandwidthUnits'] = None,
                 value: Optional[builtins.float] = None):
        """
        :param 'ConfigBandwidthUnits' units: The units of the bandwidth.
        :param builtins.float value: The value of the bandwidth. AWS Ground Station currently has the following bandwidth limitations: 
               
               - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
               - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
               - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        """
        if units is not None:
            pulumi.set(__self__, "units", units)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def units(self) -> Optional['ConfigBandwidthUnits']:
        """
        The units of the bandwidth.
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.float]:
        """
        The value of the bandwidth. AWS Ground Station currently has the following bandwidth limitations: 

        - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
        - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
        - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConfigS3RecordingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigS3RecordingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigS3RecordingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigS3RecordingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_arn: S3 Bucket where the data is written. The name of the S3 Bucket provided must begin with `aws-groundstation` .
        :param builtins.str prefix: The prefix of the S3 data object. If you choose to use any optional keys for substitution, these values will be replaced with the corresponding information from your contact details. For example, a prefix of `{satellite_id}/{year}/{month}/{day}/` will replaced with `fake_satellite_id/2021/01/10/`
               
               *Optional keys for substitution* : `{satellite_id}` | `{config-name}` | `{config-id}` | `{year}` | `{month}` | `{day}`
        :param builtins.str role_arn: Defines the ARN of the role assumed for putting archives to S3.
        """
        if bucket_arn is not None:
            pulumi.set(__self__, "bucket_arn", bucket_arn)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> Optional[builtins.str]:
        """
        S3 Bucket where the data is written. The name of the S3 Bucket provided must begin with `aws-groundstation` .
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The prefix of the S3 data object. If you choose to use any optional keys for substitution, these values will be replaced with the corresponding information from your contact details. For example, a prefix of `{satellite_id}/{year}/{month}/{day}/` will replaced with `fake_satellite_id/2021/01/10/`

        *Optional keys for substitution* : `{satellite_id}` | `{config-name}` | `{config-id}` | `{year}` | `{month}` | `{day}`
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Defines the ARN of the role assumed for putting archives to S3.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class ConfigSpectrumConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "centerFrequency":
            suggest = "center_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigSpectrumConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigSpectrumConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigSpectrumConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth: Optional['outputs.ConfigFrequencyBandwidth'] = None,
                 center_frequency: Optional['outputs.ConfigFrequency'] = None,
                 polarization: Optional['ConfigPolarization'] = None):
        """
        :param 'ConfigFrequencyBandwidth' bandwidth: The bandwidth of the spectrum. AWS Ground Station currently has the following bandwidth limitations: 
               
               - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
               - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
               - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        :param 'ConfigFrequency' center_frequency: The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        :param 'ConfigPolarization' polarization: The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` . Capturing both `"RIGHT_HAND"` and `"LEFT_HAND"` polarization requires two separate configs.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if center_frequency is not None:
            pulumi.set(__self__, "center_frequency", center_frequency)
        if polarization is not None:
            pulumi.set(__self__, "polarization", polarization)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional['outputs.ConfigFrequencyBandwidth']:
        """
        The bandwidth of the spectrum. AWS Ground Station currently has the following bandwidth limitations: 

        - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
        - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
        - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="centerFrequency")
    def center_frequency(self) -> Optional['outputs.ConfigFrequency']:
        """
        The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        return pulumi.get(self, "center_frequency")

    @property
    @pulumi.getter
    def polarization(self) -> Optional['ConfigPolarization']:
        """
        The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` . Capturing both `"RIGHT_HAND"` and `"LEFT_HAND"` polarization requires two separate configs.
        """
        return pulumi.get(self, "polarization")


@pulumi.output_type
class ConfigTrackingConfig(dict):
    def __init__(__self__, *,
                 autotrack: Optional['ConfigTrackingConfigAutotrack'] = None):
        """
        :param 'ConfigTrackingConfigAutotrack' autotrack: Specifies whether or not to use autotrack. `REMOVED` specifies that program track should only be used during the contact. `PREFERRED` specifies that autotracking is preferred during the contact but fallback to program track if the signal is lost. `REQUIRED` specifies that autotracking is required during the contact and not to use program track if the signal is lost.
        """
        if autotrack is not None:
            pulumi.set(__self__, "autotrack", autotrack)

    @property
    @pulumi.getter
    def autotrack(self) -> Optional['ConfigTrackingConfigAutotrack']:
        """
        Specifies whether or not to use autotrack. `REMOVED` specifies that program track should only be used during the contact. `PREFERRED` specifies that autotracking is preferred during the contact but fallback to program track if the signal is lost. `REQUIRED` specifies that autotracking is required during the contact and not to use program track if the signal is lost.
        """
        return pulumi.get(self, "autotrack")


@pulumi.output_type
class ConfigUplinkEchoConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "antennaUplinkConfigArn":
            suggest = "antenna_uplink_config_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigUplinkEchoConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigUplinkEchoConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigUplinkEchoConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 antenna_uplink_config_arn: Optional[builtins.str] = None,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str antenna_uplink_config_arn: Defines the ARN of the uplink config to echo back to a dataflow endpoint.
        :param builtins.bool enabled: Whether or not uplink echo is enabled.
        """
        if antenna_uplink_config_arn is not None:
            pulumi.set(__self__, "antenna_uplink_config_arn", antenna_uplink_config_arn)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="antennaUplinkConfigArn")
    def antenna_uplink_config_arn(self) -> Optional[builtins.str]:
        """
        Defines the ARN of the uplink config to echo back to a dataflow endpoint.
        """
        return pulumi.get(self, "antenna_uplink_config_arn")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether or not uplink echo is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ConfigUplinkSpectrumConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "centerFrequency":
            suggest = "center_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigUplinkSpectrumConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigUplinkSpectrumConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigUplinkSpectrumConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 center_frequency: Optional['outputs.ConfigFrequency'] = None,
                 polarization: Optional['ConfigPolarization'] = None):
        """
        :param 'ConfigFrequency' center_frequency: The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        :param 'ConfigPolarization' polarization: The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` .
        """
        if center_frequency is not None:
            pulumi.set(__self__, "center_frequency", center_frequency)
        if polarization is not None:
            pulumi.set(__self__, "polarization", polarization)

    @property
    @pulumi.getter(name="centerFrequency")
    def center_frequency(self) -> Optional['outputs.ConfigFrequency']:
        """
        The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        return pulumi.get(self, "center_frequency")

    @property
    @pulumi.getter
    def polarization(self) -> Optional['ConfigPolarization']:
        """
        The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` .
        """
        return pulumi.get(self, "polarization")


@pulumi.output_type
class DataflowEndpointGroupAwsGroundStationAgentEndpoint(dict):
    """
    Information about AwsGroundStationAgentEndpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentStatus":
            suggest = "agent_status"
        elif key == "auditResults":
            suggest = "audit_results"
        elif key == "egressAddress":
            suggest = "egress_address"
        elif key == "ingressAddress":
            suggest = "ingress_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataflowEndpointGroupAwsGroundStationAgentEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataflowEndpointGroupAwsGroundStationAgentEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataflowEndpointGroupAwsGroundStationAgentEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_status: Optional['DataflowEndpointGroupAgentStatus'] = None,
                 audit_results: Optional['DataflowEndpointGroupAuditResults'] = None,
                 egress_address: Optional['outputs.DataflowEndpointGroupConnectionDetails'] = None,
                 ingress_address: Optional['outputs.DataflowEndpointGroupRangedConnectionDetails'] = None,
                 name: Optional[builtins.str] = None):
        """
        Information about AwsGroundStationAgentEndpoint.
        :param 'DataflowEndpointGroupAgentStatus' agent_status: The status of AgentEndpoint.
        :param 'DataflowEndpointGroupAuditResults' audit_results: The results of the audit.
        :param 'DataflowEndpointGroupConnectionDetails' egress_address: The egress address of AgentEndpoint.
        :param 'DataflowEndpointGroupRangedConnectionDetails' ingress_address: The ingress address of AgentEndpoint.
        :param builtins.str name: Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
        """
        if agent_status is not None:
            pulumi.set(__self__, "agent_status", agent_status)
        if audit_results is not None:
            pulumi.set(__self__, "audit_results", audit_results)
        if egress_address is not None:
            pulumi.set(__self__, "egress_address", egress_address)
        if ingress_address is not None:
            pulumi.set(__self__, "ingress_address", ingress_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="agentStatus")
    def agent_status(self) -> Optional['DataflowEndpointGroupAgentStatus']:
        """
        The status of AgentEndpoint.
        """
        return pulumi.get(self, "agent_status")

    @property
    @pulumi.getter(name="auditResults")
    def audit_results(self) -> Optional['DataflowEndpointGroupAuditResults']:
        """
        The results of the audit.
        """
        return pulumi.get(self, "audit_results")

    @property
    @pulumi.getter(name="egressAddress")
    def egress_address(self) -> Optional['outputs.DataflowEndpointGroupConnectionDetails']:
        """
        The egress address of AgentEndpoint.
        """
        return pulumi.get(self, "egress_address")

    @property
    @pulumi.getter(name="ingressAddress")
    def ingress_address(self) -> Optional['outputs.DataflowEndpointGroupRangedConnectionDetails']:
        """
        The ingress address of AgentEndpoint.
        """
        return pulumi.get(self, "ingress_address")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DataflowEndpointGroupConnectionDetails(dict):
    """
    Egress address of AgentEndpoint with an optional mtu.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "socketAddress":
            suggest = "socket_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataflowEndpointGroupConnectionDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataflowEndpointGroupConnectionDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataflowEndpointGroupConnectionDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mtu: Optional[builtins.int] = None,
                 socket_address: Optional['outputs.DataflowEndpointGroupSocketAddress'] = None):
        """
        Egress address of AgentEndpoint with an optional mtu.
        :param builtins.int mtu: Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        :param 'DataflowEndpointGroupSocketAddress' socket_address: A socket address.
        """
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if socket_address is not None:
            pulumi.set(__self__, "socket_address", socket_address)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[builtins.int]:
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter(name="socketAddress")
    def socket_address(self) -> Optional['outputs.DataflowEndpointGroupSocketAddress']:
        """
        A socket address.
        """
        return pulumi.get(self, "socket_address")


@pulumi.output_type
class DataflowEndpointGroupDataflowEndpoint(dict):
    def __init__(__self__, *,
                 address: Optional['outputs.DataflowEndpointGroupSocketAddress'] = None,
                 mtu: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None):
        """
        :param 'DataflowEndpointGroupSocketAddress' address: The address and port of an endpoint.
        :param builtins.int mtu: Maximum transmission unit (MTU) size in bytes of a dataflow endpoint. Valid values are between 1400 and 1500. A default value of 1500 is used if not set.
        :param builtins.str name: The endpoint name.
               
               When listing available contacts for a satellite, Ground Station searches for a dataflow endpoint whose name matches the value specified by the dataflow endpoint config of the selected mission profile. If no matching dataflow endpoints are found then Ground Station will not display any available contacts for the satellite.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def address(self) -> Optional['outputs.DataflowEndpointGroupSocketAddress']:
        """
        The address and port of an endpoint.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[builtins.int]:
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint. Valid values are between 1400 and 1500. A default value of 1500 is used if not set.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The endpoint name.

        When listing available contacts for a satellite, Ground Station searches for a dataflow endpoint whose name matches the value specified by the dataflow endpoint config of the selected mission profile. If no matching dataflow endpoints are found then Ground Station will not display any available contacts for the satellite.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DataflowEndpointGroupEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsGroundStationAgentEndpoint":
            suggest = "aws_ground_station_agent_endpoint"
        elif key == "securityDetails":
            suggest = "security_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataflowEndpointGroupEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataflowEndpointGroupEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataflowEndpointGroupEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_ground_station_agent_endpoint: Optional['outputs.DataflowEndpointGroupAwsGroundStationAgentEndpoint'] = None,
                 endpoint: Optional['outputs.DataflowEndpointGroupDataflowEndpoint'] = None,
                 security_details: Optional['outputs.DataflowEndpointGroupSecurityDetails'] = None):
        """
        :param 'DataflowEndpointGroupAwsGroundStationAgentEndpoint' aws_ground_station_agent_endpoint: An agent endpoint.
        :param 'DataflowEndpointGroupDataflowEndpoint' endpoint: Information about the endpoint such as name and the endpoint address.
        :param 'DataflowEndpointGroupSecurityDetails' security_details: The role ARN, and IDs for security groups and subnets.
        """
        if aws_ground_station_agent_endpoint is not None:
            pulumi.set(__self__, "aws_ground_station_agent_endpoint", aws_ground_station_agent_endpoint)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if security_details is not None:
            pulumi.set(__self__, "security_details", security_details)

    @property
    @pulumi.getter(name="awsGroundStationAgentEndpoint")
    def aws_ground_station_agent_endpoint(self) -> Optional['outputs.DataflowEndpointGroupAwsGroundStationAgentEndpoint']:
        """
        An agent endpoint.
        """
        return pulumi.get(self, "aws_ground_station_agent_endpoint")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional['outputs.DataflowEndpointGroupDataflowEndpoint']:
        """
        Information about the endpoint such as name and the endpoint address.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="securityDetails")
    def security_details(self) -> Optional['outputs.DataflowEndpointGroupSecurityDetails']:
        """
        The role ARN, and IDs for security groups and subnets.
        """
        return pulumi.get(self, "security_details")


@pulumi.output_type
class DataflowEndpointGroupIntegerRange(dict):
    """
    An integer range that has a minimum and maximum value.
    """
    def __init__(__self__, *,
                 maximum: Optional[builtins.int] = None,
                 minimum: Optional[builtins.int] = None):
        """
        An integer range that has a minimum and maximum value.
        :param builtins.int maximum: A maximum value.
        :param builtins.int minimum: A minimum value.
        """
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def maximum(self) -> Optional[builtins.int]:
        """
        A maximum value.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[builtins.int]:
        """
        A minimum value.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class DataflowEndpointGroupRangedConnectionDetails(dict):
    """
    Ingress address of AgentEndpoint with a port range and an optional mtu.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "socketAddress":
            suggest = "socket_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataflowEndpointGroupRangedConnectionDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataflowEndpointGroupRangedConnectionDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataflowEndpointGroupRangedConnectionDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mtu: Optional[builtins.int] = None,
                 socket_address: Optional['outputs.DataflowEndpointGroupRangedSocketAddress'] = None):
        """
        Ingress address of AgentEndpoint with a port range and an optional mtu.
        :param builtins.int mtu: Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        :param 'DataflowEndpointGroupRangedSocketAddress' socket_address: A ranged socket address.
        """
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if socket_address is not None:
            pulumi.set(__self__, "socket_address", socket_address)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[builtins.int]:
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter(name="socketAddress")
    def socket_address(self) -> Optional['outputs.DataflowEndpointGroupRangedSocketAddress']:
        """
        A ranged socket address.
        """
        return pulumi.get(self, "socket_address")


@pulumi.output_type
class DataflowEndpointGroupRangedSocketAddress(dict):
    """
    A socket address with a port range.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataflowEndpointGroupRangedSocketAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataflowEndpointGroupRangedSocketAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataflowEndpointGroupRangedSocketAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 port_range: Optional['outputs.DataflowEndpointGroupIntegerRange'] = None):
        """
        A socket address with a port range.
        :param builtins.str name: IPv4 socket address.
        :param 'DataflowEndpointGroupIntegerRange' port_range: Port range of a socket address.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        IPv4 socket address.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional['outputs.DataflowEndpointGroupIntegerRange']:
        """
        Port range of a socket address.
        """
        return pulumi.get(self, "port_range")


@pulumi.output_type
class DataflowEndpointGroupSecurityDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataflowEndpointGroupSecurityDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataflowEndpointGroupSecurityDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataflowEndpointGroupSecurityDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: Optional[builtins.str] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str role_arn: The ARN of a role which Ground Station has permission to assume, such as `arn:aws:iam::1234567890:role/DataDeliveryServiceRole` .
               
               Ground Station will assume this role and create an ENI in your VPC on the specified subnet upon creation of a dataflow endpoint group. This ENI is used as the ingress/egress point for data streamed during a satellite contact.
        :param Sequence[builtins.str] security_group_ids: The security group Ids of the security role, such as `sg-1234567890abcdef0` .
        :param Sequence[builtins.str] subnet_ids: The subnet Ids of the security details, such as `subnet-12345678` .
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of a role which Ground Station has permission to assume, such as `arn:aws:iam::1234567890:role/DataDeliveryServiceRole` .

        Ground Station will assume this role and create an ENI in your VPC on the specified subnet upon creation of a dataflow endpoint group. This ENI is used as the ingress/egress point for data streamed during a satellite contact.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The security group Ids of the security role, such as `sg-1234567890abcdef0` .
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The subnet Ids of the security details, such as `subnet-12345678` .
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class DataflowEndpointGroupSocketAddress(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str name: The name of the endpoint, such as `Endpoint 1` .
        :param builtins.int port: The port of the endpoint, such as `55888` .
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the endpoint, such as `Endpoint 1` .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port of the endpoint, such as `55888` .
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class MissionProfileDataflowEdge(dict):
    def __init__(__self__, *,
                 destination: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None):
        """
        :param builtins.str destination: The ARN of the destination for this dataflow edge. For example, specify the ARN of a dataflow endpoint config for a downlink edge or an antenna uplink config for an uplink edge.
        :param builtins.str source: The ARN of the source for this dataflow edge. For example, specify the ARN of an antenna downlink config for a downlink edge or a dataflow endpoint config for an uplink edge.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> Optional[builtins.str]:
        """
        The ARN of the destination for this dataflow edge. For example, specify the ARN of a dataflow endpoint config for a downlink edge or an antenna uplink config for an uplink edge.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        The ARN of the source for this dataflow edge. For example, specify the ARN of an antenna downlink config for a downlink edge or a dataflow endpoint config for an uplink edge.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class MissionProfileStreamsKmsKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsAliasArn":
            suggest = "kms_alias_arn"
        elif key == "kmsAliasName":
            suggest = "kms_alias_name"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MissionProfileStreamsKmsKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MissionProfileStreamsKmsKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MissionProfileStreamsKmsKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_alias_arn: Optional[builtins.str] = None,
                 kms_alias_name: Optional[builtins.str] = None,
                 kms_key_arn: Optional[builtins.str] = None):
        """
        :param builtins.str kms_alias_arn: KMS Alias Arn.
        :param builtins.str kms_alias_name: KMS Alias Name.
        :param builtins.str kms_key_arn: KMS Key Arn.
        """
        if kms_alias_arn is not None:
            pulumi.set(__self__, "kms_alias_arn", kms_alias_arn)
        if kms_alias_name is not None:
            pulumi.set(__self__, "kms_alias_name", kms_alias_name)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="kmsAliasArn")
    def kms_alias_arn(self) -> Optional[builtins.str]:
        """
        KMS Alias Arn.
        """
        return pulumi.get(self, "kms_alias_arn")

    @property
    @pulumi.getter(name="kmsAliasName")
    def kms_alias_name(self) -> Optional[builtins.str]:
        """
        KMS Alias Name.
        """
        return pulumi.get(self, "kms_alias_name")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        KMS Key Arn.
        """
        return pulumi.get(self, "kms_key_arn")


