# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['MissionProfileArgs', 'MissionProfile']

@pulumi.input_type
class MissionProfileArgs:
    def __init__(__self__, *,
                 dataflow_edges: pulumi.Input[Sequence[pulumi.Input['MissionProfileDataflowEdgeArgs']]],
                 minimum_viable_contact_duration_seconds: pulumi.Input[builtins.int],
                 tracking_config_arn: pulumi.Input[builtins.str],
                 contact_post_pass_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 contact_pre_pass_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 streams_kms_key: Optional[pulumi.Input['MissionProfileStreamsKmsKeyArgs']] = None,
                 streams_kms_role: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a MissionProfile resource.
        :param pulumi.Input[Sequence[pulumi.Input['MissionProfileDataflowEdgeArgs']]] dataflow_edges: A list containing lists of config ARNs. Each list of config ARNs is an edge, with a "from" config and a "to" config.
        :param pulumi.Input[builtins.int] minimum_viable_contact_duration_seconds: Visibilities with shorter duration than the specified minimum viable contact duration will be ignored when searching for available contacts.
        :param pulumi.Input[builtins.str] tracking_config_arn: The ARN of a tracking config objects that defines how to track the satellite through the sky during a contact.
        :param pulumi.Input[builtins.int] contact_post_pass_duration_seconds: Post-pass time needed after the contact.
        :param pulumi.Input[builtins.int] contact_pre_pass_duration_seconds: Pre-pass time needed before the contact.
        :param pulumi.Input[builtins.str] name: A name used to identify a mission profile.
        :param pulumi.Input['MissionProfileStreamsKmsKeyArgs'] streams_kms_key: The ARN of a KMS Key used for encrypting data during transmission from the source to destination locations.
        :param pulumi.Input[builtins.str] streams_kms_role: The ARN of the KMS Key or Alias Key role used to define permissions on KMS Key usage.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags assigned to the mission profile.
        """
        pulumi.set(__self__, "dataflow_edges", dataflow_edges)
        pulumi.set(__self__, "minimum_viable_contact_duration_seconds", minimum_viable_contact_duration_seconds)
        pulumi.set(__self__, "tracking_config_arn", tracking_config_arn)
        if contact_post_pass_duration_seconds is not None:
            pulumi.set(__self__, "contact_post_pass_duration_seconds", contact_post_pass_duration_seconds)
        if contact_pre_pass_duration_seconds is not None:
            pulumi.set(__self__, "contact_pre_pass_duration_seconds", contact_pre_pass_duration_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams_kms_key is not None:
            pulumi.set(__self__, "streams_kms_key", streams_kms_key)
        if streams_kms_role is not None:
            pulumi.set(__self__, "streams_kms_role", streams_kms_role)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataflowEdges")
    def dataflow_edges(self) -> pulumi.Input[Sequence[pulumi.Input['MissionProfileDataflowEdgeArgs']]]:
        """
        A list containing lists of config ARNs. Each list of config ARNs is an edge, with a "from" config and a "to" config.
        """
        return pulumi.get(self, "dataflow_edges")

    @dataflow_edges.setter
    def dataflow_edges(self, value: pulumi.Input[Sequence[pulumi.Input['MissionProfileDataflowEdgeArgs']]]):
        pulumi.set(self, "dataflow_edges", value)

    @property
    @pulumi.getter(name="minimumViableContactDurationSeconds")
    def minimum_viable_contact_duration_seconds(self) -> pulumi.Input[builtins.int]:
        """
        Visibilities with shorter duration than the specified minimum viable contact duration will be ignored when searching for available contacts.
        """
        return pulumi.get(self, "minimum_viable_contact_duration_seconds")

    @minimum_viable_contact_duration_seconds.setter
    def minimum_viable_contact_duration_seconds(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "minimum_viable_contact_duration_seconds", value)

    @property
    @pulumi.getter(name="trackingConfigArn")
    def tracking_config_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of a tracking config objects that defines how to track the satellite through the sky during a contact.
        """
        return pulumi.get(self, "tracking_config_arn")

    @tracking_config_arn.setter
    def tracking_config_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tracking_config_arn", value)

    @property
    @pulumi.getter(name="contactPostPassDurationSeconds")
    def contact_post_pass_duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Post-pass time needed after the contact.
        """
        return pulumi.get(self, "contact_post_pass_duration_seconds")

    @contact_post_pass_duration_seconds.setter
    def contact_post_pass_duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "contact_post_pass_duration_seconds", value)

    @property
    @pulumi.getter(name="contactPrePassDurationSeconds")
    def contact_pre_pass_duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Pre-pass time needed before the contact.
        """
        return pulumi.get(self, "contact_pre_pass_duration_seconds")

    @contact_pre_pass_duration_seconds.setter
    def contact_pre_pass_duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "contact_pre_pass_duration_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name used to identify a mission profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="streamsKmsKey")
    def streams_kms_key(self) -> Optional[pulumi.Input['MissionProfileStreamsKmsKeyArgs']]:
        """
        The ARN of a KMS Key used for encrypting data during transmission from the source to destination locations.
        """
        return pulumi.get(self, "streams_kms_key")

    @streams_kms_key.setter
    def streams_kms_key(self, value: Optional[pulumi.Input['MissionProfileStreamsKmsKeyArgs']]):
        pulumi.set(self, "streams_kms_key", value)

    @property
    @pulumi.getter(name="streamsKmsRole")
    def streams_kms_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the KMS Key or Alias Key role used to define permissions on KMS Key usage.
        """
        return pulumi.get(self, "streams_kms_role")

    @streams_kms_role.setter
    def streams_kms_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "streams_kms_role", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags assigned to the mission profile.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:groundstation:MissionProfile")
class MissionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_post_pass_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 contact_pre_pass_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 dataflow_edges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MissionProfileDataflowEdgeArgs', 'MissionProfileDataflowEdgeArgsDict']]]]] = None,
                 minimum_viable_contact_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 streams_kms_key: Optional[pulumi.Input[Union['MissionProfileStreamsKmsKeyArgs', 'MissionProfileStreamsKmsKeyArgsDict']]] = None,
                 streams_kms_role: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tracking_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        AWS Ground Station Mission Profile resource type for CloudFormation.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_mission_profile = aws_native.groundstation.MissionProfile("myMissionProfile",
            name="My Mission Profile",
            contact_pre_pass_duration_seconds=120,
            contact_post_pass_duration_seconds=180,
            minimum_viable_contact_duration_seconds=300,
            tracking_config_arn="arn:aws:groundstation:us-east-2:1234567890:config/tracking/00000000-0000-0000-0000-000000000000",
            dataflow_edges=[
                {
                    "source": "arn:aws:groundstation:us-east-2:1234567890:config/antenna-downlink/11111111-1111-1111-1111-111111111111",
                    "destination": "arn:aws:groundstation:us-east-2:1234567890:config/dataflow-endpoint/22222222-2222-2222-2222-222222222222",
                },
                {
                    "source": "arn:aws:groundstation:us-east-2:1234567890:config/dataflow-endpoint/33333333-3333-3333-3333-333333333333",
                    "destination": "arn:aws:groundstation:us-east-2:1234567890:config/antenna-uplink/44444444-4444-4444-4444-444444444444",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_mission_profile = aws_native.groundstation.MissionProfile("myMissionProfile",
            name="Mission Profile",
            contact_pre_pass_duration_seconds=120,
            contact_post_pass_duration_seconds=180,
            minimum_viable_contact_duration_seconds=300,
            tracking_config_arn="arn:aws:groundstation:us-east-2:1234567890:config/tracking/00000000-0000-0000-0000-000000000000",
            dataflow_edges=[
                {
                    "source": "arn:aws:groundstation:us-east-2:1234567890:config/antenna-downlink/11111111-1111-1111-1111-111111111111",
                    "destination": "arn:aws:groundstation:us-east-2:1234567890:config/dataflow-endpoint/22222222-2222-2222-2222-222222222222",
                },
                {
                    "source": "arn:aws:groundstation:us-east-2:1234567890:config/dataflow-endpoint/33333333-3333-3333-3333-333333333333",
                    "destination": "arn:aws:groundstation:us-east-2:1234567890:config/antenna-uplink/44444444-4444-4444-4444-444444444444",
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] contact_post_pass_duration_seconds: Post-pass time needed after the contact.
        :param pulumi.Input[builtins.int] contact_pre_pass_duration_seconds: Pre-pass time needed before the contact.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MissionProfileDataflowEdgeArgs', 'MissionProfileDataflowEdgeArgsDict']]]] dataflow_edges: A list containing lists of config ARNs. Each list of config ARNs is an edge, with a "from" config and a "to" config.
        :param pulumi.Input[builtins.int] minimum_viable_contact_duration_seconds: Visibilities with shorter duration than the specified minimum viable contact duration will be ignored when searching for available contacts.
        :param pulumi.Input[builtins.str] name: A name used to identify a mission profile.
        :param pulumi.Input[Union['MissionProfileStreamsKmsKeyArgs', 'MissionProfileStreamsKmsKeyArgsDict']] streams_kms_key: The ARN of a KMS Key used for encrypting data during transmission from the source to destination locations.
        :param pulumi.Input[builtins.str] streams_kms_role: The ARN of the KMS Key or Alias Key role used to define permissions on KMS Key usage.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags assigned to the mission profile.
        :param pulumi.Input[builtins.str] tracking_config_arn: The ARN of a tracking config objects that defines how to track the satellite through the sky during a contact.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MissionProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS Ground Station Mission Profile resource type for CloudFormation.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_mission_profile = aws_native.groundstation.MissionProfile("myMissionProfile",
            name="My Mission Profile",
            contact_pre_pass_duration_seconds=120,
            contact_post_pass_duration_seconds=180,
            minimum_viable_contact_duration_seconds=300,
            tracking_config_arn="arn:aws:groundstation:us-east-2:1234567890:config/tracking/00000000-0000-0000-0000-000000000000",
            dataflow_edges=[
                {
                    "source": "arn:aws:groundstation:us-east-2:1234567890:config/antenna-downlink/11111111-1111-1111-1111-111111111111",
                    "destination": "arn:aws:groundstation:us-east-2:1234567890:config/dataflow-endpoint/22222222-2222-2222-2222-222222222222",
                },
                {
                    "source": "arn:aws:groundstation:us-east-2:1234567890:config/dataflow-endpoint/33333333-3333-3333-3333-333333333333",
                    "destination": "arn:aws:groundstation:us-east-2:1234567890:config/antenna-uplink/44444444-4444-4444-4444-444444444444",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_mission_profile = aws_native.groundstation.MissionProfile("myMissionProfile",
            name="Mission Profile",
            contact_pre_pass_duration_seconds=120,
            contact_post_pass_duration_seconds=180,
            minimum_viable_contact_duration_seconds=300,
            tracking_config_arn="arn:aws:groundstation:us-east-2:1234567890:config/tracking/00000000-0000-0000-0000-000000000000",
            dataflow_edges=[
                {
                    "source": "arn:aws:groundstation:us-east-2:1234567890:config/antenna-downlink/11111111-1111-1111-1111-111111111111",
                    "destination": "arn:aws:groundstation:us-east-2:1234567890:config/dataflow-endpoint/22222222-2222-2222-2222-222222222222",
                },
                {
                    "source": "arn:aws:groundstation:us-east-2:1234567890:config/dataflow-endpoint/33333333-3333-3333-3333-333333333333",
                    "destination": "arn:aws:groundstation:us-east-2:1234567890:config/antenna-uplink/44444444-4444-4444-4444-444444444444",
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param MissionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MissionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_post_pass_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 contact_pre_pass_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 dataflow_edges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MissionProfileDataflowEdgeArgs', 'MissionProfileDataflowEdgeArgsDict']]]]] = None,
                 minimum_viable_contact_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 streams_kms_key: Optional[pulumi.Input[Union['MissionProfileStreamsKmsKeyArgs', 'MissionProfileStreamsKmsKeyArgsDict']]] = None,
                 streams_kms_role: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tracking_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MissionProfileArgs.__new__(MissionProfileArgs)

            __props__.__dict__["contact_post_pass_duration_seconds"] = contact_post_pass_duration_seconds
            __props__.__dict__["contact_pre_pass_duration_seconds"] = contact_pre_pass_duration_seconds
            if dataflow_edges is None and not opts.urn:
                raise TypeError("Missing required property 'dataflow_edges'")
            __props__.__dict__["dataflow_edges"] = dataflow_edges
            if minimum_viable_contact_duration_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'minimum_viable_contact_duration_seconds'")
            __props__.__dict__["minimum_viable_contact_duration_seconds"] = minimum_viable_contact_duration_seconds
            __props__.__dict__["name"] = name
            __props__.__dict__["streams_kms_key"] = streams_kms_key
            __props__.__dict__["streams_kms_role"] = streams_kms_role
            __props__.__dict__["tags"] = tags
            if tracking_config_arn is None and not opts.urn:
                raise TypeError("Missing required property 'tracking_config_arn'")
            __props__.__dict__["tracking_config_arn"] = tracking_config_arn
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["region"] = None
        super(MissionProfile, __self__).__init__(
            'aws-native:groundstation:MissionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MissionProfile':
        """
        Get an existing MissionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MissionProfileArgs.__new__(MissionProfileArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["contact_post_pass_duration_seconds"] = None
        __props__.__dict__["contact_pre_pass_duration_seconds"] = None
        __props__.__dict__["dataflow_edges"] = None
        __props__.__dict__["minimum_viable_contact_duration_seconds"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["region"] = None
        __props__.__dict__["streams_kms_key"] = None
        __props__.__dict__["streams_kms_role"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tracking_config_arn"] = None
        return MissionProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the mission profile, such as `arn:aws:groundstation:us-east-2:1234567890:mission-profile/9940bf3b-d2ba-427e-9906-842b5e5d2296` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the mission profile, such as `9940bf3b-d2ba-427e-9906-842b5e5d2296` .
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="contactPostPassDurationSeconds")
    def contact_post_pass_duration_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Post-pass time needed after the contact.
        """
        return pulumi.get(self, "contact_post_pass_duration_seconds")

    @property
    @pulumi.getter(name="contactPrePassDurationSeconds")
    def contact_pre_pass_duration_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Pre-pass time needed before the contact.
        """
        return pulumi.get(self, "contact_pre_pass_duration_seconds")

    @property
    @pulumi.getter(name="dataflowEdges")
    def dataflow_edges(self) -> pulumi.Output[Sequence['outputs.MissionProfileDataflowEdge']]:
        """
        A list containing lists of config ARNs. Each list of config ARNs is an edge, with a "from" config and a "to" config.
        """
        return pulumi.get(self, "dataflow_edges")

    @property
    @pulumi.getter(name="minimumViableContactDurationSeconds")
    def minimum_viable_contact_duration_seconds(self) -> pulumi.Output[builtins.int]:
        """
        Visibilities with shorter duration than the specified minimum viable contact duration will be ignored when searching for available contacts.
        """
        return pulumi.get(self, "minimum_viable_contact_duration_seconds")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name used to identify a mission profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region of the mission profile.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streamsKmsKey")
    def streams_kms_key(self) -> pulumi.Output[Optional['outputs.MissionProfileStreamsKmsKey']]:
        """
        The ARN of a KMS Key used for encrypting data during transmission from the source to destination locations.
        """
        return pulumi.get(self, "streams_kms_key")

    @property
    @pulumi.getter(name="streamsKmsRole")
    def streams_kms_role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of the KMS Key or Alias Key role used to define permissions on KMS Key usage.
        """
        return pulumi.get(self, "streams_kms_role")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags assigned to the mission profile.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trackingConfigArn")
    def tracking_config_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of a tracking config objects that defines how to track the satellite through the sky during a contact.
        """
        return pulumi.get(self, "tracking_config_arn")

