# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetMissionProfileResult',
    'AwaitableGetMissionProfileResult',
    'get_mission_profile',
    'get_mission_profile_output',
]

@pulumi.output_type
class GetMissionProfileResult:
    def __init__(__self__, arn=None, contact_post_pass_duration_seconds=None, contact_pre_pass_duration_seconds=None, dataflow_edges=None, id=None, minimum_viable_contact_duration_seconds=None, name=None, region=None, streams_kms_key=None, streams_kms_role=None, tags=None, tracking_config_arn=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if contact_post_pass_duration_seconds and not isinstance(contact_post_pass_duration_seconds, int):
            raise TypeError("Expected argument 'contact_post_pass_duration_seconds' to be a int")
        pulumi.set(__self__, "contact_post_pass_duration_seconds", contact_post_pass_duration_seconds)
        if contact_pre_pass_duration_seconds and not isinstance(contact_pre_pass_duration_seconds, int):
            raise TypeError("Expected argument 'contact_pre_pass_duration_seconds' to be a int")
        pulumi.set(__self__, "contact_pre_pass_duration_seconds", contact_pre_pass_duration_seconds)
        if dataflow_edges and not isinstance(dataflow_edges, list):
            raise TypeError("Expected argument 'dataflow_edges' to be a list")
        pulumi.set(__self__, "dataflow_edges", dataflow_edges)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if minimum_viable_contact_duration_seconds and not isinstance(minimum_viable_contact_duration_seconds, int):
            raise TypeError("Expected argument 'minimum_viable_contact_duration_seconds' to be a int")
        pulumi.set(__self__, "minimum_viable_contact_duration_seconds", minimum_viable_contact_duration_seconds)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if streams_kms_key and not isinstance(streams_kms_key, dict):
            raise TypeError("Expected argument 'streams_kms_key' to be a dict")
        pulumi.set(__self__, "streams_kms_key", streams_kms_key)
        if streams_kms_role and not isinstance(streams_kms_role, str):
            raise TypeError("Expected argument 'streams_kms_role' to be a str")
        pulumi.set(__self__, "streams_kms_role", streams_kms_role)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tracking_config_arn and not isinstance(tracking_config_arn, str):
            raise TypeError("Expected argument 'tracking_config_arn' to be a str")
        pulumi.set(__self__, "tracking_config_arn", tracking_config_arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the mission profile, such as `arn:aws:groundstation:us-east-2:1234567890:mission-profile/9940bf3b-d2ba-427e-9906-842b5e5d2296` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="contactPostPassDurationSeconds")
    def contact_post_pass_duration_seconds(self) -> Optional[builtins.int]:
        """
        Post-pass time needed after the contact.
        """
        return pulumi.get(self, "contact_post_pass_duration_seconds")

    @property
    @pulumi.getter(name="contactPrePassDurationSeconds")
    def contact_pre_pass_duration_seconds(self) -> Optional[builtins.int]:
        """
        Pre-pass time needed before the contact.
        """
        return pulumi.get(self, "contact_pre_pass_duration_seconds")

    @property
    @pulumi.getter(name="dataflowEdges")
    def dataflow_edges(self) -> Optional[Sequence['outputs.MissionProfileDataflowEdge']]:
        """
        A list containing lists of config ARNs. Each list of config ARNs is an edge, with a "from" config and a "to" config.
        """
        return pulumi.get(self, "dataflow_edges")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the mission profile, such as `9940bf3b-d2ba-427e-9906-842b5e5d2296` .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="minimumViableContactDurationSeconds")
    def minimum_viable_contact_duration_seconds(self) -> Optional[builtins.int]:
        """
        Visibilities with shorter duration than the specified minimum viable contact duration will be ignored when searching for available contacts.
        """
        return pulumi.get(self, "minimum_viable_contact_duration_seconds")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        A name used to identify a mission profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region of the mission profile.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streamsKmsKey")
    def streams_kms_key(self) -> Optional['outputs.MissionProfileStreamsKmsKey']:
        """
        The ARN of a KMS Key used for encrypting data during transmission from the source to destination locations.
        """
        return pulumi.get(self, "streams_kms_key")

    @property
    @pulumi.getter(name="streamsKmsRole")
    def streams_kms_role(self) -> Optional[builtins.str]:
        """
        The ARN of the KMS Key or Alias Key role used to define permissions on KMS Key usage.
        """
        return pulumi.get(self, "streams_kms_role")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags assigned to the mission profile.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trackingConfigArn")
    def tracking_config_arn(self) -> Optional[builtins.str]:
        """
        The ARN of a tracking config objects that defines how to track the satellite through the sky during a contact.
        """
        return pulumi.get(self, "tracking_config_arn")


class AwaitableGetMissionProfileResult(GetMissionProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMissionProfileResult(
            arn=self.arn,
            contact_post_pass_duration_seconds=self.contact_post_pass_duration_seconds,
            contact_pre_pass_duration_seconds=self.contact_pre_pass_duration_seconds,
            dataflow_edges=self.dataflow_edges,
            id=self.id,
            minimum_viable_contact_duration_seconds=self.minimum_viable_contact_duration_seconds,
            name=self.name,
            region=self.region,
            streams_kms_key=self.streams_kms_key,
            streams_kms_role=self.streams_kms_role,
            tags=self.tags,
            tracking_config_arn=self.tracking_config_arn)


def get_mission_profile(arn: Optional[builtins.str] = None,
                        id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMissionProfileResult:
    """
    AWS Ground Station Mission Profile resource type for CloudFormation.


    :param builtins.str arn: The ARN of the mission profile, such as `arn:aws:groundstation:us-east-2:1234567890:mission-profile/9940bf3b-d2ba-427e-9906-842b5e5d2296` .
    :param builtins.str id: The ID of the mission profile, such as `9940bf3b-d2ba-427e-9906-842b5e5d2296` .
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:groundstation:getMissionProfile', __args__, opts=opts, typ=GetMissionProfileResult).value

    return AwaitableGetMissionProfileResult(
        arn=pulumi.get(__ret__, 'arn'),
        contact_post_pass_duration_seconds=pulumi.get(__ret__, 'contact_post_pass_duration_seconds'),
        contact_pre_pass_duration_seconds=pulumi.get(__ret__, 'contact_pre_pass_duration_seconds'),
        dataflow_edges=pulumi.get(__ret__, 'dataflow_edges'),
        id=pulumi.get(__ret__, 'id'),
        minimum_viable_contact_duration_seconds=pulumi.get(__ret__, 'minimum_viable_contact_duration_seconds'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        streams_kms_key=pulumi.get(__ret__, 'streams_kms_key'),
        streams_kms_role=pulumi.get(__ret__, 'streams_kms_role'),
        tags=pulumi.get(__ret__, 'tags'),
        tracking_config_arn=pulumi.get(__ret__, 'tracking_config_arn'))
def get_mission_profile_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                               id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMissionProfileResult]:
    """
    AWS Ground Station Mission Profile resource type for CloudFormation.


    :param builtins.str arn: The ARN of the mission profile, such as `arn:aws:groundstation:us-east-2:1234567890:mission-profile/9940bf3b-d2ba-427e-9906-842b5e5d2296` .
    :param builtins.str id: The ID of the mission profile, such as `9940bf3b-d2ba-427e-9906-842b5e5d2296` .
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:groundstation:getMissionProfile', __args__, opts=opts, typ=GetMissionProfileResult)
    return __ret__.apply(lambda __response__: GetMissionProfileResult(
        arn=pulumi.get(__response__, 'arn'),
        contact_post_pass_duration_seconds=pulumi.get(__response__, 'contact_post_pass_duration_seconds'),
        contact_pre_pass_duration_seconds=pulumi.get(__response__, 'contact_pre_pass_duration_seconds'),
        dataflow_edges=pulumi.get(__response__, 'dataflow_edges'),
        id=pulumi.get(__response__, 'id'),
        minimum_viable_contact_duration_seconds=pulumi.get(__response__, 'minimum_viable_contact_duration_seconds'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        streams_kms_key=pulumi.get(__response__, 'streams_kms_key'),
        streams_kms_role=pulumi.get(__response__, 'streams_kms_role'),
        tags=pulumi.get(__response__, 'tags'),
        tracking_config_arn=pulumi.get(__response__, 'tracking_config_arn')))
