# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ConfigAntennaDownlinkConfigArgs',
    'ConfigAntennaDownlinkConfigArgsDict',
    'ConfigAntennaDownlinkDemodDecodeConfigArgs',
    'ConfigAntennaDownlinkDemodDecodeConfigArgsDict',
    'ConfigAntennaUplinkConfigArgs',
    'ConfigAntennaUplinkConfigArgsDict',
    'ConfigDataflowEndpointConfigArgs',
    'ConfigDataflowEndpointConfigArgsDict',
    'ConfigDataArgs',
    'ConfigDataArgsDict',
    'ConfigDecodeConfigArgs',
    'ConfigDecodeConfigArgsDict',
    'ConfigDemodulationConfigArgs',
    'ConfigDemodulationConfigArgsDict',
    'ConfigEirpArgs',
    'ConfigEirpArgsDict',
    'ConfigFrequencyBandwidthArgs',
    'ConfigFrequencyBandwidthArgsDict',
    'ConfigFrequencyArgs',
    'ConfigFrequencyArgsDict',
    'ConfigS3RecordingConfigArgs',
    'ConfigS3RecordingConfigArgsDict',
    'ConfigSpectrumConfigArgs',
    'ConfigSpectrumConfigArgsDict',
    'ConfigTrackingConfigArgs',
    'ConfigTrackingConfigArgsDict',
    'ConfigUplinkEchoConfigArgs',
    'ConfigUplinkEchoConfigArgsDict',
    'ConfigUplinkSpectrumConfigArgs',
    'ConfigUplinkSpectrumConfigArgsDict',
    'DataflowEndpointGroupAwsGroundStationAgentEndpointArgs',
    'DataflowEndpointGroupAwsGroundStationAgentEndpointArgsDict',
    'DataflowEndpointGroupConnectionDetailsArgs',
    'DataflowEndpointGroupConnectionDetailsArgsDict',
    'DataflowEndpointGroupDataflowEndpointArgs',
    'DataflowEndpointGroupDataflowEndpointArgsDict',
    'DataflowEndpointGroupEndpointDetailsArgs',
    'DataflowEndpointGroupEndpointDetailsArgsDict',
    'DataflowEndpointGroupIntegerRangeArgs',
    'DataflowEndpointGroupIntegerRangeArgsDict',
    'DataflowEndpointGroupRangedConnectionDetailsArgs',
    'DataflowEndpointGroupRangedConnectionDetailsArgsDict',
    'DataflowEndpointGroupRangedSocketAddressArgs',
    'DataflowEndpointGroupRangedSocketAddressArgsDict',
    'DataflowEndpointGroupSecurityDetailsArgs',
    'DataflowEndpointGroupSecurityDetailsArgsDict',
    'DataflowEndpointGroupSocketAddressArgs',
    'DataflowEndpointGroupSocketAddressArgsDict',
    'MissionProfileDataflowEdgeArgs',
    'MissionProfileDataflowEdgeArgsDict',
    'MissionProfileStreamsKmsKeyArgs',
    'MissionProfileStreamsKmsKeyArgsDict',
]

MYPY = False

if not MYPY:
    class ConfigAntennaDownlinkConfigArgsDict(TypedDict):
        spectrum_config: NotRequired[pulumi.Input['ConfigSpectrumConfigArgsDict']]
        """
        Defines the spectrum configuration.
        """
elif False:
    ConfigAntennaDownlinkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigAntennaDownlinkConfigArgs:
    def __init__(__self__, *,
                 spectrum_config: Optional[pulumi.Input['ConfigSpectrumConfigArgs']] = None):
        """
        :param pulumi.Input['ConfigSpectrumConfigArgs'] spectrum_config: Defines the spectrum configuration.
        """
        if spectrum_config is not None:
            pulumi.set(__self__, "spectrum_config", spectrum_config)

    @property
    @pulumi.getter(name="spectrumConfig")
    def spectrum_config(self) -> Optional[pulumi.Input['ConfigSpectrumConfigArgs']]:
        """
        Defines the spectrum configuration.
        """
        return pulumi.get(self, "spectrum_config")

    @spectrum_config.setter
    def spectrum_config(self, value: Optional[pulumi.Input['ConfigSpectrumConfigArgs']]):
        pulumi.set(self, "spectrum_config", value)


if not MYPY:
    class ConfigAntennaDownlinkDemodDecodeConfigArgsDict(TypedDict):
        decode_config: NotRequired[pulumi.Input['ConfigDecodeConfigArgsDict']]
        """
        Defines how the RF signal will be decoded.
        """
        demodulation_config: NotRequired[pulumi.Input['ConfigDemodulationConfigArgsDict']]
        """
        Defines how the RF signal will be demodulated.
        """
        spectrum_config: NotRequired[pulumi.Input['ConfigSpectrumConfigArgsDict']]
        """
        Defines the spectrum configuration.
        """
elif False:
    ConfigAntennaDownlinkDemodDecodeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigAntennaDownlinkDemodDecodeConfigArgs:
    def __init__(__self__, *,
                 decode_config: Optional[pulumi.Input['ConfigDecodeConfigArgs']] = None,
                 demodulation_config: Optional[pulumi.Input['ConfigDemodulationConfigArgs']] = None,
                 spectrum_config: Optional[pulumi.Input['ConfigSpectrumConfigArgs']] = None):
        """
        :param pulumi.Input['ConfigDecodeConfigArgs'] decode_config: Defines how the RF signal will be decoded.
        :param pulumi.Input['ConfigDemodulationConfigArgs'] demodulation_config: Defines how the RF signal will be demodulated.
        :param pulumi.Input['ConfigSpectrumConfigArgs'] spectrum_config: Defines the spectrum configuration.
        """
        if decode_config is not None:
            pulumi.set(__self__, "decode_config", decode_config)
        if demodulation_config is not None:
            pulumi.set(__self__, "demodulation_config", demodulation_config)
        if spectrum_config is not None:
            pulumi.set(__self__, "spectrum_config", spectrum_config)

    @property
    @pulumi.getter(name="decodeConfig")
    def decode_config(self) -> Optional[pulumi.Input['ConfigDecodeConfigArgs']]:
        """
        Defines how the RF signal will be decoded.
        """
        return pulumi.get(self, "decode_config")

    @decode_config.setter
    def decode_config(self, value: Optional[pulumi.Input['ConfigDecodeConfigArgs']]):
        pulumi.set(self, "decode_config", value)

    @property
    @pulumi.getter(name="demodulationConfig")
    def demodulation_config(self) -> Optional[pulumi.Input['ConfigDemodulationConfigArgs']]:
        """
        Defines how the RF signal will be demodulated.
        """
        return pulumi.get(self, "demodulation_config")

    @demodulation_config.setter
    def demodulation_config(self, value: Optional[pulumi.Input['ConfigDemodulationConfigArgs']]):
        pulumi.set(self, "demodulation_config", value)

    @property
    @pulumi.getter(name="spectrumConfig")
    def spectrum_config(self) -> Optional[pulumi.Input['ConfigSpectrumConfigArgs']]:
        """
        Defines the spectrum configuration.
        """
        return pulumi.get(self, "spectrum_config")

    @spectrum_config.setter
    def spectrum_config(self, value: Optional[pulumi.Input['ConfigSpectrumConfigArgs']]):
        pulumi.set(self, "spectrum_config", value)


if not MYPY:
    class ConfigAntennaUplinkConfigArgsDict(TypedDict):
        spectrum_config: NotRequired[pulumi.Input['ConfigUplinkSpectrumConfigArgsDict']]
        """
        Defines the spectrum configuration.
        """
        target_eirp: NotRequired[pulumi.Input['ConfigEirpArgsDict']]
        """
        The equivalent isotropically radiated power (EIRP) to use for uplink transmissions. Valid values are between 20.0 to 50.0 dBW.
        """
        transmit_disabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not uplink transmit is disabled.
        """
elif False:
    ConfigAntennaUplinkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigAntennaUplinkConfigArgs:
    def __init__(__self__, *,
                 spectrum_config: Optional[pulumi.Input['ConfigUplinkSpectrumConfigArgs']] = None,
                 target_eirp: Optional[pulumi.Input['ConfigEirpArgs']] = None,
                 transmit_disabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input['ConfigUplinkSpectrumConfigArgs'] spectrum_config: Defines the spectrum configuration.
        :param pulumi.Input['ConfigEirpArgs'] target_eirp: The equivalent isotropically radiated power (EIRP) to use for uplink transmissions. Valid values are between 20.0 to 50.0 dBW.
        :param pulumi.Input[builtins.bool] transmit_disabled: Whether or not uplink transmit is disabled.
        """
        if spectrum_config is not None:
            pulumi.set(__self__, "spectrum_config", spectrum_config)
        if target_eirp is not None:
            pulumi.set(__self__, "target_eirp", target_eirp)
        if transmit_disabled is not None:
            pulumi.set(__self__, "transmit_disabled", transmit_disabled)

    @property
    @pulumi.getter(name="spectrumConfig")
    def spectrum_config(self) -> Optional[pulumi.Input['ConfigUplinkSpectrumConfigArgs']]:
        """
        Defines the spectrum configuration.
        """
        return pulumi.get(self, "spectrum_config")

    @spectrum_config.setter
    def spectrum_config(self, value: Optional[pulumi.Input['ConfigUplinkSpectrumConfigArgs']]):
        pulumi.set(self, "spectrum_config", value)

    @property
    @pulumi.getter(name="targetEirp")
    def target_eirp(self) -> Optional[pulumi.Input['ConfigEirpArgs']]:
        """
        The equivalent isotropically radiated power (EIRP) to use for uplink transmissions. Valid values are between 20.0 to 50.0 dBW.
        """
        return pulumi.get(self, "target_eirp")

    @target_eirp.setter
    def target_eirp(self, value: Optional[pulumi.Input['ConfigEirpArgs']]):
        pulumi.set(self, "target_eirp", value)

    @property
    @pulumi.getter(name="transmitDisabled")
    def transmit_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not uplink transmit is disabled.
        """
        return pulumi.get(self, "transmit_disabled")

    @transmit_disabled.setter
    def transmit_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "transmit_disabled", value)


if not MYPY:
    class ConfigDataflowEndpointConfigArgsDict(TypedDict):
        dataflow_endpoint_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the dataflow endpoint to use during contacts.
        """
        dataflow_endpoint_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The region of the dataflow endpoint to use during contacts. When omitted, Ground Station will use the region of the contact.
        """
elif False:
    ConfigDataflowEndpointConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigDataflowEndpointConfigArgs:
    def __init__(__self__, *,
                 dataflow_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 dataflow_endpoint_region: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] dataflow_endpoint_name: The name of the dataflow endpoint to use during contacts.
        :param pulumi.Input[builtins.str] dataflow_endpoint_region: The region of the dataflow endpoint to use during contacts. When omitted, Ground Station will use the region of the contact.
        """
        if dataflow_endpoint_name is not None:
            pulumi.set(__self__, "dataflow_endpoint_name", dataflow_endpoint_name)
        if dataflow_endpoint_region is not None:
            pulumi.set(__self__, "dataflow_endpoint_region", dataflow_endpoint_region)

    @property
    @pulumi.getter(name="dataflowEndpointName")
    def dataflow_endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the dataflow endpoint to use during contacts.
        """
        return pulumi.get(self, "dataflow_endpoint_name")

    @dataflow_endpoint_name.setter
    def dataflow_endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataflow_endpoint_name", value)

    @property
    @pulumi.getter(name="dataflowEndpointRegion")
    def dataflow_endpoint_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the dataflow endpoint to use during contacts. When omitted, Ground Station will use the region of the contact.
        """
        return pulumi.get(self, "dataflow_endpoint_region")

    @dataflow_endpoint_region.setter
    def dataflow_endpoint_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataflow_endpoint_region", value)


if not MYPY:
    class ConfigDataArgsDict(TypedDict):
        antenna_downlink_config: NotRequired[pulumi.Input['ConfigAntennaDownlinkConfigArgsDict']]
        """
        Provides information for an antenna downlink config object. Antenna downlink config objects are used to provide parameters for downlinks where no demodulation or decoding is performed by Ground Station (RF over IP downlinks).
        """
        antenna_downlink_demod_decode_config: NotRequired[pulumi.Input['ConfigAntennaDownlinkDemodDecodeConfigArgsDict']]
        """
        Provides information for a downlink demod decode config object. Downlink demod decode config objects are used to provide parameters for downlinks where the Ground Station service will demodulate and decode the downlinked data.
        """
        antenna_uplink_config: NotRequired[pulumi.Input['ConfigAntennaUplinkConfigArgsDict']]
        """
        Provides information for an uplink config object. Uplink config objects are used to provide parameters for uplink contacts.
        """
        dataflow_endpoint_config: NotRequired[pulumi.Input['ConfigDataflowEndpointConfigArgsDict']]
        """
        Provides information for a dataflow endpoint config object. Dataflow endpoint config objects are used to provide parameters about which IP endpoint(s) to use during a contact. Dataflow endpoints are where Ground Station sends data during a downlink contact and where Ground Station receives data to send to the satellite during an uplink contact.
        """
        s3_recording_config: NotRequired[pulumi.Input['ConfigS3RecordingConfigArgsDict']]
        """
        Provides information for an S3 recording config object. S3 recording config objects are used to provide parameters for S3 recording during downlink contacts.
        """
        tracking_config: NotRequired[pulumi.Input['ConfigTrackingConfigArgsDict']]
        """
        Provides information for a tracking config object. Tracking config objects are used to provide parameters about how to track the satellite through the sky during a contact.
        """
        uplink_echo_config: NotRequired[pulumi.Input['ConfigUplinkEchoConfigArgsDict']]
        """
        Provides information for an uplink echo config object. Uplink echo config objects are used to provide parameters for uplink echo during uplink contacts.
        """
elif False:
    ConfigDataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigDataArgs:
    def __init__(__self__, *,
                 antenna_downlink_config: Optional[pulumi.Input['ConfigAntennaDownlinkConfigArgs']] = None,
                 antenna_downlink_demod_decode_config: Optional[pulumi.Input['ConfigAntennaDownlinkDemodDecodeConfigArgs']] = None,
                 antenna_uplink_config: Optional[pulumi.Input['ConfigAntennaUplinkConfigArgs']] = None,
                 dataflow_endpoint_config: Optional[pulumi.Input['ConfigDataflowEndpointConfigArgs']] = None,
                 s3_recording_config: Optional[pulumi.Input['ConfigS3RecordingConfigArgs']] = None,
                 tracking_config: Optional[pulumi.Input['ConfigTrackingConfigArgs']] = None,
                 uplink_echo_config: Optional[pulumi.Input['ConfigUplinkEchoConfigArgs']] = None):
        """
        :param pulumi.Input['ConfigAntennaDownlinkConfigArgs'] antenna_downlink_config: Provides information for an antenna downlink config object. Antenna downlink config objects are used to provide parameters for downlinks where no demodulation or decoding is performed by Ground Station (RF over IP downlinks).
        :param pulumi.Input['ConfigAntennaDownlinkDemodDecodeConfigArgs'] antenna_downlink_demod_decode_config: Provides information for a downlink demod decode config object. Downlink demod decode config objects are used to provide parameters for downlinks where the Ground Station service will demodulate and decode the downlinked data.
        :param pulumi.Input['ConfigAntennaUplinkConfigArgs'] antenna_uplink_config: Provides information for an uplink config object. Uplink config objects are used to provide parameters for uplink contacts.
        :param pulumi.Input['ConfigDataflowEndpointConfigArgs'] dataflow_endpoint_config: Provides information for a dataflow endpoint config object. Dataflow endpoint config objects are used to provide parameters about which IP endpoint(s) to use during a contact. Dataflow endpoints are where Ground Station sends data during a downlink contact and where Ground Station receives data to send to the satellite during an uplink contact.
        :param pulumi.Input['ConfigS3RecordingConfigArgs'] s3_recording_config: Provides information for an S3 recording config object. S3 recording config objects are used to provide parameters for S3 recording during downlink contacts.
        :param pulumi.Input['ConfigTrackingConfigArgs'] tracking_config: Provides information for a tracking config object. Tracking config objects are used to provide parameters about how to track the satellite through the sky during a contact.
        :param pulumi.Input['ConfigUplinkEchoConfigArgs'] uplink_echo_config: Provides information for an uplink echo config object. Uplink echo config objects are used to provide parameters for uplink echo during uplink contacts.
        """
        if antenna_downlink_config is not None:
            pulumi.set(__self__, "antenna_downlink_config", antenna_downlink_config)
        if antenna_downlink_demod_decode_config is not None:
            pulumi.set(__self__, "antenna_downlink_demod_decode_config", antenna_downlink_demod_decode_config)
        if antenna_uplink_config is not None:
            pulumi.set(__self__, "antenna_uplink_config", antenna_uplink_config)
        if dataflow_endpoint_config is not None:
            pulumi.set(__self__, "dataflow_endpoint_config", dataflow_endpoint_config)
        if s3_recording_config is not None:
            pulumi.set(__self__, "s3_recording_config", s3_recording_config)
        if tracking_config is not None:
            pulumi.set(__self__, "tracking_config", tracking_config)
        if uplink_echo_config is not None:
            pulumi.set(__self__, "uplink_echo_config", uplink_echo_config)

    @property
    @pulumi.getter(name="antennaDownlinkConfig")
    def antenna_downlink_config(self) -> Optional[pulumi.Input['ConfigAntennaDownlinkConfigArgs']]:
        """
        Provides information for an antenna downlink config object. Antenna downlink config objects are used to provide parameters for downlinks where no demodulation or decoding is performed by Ground Station (RF over IP downlinks).
        """
        return pulumi.get(self, "antenna_downlink_config")

    @antenna_downlink_config.setter
    def antenna_downlink_config(self, value: Optional[pulumi.Input['ConfigAntennaDownlinkConfigArgs']]):
        pulumi.set(self, "antenna_downlink_config", value)

    @property
    @pulumi.getter(name="antennaDownlinkDemodDecodeConfig")
    def antenna_downlink_demod_decode_config(self) -> Optional[pulumi.Input['ConfigAntennaDownlinkDemodDecodeConfigArgs']]:
        """
        Provides information for a downlink demod decode config object. Downlink demod decode config objects are used to provide parameters for downlinks where the Ground Station service will demodulate and decode the downlinked data.
        """
        return pulumi.get(self, "antenna_downlink_demod_decode_config")

    @antenna_downlink_demod_decode_config.setter
    def antenna_downlink_demod_decode_config(self, value: Optional[pulumi.Input['ConfigAntennaDownlinkDemodDecodeConfigArgs']]):
        pulumi.set(self, "antenna_downlink_demod_decode_config", value)

    @property
    @pulumi.getter(name="antennaUplinkConfig")
    def antenna_uplink_config(self) -> Optional[pulumi.Input['ConfigAntennaUplinkConfigArgs']]:
        """
        Provides information for an uplink config object. Uplink config objects are used to provide parameters for uplink contacts.
        """
        return pulumi.get(self, "antenna_uplink_config")

    @antenna_uplink_config.setter
    def antenna_uplink_config(self, value: Optional[pulumi.Input['ConfigAntennaUplinkConfigArgs']]):
        pulumi.set(self, "antenna_uplink_config", value)

    @property
    @pulumi.getter(name="dataflowEndpointConfig")
    def dataflow_endpoint_config(self) -> Optional[pulumi.Input['ConfigDataflowEndpointConfigArgs']]:
        """
        Provides information for a dataflow endpoint config object. Dataflow endpoint config objects are used to provide parameters about which IP endpoint(s) to use during a contact. Dataflow endpoints are where Ground Station sends data during a downlink contact and where Ground Station receives data to send to the satellite during an uplink contact.
        """
        return pulumi.get(self, "dataflow_endpoint_config")

    @dataflow_endpoint_config.setter
    def dataflow_endpoint_config(self, value: Optional[pulumi.Input['ConfigDataflowEndpointConfigArgs']]):
        pulumi.set(self, "dataflow_endpoint_config", value)

    @property
    @pulumi.getter(name="s3RecordingConfig")
    def s3_recording_config(self) -> Optional[pulumi.Input['ConfigS3RecordingConfigArgs']]:
        """
        Provides information for an S3 recording config object. S3 recording config objects are used to provide parameters for S3 recording during downlink contacts.
        """
        return pulumi.get(self, "s3_recording_config")

    @s3_recording_config.setter
    def s3_recording_config(self, value: Optional[pulumi.Input['ConfigS3RecordingConfigArgs']]):
        pulumi.set(self, "s3_recording_config", value)

    @property
    @pulumi.getter(name="trackingConfig")
    def tracking_config(self) -> Optional[pulumi.Input['ConfigTrackingConfigArgs']]:
        """
        Provides information for a tracking config object. Tracking config objects are used to provide parameters about how to track the satellite through the sky during a contact.
        """
        return pulumi.get(self, "tracking_config")

    @tracking_config.setter
    def tracking_config(self, value: Optional[pulumi.Input['ConfigTrackingConfigArgs']]):
        pulumi.set(self, "tracking_config", value)

    @property
    @pulumi.getter(name="uplinkEchoConfig")
    def uplink_echo_config(self) -> Optional[pulumi.Input['ConfigUplinkEchoConfigArgs']]:
        """
        Provides information for an uplink echo config object. Uplink echo config objects are used to provide parameters for uplink echo during uplink contacts.
        """
        return pulumi.get(self, "uplink_echo_config")

    @uplink_echo_config.setter
    def uplink_echo_config(self, value: Optional[pulumi.Input['ConfigUplinkEchoConfigArgs']]):
        pulumi.set(self, "uplink_echo_config", value)


if not MYPY:
    class ConfigDecodeConfigArgsDict(TypedDict):
        unvalidated_json: NotRequired[pulumi.Input[builtins.str]]
        """
        The decoding settings are in JSON format and define a set of steps to perform to decode the data.
        """
elif False:
    ConfigDecodeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigDecodeConfigArgs:
    def __init__(__self__, *,
                 unvalidated_json: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] unvalidated_json: The decoding settings are in JSON format and define a set of steps to perform to decode the data.
        """
        if unvalidated_json is not None:
            pulumi.set(__self__, "unvalidated_json", unvalidated_json)

    @property
    @pulumi.getter(name="unvalidatedJson")
    def unvalidated_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The decoding settings are in JSON format and define a set of steps to perform to decode the data.
        """
        return pulumi.get(self, "unvalidated_json")

    @unvalidated_json.setter
    def unvalidated_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unvalidated_json", value)


if not MYPY:
    class ConfigDemodulationConfigArgsDict(TypedDict):
        unvalidated_json: NotRequired[pulumi.Input[builtins.str]]
        """
        The demodulation settings are in JSON format and define parameters for demodulation, for example which modulation scheme (e.g. PSK, QPSK, etc.) and matched filter to use.
        """
elif False:
    ConfigDemodulationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigDemodulationConfigArgs:
    def __init__(__self__, *,
                 unvalidated_json: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] unvalidated_json: The demodulation settings are in JSON format and define parameters for demodulation, for example which modulation scheme (e.g. PSK, QPSK, etc.) and matched filter to use.
        """
        if unvalidated_json is not None:
            pulumi.set(__self__, "unvalidated_json", unvalidated_json)

    @property
    @pulumi.getter(name="unvalidatedJson")
    def unvalidated_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The demodulation settings are in JSON format and define parameters for demodulation, for example which modulation scheme (e.g. PSK, QPSK, etc.) and matched filter to use.
        """
        return pulumi.get(self, "unvalidated_json")

    @unvalidated_json.setter
    def unvalidated_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unvalidated_json", value)


if not MYPY:
    class ConfigEirpArgsDict(TypedDict):
        units: NotRequired[pulumi.Input['ConfigEirpUnits']]
        """
        The units of the EIRP.
        """
        value: NotRequired[pulumi.Input[builtins.float]]
        """
        The value of the EIRP. Valid values are between 20.0 to 50.0 dBW.
        """
elif False:
    ConfigEirpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigEirpArgs:
    def __init__(__self__, *,
                 units: Optional[pulumi.Input['ConfigEirpUnits']] = None,
                 value: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input['ConfigEirpUnits'] units: The units of the EIRP.
        :param pulumi.Input[builtins.float] value: The value of the EIRP. Valid values are between 20.0 to 50.0 dBW.
        """
        if units is not None:
            pulumi.set(__self__, "units", units)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input['ConfigEirpUnits']]:
        """
        The units of the EIRP.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input['ConfigEirpUnits']]):
        pulumi.set(self, "units", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value of the EIRP. Valid values are between 20.0 to 50.0 dBW.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ConfigFrequencyBandwidthArgsDict(TypedDict):
        units: NotRequired[pulumi.Input['ConfigBandwidthUnits']]
        """
        The units of the bandwidth.
        """
        value: NotRequired[pulumi.Input[builtins.float]]
        """
        The value of the bandwidth. AWS Ground Station currently has the following bandwidth limitations: 

        - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
        - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
        - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        """
elif False:
    ConfigFrequencyBandwidthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigFrequencyBandwidthArgs:
    def __init__(__self__, *,
                 units: Optional[pulumi.Input['ConfigBandwidthUnits']] = None,
                 value: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input['ConfigBandwidthUnits'] units: The units of the bandwidth.
        :param pulumi.Input[builtins.float] value: The value of the bandwidth. AWS Ground Station currently has the following bandwidth limitations: 
               
               - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
               - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
               - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        """
        if units is not None:
            pulumi.set(__self__, "units", units)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input['ConfigBandwidthUnits']]:
        """
        The units of the bandwidth.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input['ConfigBandwidthUnits']]):
        pulumi.set(self, "units", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value of the bandwidth. AWS Ground Station currently has the following bandwidth limitations: 

        - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
        - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
        - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ConfigFrequencyArgsDict(TypedDict):
        units: NotRequired[pulumi.Input['ConfigFrequencyUnits']]
        """
        The units of the frequency.
        """
        value: NotRequired[pulumi.Input[builtins.float]]
        """
        The value of the frequency. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
elif False:
    ConfigFrequencyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigFrequencyArgs:
    def __init__(__self__, *,
                 units: Optional[pulumi.Input['ConfigFrequencyUnits']] = None,
                 value: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input['ConfigFrequencyUnits'] units: The units of the frequency.
        :param pulumi.Input[builtins.float] value: The value of the frequency. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        if units is not None:
            pulumi.set(__self__, "units", units)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input['ConfigFrequencyUnits']]:
        """
        The units of the frequency.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input['ConfigFrequencyUnits']]):
        pulumi.set(self, "units", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value of the frequency. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ConfigS3RecordingConfigArgsDict(TypedDict):
        bucket_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        S3 Bucket where the data is written. The name of the S3 Bucket provided must begin with `aws-groundstation` .
        """
        prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The prefix of the S3 data object. If you choose to use any optional keys for substitution, these values will be replaced with the corresponding information from your contact details. For example, a prefix of `{satellite_id}/{year}/{month}/{day}/` will replaced with `fake_satellite_id/2021/01/10/`

        *Optional keys for substitution* : `{satellite_id}` | `{config-name}` | `{config-id}` | `{year}` | `{month}` | `{day}`
        """
        role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        Defines the ARN of the role assumed for putting archives to S3.
        """
elif False:
    ConfigS3RecordingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigS3RecordingConfigArgs:
    def __init__(__self__, *,
                 bucket_arn: Optional[pulumi.Input[builtins.str]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket_arn: S3 Bucket where the data is written. The name of the S3 Bucket provided must begin with `aws-groundstation` .
        :param pulumi.Input[builtins.str] prefix: The prefix of the S3 data object. If you choose to use any optional keys for substitution, these values will be replaced with the corresponding information from your contact details. For example, a prefix of `{satellite_id}/{year}/{month}/{day}/` will replaced with `fake_satellite_id/2021/01/10/`
               
               *Optional keys for substitution* : `{satellite_id}` | `{config-name}` | `{config-id}` | `{year}` | `{month}` | `{day}`
        :param pulumi.Input[builtins.str] role_arn: Defines the ARN of the role assumed for putting archives to S3.
        """
        if bucket_arn is not None:
            pulumi.set(__self__, "bucket_arn", bucket_arn)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 Bucket where the data is written. The name of the S3 Bucket provided must begin with `aws-groundstation` .
        """
        return pulumi.get(self, "bucket_arn")

    @bucket_arn.setter
    def bucket_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_arn", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The prefix of the S3 data object. If you choose to use any optional keys for substitution, these values will be replaced with the corresponding information from your contact details. For example, a prefix of `{satellite_id}/{year}/{month}/{day}/` will replaced with `fake_satellite_id/2021/01/10/`

        *Optional keys for substitution* : `{satellite_id}` | `{config-name}` | `{config-id}` | `{year}` | `{month}` | `{day}`
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the ARN of the role assumed for putting archives to S3.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class ConfigSpectrumConfigArgsDict(TypedDict):
        bandwidth: NotRequired[pulumi.Input['ConfigFrequencyBandwidthArgsDict']]
        """
        The bandwidth of the spectrum. AWS Ground Station currently has the following bandwidth limitations: 

        - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
        - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
        - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        """
        center_frequency: NotRequired[pulumi.Input['ConfigFrequencyArgsDict']]
        """
        The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        polarization: NotRequired[pulumi.Input['ConfigPolarization']]
        """
        The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` . Capturing both `"RIGHT_HAND"` and `"LEFT_HAND"` polarization requires two separate configs.
        """
elif False:
    ConfigSpectrumConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigSpectrumConfigArgs:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input['ConfigFrequencyBandwidthArgs']] = None,
                 center_frequency: Optional[pulumi.Input['ConfigFrequencyArgs']] = None,
                 polarization: Optional[pulumi.Input['ConfigPolarization']] = None):
        """
        :param pulumi.Input['ConfigFrequencyBandwidthArgs'] bandwidth: The bandwidth of the spectrum. AWS Ground Station currently has the following bandwidth limitations: 
               
               - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
               - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
               - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        :param pulumi.Input['ConfigFrequencyArgs'] center_frequency: The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        :param pulumi.Input['ConfigPolarization'] polarization: The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` . Capturing both `"RIGHT_HAND"` and `"LEFT_HAND"` polarization requires two separate configs.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if center_frequency is not None:
            pulumi.set(__self__, "center_frequency", center_frequency)
        if polarization is not None:
            pulumi.set(__self__, "polarization", polarization)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input['ConfigFrequencyBandwidthArgs']]:
        """
        The bandwidth of the spectrum. AWS Ground Station currently has the following bandwidth limitations: 

        - For `AntennaDownlinkDemodDecodeconfig` , valid values are between 125 kHz to 650 MHz.
        - For `AntennaDownlinkconfig` , valid values are between 10 kHz to 54 MHz.
        - For `AntennaUplinkConfig` , valid values are between 10 kHz to 54 MHz.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input['ConfigFrequencyBandwidthArgs']]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="centerFrequency")
    def center_frequency(self) -> Optional[pulumi.Input['ConfigFrequencyArgs']]:
        """
        The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        return pulumi.get(self, "center_frequency")

    @center_frequency.setter
    def center_frequency(self, value: Optional[pulumi.Input['ConfigFrequencyArgs']]):
        pulumi.set(self, "center_frequency", value)

    @property
    @pulumi.getter
    def polarization(self) -> Optional[pulumi.Input['ConfigPolarization']]:
        """
        The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` . Capturing both `"RIGHT_HAND"` and `"LEFT_HAND"` polarization requires two separate configs.
        """
        return pulumi.get(self, "polarization")

    @polarization.setter
    def polarization(self, value: Optional[pulumi.Input['ConfigPolarization']]):
        pulumi.set(self, "polarization", value)


if not MYPY:
    class ConfigTrackingConfigArgsDict(TypedDict):
        autotrack: NotRequired[pulumi.Input['ConfigTrackingConfigAutotrack']]
        """
        Specifies whether or not to use autotrack. `REMOVED` specifies that program track should only be used during the contact. `PREFERRED` specifies that autotracking is preferred during the contact but fallback to program track if the signal is lost. `REQUIRED` specifies that autotracking is required during the contact and not to use program track if the signal is lost.
        """
elif False:
    ConfigTrackingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigTrackingConfigArgs:
    def __init__(__self__, *,
                 autotrack: Optional[pulumi.Input['ConfigTrackingConfigAutotrack']] = None):
        """
        :param pulumi.Input['ConfigTrackingConfigAutotrack'] autotrack: Specifies whether or not to use autotrack. `REMOVED` specifies that program track should only be used during the contact. `PREFERRED` specifies that autotracking is preferred during the contact but fallback to program track if the signal is lost. `REQUIRED` specifies that autotracking is required during the contact and not to use program track if the signal is lost.
        """
        if autotrack is not None:
            pulumi.set(__self__, "autotrack", autotrack)

    @property
    @pulumi.getter
    def autotrack(self) -> Optional[pulumi.Input['ConfigTrackingConfigAutotrack']]:
        """
        Specifies whether or not to use autotrack. `REMOVED` specifies that program track should only be used during the contact. `PREFERRED` specifies that autotracking is preferred during the contact but fallback to program track if the signal is lost. `REQUIRED` specifies that autotracking is required during the contact and not to use program track if the signal is lost.
        """
        return pulumi.get(self, "autotrack")

    @autotrack.setter
    def autotrack(self, value: Optional[pulumi.Input['ConfigTrackingConfigAutotrack']]):
        pulumi.set(self, "autotrack", value)


if not MYPY:
    class ConfigUplinkEchoConfigArgsDict(TypedDict):
        antenna_uplink_config_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        Defines the ARN of the uplink config to echo back to a dataflow endpoint.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not uplink echo is enabled.
        """
elif False:
    ConfigUplinkEchoConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigUplinkEchoConfigArgs:
    def __init__(__self__, *,
                 antenna_uplink_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] antenna_uplink_config_arn: Defines the ARN of the uplink config to echo back to a dataflow endpoint.
        :param pulumi.Input[builtins.bool] enabled: Whether or not uplink echo is enabled.
        """
        if antenna_uplink_config_arn is not None:
            pulumi.set(__self__, "antenna_uplink_config_arn", antenna_uplink_config_arn)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="antennaUplinkConfigArn")
    def antenna_uplink_config_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the ARN of the uplink config to echo back to a dataflow endpoint.
        """
        return pulumi.get(self, "antenna_uplink_config_arn")

    @antenna_uplink_config_arn.setter
    def antenna_uplink_config_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "antenna_uplink_config_arn", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not uplink echo is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ConfigUplinkSpectrumConfigArgsDict(TypedDict):
        center_frequency: NotRequired[pulumi.Input['ConfigFrequencyArgsDict']]
        """
        The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        polarization: NotRequired[pulumi.Input['ConfigPolarization']]
        """
        The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` .
        """
elif False:
    ConfigUplinkSpectrumConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigUplinkSpectrumConfigArgs:
    def __init__(__self__, *,
                 center_frequency: Optional[pulumi.Input['ConfigFrequencyArgs']] = None,
                 polarization: Optional[pulumi.Input['ConfigPolarization']] = None):
        """
        :param pulumi.Input['ConfigFrequencyArgs'] center_frequency: The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        :param pulumi.Input['ConfigPolarization'] polarization: The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` .
        """
        if center_frequency is not None:
            pulumi.set(__self__, "center_frequency", center_frequency)
        if polarization is not None:
            pulumi.set(__self__, "polarization", polarization)

    @property
    @pulumi.getter(name="centerFrequency")
    def center_frequency(self) -> Optional[pulumi.Input['ConfigFrequencyArgs']]:
        """
        The center frequency of the spectrum. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
        """
        return pulumi.get(self, "center_frequency")

    @center_frequency.setter
    def center_frequency(self, value: Optional[pulumi.Input['ConfigFrequencyArgs']]):
        pulumi.set(self, "center_frequency", value)

    @property
    @pulumi.getter
    def polarization(self) -> Optional[pulumi.Input['ConfigPolarization']]:
        """
        The polarization of the spectrum. Valid values are `"RIGHT_HAND"` and `"LEFT_HAND"` .
        """
        return pulumi.get(self, "polarization")

    @polarization.setter
    def polarization(self, value: Optional[pulumi.Input['ConfigPolarization']]):
        pulumi.set(self, "polarization", value)


if not MYPY:
    class DataflowEndpointGroupAwsGroundStationAgentEndpointArgsDict(TypedDict):
        """
        Information about AwsGroundStationAgentEndpoint.
        """
        agent_status: NotRequired[pulumi.Input['DataflowEndpointGroupAgentStatus']]
        """
        The status of AgentEndpoint.
        """
        audit_results: NotRequired[pulumi.Input['DataflowEndpointGroupAuditResults']]
        """
        The results of the audit.
        """
        egress_address: NotRequired[pulumi.Input['DataflowEndpointGroupConnectionDetailsArgsDict']]
        """
        The egress address of AgentEndpoint.
        """
        ingress_address: NotRequired[pulumi.Input['DataflowEndpointGroupRangedConnectionDetailsArgsDict']]
        """
        The ingress address of AgentEndpoint.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
        """
elif False:
    DataflowEndpointGroupAwsGroundStationAgentEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupAwsGroundStationAgentEndpointArgs:
    def __init__(__self__, *,
                 agent_status: Optional[pulumi.Input['DataflowEndpointGroupAgentStatus']] = None,
                 audit_results: Optional[pulumi.Input['DataflowEndpointGroupAuditResults']] = None,
                 egress_address: Optional[pulumi.Input['DataflowEndpointGroupConnectionDetailsArgs']] = None,
                 ingress_address: Optional[pulumi.Input['DataflowEndpointGroupRangedConnectionDetailsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Information about AwsGroundStationAgentEndpoint.
        :param pulumi.Input['DataflowEndpointGroupAgentStatus'] agent_status: The status of AgentEndpoint.
        :param pulumi.Input['DataflowEndpointGroupAuditResults'] audit_results: The results of the audit.
        :param pulumi.Input['DataflowEndpointGroupConnectionDetailsArgs'] egress_address: The egress address of AgentEndpoint.
        :param pulumi.Input['DataflowEndpointGroupRangedConnectionDetailsArgs'] ingress_address: The ingress address of AgentEndpoint.
        :param pulumi.Input[builtins.str] name: Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
        """
        if agent_status is not None:
            pulumi.set(__self__, "agent_status", agent_status)
        if audit_results is not None:
            pulumi.set(__self__, "audit_results", audit_results)
        if egress_address is not None:
            pulumi.set(__self__, "egress_address", egress_address)
        if ingress_address is not None:
            pulumi.set(__self__, "ingress_address", ingress_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="agentStatus")
    def agent_status(self) -> Optional[pulumi.Input['DataflowEndpointGroupAgentStatus']]:
        """
        The status of AgentEndpoint.
        """
        return pulumi.get(self, "agent_status")

    @agent_status.setter
    def agent_status(self, value: Optional[pulumi.Input['DataflowEndpointGroupAgentStatus']]):
        pulumi.set(self, "agent_status", value)

    @property
    @pulumi.getter(name="auditResults")
    def audit_results(self) -> Optional[pulumi.Input['DataflowEndpointGroupAuditResults']]:
        """
        The results of the audit.
        """
        return pulumi.get(self, "audit_results")

    @audit_results.setter
    def audit_results(self, value: Optional[pulumi.Input['DataflowEndpointGroupAuditResults']]):
        pulumi.set(self, "audit_results", value)

    @property
    @pulumi.getter(name="egressAddress")
    def egress_address(self) -> Optional[pulumi.Input['DataflowEndpointGroupConnectionDetailsArgs']]:
        """
        The egress address of AgentEndpoint.
        """
        return pulumi.get(self, "egress_address")

    @egress_address.setter
    def egress_address(self, value: Optional[pulumi.Input['DataflowEndpointGroupConnectionDetailsArgs']]):
        pulumi.set(self, "egress_address", value)

    @property
    @pulumi.getter(name="ingressAddress")
    def ingress_address(self) -> Optional[pulumi.Input['DataflowEndpointGroupRangedConnectionDetailsArgs']]:
        """
        The ingress address of AgentEndpoint.
        """
        return pulumi.get(self, "ingress_address")

    @ingress_address.setter
    def ingress_address(self, value: Optional[pulumi.Input['DataflowEndpointGroupRangedConnectionDetailsArgs']]):
        pulumi.set(self, "ingress_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DataflowEndpointGroupConnectionDetailsArgsDict(TypedDict):
        """
        Egress address of AgentEndpoint with an optional mtu.
        """
        mtu: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        """
        socket_address: NotRequired[pulumi.Input['DataflowEndpointGroupSocketAddressArgsDict']]
        """
        A socket address.
        """
elif False:
    DataflowEndpointGroupConnectionDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupConnectionDetailsArgs:
    def __init__(__self__, *,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 socket_address: Optional[pulumi.Input['DataflowEndpointGroupSocketAddressArgs']] = None):
        """
        Egress address of AgentEndpoint with an optional mtu.
        :param pulumi.Input[builtins.int] mtu: Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        :param pulumi.Input['DataflowEndpointGroupSocketAddressArgs'] socket_address: A socket address.
        """
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if socket_address is not None:
            pulumi.set(__self__, "socket_address", socket_address)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter(name="socketAddress")
    def socket_address(self) -> Optional[pulumi.Input['DataflowEndpointGroupSocketAddressArgs']]:
        """
        A socket address.
        """
        return pulumi.get(self, "socket_address")

    @socket_address.setter
    def socket_address(self, value: Optional[pulumi.Input['DataflowEndpointGroupSocketAddressArgs']]):
        pulumi.set(self, "socket_address", value)


if not MYPY:
    class DataflowEndpointGroupDataflowEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input['DataflowEndpointGroupSocketAddressArgsDict']]
        """
        The address and port of an endpoint.
        """
        mtu: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint. Valid values are between 1400 and 1500. A default value of 1500 is used if not set.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The endpoint name.

        When listing available contacts for a satellite, Ground Station searches for a dataflow endpoint whose name matches the value specified by the dataflow endpoint config of the selected mission profile. If no matching dataflow endpoints are found then Ground Station will not display any available contacts for the satellite.
        """
elif False:
    DataflowEndpointGroupDataflowEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupDataflowEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input['DataflowEndpointGroupSocketAddressArgs']] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['DataflowEndpointGroupSocketAddressArgs'] address: The address and port of an endpoint.
        :param pulumi.Input[builtins.int] mtu: Maximum transmission unit (MTU) size in bytes of a dataflow endpoint. Valid values are between 1400 and 1500. A default value of 1500 is used if not set.
        :param pulumi.Input[builtins.str] name: The endpoint name.
               
               When listing available contacts for a satellite, Ground Station searches for a dataflow endpoint whose name matches the value specified by the dataflow endpoint config of the selected mission profile. If no matching dataflow endpoints are found then Ground Station will not display any available contacts for the satellite.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input['DataflowEndpointGroupSocketAddressArgs']]:
        """
        The address and port of an endpoint.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input['DataflowEndpointGroupSocketAddressArgs']]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint. Valid values are between 1400 and 1500. A default value of 1500 is used if not set.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint name.

        When listing available contacts for a satellite, Ground Station searches for a dataflow endpoint whose name matches the value specified by the dataflow endpoint config of the selected mission profile. If no matching dataflow endpoints are found then Ground Station will not display any available contacts for the satellite.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DataflowEndpointGroupEndpointDetailsArgsDict(TypedDict):
        aws_ground_station_agent_endpoint: NotRequired[pulumi.Input['DataflowEndpointGroupAwsGroundStationAgentEndpointArgsDict']]
        """
        An agent endpoint.
        """
        endpoint: NotRequired[pulumi.Input['DataflowEndpointGroupDataflowEndpointArgsDict']]
        """
        Information about the endpoint such as name and the endpoint address.
        """
        security_details: NotRequired[pulumi.Input['DataflowEndpointGroupSecurityDetailsArgsDict']]
        """
        The role ARN, and IDs for security groups and subnets.
        """
elif False:
    DataflowEndpointGroupEndpointDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupEndpointDetailsArgs:
    def __init__(__self__, *,
                 aws_ground_station_agent_endpoint: Optional[pulumi.Input['DataflowEndpointGroupAwsGroundStationAgentEndpointArgs']] = None,
                 endpoint: Optional[pulumi.Input['DataflowEndpointGroupDataflowEndpointArgs']] = None,
                 security_details: Optional[pulumi.Input['DataflowEndpointGroupSecurityDetailsArgs']] = None):
        """
        :param pulumi.Input['DataflowEndpointGroupAwsGroundStationAgentEndpointArgs'] aws_ground_station_agent_endpoint: An agent endpoint.
        :param pulumi.Input['DataflowEndpointGroupDataflowEndpointArgs'] endpoint: Information about the endpoint such as name and the endpoint address.
        :param pulumi.Input['DataflowEndpointGroupSecurityDetailsArgs'] security_details: The role ARN, and IDs for security groups and subnets.
        """
        if aws_ground_station_agent_endpoint is not None:
            pulumi.set(__self__, "aws_ground_station_agent_endpoint", aws_ground_station_agent_endpoint)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if security_details is not None:
            pulumi.set(__self__, "security_details", security_details)

    @property
    @pulumi.getter(name="awsGroundStationAgentEndpoint")
    def aws_ground_station_agent_endpoint(self) -> Optional[pulumi.Input['DataflowEndpointGroupAwsGroundStationAgentEndpointArgs']]:
        """
        An agent endpoint.
        """
        return pulumi.get(self, "aws_ground_station_agent_endpoint")

    @aws_ground_station_agent_endpoint.setter
    def aws_ground_station_agent_endpoint(self, value: Optional[pulumi.Input['DataflowEndpointGroupAwsGroundStationAgentEndpointArgs']]):
        pulumi.set(self, "aws_ground_station_agent_endpoint", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['DataflowEndpointGroupDataflowEndpointArgs']]:
        """
        Information about the endpoint such as name and the endpoint address.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['DataflowEndpointGroupDataflowEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="securityDetails")
    def security_details(self) -> Optional[pulumi.Input['DataflowEndpointGroupSecurityDetailsArgs']]:
        """
        The role ARN, and IDs for security groups and subnets.
        """
        return pulumi.get(self, "security_details")

    @security_details.setter
    def security_details(self, value: Optional[pulumi.Input['DataflowEndpointGroupSecurityDetailsArgs']]):
        pulumi.set(self, "security_details", value)


if not MYPY:
    class DataflowEndpointGroupIntegerRangeArgsDict(TypedDict):
        """
        An integer range that has a minimum and maximum value.
        """
        maximum: NotRequired[pulumi.Input[builtins.int]]
        """
        A maximum value.
        """
        minimum: NotRequired[pulumi.Input[builtins.int]]
        """
        A minimum value.
        """
elif False:
    DataflowEndpointGroupIntegerRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupIntegerRangeArgs:
    def __init__(__self__, *,
                 maximum: Optional[pulumi.Input[builtins.int]] = None,
                 minimum: Optional[pulumi.Input[builtins.int]] = None):
        """
        An integer range that has a minimum and maximum value.
        :param pulumi.Input[builtins.int] maximum: A maximum value.
        :param pulumi.Input[builtins.int] minimum: A minimum value.
        """
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def maximum(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A maximum value.
        """
        return pulumi.get(self, "maximum")

    @maximum.setter
    def maximum(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum", value)

    @property
    @pulumi.getter
    def minimum(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A minimum value.
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum", value)


if not MYPY:
    class DataflowEndpointGroupRangedConnectionDetailsArgsDict(TypedDict):
        """
        Ingress address of AgentEndpoint with a port range and an optional mtu.
        """
        mtu: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        """
        socket_address: NotRequired[pulumi.Input['DataflowEndpointGroupRangedSocketAddressArgsDict']]
        """
        A ranged socket address.
        """
elif False:
    DataflowEndpointGroupRangedConnectionDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupRangedConnectionDetailsArgs:
    def __init__(__self__, *,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 socket_address: Optional[pulumi.Input['DataflowEndpointGroupRangedSocketAddressArgs']] = None):
        """
        Ingress address of AgentEndpoint with a port range and an optional mtu.
        :param pulumi.Input[builtins.int] mtu: Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        :param pulumi.Input['DataflowEndpointGroupRangedSocketAddressArgs'] socket_address: A ranged socket address.
        """
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if socket_address is not None:
            pulumi.set(__self__, "socket_address", socket_address)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter(name="socketAddress")
    def socket_address(self) -> Optional[pulumi.Input['DataflowEndpointGroupRangedSocketAddressArgs']]:
        """
        A ranged socket address.
        """
        return pulumi.get(self, "socket_address")

    @socket_address.setter
    def socket_address(self, value: Optional[pulumi.Input['DataflowEndpointGroupRangedSocketAddressArgs']]):
        pulumi.set(self, "socket_address", value)


if not MYPY:
    class DataflowEndpointGroupRangedSocketAddressArgsDict(TypedDict):
        """
        A socket address with a port range.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        IPv4 socket address.
        """
        port_range: NotRequired[pulumi.Input['DataflowEndpointGroupIntegerRangeArgsDict']]
        """
        Port range of a socket address.
        """
elif False:
    DataflowEndpointGroupRangedSocketAddressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupRangedSocketAddressArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port_range: Optional[pulumi.Input['DataflowEndpointGroupIntegerRangeArgs']] = None):
        """
        A socket address with a port range.
        :param pulumi.Input[builtins.str] name: IPv4 socket address.
        :param pulumi.Input['DataflowEndpointGroupIntegerRangeArgs'] port_range: Port range of a socket address.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 socket address.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input['DataflowEndpointGroupIntegerRangeArgs']]:
        """
        Port range of a socket address.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input['DataflowEndpointGroupIntegerRangeArgs']]):
        pulumi.set(self, "port_range", value)


if not MYPY:
    class DataflowEndpointGroupSecurityDetailsArgsDict(TypedDict):
        role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of a role which Ground Station has permission to assume, such as `arn:aws:iam::1234567890:role/DataDeliveryServiceRole` .

        Ground Station will assume this role and create an ENI in your VPC on the specified subnet upon creation of a dataflow endpoint group. This ENI is used as the ingress/egress point for data streamed during a satellite contact.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The security group Ids of the security role, such as `sg-1234567890abcdef0` .
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The subnet Ids of the security details, such as `subnet-12345678` .
        """
elif False:
    DataflowEndpointGroupSecurityDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupSecurityDetailsArgs:
    def __init__(__self__, *,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] role_arn: The ARN of a role which Ground Station has permission to assume, such as `arn:aws:iam::1234567890:role/DataDeliveryServiceRole` .
               
               Ground Station will assume this role and create an ENI in your VPC on the specified subnet upon creation of a dataflow endpoint group. This ENI is used as the ingress/egress point for data streamed during a satellite contact.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The security group Ids of the security role, such as `sg-1234567890abcdef0` .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The subnet Ids of the security details, such as `subnet-12345678` .
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of a role which Ground Station has permission to assume, such as `arn:aws:iam::1234567890:role/DataDeliveryServiceRole` .

        Ground Station will assume this role and create an ENI in your VPC on the specified subnet upon creation of a dataflow endpoint group. This ENI is used as the ingress/egress point for data streamed during a satellite contact.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The security group Ids of the security role, such as `sg-1234567890abcdef0` .
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The subnet Ids of the security details, such as `subnet-12345678` .
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)


if not MYPY:
    class DataflowEndpointGroupSocketAddressArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the endpoint, such as `Endpoint 1` .
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port of the endpoint, such as `55888` .
        """
elif False:
    DataflowEndpointGroupSocketAddressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataflowEndpointGroupSocketAddressArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the endpoint, such as `Endpoint 1` .
        :param pulumi.Input[builtins.int] port: The port of the endpoint, such as `55888` .
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the endpoint, such as `Endpoint 1` .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port of the endpoint, such as `55888` .
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class MissionProfileDataflowEdgeArgsDict(TypedDict):
        destination: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the destination for this dataflow edge. For example, specify the ARN of a dataflow endpoint config for a downlink edge or an antenna uplink config for an uplink edge.
        """
        source: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the source for this dataflow edge. For example, specify the ARN of an antenna downlink config for a downlink edge or a dataflow endpoint config for an uplink edge.
        """
elif False:
    MissionProfileDataflowEdgeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MissionProfileDataflowEdgeArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] destination: The ARN of the destination for this dataflow edge. For example, specify the ARN of a dataflow endpoint config for a downlink edge or an antenna uplink config for an uplink edge.
        :param pulumi.Input[builtins.str] source: The ARN of the source for this dataflow edge. For example, specify the ARN of an antenna downlink config for a downlink edge or a dataflow endpoint config for an uplink edge.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the destination for this dataflow edge. For example, specify the ARN of a dataflow endpoint config for a downlink edge or an antenna uplink config for an uplink edge.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the source for this dataflow edge. For example, specify the ARN of an antenna downlink config for a downlink edge or a dataflow endpoint config for an uplink edge.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)


if not MYPY:
    class MissionProfileStreamsKmsKeyArgsDict(TypedDict):
        kms_alias_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        KMS Alias Arn.
        """
        kms_alias_name: NotRequired[pulumi.Input[builtins.str]]
        """
        KMS Alias Name.
        """
        kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        KMS Key Arn.
        """
elif False:
    MissionProfileStreamsKmsKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MissionProfileStreamsKmsKeyArgs:
    def __init__(__self__, *,
                 kms_alias_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_alias_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] kms_alias_arn: KMS Alias Arn.
        :param pulumi.Input[builtins.str] kms_alias_name: KMS Alias Name.
        :param pulumi.Input[builtins.str] kms_key_arn: KMS Key Arn.
        """
        if kms_alias_arn is not None:
            pulumi.set(__self__, "kms_alias_arn", kms_alias_arn)
        if kms_alias_name is not None:
            pulumi.set(__self__, "kms_alias_name", kms_alias_name)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="kmsAliasArn")
    def kms_alias_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS Alias Arn.
        """
        return pulumi.get(self, "kms_alias_arn")

    @kms_alias_arn.setter
    def kms_alias_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_alias_arn", value)

    @property
    @pulumi.getter(name="kmsAliasName")
    def kms_alias_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS Alias Name.
        """
        return pulumi.get(self, "kms_alias_name")

    @kms_alias_name.setter
    def kms_alias_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_alias_name", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS Key Arn.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)


