# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ComponentVersionComponentDependencyRequirement',
    'ComponentVersionComponentPlatform',
    'ComponentVersionLambdaContainerParams',
    'ComponentVersionLambdaDeviceMount',
    'ComponentVersionLambdaEventSource',
    'ComponentVersionLambdaExecutionParameters',
    'ComponentVersionLambdaFunctionRecipeSource',
    'ComponentVersionLambdaLinuxProcessParams',
    'ComponentVersionLambdaVolumeMount',
    'DeploymentComponentConfigurationUpdate',
    'DeploymentComponentDeploymentSpecification',
    'DeploymentComponentRunWith',
    'DeploymentComponentUpdatePolicy',
    'DeploymentConfigurationValidationPolicy',
    'DeploymentIoTJobAbortConfig',
    'DeploymentIoTJobAbortCriteria',
    'DeploymentIoTJobConfiguration',
    'DeploymentIoTJobExecutionsRolloutConfig',
    'DeploymentIoTJobExponentialRolloutRate',
    'DeploymentIoTJobRateIncreaseCriteria',
    'DeploymentIoTJobTimeoutConfig',
    'DeploymentPolicies',
    'DeploymentSystemResourceLimits',
]

@pulumi.output_type
class ComponentVersionComponentDependencyRequirement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependencyType":
            suggest = "dependency_type"
        elif key == "versionRequirement":
            suggest = "version_requirement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentVersionComponentDependencyRequirement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentVersionComponentDependencyRequirement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentVersionComponentDependencyRequirement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dependency_type: Optional['ComponentVersionComponentDependencyRequirementDependencyType'] = None,
                 version_requirement: Optional[builtins.str] = None):
        if dependency_type is not None:
            pulumi.set(__self__, "dependency_type", dependency_type)
        if version_requirement is not None:
            pulumi.set(__self__, "version_requirement", version_requirement)

    @property
    @pulumi.getter(name="dependencyType")
    def dependency_type(self) -> Optional['ComponentVersionComponentDependencyRequirementDependencyType']:
        return pulumi.get(self, "dependency_type")

    @property
    @pulumi.getter(name="versionRequirement")
    def version_requirement(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version_requirement")


@pulumi.output_type
class ComponentVersionComponentPlatform(dict):
    def __init__(__self__, *,
                 attributes: Optional[Mapping[str, builtins.str]] = None,
                 name: Optional[builtins.str] = None):
        """
        :param Mapping[str, builtins.str] attributes: A dictionary of attributes for the platform. The AWS IoT Greengrass Core software defines the `os` and `platform` by default. You can specify additional platform attributes for a core device when you deploy the AWS IoT Greengrass nucleus component. For more information, see the [AWS IoT Greengrass nucleus component](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html) in the *AWS IoT Greengrass V2 Developer Guide* .
        :param builtins.str name: The friendly name of the platform. This name helps you identify the platform.
               
               If you omit this parameter, AWS IoT Greengrass creates a friendly name from the `os` and `architecture` of the platform.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A dictionary of attributes for the platform. The AWS IoT Greengrass Core software defines the `os` and `platform` by default. You can specify additional platform attributes for a core device when you deploy the AWS IoT Greengrass nucleus component. For more information, see the [AWS IoT Greengrass nucleus component](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html) in the *AWS IoT Greengrass V2 Developer Guide* .
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The friendly name of the platform. This name helps you identify the platform.

        If you omit this parameter, AWS IoT Greengrass creates a friendly name from the `os` and `architecture` of the platform.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ComponentVersionLambdaContainerParams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memorySizeInKb":
            suggest = "memory_size_in_kb"
        elif key == "mountRoSysfs":
            suggest = "mount_ro_sysfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentVersionLambdaContainerParams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentVersionLambdaContainerParams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentVersionLambdaContainerParams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 devices: Optional[Sequence['outputs.ComponentVersionLambdaDeviceMount']] = None,
                 memory_size_in_kb: Optional[builtins.int] = None,
                 mount_ro_sysfs: Optional[builtins.bool] = None,
                 volumes: Optional[Sequence['outputs.ComponentVersionLambdaVolumeMount']] = None):
        """
        :param Sequence['ComponentVersionLambdaDeviceMount'] devices: The list of system devices that the container can access.
        :param builtins.int memory_size_in_kb: The memory size of the container, expressed in kilobytes.
               
               Default: `16384` (16 MB)
        :param builtins.bool mount_ro_sysfs: Whether or not the container can read information from the device's `/sys` folder.
               
               Default: `false`
        :param Sequence['ComponentVersionLambdaVolumeMount'] volumes: The list of volumes that the container can access.
        """
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if memory_size_in_kb is not None:
            pulumi.set(__self__, "memory_size_in_kb", memory_size_in_kb)
        if mount_ro_sysfs is not None:
            pulumi.set(__self__, "mount_ro_sysfs", mount_ro_sysfs)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.ComponentVersionLambdaDeviceMount']]:
        """
        The list of system devices that the container can access.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="memorySizeInKb")
    def memory_size_in_kb(self) -> Optional[builtins.int]:
        """
        The memory size of the container, expressed in kilobytes.

        Default: `16384` (16 MB)
        """
        return pulumi.get(self, "memory_size_in_kb")

    @property
    @pulumi.getter(name="mountRoSysfs")
    def mount_ro_sysfs(self) -> Optional[builtins.bool]:
        """
        Whether or not the container can read information from the device's `/sys` folder.

        Default: `false`
        """
        return pulumi.get(self, "mount_ro_sysfs")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.ComponentVersionLambdaVolumeMount']]:
        """
        The list of volumes that the container can access.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class ComponentVersionLambdaDeviceMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addGroupOwner":
            suggest = "add_group_owner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentVersionLambdaDeviceMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentVersionLambdaDeviceMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentVersionLambdaDeviceMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_group_owner: Optional[builtins.bool] = None,
                 path: Optional[builtins.str] = None,
                 permission: Optional['ComponentVersionLambdaFilesystemPermission'] = None):
        """
        :param builtins.bool add_group_owner: Whether or not to add the component's system user as an owner of the device.
               
               Default: `false`
        :param builtins.str path: The mount path for the device in the file system.
        :param 'ComponentVersionLambdaFilesystemPermission' permission: The permission to access the device: read/only ( `ro` ) or read/write ( `rw` ).
               
               Default: `ro`
        """
        if add_group_owner is not None:
            pulumi.set(__self__, "add_group_owner", add_group_owner)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter(name="addGroupOwner")
    def add_group_owner(self) -> Optional[builtins.bool]:
        """
        Whether or not to add the component's system user as an owner of the device.

        Default: `false`
        """
        return pulumi.get(self, "add_group_owner")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The mount path for the device in the file system.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def permission(self) -> Optional['ComponentVersionLambdaFilesystemPermission']:
        """
        The permission to access the device: read/only ( `ro` ) or read/write ( `rw` ).

        Default: `ro`
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ComponentVersionLambdaEventSource(dict):
    def __init__(__self__, *,
                 topic: Optional[builtins.str] = None,
                 type: Optional['ComponentVersionLambdaEventSourceType'] = None):
        """
        :param builtins.str topic: The topic to which to subscribe to receive event messages.
        :param 'ComponentVersionLambdaEventSourceType' type: The type of event source. Choose from the following options:
               
               - `PUB_SUB` – Subscribe to local publish/subscribe messages. This event source type doesn't support MQTT wildcards ( `+` and `#` ) in the event source topic.
               - `IOT_CORE` – Subscribe to AWS IoT Core MQTT messages. This event source type supports MQTT wildcards ( `+` and `#` ) in the event source topic.
        """
        if topic is not None:
            pulumi.set(__self__, "topic", topic)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def topic(self) -> Optional[builtins.str]:
        """
        The topic to which to subscribe to receive event messages.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def type(self) -> Optional['ComponentVersionLambdaEventSourceType']:
        """
        The type of event source. Choose from the following options:

        - `PUB_SUB` – Subscribe to local publish/subscribe messages. This event source type doesn't support MQTT wildcards ( `+` and `#` ) in the event source topic.
        - `IOT_CORE` – Subscribe to AWS IoT Core MQTT messages. This event source type supports MQTT wildcards ( `+` and `#` ) in the event source topic.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ComponentVersionLambdaExecutionParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "eventSources":
            suggest = "event_sources"
        elif key == "execArgs":
            suggest = "exec_args"
        elif key == "inputPayloadEncodingType":
            suggest = "input_payload_encoding_type"
        elif key == "linuxProcessParams":
            suggest = "linux_process_params"
        elif key == "maxIdleTimeInSeconds":
            suggest = "max_idle_time_in_seconds"
        elif key == "maxInstancesCount":
            suggest = "max_instances_count"
        elif key == "maxQueueSize":
            suggest = "max_queue_size"
        elif key == "statusTimeoutInSeconds":
            suggest = "status_timeout_in_seconds"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentVersionLambdaExecutionParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentVersionLambdaExecutionParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentVersionLambdaExecutionParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_variables: Optional[Mapping[str, builtins.str]] = None,
                 event_sources: Optional[Sequence['outputs.ComponentVersionLambdaEventSource']] = None,
                 exec_args: Optional[Sequence[builtins.str]] = None,
                 input_payload_encoding_type: Optional['ComponentVersionLambdaExecutionParametersInputPayloadEncodingType'] = None,
                 linux_process_params: Optional['outputs.ComponentVersionLambdaLinuxProcessParams'] = None,
                 max_idle_time_in_seconds: Optional[builtins.int] = None,
                 max_instances_count: Optional[builtins.int] = None,
                 max_queue_size: Optional[builtins.int] = None,
                 pinned: Optional[builtins.bool] = None,
                 status_timeout_in_seconds: Optional[builtins.int] = None,
                 timeout_in_seconds: Optional[builtins.int] = None):
        """
        :param Mapping[str, builtins.str] environment_variables: The map of environment variables that are available to the Lambda function when it runs.
        :param Sequence['ComponentVersionLambdaEventSource'] event_sources: The list of event sources to which to subscribe to receive work messages. The Lambda function runs when it receives a message from an event source. You can subscribe this function to local publish/subscribe messages and AWS IoT Core MQTT messages.
        :param Sequence[builtins.str] exec_args: The list of arguments to pass to the Lambda function when it runs.
        :param 'ComponentVersionLambdaExecutionParametersInputPayloadEncodingType' input_payload_encoding_type: The encoding type that the Lambda function supports.
               
               Default: `json`
        :param 'ComponentVersionLambdaLinuxProcessParams' linux_process_params: The parameters for the Linux process that contains the Lambda function.
        :param builtins.int max_idle_time_in_seconds: The maximum amount of time in seconds that a non-pinned Lambda function can idle before the AWS IoT Greengrass Core software stops its process.
        :param builtins.int max_instances_count: The maximum number of instances that a non-pinned Lambda function can run at the same time.
        :param builtins.int max_queue_size: The maximum size of the message queue for the Lambda function component. The AWS IoT Greengrass core device stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to consume each message.
        :param builtins.bool pinned: Whether or not the Lambda function is pinned, or long-lived.
               
               - A pinned Lambda function starts when the AWS IoT Greengrass Core starts and keeps running in its own container.
               - A non-pinned Lambda function starts only when it receives a work item and exists after it idles for `maxIdleTimeInSeconds` . If the function has multiple work items, the AWS IoT Greengrass Core software creates multiple instances of the function.
               
               Default: `true`
        :param builtins.int status_timeout_in_seconds: The interval in seconds at which a pinned (also known as long-lived) Lambda function component sends status updates to the Lambda manager component.
        :param builtins.int timeout_in_seconds: The maximum amount of time in seconds that the Lambda function can process a work item.
        """
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if event_sources is not None:
            pulumi.set(__self__, "event_sources", event_sources)
        if exec_args is not None:
            pulumi.set(__self__, "exec_args", exec_args)
        if input_payload_encoding_type is not None:
            pulumi.set(__self__, "input_payload_encoding_type", input_payload_encoding_type)
        if linux_process_params is not None:
            pulumi.set(__self__, "linux_process_params", linux_process_params)
        if max_idle_time_in_seconds is not None:
            pulumi.set(__self__, "max_idle_time_in_seconds", max_idle_time_in_seconds)
        if max_instances_count is not None:
            pulumi.set(__self__, "max_instances_count", max_instances_count)
        if max_queue_size is not None:
            pulumi.set(__self__, "max_queue_size", max_queue_size)
        if pinned is not None:
            pulumi.set(__self__, "pinned", pinned)
        if status_timeout_in_seconds is not None:
            pulumi.set(__self__, "status_timeout_in_seconds", status_timeout_in_seconds)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The map of environment variables that are available to the Lambda function when it runs.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="eventSources")
    def event_sources(self) -> Optional[Sequence['outputs.ComponentVersionLambdaEventSource']]:
        """
        The list of event sources to which to subscribe to receive work messages. The Lambda function runs when it receives a message from an event source. You can subscribe this function to local publish/subscribe messages and AWS IoT Core MQTT messages.
        """
        return pulumi.get(self, "event_sources")

    @property
    @pulumi.getter(name="execArgs")
    def exec_args(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of arguments to pass to the Lambda function when it runs.
        """
        return pulumi.get(self, "exec_args")

    @property
    @pulumi.getter(name="inputPayloadEncodingType")
    def input_payload_encoding_type(self) -> Optional['ComponentVersionLambdaExecutionParametersInputPayloadEncodingType']:
        """
        The encoding type that the Lambda function supports.

        Default: `json`
        """
        return pulumi.get(self, "input_payload_encoding_type")

    @property
    @pulumi.getter(name="linuxProcessParams")
    def linux_process_params(self) -> Optional['outputs.ComponentVersionLambdaLinuxProcessParams']:
        """
        The parameters for the Linux process that contains the Lambda function.
        """
        return pulumi.get(self, "linux_process_params")

    @property
    @pulumi.getter(name="maxIdleTimeInSeconds")
    def max_idle_time_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum amount of time in seconds that a non-pinned Lambda function can idle before the AWS IoT Greengrass Core software stops its process.
        """
        return pulumi.get(self, "max_idle_time_in_seconds")

    @property
    @pulumi.getter(name="maxInstancesCount")
    def max_instances_count(self) -> Optional[builtins.int]:
        """
        The maximum number of instances that a non-pinned Lambda function can run at the same time.
        """
        return pulumi.get(self, "max_instances_count")

    @property
    @pulumi.getter(name="maxQueueSize")
    def max_queue_size(self) -> Optional[builtins.int]:
        """
        The maximum size of the message queue for the Lambda function component. The AWS IoT Greengrass core device stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to consume each message.
        """
        return pulumi.get(self, "max_queue_size")

    @property
    @pulumi.getter
    def pinned(self) -> Optional[builtins.bool]:
        """
        Whether or not the Lambda function is pinned, or long-lived.

        - A pinned Lambda function starts when the AWS IoT Greengrass Core starts and keeps running in its own container.
        - A non-pinned Lambda function starts only when it receives a work item and exists after it idles for `maxIdleTimeInSeconds` . If the function has multiple work items, the AWS IoT Greengrass Core software creates multiple instances of the function.

        Default: `true`
        """
        return pulumi.get(self, "pinned")

    @property
    @pulumi.getter(name="statusTimeoutInSeconds")
    def status_timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        The interval in seconds at which a pinned (also known as long-lived) Lambda function component sends status updates to the Lambda manager component.
        """
        return pulumi.get(self, "status_timeout_in_seconds")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum amount of time in seconds that the Lambda function can process a work item.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class ComponentVersionLambdaFunctionRecipeSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentDependencies":
            suggest = "component_dependencies"
        elif key == "componentLambdaParameters":
            suggest = "component_lambda_parameters"
        elif key == "componentName":
            suggest = "component_name"
        elif key == "componentPlatforms":
            suggest = "component_platforms"
        elif key == "componentVersion":
            suggest = "component_version"
        elif key == "lambdaArn":
            suggest = "lambda_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentVersionLambdaFunctionRecipeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentVersionLambdaFunctionRecipeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentVersionLambdaFunctionRecipeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_dependencies: Optional[Mapping[str, 'outputs.ComponentVersionComponentDependencyRequirement']] = None,
                 component_lambda_parameters: Optional['outputs.ComponentVersionLambdaExecutionParameters'] = None,
                 component_name: Optional[builtins.str] = None,
                 component_platforms: Optional[Sequence['outputs.ComponentVersionComponentPlatform']] = None,
                 component_version: Optional[builtins.str] = None,
                 lambda_arn: Optional[builtins.str] = None):
        """
        :param Mapping[str, 'ComponentVersionComponentDependencyRequirement'] component_dependencies: The component versions on which this Lambda function component depends.
        :param 'ComponentVersionLambdaExecutionParameters' component_lambda_parameters: The system and runtime parameters for the Lambda function as it runs on the AWS IoT Greengrass core device.
        :param builtins.str component_name: The name of the component.
               
               Defaults to the name of the Lambda function.
        :param Sequence['ComponentVersionComponentPlatform'] component_platforms: The platforms that the component version supports.
        :param builtins.str component_version: The version of the component.
               
               Defaults to the version of the Lambda function as a semantic version. For example, if your function version is `3` , the component version becomes `3.0.0` .
        :param builtins.str lambda_arn: The ARN of the Lambda function. The ARN must include the version of the function to import. You can't use version aliases like `$LATEST` .
        """
        if component_dependencies is not None:
            pulumi.set(__self__, "component_dependencies", component_dependencies)
        if component_lambda_parameters is not None:
            pulumi.set(__self__, "component_lambda_parameters", component_lambda_parameters)
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if component_platforms is not None:
            pulumi.set(__self__, "component_platforms", component_platforms)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if lambda_arn is not None:
            pulumi.set(__self__, "lambda_arn", lambda_arn)

    @property
    @pulumi.getter(name="componentDependencies")
    def component_dependencies(self) -> Optional[Mapping[str, 'outputs.ComponentVersionComponentDependencyRequirement']]:
        """
        The component versions on which this Lambda function component depends.
        """
        return pulumi.get(self, "component_dependencies")

    @property
    @pulumi.getter(name="componentLambdaParameters")
    def component_lambda_parameters(self) -> Optional['outputs.ComponentVersionLambdaExecutionParameters']:
        """
        The system and runtime parameters for the Lambda function as it runs on the AWS IoT Greengrass core device.
        """
        return pulumi.get(self, "component_lambda_parameters")

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[builtins.str]:
        """
        The name of the component.

        Defaults to the name of the Lambda function.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter(name="componentPlatforms")
    def component_platforms(self) -> Optional[Sequence['outputs.ComponentVersionComponentPlatform']]:
        """
        The platforms that the component version supports.
        """
        return pulumi.get(self, "component_platforms")

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[builtins.str]:
        """
        The version of the component.

        Defaults to the version of the Lambda function as a semantic version. For example, if your function version is `3` , the component version becomes `3.0.0` .
        """
        return pulumi.get(self, "component_version")

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the Lambda function. The ARN must include the version of the function to import. You can't use version aliases like `$LATEST` .
        """
        return pulumi.get(self, "lambda_arn")


@pulumi.output_type
class ComponentVersionLambdaLinuxProcessParams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerParams":
            suggest = "container_params"
        elif key == "isolationMode":
            suggest = "isolation_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentVersionLambdaLinuxProcessParams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentVersionLambdaLinuxProcessParams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentVersionLambdaLinuxProcessParams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_params: Optional['outputs.ComponentVersionLambdaContainerParams'] = None,
                 isolation_mode: Optional['ComponentVersionLambdaLinuxProcessParamsIsolationMode'] = None):
        """
        :param 'ComponentVersionLambdaContainerParams' container_params: The parameters for the container in which the Lambda function runs.
        :param 'ComponentVersionLambdaLinuxProcessParamsIsolationMode' isolation_mode: The isolation mode for the process that contains the Lambda function. The process can run in an isolated runtime environment inside the AWS IoT Greengrass container, or as a regular process outside any container.
               
               Default: `GreengrassContainer`
        """
        if container_params is not None:
            pulumi.set(__self__, "container_params", container_params)
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)

    @property
    @pulumi.getter(name="containerParams")
    def container_params(self) -> Optional['outputs.ComponentVersionLambdaContainerParams']:
        """
        The parameters for the container in which the Lambda function runs.
        """
        return pulumi.get(self, "container_params")

    @property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional['ComponentVersionLambdaLinuxProcessParamsIsolationMode']:
        """
        The isolation mode for the process that contains the Lambda function. The process can run in an isolated runtime environment inside the AWS IoT Greengrass container, or as a regular process outside any container.

        Default: `GreengrassContainer`
        """
        return pulumi.get(self, "isolation_mode")


@pulumi.output_type
class ComponentVersionLambdaVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addGroupOwner":
            suggest = "add_group_owner"
        elif key == "destinationPath":
            suggest = "destination_path"
        elif key == "sourcePath":
            suggest = "source_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentVersionLambdaVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentVersionLambdaVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentVersionLambdaVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_group_owner: Optional[builtins.bool] = None,
                 destination_path: Optional[builtins.str] = None,
                 permission: Optional['ComponentVersionLambdaFilesystemPermission'] = None,
                 source_path: Optional[builtins.str] = None):
        """
        :param builtins.bool add_group_owner: Whether or not to add the AWS IoT Greengrass user group as an owner of the volume.
               
               Default: `false`
        :param builtins.str destination_path: The path to the logical volume in the file system.
        :param 'ComponentVersionLambdaFilesystemPermission' permission: The permission to access the volume: read/only ( `ro` ) or read/write ( `rw` ).
               
               Default: `ro`
        :param builtins.str source_path: The path to the physical volume in the file system.
        """
        if add_group_owner is not None:
            pulumi.set(__self__, "add_group_owner", add_group_owner)
        if destination_path is not None:
            pulumi.set(__self__, "destination_path", destination_path)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)

    @property
    @pulumi.getter(name="addGroupOwner")
    def add_group_owner(self) -> Optional[builtins.bool]:
        """
        Whether or not to add the AWS IoT Greengrass user group as an owner of the volume.

        Default: `false`
        """
        return pulumi.get(self, "add_group_owner")

    @property
    @pulumi.getter(name="destinationPath")
    def destination_path(self) -> Optional[builtins.str]:
        """
        The path to the logical volume in the file system.
        """
        return pulumi.get(self, "destination_path")

    @property
    @pulumi.getter
    def permission(self) -> Optional['ComponentVersionLambdaFilesystemPermission']:
        """
        The permission to access the volume: read/only ( `ro` ) or read/write ( `rw` ).

        Default: `ro`
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[builtins.str]:
        """
        The path to the physical volume in the file system.
        """
        return pulumi.get(self, "source_path")


@pulumi.output_type
class DeploymentComponentConfigurationUpdate(dict):
    def __init__(__self__, *,
                 merge: Optional[builtins.str] = None,
                 reset: Optional[Sequence[builtins.str]] = None):
        if merge is not None:
            pulumi.set(__self__, "merge", merge)
        if reset is not None:
            pulumi.set(__self__, "reset", reset)

    @property
    @pulumi.getter
    def merge(self) -> Optional[builtins.str]:
        return pulumi.get(self, "merge")

    @property
    @pulumi.getter
    def reset(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "reset")


@pulumi.output_type
class DeploymentComponentDeploymentSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentVersion":
            suggest = "component_version"
        elif key == "configurationUpdate":
            suggest = "configuration_update"
        elif key == "runWith":
            suggest = "run_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentComponentDeploymentSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentComponentDeploymentSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentComponentDeploymentSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_version: Optional[builtins.str] = None,
                 configuration_update: Optional['outputs.DeploymentComponentConfigurationUpdate'] = None,
                 run_with: Optional['outputs.DeploymentComponentRunWith'] = None):
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if configuration_update is not None:
            pulumi.set(__self__, "configuration_update", configuration_update)
        if run_with is not None:
            pulumi.set(__self__, "run_with", run_with)

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "component_version")

    @property
    @pulumi.getter(name="configurationUpdate")
    def configuration_update(self) -> Optional['outputs.DeploymentComponentConfigurationUpdate']:
        return pulumi.get(self, "configuration_update")

    @property
    @pulumi.getter(name="runWith")
    def run_with(self) -> Optional['outputs.DeploymentComponentRunWith']:
        return pulumi.get(self, "run_with")


@pulumi.output_type
class DeploymentComponentRunWith(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "posixUser":
            suggest = "posix_user"
        elif key == "systemResourceLimits":
            suggest = "system_resource_limits"
        elif key == "windowsUser":
            suggest = "windows_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentComponentRunWith. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentComponentRunWith.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentComponentRunWith.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 posix_user: Optional[builtins.str] = None,
                 system_resource_limits: Optional['outputs.DeploymentSystemResourceLimits'] = None,
                 windows_user: Optional[builtins.str] = None):
        if posix_user is not None:
            pulumi.set(__self__, "posix_user", posix_user)
        if system_resource_limits is not None:
            pulumi.set(__self__, "system_resource_limits", system_resource_limits)
        if windows_user is not None:
            pulumi.set(__self__, "windows_user", windows_user)

    @property
    @pulumi.getter(name="posixUser")
    def posix_user(self) -> Optional[builtins.str]:
        return pulumi.get(self, "posix_user")

    @property
    @pulumi.getter(name="systemResourceLimits")
    def system_resource_limits(self) -> Optional['outputs.DeploymentSystemResourceLimits']:
        return pulumi.get(self, "system_resource_limits")

    @property
    @pulumi.getter(name="windowsUser")
    def windows_user(self) -> Optional[builtins.str]:
        return pulumi.get(self, "windows_user")


@pulumi.output_type
class DeploymentComponentUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentComponentUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentComponentUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentComponentUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional['DeploymentComponentUpdatePolicyAction'] = None,
                 timeout_in_seconds: Optional[builtins.int] = None):
        """
        :param 'DeploymentComponentUpdatePolicyAction' action: Whether or not to notify components and wait for components to become safe to update. Choose from the following options:
               
               - `NOTIFY_COMPONENTS` – The deployment notifies each component before it stops and updates that component. Components can use the [SubscribeToComponentUpdates](https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates) IPC operation to receive these notifications. Then, components can respond with the [DeferComponentUpdate](https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate) IPC operation. For more information, see the [Create deployments](https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html) in the *AWS IoT Greengrass V2 Developer Guide* .
               - `SKIP_NOTIFY_COMPONENTS` – The deployment doesn't notify components or wait for them to be safe to update.
               
               Default: `NOTIFY_COMPONENTS`
        :param builtins.int timeout_in_seconds: The amount of time in seconds that each component on a device has to report that it's safe to update. If the component waits for longer than this timeout, then the deployment proceeds on the device.
               
               Default: `60`
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter
    def action(self) -> Optional['DeploymentComponentUpdatePolicyAction']:
        """
        Whether or not to notify components and wait for components to become safe to update. Choose from the following options:

        - `NOTIFY_COMPONENTS` – The deployment notifies each component before it stops and updates that component. Components can use the [SubscribeToComponentUpdates](https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates) IPC operation to receive these notifications. Then, components can respond with the [DeferComponentUpdate](https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate) IPC operation. For more information, see the [Create deployments](https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html) in the *AWS IoT Greengrass V2 Developer Guide* .
        - `SKIP_NOTIFY_COMPONENTS` – The deployment doesn't notify components or wait for them to be safe to update.

        Default: `NOTIFY_COMPONENTS`
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        The amount of time in seconds that each component on a device has to report that it's safe to update. If the component waits for longer than this timeout, then the deployment proceeds on the device.

        Default: `60`
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class DeploymentConfigurationValidationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentConfigurationValidationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentConfigurationValidationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentConfigurationValidationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeout_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int timeout_in_seconds: The amount of time in seconds that a component can validate its configuration updates. If the validation time exceeds this timeout, then the deployment proceeds for the device.
               
               Default: `30`
        """
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        The amount of time in seconds that a component can validate its configuration updates. If the validation time exceeds this timeout, then the deployment proceeds for the device.

        Default: `30`
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class DeploymentIoTJobAbortConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "criteriaList":
            suggest = "criteria_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIoTJobAbortConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIoTJobAbortConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIoTJobAbortConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criteria_list: Sequence['outputs.DeploymentIoTJobAbortCriteria']):
        """
        :param Sequence['DeploymentIoTJobAbortCriteria'] criteria_list: The list of criteria that define when and how to cancel the configuration deployment.
        """
        pulumi.set(__self__, "criteria_list", criteria_list)

    @property
    @pulumi.getter(name="criteriaList")
    def criteria_list(self) -> Sequence['outputs.DeploymentIoTJobAbortCriteria']:
        """
        The list of criteria that define when and how to cancel the configuration deployment.
        """
        return pulumi.get(self, "criteria_list")


@pulumi.output_type
class DeploymentIoTJobAbortCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureType":
            suggest = "failure_type"
        elif key == "minNumberOfExecutedThings":
            suggest = "min_number_of_executed_things"
        elif key == "thresholdPercentage":
            suggest = "threshold_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIoTJobAbortCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIoTJobAbortCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIoTJobAbortCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'DeploymentIoTJobAbortCriteriaAction',
                 failure_type: 'DeploymentIoTJobAbortCriteriaFailureType',
                 min_number_of_executed_things: builtins.int,
                 threshold_percentage: builtins.float):
        """
        :param 'DeploymentIoTJobAbortCriteriaAction' action: The action to perform when the criteria are met.
        :param 'DeploymentIoTJobAbortCriteriaFailureType' failure_type: The type of job deployment failure that can cancel a job.
        :param builtins.int min_number_of_executed_things: The minimum number of things that receive the configuration before the job can cancel.
        :param builtins.float threshold_percentage: The minimum percentage of `failureType` failures that occur before the job can cancel.
               
               This parameter supports up to two digits after the decimal (for example, you can specify `10.9` or `10.99` , but not `10.999` ).
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "failure_type", failure_type)
        pulumi.set(__self__, "min_number_of_executed_things", min_number_of_executed_things)
        pulumi.set(__self__, "threshold_percentage", threshold_percentage)

    @property
    @pulumi.getter
    def action(self) -> 'DeploymentIoTJobAbortCriteriaAction':
        """
        The action to perform when the criteria are met.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="failureType")
    def failure_type(self) -> 'DeploymentIoTJobAbortCriteriaFailureType':
        """
        The type of job deployment failure that can cancel a job.
        """
        return pulumi.get(self, "failure_type")

    @property
    @pulumi.getter(name="minNumberOfExecutedThings")
    def min_number_of_executed_things(self) -> builtins.int:
        """
        The minimum number of things that receive the configuration before the job can cancel.
        """
        return pulumi.get(self, "min_number_of_executed_things")

    @property
    @pulumi.getter(name="thresholdPercentage")
    def threshold_percentage(self) -> builtins.float:
        """
        The minimum percentage of `failureType` failures that occur before the job can cancel.

        This parameter supports up to two digits after the decimal (for example, you can specify `10.9` or `10.99` , but not `10.999` ).
        """
        return pulumi.get(self, "threshold_percentage")


@pulumi.output_type
class DeploymentIoTJobConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortConfig":
            suggest = "abort_config"
        elif key == "jobExecutionsRolloutConfig":
            suggest = "job_executions_rollout_config"
        elif key == "timeoutConfig":
            suggest = "timeout_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIoTJobConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIoTJobConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIoTJobConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 abort_config: Optional['outputs.DeploymentIoTJobAbortConfig'] = None,
                 job_executions_rollout_config: Optional['outputs.DeploymentIoTJobExecutionsRolloutConfig'] = None,
                 timeout_config: Optional['outputs.DeploymentIoTJobTimeoutConfig'] = None):
        """
        :param 'DeploymentIoTJobAbortConfig' abort_config: The stop configuration for the job. This configuration defines when and how to stop a job rollout.
        :param 'DeploymentIoTJobExecutionsRolloutConfig' job_executions_rollout_config: The rollout configuration for the job. This configuration defines the rate at which the job rolls out to the fleet of target devices.
        :param 'DeploymentIoTJobTimeoutConfig' timeout_config: The timeout configuration for the job. This configuration defines the amount of time each device has to complete the job.
        """
        if abort_config is not None:
            pulumi.set(__self__, "abort_config", abort_config)
        if job_executions_rollout_config is not None:
            pulumi.set(__self__, "job_executions_rollout_config", job_executions_rollout_config)
        if timeout_config is not None:
            pulumi.set(__self__, "timeout_config", timeout_config)

    @property
    @pulumi.getter(name="abortConfig")
    def abort_config(self) -> Optional['outputs.DeploymentIoTJobAbortConfig']:
        """
        The stop configuration for the job. This configuration defines when and how to stop a job rollout.
        """
        return pulumi.get(self, "abort_config")

    @property
    @pulumi.getter(name="jobExecutionsRolloutConfig")
    def job_executions_rollout_config(self) -> Optional['outputs.DeploymentIoTJobExecutionsRolloutConfig']:
        """
        The rollout configuration for the job. This configuration defines the rate at which the job rolls out to the fleet of target devices.
        """
        return pulumi.get(self, "job_executions_rollout_config")

    @property
    @pulumi.getter(name="timeoutConfig")
    def timeout_config(self) -> Optional['outputs.DeploymentIoTJobTimeoutConfig']:
        """
        The timeout configuration for the job. This configuration defines the amount of time each device has to complete the job.
        """
        return pulumi.get(self, "timeout_config")


@pulumi.output_type
class DeploymentIoTJobExecutionsRolloutConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exponentialRate":
            suggest = "exponential_rate"
        elif key == "maximumPerMinute":
            suggest = "maximum_per_minute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIoTJobExecutionsRolloutConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIoTJobExecutionsRolloutConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIoTJobExecutionsRolloutConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exponential_rate: Optional['outputs.DeploymentIoTJobExponentialRolloutRate'] = None,
                 maximum_per_minute: Optional[builtins.int] = None):
        """
        :param 'DeploymentIoTJobExponentialRolloutRate' exponential_rate: The exponential rate to increase the job rollout rate.
        :param builtins.int maximum_per_minute: The maximum number of devices that receive a pending job notification, per minute.
        """
        if exponential_rate is not None:
            pulumi.set(__self__, "exponential_rate", exponential_rate)
        if maximum_per_minute is not None:
            pulumi.set(__self__, "maximum_per_minute", maximum_per_minute)

    @property
    @pulumi.getter(name="exponentialRate")
    def exponential_rate(self) -> Optional['outputs.DeploymentIoTJobExponentialRolloutRate']:
        """
        The exponential rate to increase the job rollout rate.
        """
        return pulumi.get(self, "exponential_rate")

    @property
    @pulumi.getter(name="maximumPerMinute")
    def maximum_per_minute(self) -> Optional[builtins.int]:
        """
        The maximum number of devices that receive a pending job notification, per minute.
        """
        return pulumi.get(self, "maximum_per_minute")


@pulumi.output_type
class DeploymentIoTJobExponentialRolloutRate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseRatePerMinute":
            suggest = "base_rate_per_minute"
        elif key == "incrementFactor":
            suggest = "increment_factor"
        elif key == "rateIncreaseCriteria":
            suggest = "rate_increase_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIoTJobExponentialRolloutRate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIoTJobExponentialRolloutRate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIoTJobExponentialRolloutRate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_rate_per_minute: builtins.int,
                 increment_factor: builtins.float,
                 rate_increase_criteria: 'outputs.DeploymentIoTJobRateIncreaseCriteria'):
        """
        :param builtins.int base_rate_per_minute: The minimum number of devices that receive a pending job notification, per minute, when the job starts. This parameter defines the initial rollout rate of the job.
        :param builtins.float increment_factor: The exponential factor to increase the rollout rate for the job.
               
               This parameter supports up to one digit after the decimal (for example, you can specify `1.5` , but not `1.55` ).
        :param 'DeploymentIoTJobRateIncreaseCriteria' rate_increase_criteria: The criteria to increase the rollout rate for the job.
        """
        pulumi.set(__self__, "base_rate_per_minute", base_rate_per_minute)
        pulumi.set(__self__, "increment_factor", increment_factor)
        pulumi.set(__self__, "rate_increase_criteria", rate_increase_criteria)

    @property
    @pulumi.getter(name="baseRatePerMinute")
    def base_rate_per_minute(self) -> builtins.int:
        """
        The minimum number of devices that receive a pending job notification, per minute, when the job starts. This parameter defines the initial rollout rate of the job.
        """
        return pulumi.get(self, "base_rate_per_minute")

    @property
    @pulumi.getter(name="incrementFactor")
    def increment_factor(self) -> builtins.float:
        """
        The exponential factor to increase the rollout rate for the job.

        This parameter supports up to one digit after the decimal (for example, you can specify `1.5` , but not `1.55` ).
        """
        return pulumi.get(self, "increment_factor")

    @property
    @pulumi.getter(name="rateIncreaseCriteria")
    def rate_increase_criteria(self) -> 'outputs.DeploymentIoTJobRateIncreaseCriteria':
        """
        The criteria to increase the rollout rate for the job.
        """
        return pulumi.get(self, "rate_increase_criteria")


@pulumi.output_type
class DeploymentIoTJobRateIncreaseCriteria(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DeploymentIoTJobTimeoutConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inProgressTimeoutInMinutes":
            suggest = "in_progress_timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIoTJobTimeoutConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIoTJobTimeoutConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIoTJobTimeoutConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_progress_timeout_in_minutes: Optional[builtins.int] = None):
        """
        :param builtins.int in_progress_timeout_in_minutes: The amount of time, in minutes, that devices have to complete the job. The timer starts when the job status is set to `IN_PROGRESS` . If the job status doesn't change to a terminal state before the time expires, then the job status is set to `TIMED_OUT` .
               
               The timeout interval must be between 1 minute and 7 days (10080 minutes).
        """
        if in_progress_timeout_in_minutes is not None:
            pulumi.set(__self__, "in_progress_timeout_in_minutes", in_progress_timeout_in_minutes)

    @property
    @pulumi.getter(name="inProgressTimeoutInMinutes")
    def in_progress_timeout_in_minutes(self) -> Optional[builtins.int]:
        """
        The amount of time, in minutes, that devices have to complete the job. The timer starts when the job status is set to `IN_PROGRESS` . If the job status doesn't change to a terminal state before the time expires, then the job status is set to `TIMED_OUT` .

        The timeout interval must be between 1 minute and 7 days (10080 minutes).
        """
        return pulumi.get(self, "in_progress_timeout_in_minutes")


@pulumi.output_type
class DeploymentPolicies(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentUpdatePolicy":
            suggest = "component_update_policy"
        elif key == "configurationValidationPolicy":
            suggest = "configuration_validation_policy"
        elif key == "failureHandlingPolicy":
            suggest = "failure_handling_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPolicies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPolicies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPolicies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_update_policy: Optional['outputs.DeploymentComponentUpdatePolicy'] = None,
                 configuration_validation_policy: Optional['outputs.DeploymentConfigurationValidationPolicy'] = None,
                 failure_handling_policy: Optional['DeploymentPoliciesFailureHandlingPolicy'] = None):
        """
        :param 'DeploymentComponentUpdatePolicy' component_update_policy: The component update policy for the configuration deployment. This policy defines when it's safe to deploy the configuration to devices.
        :param 'DeploymentConfigurationValidationPolicy' configuration_validation_policy: The configuration validation policy for the configuration deployment. This policy defines how long each component has to validate its configure updates.
        :param 'DeploymentPoliciesFailureHandlingPolicy' failure_handling_policy: The failure handling policy for the configuration deployment. This policy defines what to do if the deployment fails.
               
               Default: `ROLLBACK`
        """
        if component_update_policy is not None:
            pulumi.set(__self__, "component_update_policy", component_update_policy)
        if configuration_validation_policy is not None:
            pulumi.set(__self__, "configuration_validation_policy", configuration_validation_policy)
        if failure_handling_policy is not None:
            pulumi.set(__self__, "failure_handling_policy", failure_handling_policy)

    @property
    @pulumi.getter(name="componentUpdatePolicy")
    def component_update_policy(self) -> Optional['outputs.DeploymentComponentUpdatePolicy']:
        """
        The component update policy for the configuration deployment. This policy defines when it's safe to deploy the configuration to devices.
        """
        return pulumi.get(self, "component_update_policy")

    @property
    @pulumi.getter(name="configurationValidationPolicy")
    def configuration_validation_policy(self) -> Optional['outputs.DeploymentConfigurationValidationPolicy']:
        """
        The configuration validation policy for the configuration deployment. This policy defines how long each component has to validate its configure updates.
        """
        return pulumi.get(self, "configuration_validation_policy")

    @property
    @pulumi.getter(name="failureHandlingPolicy")
    def failure_handling_policy(self) -> Optional['DeploymentPoliciesFailureHandlingPolicy']:
        """
        The failure handling policy for the configuration deployment. This policy defines what to do if the deployment fails.

        Default: `ROLLBACK`
        """
        return pulumi.get(self, "failure_handling_policy")


@pulumi.output_type
class DeploymentSystemResourceLimits(dict):
    def __init__(__self__, *,
                 cpus: Optional[builtins.float] = None,
                 memory: Optional[builtins.int] = None):
        if cpus is not None:
            pulumi.set(__self__, "cpus", cpus)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpus(self) -> Optional[builtins.float]:
        return pulumi.get(self, "cpus")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        return pulumi.get(self, "memory")


