# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 account_access_type: pulumi.Input['WorkspaceAccountAccessType'],
                 authentication_providers: pulumi.Input[Sequence[pulumi.Input['WorkspaceAuthenticationProviderTypes']]],
                 permission_type: pulumi.Input['WorkspacePermissionType'],
                 client_token: Optional[pulumi.Input[builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDataSourceType']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_access_control: Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']] = None,
                 notification_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceNotificationDestinationType']]]] = None,
                 organization_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 plugin_admin_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 saml_configuration: Optional[pulumi.Input['WorkspaceSamlConfigurationArgs']] = None,
                 stack_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_configuration: Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input['WorkspaceAccountAccessType'] account_access_type: Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization. If this is `ORGANIZATION` , the `OrganizationalUnits` parameter specifies which organizational units the workspace can access.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceAuthenticationProviderTypes']]] authentication_providers: List of authentication providers to enable.
        :param pulumi.Input['WorkspacePermissionType'] permission_type: If this is `SERVICE_MANAGED` , and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.
               
               If this is `CUSTOMER_MANAGED` , you must manage those roles and permissions yourself.
               
               If you are working with a workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other AWS accounts in the organization, this parameter must be set to `CUSTOMER_MANAGED` .
               
               For more information about converting between customer and service managed, see [Managing permissions for data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html) . For more information about the roles and permissions that must be managed for customer managed workspaces, see [Amazon Managed Grafana permissions and policies for AWS data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
        :param pulumi.Input[builtins.str] client_token: A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceDataSourceType']]] data_sources: List of data sources on the service managed IAM role.
        :param pulumi.Input[builtins.str] description: Description of a workspace.
        :param pulumi.Input[builtins.str] grafana_version: The version of Grafana to support in your workspace.
        :param pulumi.Input[builtins.str] name: The user friendly name of a workspace.
        :param pulumi.Input['WorkspaceNetworkAccessControlArgs'] network_access_control: The configuration settings for network access to your workspace.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceNotificationDestinationType']]] notification_destinations: List of notification destinations on the customers service managed IAM role that the Grafana workspace can query.
        :param pulumi.Input[builtins.str] organization_role_name: The name of an IAM role that already exists to use with AWS Organizations to access AWS data sources and notification channels in other accounts in an organization.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] organizational_units: List of Organizational Units containing AWS accounts the Grafana workspace can pull data from.
        :param pulumi.Input[builtins.bool] plugin_admin_enabled: Allow workspace admins to install plugins
        :param pulumi.Input[builtins.str] role_arn: IAM Role that will be used to grant the Grafana workspace access to a customers AWS resources.
        :param pulumi.Input['WorkspaceSamlConfigurationArgs'] saml_configuration: If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
        :param pulumi.Input[builtins.str] stack_set_name: The name of the AWS CloudFormation stack set to use to generate IAM roles to be used for this workspace.
        :param pulumi.Input['WorkspaceVpcConfigurationArgs'] vpc_configuration: The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
               
               > Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
        """
        pulumi.set(__self__, "account_access_type", account_access_type)
        pulumi.set(__self__, "authentication_providers", authentication_providers)
        pulumi.set(__self__, "permission_type", permission_type)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if grafana_version is not None:
            pulumi.set(__self__, "grafana_version", grafana_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_access_control is not None:
            pulumi.set(__self__, "network_access_control", network_access_control)
        if notification_destinations is not None:
            pulumi.set(__self__, "notification_destinations", notification_destinations)
        if organization_role_name is not None:
            pulumi.set(__self__, "organization_role_name", organization_role_name)
        if organizational_units is not None:
            pulumi.set(__self__, "organizational_units", organizational_units)
        if plugin_admin_enabled is not None:
            pulumi.set(__self__, "plugin_admin_enabled", plugin_admin_enabled)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if saml_configuration is not None:
            pulumi.set(__self__, "saml_configuration", saml_configuration)
        if stack_set_name is not None:
            pulumi.set(__self__, "stack_set_name", stack_set_name)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="accountAccessType")
    def account_access_type(self) -> pulumi.Input['WorkspaceAccountAccessType']:
        """
        Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization. If this is `ORGANIZATION` , the `OrganizationalUnits` parameter specifies which organizational units the workspace can access.
        """
        return pulumi.get(self, "account_access_type")

    @account_access_type.setter
    def account_access_type(self, value: pulumi.Input['WorkspaceAccountAccessType']):
        pulumi.set(self, "account_access_type", value)

    @property
    @pulumi.getter(name="authenticationProviders")
    def authentication_providers(self) -> pulumi.Input[Sequence[pulumi.Input['WorkspaceAuthenticationProviderTypes']]]:
        """
        List of authentication providers to enable.
        """
        return pulumi.get(self, "authentication_providers")

    @authentication_providers.setter
    def authentication_providers(self, value: pulumi.Input[Sequence[pulumi.Input['WorkspaceAuthenticationProviderTypes']]]):
        pulumi.set(self, "authentication_providers", value)

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> pulumi.Input['WorkspacePermissionType']:
        """
        If this is `SERVICE_MANAGED` , and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.

        If this is `CUSTOMER_MANAGED` , you must manage those roles and permissions yourself.

        If you are working with a workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other AWS accounts in the organization, this parameter must be set to `CUSTOMER_MANAGED` .

        For more information about converting between customer and service managed, see [Managing permissions for data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html) . For more information about the roles and permissions that must be managed for customer managed workspaces, see [Amazon Managed Grafana permissions and policies for AWS data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
        """
        return pulumi.get(self, "permission_type")

    @permission_type.setter
    def permission_type(self, value: pulumi.Input['WorkspacePermissionType']):
        pulumi.set(self, "permission_type", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDataSourceType']]]]:
        """
        List of data sources on the service managed IAM role.
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDataSourceType']]]]):
        pulumi.set(self, "data_sources", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of a workspace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of Grafana to support in your workspace.
        """
        return pulumi.get(self, "grafana_version")

    @grafana_version.setter
    def grafana_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grafana_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user friendly name of a workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkAccessControl")
    def network_access_control(self) -> Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']]:
        """
        The configuration settings for network access to your workspace.
        """
        return pulumi.get(self, "network_access_control")

    @network_access_control.setter
    def network_access_control(self, value: Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']]):
        pulumi.set(self, "network_access_control", value)

    @property
    @pulumi.getter(name="notificationDestinations")
    def notification_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceNotificationDestinationType']]]]:
        """
        List of notification destinations on the customers service managed IAM role that the Grafana workspace can query.
        """
        return pulumi.get(self, "notification_destinations")

    @notification_destinations.setter
    def notification_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceNotificationDestinationType']]]]):
        pulumi.set(self, "notification_destinations", value)

    @property
    @pulumi.getter(name="organizationRoleName")
    def organization_role_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of an IAM role that already exists to use with AWS Organizations to access AWS data sources and notification channels in other accounts in an organization.
        """
        return pulumi.get(self, "organization_role_name")

    @organization_role_name.setter
    def organization_role_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_role_name", value)

    @property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of Organizational Units containing AWS accounts the Grafana workspace can pull data from.
        """
        return pulumi.get(self, "organizational_units")

    @organizational_units.setter
    def organizational_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "organizational_units", value)

    @property
    @pulumi.getter(name="pluginAdminEnabled")
    def plugin_admin_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow workspace admins to install plugins
        """
        return pulumi.get(self, "plugin_admin_enabled")

    @plugin_admin_enabled.setter
    def plugin_admin_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "plugin_admin_enabled", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IAM Role that will be used to grant the Grafana workspace access to a customers AWS resources.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="samlConfiguration")
    def saml_configuration(self) -> Optional[pulumi.Input['WorkspaceSamlConfigurationArgs']]:
        """
        If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
        """
        return pulumi.get(self, "saml_configuration")

    @saml_configuration.setter
    def saml_configuration(self, value: Optional[pulumi.Input['WorkspaceSamlConfigurationArgs']]):
        pulumi.set(self, "saml_configuration", value)

    @property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the AWS CloudFormation stack set to use to generate IAM roles to be used for this workspace.
        """
        return pulumi.get(self, "stack_set_name")

    @stack_set_name.setter
    def stack_set_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_set_name", value)

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']]:
        """
        The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.

        > Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']]):
        pulumi.set(self, "vpc_configuration", value)


@pulumi.type_token("aws-native:grafana:Workspace")
class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_access_type: Optional[pulumi.Input['WorkspaceAccountAccessType']] = None,
                 authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceAuthenticationProviderTypes']]]] = None,
                 client_token: Optional[pulumi.Input[builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDataSourceType']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_access_control: Optional[pulumi.Input[Union['WorkspaceNetworkAccessControlArgs', 'WorkspaceNetworkAccessControlArgsDict']]] = None,
                 notification_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceNotificationDestinationType']]]] = None,
                 organization_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 permission_type: Optional[pulumi.Input['WorkspacePermissionType']] = None,
                 plugin_admin_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 saml_configuration: Optional[pulumi.Input[Union['WorkspaceSamlConfigurationArgs', 'WorkspaceSamlConfigurationArgsDict']]] = None,
                 stack_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_configuration: Optional[pulumi.Input[Union['WorkspaceVpcConfigurationArgs', 'WorkspaceVpcConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Definition of AWS::Grafana::Workspace Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['WorkspaceAccountAccessType'] account_access_type: Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization. If this is `ORGANIZATION` , the `OrganizationalUnits` parameter specifies which organizational units the workspace can access.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceAuthenticationProviderTypes']]] authentication_providers: List of authentication providers to enable.
        :param pulumi.Input[builtins.str] client_token: A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceDataSourceType']]] data_sources: List of data sources on the service managed IAM role.
        :param pulumi.Input[builtins.str] description: Description of a workspace.
        :param pulumi.Input[builtins.str] grafana_version: The version of Grafana to support in your workspace.
        :param pulumi.Input[builtins.str] name: The user friendly name of a workspace.
        :param pulumi.Input[Union['WorkspaceNetworkAccessControlArgs', 'WorkspaceNetworkAccessControlArgsDict']] network_access_control: The configuration settings for network access to your workspace.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceNotificationDestinationType']]] notification_destinations: List of notification destinations on the customers service managed IAM role that the Grafana workspace can query.
        :param pulumi.Input[builtins.str] organization_role_name: The name of an IAM role that already exists to use with AWS Organizations to access AWS data sources and notification channels in other accounts in an organization.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] organizational_units: List of Organizational Units containing AWS accounts the Grafana workspace can pull data from.
        :param pulumi.Input['WorkspacePermissionType'] permission_type: If this is `SERVICE_MANAGED` , and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.
               
               If this is `CUSTOMER_MANAGED` , you must manage those roles and permissions yourself.
               
               If you are working with a workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other AWS accounts in the organization, this parameter must be set to `CUSTOMER_MANAGED` .
               
               For more information about converting between customer and service managed, see [Managing permissions for data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html) . For more information about the roles and permissions that must be managed for customer managed workspaces, see [Amazon Managed Grafana permissions and policies for AWS data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
        :param pulumi.Input[builtins.bool] plugin_admin_enabled: Allow workspace admins to install plugins
        :param pulumi.Input[builtins.str] role_arn: IAM Role that will be used to grant the Grafana workspace access to a customers AWS resources.
        :param pulumi.Input[Union['WorkspaceSamlConfigurationArgs', 'WorkspaceSamlConfigurationArgsDict']] saml_configuration: If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
        :param pulumi.Input[builtins.str] stack_set_name: The name of the AWS CloudFormation stack set to use to generate IAM roles to be used for this workspace.
        :param pulumi.Input[Union['WorkspaceVpcConfigurationArgs', 'WorkspaceVpcConfigurationArgsDict']] vpc_configuration: The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
               
               > Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Grafana::Workspace Resource Type

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_access_type: Optional[pulumi.Input['WorkspaceAccountAccessType']] = None,
                 authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceAuthenticationProviderTypes']]]] = None,
                 client_token: Optional[pulumi.Input[builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDataSourceType']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_access_control: Optional[pulumi.Input[Union['WorkspaceNetworkAccessControlArgs', 'WorkspaceNetworkAccessControlArgsDict']]] = None,
                 notification_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceNotificationDestinationType']]]] = None,
                 organization_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 permission_type: Optional[pulumi.Input['WorkspacePermissionType']] = None,
                 plugin_admin_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 saml_configuration: Optional[pulumi.Input[Union['WorkspaceSamlConfigurationArgs', 'WorkspaceSamlConfigurationArgsDict']]] = None,
                 stack_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_configuration: Optional[pulumi.Input[Union['WorkspaceVpcConfigurationArgs', 'WorkspaceVpcConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            if account_access_type is None and not opts.urn:
                raise TypeError("Missing required property 'account_access_type'")
            __props__.__dict__["account_access_type"] = account_access_type
            if authentication_providers is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_providers'")
            __props__.__dict__["authentication_providers"] = authentication_providers
            __props__.__dict__["client_token"] = client_token
            __props__.__dict__["data_sources"] = data_sources
            __props__.__dict__["description"] = description
            __props__.__dict__["grafana_version"] = grafana_version
            __props__.__dict__["name"] = name
            __props__.__dict__["network_access_control"] = network_access_control
            __props__.__dict__["notification_destinations"] = notification_destinations
            __props__.__dict__["organization_role_name"] = organization_role_name
            __props__.__dict__["organizational_units"] = organizational_units
            if permission_type is None and not opts.urn:
                raise TypeError("Missing required property 'permission_type'")
            __props__.__dict__["permission_type"] = permission_type
            __props__.__dict__["plugin_admin_enabled"] = plugin_admin_enabled
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["saml_configuration"] = saml_configuration
            __props__.__dict__["stack_set_name"] = stack_set_name
            __props__.__dict__["vpc_configuration"] = vpc_configuration
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["modification_timestamp"] = None
            __props__.__dict__["saml_configuration_status"] = None
            __props__.__dict__["sso_client_id"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clientToken"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Workspace, __self__).__init__(
            'aws-native:grafana:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

        __props__.__dict__["account_access_type"] = None
        __props__.__dict__["authentication_providers"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["client_token"] = None
        __props__.__dict__["creation_timestamp"] = None
        __props__.__dict__["data_sources"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["grafana_version"] = None
        __props__.__dict__["modification_timestamp"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_access_control"] = None
        __props__.__dict__["notification_destinations"] = None
        __props__.__dict__["organization_role_name"] = None
        __props__.__dict__["organizational_units"] = None
        __props__.__dict__["permission_type"] = None
        __props__.__dict__["plugin_admin_enabled"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["saml_configuration"] = None
        __props__.__dict__["saml_configuration_status"] = None
        __props__.__dict__["sso_client_id"] = None
        __props__.__dict__["stack_set_name"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["vpc_configuration"] = None
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountAccessType")
    def account_access_type(self) -> pulumi.Output['WorkspaceAccountAccessType']:
        """
        Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization. If this is `ORGANIZATION` , the `OrganizationalUnits` parameter specifies which organizational units the workspace can access.
        """
        return pulumi.get(self, "account_access_type")

    @property
    @pulumi.getter(name="authenticationProviders")
    def authentication_providers(self) -> pulumi.Output[Sequence['WorkspaceAuthenticationProviderTypes']]:
        """
        List of authentication providers to enable.
        """
        return pulumi.get(self, "authentication_providers")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The id that uniquely identifies a Grafana workspace.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        """
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp when the workspace was created.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> pulumi.Output[Optional[Sequence['WorkspaceDataSourceType']]]:
        """
        List of data sources on the service managed IAM role.
        """
        return pulumi.get(self, "data_sources")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of a workspace.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        Endpoint for the Grafana workspace.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of Grafana to support in your workspace.
        """
        return pulumi.get(self, "grafana_version")

    @property
    @pulumi.getter(name="modificationTimestamp")
    def modification_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp when the workspace was last modified
        """
        return pulumi.get(self, "modification_timestamp")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user friendly name of a workspace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAccessControl")
    def network_access_control(self) -> pulumi.Output[Optional['outputs.WorkspaceNetworkAccessControl']]:
        """
        The configuration settings for network access to your workspace.
        """
        return pulumi.get(self, "network_access_control")

    @property
    @pulumi.getter(name="notificationDestinations")
    def notification_destinations(self) -> pulumi.Output[Optional[Sequence['WorkspaceNotificationDestinationType']]]:
        """
        List of notification destinations on the customers service managed IAM role that the Grafana workspace can query.
        """
        return pulumi.get(self, "notification_destinations")

    @property
    @pulumi.getter(name="organizationRoleName")
    def organization_role_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of an IAM role that already exists to use with AWS Organizations to access AWS data sources and notification channels in other accounts in an organization.
        """
        return pulumi.get(self, "organization_role_name")

    @property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of Organizational Units containing AWS accounts the Grafana workspace can pull data from.
        """
        return pulumi.get(self, "organizational_units")

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> pulumi.Output['WorkspacePermissionType']:
        """
        If this is `SERVICE_MANAGED` , and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.

        If this is `CUSTOMER_MANAGED` , you must manage those roles and permissions yourself.

        If you are working with a workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other AWS accounts in the organization, this parameter must be set to `CUSTOMER_MANAGED` .

        For more information about converting between customer and service managed, see [Managing permissions for data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html) . For more information about the roles and permissions that must be managed for customer managed workspaces, see [Amazon Managed Grafana permissions and policies for AWS data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
        """
        return pulumi.get(self, "permission_type")

    @property
    @pulumi.getter(name="pluginAdminEnabled")
    def plugin_admin_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allow workspace admins to install plugins
        """
        return pulumi.get(self, "plugin_admin_enabled")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IAM Role that will be used to grant the Grafana workspace access to a customers AWS resources.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="samlConfiguration")
    def saml_configuration(self) -> pulumi.Output[Optional['outputs.WorkspaceSamlConfiguration']]:
        """
        If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
        """
        return pulumi.get(self, "saml_configuration")

    @property
    @pulumi.getter(name="samlConfigurationStatus")
    def saml_configuration_status(self) -> pulumi.Output['WorkspaceSamlConfigurationStatus']:
        """
        Specifies whether the workspace's SAML configuration is complete.

        Valid values: `CONFIGURED | NOT_CONFIGURED`

        Type: String
        """
        return pulumi.get(self, "saml_configuration_status")

    @property
    @pulumi.getter(name="ssoClientId")
    def sso_client_id(self) -> pulumi.Output[builtins.str]:
        """
        The client ID of the AWS SSO Managed Application.
        """
        return pulumi.get(self, "sso_client_id")

    @property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the AWS CloudFormation stack set to use to generate IAM roles to be used for this workspace.
        """
        return pulumi.get(self, "stack_set_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['WorkspaceStatus']:
        """
        The current status of the workspace.

        Valid values: `ACTIVE | CREATING | DELETING | FAILED | UPDATING | UPGRADING | DELETION_FAILED | CREATION_FAILED | UPDATE_FAILED | UPGRADE_FAILED | LICENSE_REMOVAL_FAILED`

        Type: String
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> pulumi.Output[Optional['outputs.WorkspaceVpcConfiguration']]:
        """
        The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.

        > Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
        """
        return pulumi.get(self, "vpc_configuration")

