# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'WorkspaceAssertionAttributes',
    'WorkspaceIdpMetadata',
    'WorkspaceNetworkAccessControl',
    'WorkspaceRoleValues',
    'WorkspaceSamlConfiguration',
    'WorkspaceVpcConfiguration',
]

@pulumi.output_type
class WorkspaceAssertionAttributes(dict):
    """
    Maps Grafana friendly names to the IdPs SAML attributes.
    """
    def __init__(__self__, *,
                 email: Optional[builtins.str] = None,
                 groups: Optional[builtins.str] = None,
                 login: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 org: Optional[builtins.str] = None,
                 role: Optional[builtins.str] = None):
        """
        Maps Grafana friendly names to the IdPs SAML attributes.
        :param builtins.str email: Name of the attribute within the SAML assert to use as the users email in Grafana.
        :param builtins.str groups: Name of the attribute within the SAML assert to use as the users groups in Grafana.
        :param builtins.str login: Name of the attribute within the SAML assert to use as the users login handle in Grafana.
        :param builtins.str name: Name of the attribute within the SAML assert to use as the users name in Grafana.
        :param builtins.str org: Name of the attribute within the SAML assert to use as the users organizations in Grafana.
        :param builtins.str role: Name of the attribute within the SAML assert to use as the users roles in Grafana.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org is not None:
            pulumi.set(__self__, "org", org)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Name of the attribute within the SAML assert to use as the users email in Grafana.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def groups(self) -> Optional[builtins.str]:
        """
        Name of the attribute within the SAML assert to use as the users groups in Grafana.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def login(self) -> Optional[builtins.str]:
        """
        Name of the attribute within the SAML assert to use as the users login handle in Grafana.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the attribute within the SAML assert to use as the users name in Grafana.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def org(self) -> Optional[builtins.str]:
        """
        Name of the attribute within the SAML assert to use as the users organizations in Grafana.
        """
        return pulumi.get(self, "org")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        Name of the attribute within the SAML assert to use as the users roles in Grafana.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class WorkspaceIdpMetadata(dict):
    """
    IdP Metadata used to configure SAML authentication in Grafana.
    """
    def __init__(__self__, *,
                 url: Optional[builtins.str] = None,
                 xml: Optional[builtins.str] = None):
        """
        IdP Metadata used to configure SAML authentication in Grafana.
        :param builtins.str url: URL that vends the IdPs metadata.
        :param builtins.str xml: XML blob of the IdPs metadata.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)
        if xml is not None:
            pulumi.set(__self__, "xml", xml)

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        URL that vends the IdPs metadata.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def xml(self) -> Optional[builtins.str]:
        """
        XML blob of the IdPs metadata.
        """
        return pulumi.get(self, "xml")


@pulumi.output_type
class WorkspaceNetworkAccessControl(dict):
    """
    The configuration settings for Network Access Control.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prefixListIds":
            suggest = "prefix_list_ids"
        elif key == "vpceIds":
            suggest = "vpce_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceNetworkAccessControl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceNetworkAccessControl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceNetworkAccessControl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prefix_list_ids: Optional[Sequence[builtins.str]] = None,
                 vpce_ids: Optional[Sequence[builtins.str]] = None):
        """
        The configuration settings for Network Access Control.
        :param Sequence[builtins.str] prefix_list_ids: The list of prefix list IDs. A prefix list is a list of CIDR ranges of IP addresses. The IP addresses specified are allowed to access your workspace. If the list is not included in the configuration then no IP addresses will be allowed to access the workspace.
        :param Sequence[builtins.str] vpce_ids: The list of Amazon VPC endpoint IDs for the workspace. If a NetworkAccessConfiguration is specified then only VPC endpoints specified here will be allowed to access the workspace.
        """
        if prefix_list_ids is not None:
            pulumi.set(__self__, "prefix_list_ids", prefix_list_ids)
        if vpce_ids is not None:
            pulumi.set(__self__, "vpce_ids", vpce_ids)

    @property
    @pulumi.getter(name="prefixListIds")
    def prefix_list_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of prefix list IDs. A prefix list is a list of CIDR ranges of IP addresses. The IP addresses specified are allowed to access your workspace. If the list is not included in the configuration then no IP addresses will be allowed to access the workspace.
        """
        return pulumi.get(self, "prefix_list_ids")

    @property
    @pulumi.getter(name="vpceIds")
    def vpce_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of Amazon VPC endpoint IDs for the workspace. If a NetworkAccessConfiguration is specified then only VPC endpoints specified here will be allowed to access the workspace.
        """
        return pulumi.get(self, "vpce_ids")


@pulumi.output_type
class WorkspaceRoleValues(dict):
    """
    Maps SAML roles to the Grafana Editor and Admin roles.
    """
    def __init__(__self__, *,
                 admin: Optional[Sequence[builtins.str]] = None,
                 editor: Optional[Sequence[builtins.str]] = None):
        """
        Maps SAML roles to the Grafana Editor and Admin roles.
        :param Sequence[builtins.str] admin: List of SAML roles which will be mapped into the Grafana Admin role.
        :param Sequence[builtins.str] editor: List of SAML roles which will be mapped into the Grafana Editor role.
        """
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if editor is not None:
            pulumi.set(__self__, "editor", editor)

    @property
    @pulumi.getter
    def admin(self) -> Optional[Sequence[builtins.str]]:
        """
        List of SAML roles which will be mapped into the Grafana Admin role.
        """
        return pulumi.get(self, "admin")

    @property
    @pulumi.getter
    def editor(self) -> Optional[Sequence[builtins.str]]:
        """
        List of SAML roles which will be mapped into the Grafana Editor role.
        """
        return pulumi.get(self, "editor")


@pulumi.output_type
class WorkspaceSamlConfiguration(dict):
    """
    SAML configuration data associated with an AMG workspace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpMetadata":
            suggest = "idp_metadata"
        elif key == "allowedOrganizations":
            suggest = "allowed_organizations"
        elif key == "assertionAttributes":
            suggest = "assertion_attributes"
        elif key == "loginValidityDuration":
            suggest = "login_validity_duration"
        elif key == "roleValues":
            suggest = "role_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceSamlConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceSamlConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceSamlConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_metadata: 'outputs.WorkspaceIdpMetadata',
                 allowed_organizations: Optional[Sequence[builtins.str]] = None,
                 assertion_attributes: Optional['outputs.WorkspaceAssertionAttributes'] = None,
                 login_validity_duration: Optional[builtins.float] = None,
                 role_values: Optional['outputs.WorkspaceRoleValues'] = None):
        """
        SAML configuration data associated with an AMG workspace.
        :param 'WorkspaceIdpMetadata' idp_metadata: A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.
        :param Sequence[builtins.str] allowed_organizations: List of SAML organizations allowed to access Grafana.
        :param 'WorkspaceAssertionAttributes' assertion_attributes: A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.
        :param builtins.float login_validity_duration: The maximum lifetime an authenticated user can be logged in (in minutes) before being required to re-authenticate.
        :param 'WorkspaceRoleValues' role_values: A structure containing arrays that map group names in the SAML assertion to the Grafana `Admin` and `Editor` roles in the workspace.
        """
        pulumi.set(__self__, "idp_metadata", idp_metadata)
        if allowed_organizations is not None:
            pulumi.set(__self__, "allowed_organizations", allowed_organizations)
        if assertion_attributes is not None:
            pulumi.set(__self__, "assertion_attributes", assertion_attributes)
        if login_validity_duration is not None:
            pulumi.set(__self__, "login_validity_duration", login_validity_duration)
        if role_values is not None:
            pulumi.set(__self__, "role_values", role_values)

    @property
    @pulumi.getter(name="idpMetadata")
    def idp_metadata(self) -> 'outputs.WorkspaceIdpMetadata':
        """
        A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.
        """
        return pulumi.get(self, "idp_metadata")

    @property
    @pulumi.getter(name="allowedOrganizations")
    def allowed_organizations(self) -> Optional[Sequence[builtins.str]]:
        """
        List of SAML organizations allowed to access Grafana.
        """
        return pulumi.get(self, "allowed_organizations")

    @property
    @pulumi.getter(name="assertionAttributes")
    def assertion_attributes(self) -> Optional['outputs.WorkspaceAssertionAttributes']:
        """
        A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.
        """
        return pulumi.get(self, "assertion_attributes")

    @property
    @pulumi.getter(name="loginValidityDuration")
    def login_validity_duration(self) -> Optional[builtins.float]:
        """
        The maximum lifetime an authenticated user can be logged in (in minutes) before being required to re-authenticate.
        """
        return pulumi.get(self, "login_validity_duration")

    @property
    @pulumi.getter(name="roleValues")
    def role_values(self) -> Optional['outputs.WorkspaceRoleValues']:
        """
        A structure containing arrays that map group names in the SAML assertion to the Grafana `Admin` and `Editor` roles in the workspace.
        """
        return pulumi.get(self, "role_values")


@pulumi.output_type
class WorkspaceVpcConfiguration(dict):
    """
    The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[builtins.str],
                 subnet_ids: Sequence[builtins.str]):
        """
        The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
        :param Sequence[builtins.str] security_group_ids: The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
        :param Sequence[builtins.str] subnet_ids: The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
        """
        return pulumi.get(self, "subnet_ids")


