# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CrawlerCatalogTarget',
    'CrawlerDeltaTarget',
    'CrawlerDynamoDbTarget',
    'CrawlerHudiTarget',
    'CrawlerIcebergTarget',
    'CrawlerJdbcTarget',
    'CrawlerLakeFormationConfiguration',
    'CrawlerMongoDbTarget',
    'CrawlerRecrawlPolicy',
    'CrawlerS3Target',
    'CrawlerSchedule',
    'CrawlerSchemaChangePolicy',
    'CrawlerTargets',
    'DatabaseDataLakePrincipal',
    'DatabaseFederatedDatabase',
    'DatabaseIdentifier',
    'DatabaseInput',
    'DatabasePrincipalPrivileges',
    'JobCommand',
    'JobConnectionsList',
    'JobExecutionProperty',
    'JobNotificationProperty',
    'SchemaRegistry',
    'SchemaVersion',
    'SchemaVersionSchema',
    'TriggerAction',
    'TriggerCondition',
    'TriggerEventBatchingCondition',
    'TriggerNotificationProperty',
    'TriggerPredicate',
    'UsageProfileConfigurationObject',
    'UsageProfileProfileConfiguration',
]

@pulumi.output_type
class CrawlerCatalogTarget(dict):
    """
    Specifies an AWS Glue Data Catalog target.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "dlqEventQueueArn":
            suggest = "dlq_event_queue_arn"
        elif key == "eventQueueArn":
            suggest = "event_queue_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerCatalogTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerCatalogTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerCatalogTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: Optional[builtins.str] = None,
                 database_name: Optional[builtins.str] = None,
                 dlq_event_queue_arn: Optional[builtins.str] = None,
                 event_queue_arn: Optional[builtins.str] = None,
                 tables: Optional[Sequence[builtins.str]] = None):
        """
        Specifies an AWS Glue Data Catalog target.
        :param builtins.str connection_name: The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a NETWORK Connection type.
        :param builtins.str database_name: The name of the database to be synchronized.
        :param builtins.str dlq_event_queue_arn: A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        :param builtins.str event_queue_arn: A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        :param Sequence[builtins.str] tables: A list of the tables to be synchronized.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if dlq_event_queue_arn is not None:
            pulumi.set(__self__, "dlq_event_queue_arn", dlq_event_queue_arn)
        if event_queue_arn is not None:
            pulumi.set(__self__, "event_queue_arn", event_queue_arn)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[builtins.str]:
        """
        The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a NETWORK Connection type.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        The name of the database to be synchronized.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dlqEventQueueArn")
    def dlq_event_queue_arn(self) -> Optional[builtins.str]:
        """
        A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        """
        return pulumi.get(self, "dlq_event_queue_arn")

    @property
    @pulumi.getter(name="eventQueueArn")
    def event_queue_arn(self) -> Optional[builtins.str]:
        """
        A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        """
        return pulumi.get(self, "event_queue_arn")

    @property
    @pulumi.getter
    def tables(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the tables to be synchronized.
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class CrawlerDeltaTarget(dict):
    """
    Specifies a Delta data store to crawl one or more Delta tables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "createNativeDeltaTable":
            suggest = "create_native_delta_table"
        elif key == "deltaTables":
            suggest = "delta_tables"
        elif key == "writeManifest":
            suggest = "write_manifest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerDeltaTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerDeltaTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerDeltaTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: Optional[builtins.str] = None,
                 create_native_delta_table: Optional[builtins.bool] = None,
                 delta_tables: Optional[Sequence[builtins.str]] = None,
                 write_manifest: Optional[builtins.bool] = None):
        """
        Specifies a Delta data store to crawl one or more Delta tables.
        :param builtins.str connection_name: The name of the connection to use to connect to the Delta table target.
        :param builtins.bool create_native_delta_table: Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
        :param Sequence[builtins.str] delta_tables: A list of the Amazon S3 paths to the Delta tables.
        :param builtins.bool write_manifest: Specifies whether to write the manifest files to the Delta table path.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if create_native_delta_table is not None:
            pulumi.set(__self__, "create_native_delta_table", create_native_delta_table)
        if delta_tables is not None:
            pulumi.set(__self__, "delta_tables", delta_tables)
        if write_manifest is not None:
            pulumi.set(__self__, "write_manifest", write_manifest)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[builtins.str]:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="createNativeDeltaTable")
    def create_native_delta_table(self) -> Optional[builtins.bool]:
        """
        Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
        """
        return pulumi.get(self, "create_native_delta_table")

    @property
    @pulumi.getter(name="deltaTables")
    def delta_tables(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the Amazon S3 paths to the Delta tables.
        """
        return pulumi.get(self, "delta_tables")

    @property
    @pulumi.getter(name="writeManifest")
    def write_manifest(self) -> Optional[builtins.bool]:
        """
        Specifies whether to write the manifest files to the Delta table path.
        """
        return pulumi.get(self, "write_manifest")


@pulumi.output_type
class CrawlerDynamoDbTarget(dict):
    """
    Specifies an Amazon DynamoDB table to crawl.
    """
    def __init__(__self__, *,
                 path: Optional[builtins.str] = None):
        """
        Specifies an Amazon DynamoDB table to crawl.
        :param builtins.str path: The name of the DynamoDB table to crawl.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The name of the DynamoDB table to crawl.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class CrawlerHudiTarget(dict):
    """
    Specifies Apache Hudi data store targets.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "maximumTraversalDepth":
            suggest = "maximum_traversal_depth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerHudiTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerHudiTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerHudiTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: Optional[builtins.str] = None,
                 exclusions: Optional[Sequence[builtins.str]] = None,
                 maximum_traversal_depth: Optional[builtins.int] = None,
                 paths: Optional[Sequence[builtins.str]] = None):
        """
        Specifies Apache Hudi data store targets.
        :param builtins.str connection_name: The name of the connection to use to connect to the Hudi target.
        :param Sequence[builtins.str] exclusions: A list of global patterns used to exclude from the crawl.
        :param builtins.int maximum_traversal_depth: The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder in your Amazon S3 path. Used to limit the crawler run time.
        :param Sequence[builtins.str] paths: One or more Amazon S3 paths that contains Hudi metadata folders as s3://bucket/prefix .
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if maximum_traversal_depth is not None:
            pulumi.set(__self__, "maximum_traversal_depth", maximum_traversal_depth)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[builtins.str]:
        """
        The name of the connection to use to connect to the Hudi target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of global patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="maximumTraversalDepth")
    def maximum_traversal_depth(self) -> Optional[builtins.int]:
        """
        The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder in your Amazon S3 path. Used to limit the crawler run time.
        """
        return pulumi.get(self, "maximum_traversal_depth")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more Amazon S3 paths that contains Hudi metadata folders as s3://bucket/prefix .
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class CrawlerIcebergTarget(dict):
    """
    Specifies Apache Iceberg data store targets.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "maximumTraversalDepth":
            suggest = "maximum_traversal_depth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerIcebergTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerIcebergTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerIcebergTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: Optional[builtins.str] = None,
                 exclusions: Optional[Sequence[builtins.str]] = None,
                 maximum_traversal_depth: Optional[builtins.int] = None,
                 paths: Optional[Sequence[builtins.str]] = None):
        """
        Specifies Apache Iceberg data store targets.
        :param builtins.str connection_name: The name of the connection to use to connect to the Iceberg target.
        :param Sequence[builtins.str] exclusions: A list of global patterns used to exclude from the crawl.
        :param builtins.int maximum_traversal_depth: The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Iceberg metadata folder in your Amazon S3 path. Used to limit the crawler run time.
        :param Sequence[builtins.str] paths: One or more Amazon S3 paths that contains Iceberg metadata folders as s3://bucket/prefix .
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if maximum_traversal_depth is not None:
            pulumi.set(__self__, "maximum_traversal_depth", maximum_traversal_depth)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[builtins.str]:
        """
        The name of the connection to use to connect to the Iceberg target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of global patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="maximumTraversalDepth")
    def maximum_traversal_depth(self) -> Optional[builtins.int]:
        """
        The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Iceberg metadata folder in your Amazon S3 path. Used to limit the crawler run time.
        """
        return pulumi.get(self, "maximum_traversal_depth")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more Amazon S3 paths that contains Iceberg metadata folders as s3://bucket/prefix .
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class CrawlerJdbcTarget(dict):
    """
    Specifies a JDBC data store to crawl.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "enableAdditionalMetadata":
            suggest = "enable_additional_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerJdbcTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerJdbcTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerJdbcTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: Optional[builtins.str] = None,
                 enable_additional_metadata: Optional[Sequence[builtins.str]] = None,
                 exclusions: Optional[Sequence[builtins.str]] = None,
                 path: Optional[builtins.str] = None):
        """
        Specifies a JDBC data store to crawl.
        :param builtins.str connection_name: The name of the connection to use to connect to the JDBC target.
        :param Sequence[builtins.str] enable_additional_metadata: Specify a value of RAWTYPES or COMMENTS to enable additional metadata in table responses. RAWTYPES provides the native-level datatype. COMMENTS provides comments associated with a column or table in the database.
               
               If you do not need additional metadata, keep the field empty.
        :param Sequence[builtins.str] exclusions: A list of glob patterns used to exclude from the crawl. For more information, see Catalog Tables with a Crawler.
        :param builtins.str path: The path of the JDBC target.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if enable_additional_metadata is not None:
            pulumi.set(__self__, "enable_additional_metadata", enable_additional_metadata)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[builtins.str]:
        """
        The name of the connection to use to connect to the JDBC target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="enableAdditionalMetadata")
    def enable_additional_metadata(self) -> Optional[Sequence[builtins.str]]:
        """
        Specify a value of RAWTYPES or COMMENTS to enable additional metadata in table responses. RAWTYPES provides the native-level datatype. COMMENTS provides comments associated with a column or table in the database.

        If you do not need additional metadata, keep the field empty.
        """
        return pulumi.get(self, "enable_additional_metadata")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of glob patterns used to exclude from the crawl. For more information, see Catalog Tables with a Crawler.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path of the JDBC target.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class CrawlerLakeFormationConfiguration(dict):
    """
    Specifies AWS Lake Formation configuration settings for the crawler
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "useLakeFormationCredentials":
            suggest = "use_lake_formation_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerLakeFormationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerLakeFormationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerLakeFormationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[builtins.str] = None,
                 use_lake_formation_credentials: Optional[builtins.bool] = None):
        """
        Specifies AWS Lake Formation configuration settings for the crawler
        :param builtins.str account_id: Required for cross account crawls. For same account crawls as the target data, this can be left as null.
        :param builtins.bool use_lake_formation_credentials: Specifies whether to use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if use_lake_formation_credentials is not None:
            pulumi.set(__self__, "use_lake_formation_credentials", use_lake_formation_credentials)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        Required for cross account crawls. For same account crawls as the target data, this can be left as null.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="useLakeFormationCredentials")
    def use_lake_formation_credentials(self) -> Optional[builtins.bool]:
        """
        Specifies whether to use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
        """
        return pulumi.get(self, "use_lake_formation_credentials")


@pulumi.output_type
class CrawlerMongoDbTarget(dict):
    """
    Specifies an Amazon DocumentDB or MongoDB data store to crawl.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerMongoDbTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerMongoDbTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerMongoDbTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None):
        """
        Specifies an Amazon DocumentDB or MongoDB data store to crawl.
        :param builtins.str connection_name: The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
        :param builtins.str path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[builtins.str]:
        """
        The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class CrawlerRecrawlPolicy(dict):
    """
    When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. For more information, see Incremental Crawls in AWS Glue in the developer guide.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recrawlBehavior":
            suggest = "recrawl_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerRecrawlPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerRecrawlPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerRecrawlPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recrawl_behavior: Optional[builtins.str] = None):
        """
        When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. For more information, see Incremental Crawls in AWS Glue in the developer guide.
        :param builtins.str recrawl_behavior: Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. A value of CRAWL_EVERYTHING specifies crawling the entire dataset again. A value of CRAWL_NEW_FOLDERS_ONLY specifies crawling only folders that were added since the last crawler run. A value of CRAWL_EVENT_MODE specifies crawling only the changes identified by Amazon S3 events.
        """
        if recrawl_behavior is not None:
            pulumi.set(__self__, "recrawl_behavior", recrawl_behavior)

    @property
    @pulumi.getter(name="recrawlBehavior")
    def recrawl_behavior(self) -> Optional[builtins.str]:
        """
        Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. A value of CRAWL_EVERYTHING specifies crawling the entire dataset again. A value of CRAWL_NEW_FOLDERS_ONLY specifies crawling only folders that were added since the last crawler run. A value of CRAWL_EVENT_MODE specifies crawling only the changes identified by Amazon S3 events.
        """
        return pulumi.get(self, "recrawl_behavior")


@pulumi.output_type
class CrawlerS3Target(dict):
    """
    Specifies a data store in Amazon Simple Storage Service (Amazon S3).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "dlqEventQueueArn":
            suggest = "dlq_event_queue_arn"
        elif key == "eventQueueArn":
            suggest = "event_queue_arn"
        elif key == "sampleSize":
            suggest = "sample_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerS3Target. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerS3Target.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerS3Target.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: Optional[builtins.str] = None,
                 dlq_event_queue_arn: Optional[builtins.str] = None,
                 event_queue_arn: Optional[builtins.str] = None,
                 exclusions: Optional[Sequence[builtins.str]] = None,
                 path: Optional[builtins.str] = None,
                 sample_size: Optional[builtins.int] = None):
        """
        Specifies a data store in Amazon Simple Storage Service (Amazon S3).
        :param builtins.str connection_name: The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
        :param builtins.str dlq_event_queue_arn: A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        :param builtins.str event_queue_arn: A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        :param Sequence[builtins.str] exclusions: A list of glob patterns used to exclude from the crawl.
        :param builtins.str path: The path to the Amazon S3 target.
        :param builtins.int sample_size: Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if dlq_event_queue_arn is not None:
            pulumi.set(__self__, "dlq_event_queue_arn", dlq_event_queue_arn)
        if event_queue_arn is not None:
            pulumi.set(__self__, "event_queue_arn", event_queue_arn)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[builtins.str]:
        """
        The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="dlqEventQueueArn")
    def dlq_event_queue_arn(self) -> Optional[builtins.str]:
        """
        A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        """
        return pulumi.get(self, "dlq_event_queue_arn")

    @property
    @pulumi.getter(name="eventQueueArn")
    def event_queue_arn(self) -> Optional[builtins.str]:
        """
        A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        """
        return pulumi.get(self, "event_queue_arn")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of glob patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path to the Amazon S3 target.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[builtins.int]:
        """
        Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
        return pulumi.get(self, "sample_size")


@pulumi.output_type
class CrawlerSchedule(dict):
    """
    A scheduling object using a cron statement to schedule an event.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: Optional[builtins.str] = None):
        """
        A scheduling object using a cron statement to schedule an event.
        :param builtins.str schedule_expression: A cron expression used to specify the schedule. For more information, see Time-Based Schedules for Jobs and Crawlers. For example, to run something every day at 12:15 UTC, specify cron(15 12 * * ? *).
        """
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[builtins.str]:
        """
        A cron expression used to specify the schedule. For more information, see Time-Based Schedules for Jobs and Crawlers. For example, to run something every day at 12:15 UTC, specify cron(15 12 * * ? *).
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class CrawlerSchemaChangePolicy(dict):
    """
    The policy that specifies update and delete behaviors for the crawler. The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The SchemaChangePolicy does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the SchemaChangePolicy on a crawler. The SchemaChangePolicy consists of two components, UpdateBehavior and DeleteBehavior.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteBehavior":
            suggest = "delete_behavior"
        elif key == "updateBehavior":
            suggest = "update_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerSchemaChangePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerSchemaChangePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerSchemaChangePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_behavior: Optional[builtins.str] = None,
                 update_behavior: Optional[builtins.str] = None):
        """
        The policy that specifies update and delete behaviors for the crawler. The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The SchemaChangePolicy does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the SchemaChangePolicy on a crawler. The SchemaChangePolicy consists of two components, UpdateBehavior and DeleteBehavior.
        :param builtins.str delete_behavior: The deletion behavior when the crawler finds a deleted object. A value of LOG specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist. A value of DELETE_FROM_DATABASE specifies that if a table or partition is found to have been removed, delete it from the database. A value of DEPRECATE_IN_DATABASE specifies that if a table has been found to no longer exist, to add a property to the table that says 'DEPRECATED' and includes a timestamp with the time of deprecation.
        :param builtins.str update_behavior: The update behavior when the crawler finds a changed schema. A value of LOG specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables). A value of UPDATE_IN_DATABASE specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
        """
        if delete_behavior is not None:
            pulumi.set(__self__, "delete_behavior", delete_behavior)
        if update_behavior is not None:
            pulumi.set(__self__, "update_behavior", update_behavior)

    @property
    @pulumi.getter(name="deleteBehavior")
    def delete_behavior(self) -> Optional[builtins.str]:
        """
        The deletion behavior when the crawler finds a deleted object. A value of LOG specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist. A value of DELETE_FROM_DATABASE specifies that if a table or partition is found to have been removed, delete it from the database. A value of DEPRECATE_IN_DATABASE specifies that if a table has been found to no longer exist, to add a property to the table that says 'DEPRECATED' and includes a timestamp with the time of deprecation.
        """
        return pulumi.get(self, "delete_behavior")

    @property
    @pulumi.getter(name="updateBehavior")
    def update_behavior(self) -> Optional[builtins.str]:
        """
        The update behavior when the crawler finds a changed schema. A value of LOG specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables). A value of UPDATE_IN_DATABASE specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
        """
        return pulumi.get(self, "update_behavior")


@pulumi.output_type
class CrawlerTargets(dict):
    """
    Specifies data stores to crawl.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogTargets":
            suggest = "catalog_targets"
        elif key == "deltaTargets":
            suggest = "delta_targets"
        elif key == "dynamoDbTargets":
            suggest = "dynamo_db_targets"
        elif key == "hudiTargets":
            suggest = "hudi_targets"
        elif key == "icebergTargets":
            suggest = "iceberg_targets"
        elif key == "jdbcTargets":
            suggest = "jdbc_targets"
        elif key == "mongoDbTargets":
            suggest = "mongo_db_targets"
        elif key == "s3Targets":
            suggest = "s3_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_targets: Optional[Sequence['outputs.CrawlerCatalogTarget']] = None,
                 delta_targets: Optional[Sequence['outputs.CrawlerDeltaTarget']] = None,
                 dynamo_db_targets: Optional[Sequence['outputs.CrawlerDynamoDbTarget']] = None,
                 hudi_targets: Optional[Sequence['outputs.CrawlerHudiTarget']] = None,
                 iceberg_targets: Optional[Sequence['outputs.CrawlerIcebergTarget']] = None,
                 jdbc_targets: Optional[Sequence['outputs.CrawlerJdbcTarget']] = None,
                 mongo_db_targets: Optional[Sequence['outputs.CrawlerMongoDbTarget']] = None,
                 s3_targets: Optional[Sequence['outputs.CrawlerS3Target']] = None):
        """
        Specifies data stores to crawl.
        :param Sequence['CrawlerCatalogTarget'] catalog_targets: Specifies AWS Glue Data Catalog targets.
        :param Sequence['CrawlerDeltaTarget'] delta_targets: Specifies an array of Delta data store targets.
        :param Sequence['CrawlerDynamoDbTarget'] dynamo_db_targets: Specifies Amazon DynamoDB targets.
        :param Sequence['CrawlerHudiTarget'] hudi_targets: Specifies Apache Hudi data store targets.
        :param Sequence['CrawlerIcebergTarget'] iceberg_targets: Specifies Apache Iceberg data store targets.
        :param Sequence['CrawlerJdbcTarget'] jdbc_targets: Specifies JDBC targets.
        :param Sequence['CrawlerMongoDbTarget'] mongo_db_targets: A list of Mongo DB targets.
        :param Sequence['CrawlerS3Target'] s3_targets: Specifies Amazon Simple Storage Service (Amazon S3) targets.
        """
        if catalog_targets is not None:
            pulumi.set(__self__, "catalog_targets", catalog_targets)
        if delta_targets is not None:
            pulumi.set(__self__, "delta_targets", delta_targets)
        if dynamo_db_targets is not None:
            pulumi.set(__self__, "dynamo_db_targets", dynamo_db_targets)
        if hudi_targets is not None:
            pulumi.set(__self__, "hudi_targets", hudi_targets)
        if iceberg_targets is not None:
            pulumi.set(__self__, "iceberg_targets", iceberg_targets)
        if jdbc_targets is not None:
            pulumi.set(__self__, "jdbc_targets", jdbc_targets)
        if mongo_db_targets is not None:
            pulumi.set(__self__, "mongo_db_targets", mongo_db_targets)
        if s3_targets is not None:
            pulumi.set(__self__, "s3_targets", s3_targets)

    @property
    @pulumi.getter(name="catalogTargets")
    def catalog_targets(self) -> Optional[Sequence['outputs.CrawlerCatalogTarget']]:
        """
        Specifies AWS Glue Data Catalog targets.
        """
        return pulumi.get(self, "catalog_targets")

    @property
    @pulumi.getter(name="deltaTargets")
    def delta_targets(self) -> Optional[Sequence['outputs.CrawlerDeltaTarget']]:
        """
        Specifies an array of Delta data store targets.
        """
        return pulumi.get(self, "delta_targets")

    @property
    @pulumi.getter(name="dynamoDbTargets")
    def dynamo_db_targets(self) -> Optional[Sequence['outputs.CrawlerDynamoDbTarget']]:
        """
        Specifies Amazon DynamoDB targets.
        """
        return pulumi.get(self, "dynamo_db_targets")

    @property
    @pulumi.getter(name="hudiTargets")
    def hudi_targets(self) -> Optional[Sequence['outputs.CrawlerHudiTarget']]:
        """
        Specifies Apache Hudi data store targets.
        """
        return pulumi.get(self, "hudi_targets")

    @property
    @pulumi.getter(name="icebergTargets")
    def iceberg_targets(self) -> Optional[Sequence['outputs.CrawlerIcebergTarget']]:
        """
        Specifies Apache Iceberg data store targets.
        """
        return pulumi.get(self, "iceberg_targets")

    @property
    @pulumi.getter(name="jdbcTargets")
    def jdbc_targets(self) -> Optional[Sequence['outputs.CrawlerJdbcTarget']]:
        """
        Specifies JDBC targets.
        """
        return pulumi.get(self, "jdbc_targets")

    @property
    @pulumi.getter(name="mongoDbTargets")
    def mongo_db_targets(self) -> Optional[Sequence['outputs.CrawlerMongoDbTarget']]:
        """
        A list of Mongo DB targets.
        """
        return pulumi.get(self, "mongo_db_targets")

    @property
    @pulumi.getter(name="s3Targets")
    def s3_targets(self) -> Optional[Sequence['outputs.CrawlerS3Target']]:
        """
        Specifies Amazon Simple Storage Service (Amazon S3) targets.
        """
        return pulumi.get(self, "s3_targets")


@pulumi.output_type
class DatabaseDataLakePrincipal(dict):
    """
    The AWS Lake Formation principal.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakePrincipalIdentifier":
            suggest = "data_lake_principal_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseDataLakePrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseDataLakePrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseDataLakePrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_principal_identifier: Optional[builtins.str] = None):
        """
        The AWS Lake Formation principal.
        :param builtins.str data_lake_principal_identifier: An identifier for the AWS Lake Formation principal.
        """
        if data_lake_principal_identifier is not None:
            pulumi.set(__self__, "data_lake_principal_identifier", data_lake_principal_identifier)

    @property
    @pulumi.getter(name="dataLakePrincipalIdentifier")
    def data_lake_principal_identifier(self) -> Optional[builtins.str]:
        """
        An identifier for the AWS Lake Formation principal.
        """
        return pulumi.get(self, "data_lake_principal_identifier")


@pulumi.output_type
class DatabaseFederatedDatabase(dict):
    """
    A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseFederatedDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseFederatedDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseFederatedDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: Optional[builtins.str] = None,
                 identifier: Optional[builtins.str] = None):
        """
        A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
        :param builtins.str connection_name: The name of the connection to the external metastore.
        :param builtins.str identifier: A unique identifier for the federated database.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[builtins.str]:
        """
        The name of the connection to the external metastore.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[builtins.str]:
        """
        A unique identifier for the federated database.
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class DatabaseIdentifier(dict):
    """
    A structure that describes a target database for resource linking.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseIdentifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseIdentifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseIdentifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: Optional[builtins.str] = None,
                 database_name: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        A structure that describes a target database for resource linking.
        :param builtins.str catalog_id: The ID of the Data Catalog in which the database resides.
        :param builtins.str database_name: The name of the catalog database.
        :param builtins.str region: Region of the target database.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        The ID of the Data Catalog in which the database resides.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        The name of the catalog database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        Region of the target database.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class DatabaseInput(dict):
    """
    The structure used to create or update a database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTableDefaultPermissions":
            suggest = "create_table_default_permissions"
        elif key == "federatedDatabase":
            suggest = "federated_database"
        elif key == "locationUri":
            suggest = "location_uri"
        elif key == "targetDatabase":
            suggest = "target_database"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_table_default_permissions: Optional[Sequence['outputs.DatabasePrincipalPrivileges']] = None,
                 description: Optional[builtins.str] = None,
                 federated_database: Optional['outputs.DatabaseFederatedDatabase'] = None,
                 location_uri: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 parameters: Optional[Any] = None,
                 target_database: Optional['outputs.DatabaseIdentifier'] = None):
        """
        The structure used to create or update a database.
        :param Sequence['DatabasePrincipalPrivileges'] create_table_default_permissions: Creates a set of default permissions on the table for principals. Used by AWS Lake Formation. Not used in the normal course of AWS Glue operations.
        :param builtins.str description: A description of the database.
        :param 'DatabaseFederatedDatabase' federated_database: A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
        :param builtins.str location_uri: The location of the database (for example, an HDFS path).
        :param builtins.str name: The name of the database. For hive compatibility, this is folded to lowercase when it is stored.
        :param Any parameters: These key-value pairs define parameters and properties of the database.
        :param 'DatabaseIdentifier' target_database: A DatabaseIdentifier structure that describes a target database for resource linking.
        """
        if create_table_default_permissions is not None:
            pulumi.set(__self__, "create_table_default_permissions", create_table_default_permissions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if federated_database is not None:
            pulumi.set(__self__, "federated_database", federated_database)
        if location_uri is not None:
            pulumi.set(__self__, "location_uri", location_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if target_database is not None:
            pulumi.set(__self__, "target_database", target_database)

    @property
    @pulumi.getter(name="createTableDefaultPermissions")
    def create_table_default_permissions(self) -> Optional[Sequence['outputs.DatabasePrincipalPrivileges']]:
        """
        Creates a set of default permissions on the table for principals. Used by AWS Lake Formation. Not used in the normal course of AWS Glue operations.
        """
        return pulumi.get(self, "create_table_default_permissions")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the database.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="federatedDatabase")
    def federated_database(self) -> Optional['outputs.DatabaseFederatedDatabase']:
        """
        A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "federated_database")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[builtins.str]:
        """
        The location of the database (for example, an HDFS path).
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the database. For hive compatibility, this is folded to lowercase when it is stored.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        These key-value pairs define parameters and properties of the database.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="targetDatabase")
    def target_database(self) -> Optional['outputs.DatabaseIdentifier']:
        """
        A DatabaseIdentifier structure that describes a target database for resource linking.
        """
        return pulumi.get(self, "target_database")


@pulumi.output_type
class DatabasePrincipalPrivileges(dict):
    """
    The permissions granted to a principal.
    """
    def __init__(__self__, *,
                 permissions: Optional[Sequence[builtins.str]] = None,
                 principal: Optional['outputs.DatabaseDataLakePrincipal'] = None):
        """
        The permissions granted to a principal.
        :param Sequence[builtins.str] permissions: The permissions that are granted to the principal.
        :param 'DatabaseDataLakePrincipal' principal: The principal who is granted permissions.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[builtins.str]]:
        """
        The permissions that are granted to the principal.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> Optional['outputs.DatabaseDataLakePrincipal']:
        """
        The principal who is granted permissions.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class JobCommand(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pythonVersion":
            suggest = "python_version"
        elif key == "scriptLocation":
            suggest = "script_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCommand. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCommand.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCommand.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 python_version: Optional[builtins.str] = None,
                 runtime: Optional[builtins.str] = None,
                 script_location: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the job command
        :param builtins.str python_version: The Python version being used to execute a Python shell job.
        :param builtins.str runtime: Runtime is used to specify the versions of Ray, Python and additional libraries available in your environment
        :param builtins.str script_location: Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that executes a job
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if script_location is not None:
            pulumi.set(__self__, "script_location", script_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the job command
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[builtins.str]:
        """
        The Python version being used to execute a Python shell job.
        """
        return pulumi.get(self, "python_version")

    @property
    @pulumi.getter
    def runtime(self) -> Optional[builtins.str]:
        """
        Runtime is used to specify the versions of Ray, Python and additional libraries available in your environment
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="scriptLocation")
    def script_location(self) -> Optional[builtins.str]:
        """
        Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that executes a job
        """
        return pulumi.get(self, "script_location")


@pulumi.output_type
class JobConnectionsList(dict):
    def __init__(__self__, *,
                 connections: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] connections: A list of connections used by the job.
        """
        if connections is not None:
            pulumi.set(__self__, "connections", connections)

    @property
    @pulumi.getter
    def connections(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of connections used by the job.
        """
        return pulumi.get(self, "connections")


@pulumi.output_type
class JobExecutionProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentRuns":
            suggest = "max_concurrent_runs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobExecutionProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobExecutionProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobExecutionProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_runs: Optional[builtins.float] = None):
        """
        :param builtins.float max_concurrent_runs: The maximum number of concurrent runs allowed for the job.
        """
        if max_concurrent_runs is not None:
            pulumi.set(__self__, "max_concurrent_runs", max_concurrent_runs)

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> Optional[builtins.float]:
        """
        The maximum number of concurrent runs allowed for the job.
        """
        return pulumi.get(self, "max_concurrent_runs")


@pulumi.output_type
class JobNotificationProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notifyDelayAfter":
            suggest = "notify_delay_after"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobNotificationProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobNotificationProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobNotificationProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notify_delay_after: Optional[builtins.int] = None):
        """
        :param builtins.int notify_delay_after: It is the number of minutes to wait before sending a job run delay notification after a job run starts
        """
        if notify_delay_after is not None:
            pulumi.set(__self__, "notify_delay_after", notify_delay_after)

    @property
    @pulumi.getter(name="notifyDelayAfter")
    def notify_delay_after(self) -> Optional[builtins.int]:
        """
        It is the number of minutes to wait before sending a job run delay notification after a job run starts
        """
        return pulumi.get(self, "notify_delay_after")


@pulumi.output_type
class SchemaRegistry(dict):
    """
    Identifier for the registry which the schema is part of.
    """
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        Identifier for the registry which the schema is part of.
        :param builtins.str arn: Amazon Resource Name for the Registry.
        :param builtins.str name: Name of the registry in which the schema will be created.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name for the Registry.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the registry in which the schema will be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SchemaVersion(dict):
    """
    Specify checkpoint version for update. This is only required to update the Compatibility.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isLatest":
            suggest = "is_latest"
        elif key == "versionNumber":
            suggest = "version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_latest: Optional[builtins.bool] = None,
                 version_number: Optional[builtins.int] = None):
        """
        Specify checkpoint version for update. This is only required to update the Compatibility.
        :param builtins.bool is_latest: Indicates if the latest version needs to be updated.
        :param builtins.int version_number: Indicates the version number in the schema to update.
        """
        if is_latest is not None:
            pulumi.set(__self__, "is_latest", is_latest)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[builtins.bool]:
        """
        Indicates if the latest version needs to be updated.
        """
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[builtins.int]:
        """
        Indicates the version number in the schema to update.
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class SchemaVersionSchema(dict):
    """
    Identifier for the schema where the schema version will be created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryName":
            suggest = "registry_name"
        elif key == "schemaArn":
            suggest = "schema_arn"
        elif key == "schemaName":
            suggest = "schema_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaVersionSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaVersionSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaVersionSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_name: Optional[builtins.str] = None,
                 schema_arn: Optional[builtins.str] = None,
                 schema_name: Optional[builtins.str] = None):
        """
        Identifier for the schema where the schema version will be created.
        :param builtins.str registry_name: Name of the registry to identify where the Schema is located.
        :param builtins.str schema_arn: Amazon Resource Name for the Schema. This attribute can be used to uniquely represent the Schema.
        :param builtins.str schema_name: Name of the schema. This parameter requires RegistryName to be provided.
        """
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if schema_arn is not None:
            pulumi.set(__self__, "schema_arn", schema_arn)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[builtins.str]:
        """
        Name of the registry to identify where the Schema is located.
        """
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name for the Schema. This attribute can be used to uniquely represent the Schema.
        """
        return pulumi.get(self, "schema_arn")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[builtins.str]:
        """
        Name of the schema. This parameter requires RegistryName to be provided.
        """
        return pulumi.get(self, "schema_name")


@pulumi.output_type
class TriggerAction(dict):
    """
    The actions initiated by this trigger.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crawlerName":
            suggest = "crawler_name"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "notificationProperty":
            suggest = "notification_property"
        elif key == "securityConfiguration":
            suggest = "security_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Optional[Any] = None,
                 crawler_name: Optional[builtins.str] = None,
                 job_name: Optional[builtins.str] = None,
                 notification_property: Optional['outputs.TriggerNotificationProperty'] = None,
                 security_configuration: Optional[builtins.str] = None,
                 timeout: Optional[builtins.int] = None):
        """
        The actions initiated by this trigger.
        :param Any arguments: The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.
        :param builtins.str crawler_name: The name of the crawler to be used with this action.
        :param builtins.str job_name: The name of a job to be executed.
        :param 'TriggerNotificationProperty' notification_property: Specifies configuration properties of a job run notification.
        :param builtins.str security_configuration: The name of the SecurityConfiguration structure to be used with this action.
        :param builtins.int timeout: The JobRun timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if crawler_name is not None:
            pulumi.set(__self__, "crawler_name", crawler_name)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if notification_property is not None:
            pulumi.set(__self__, "notification_property", notification_property)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Any]:
        """
        The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="crawlerName")
    def crawler_name(self) -> Optional[builtins.str]:
        """
        The name of the crawler to be used with this action.
        """
        return pulumi.get(self, "crawler_name")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[builtins.str]:
        """
        The name of a job to be executed.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> Optional['outputs.TriggerNotificationProperty']:
        """
        Specifies configuration properties of a job run notification.
        """
        return pulumi.get(self, "notification_property")

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[builtins.str]:
        """
        The name of the SecurityConfiguration structure to be used with this action.
        """
        return pulumi.get(self, "security_configuration")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.int]:
        """
        The JobRun timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class TriggerCondition(dict):
    """
    Defines a condition under which a trigger fires.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crawlState":
            suggest = "crawl_state"
        elif key == "crawlerName":
            suggest = "crawler_name"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "logicalOperator":
            suggest = "logical_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crawl_state: Optional[builtins.str] = None,
                 crawler_name: Optional[builtins.str] = None,
                 job_name: Optional[builtins.str] = None,
                 logical_operator: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        Defines a condition under which a trigger fires.
        :param builtins.str crawl_state: The state of the crawler to which this condition applies.
        :param builtins.str crawler_name: The name of the crawler to which this condition applies.
        :param builtins.str job_name: The name of the job whose JobRuns this condition applies to, and on which this trigger waits.
        :param builtins.str logical_operator: A logical operator.
        :param builtins.str state: The condition state. Currently, the values supported are SUCCEEDED, STOPPED, TIMEOUT, and FAILED.
        """
        if crawl_state is not None:
            pulumi.set(__self__, "crawl_state", crawl_state)
        if crawler_name is not None:
            pulumi.set(__self__, "crawler_name", crawler_name)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if logical_operator is not None:
            pulumi.set(__self__, "logical_operator", logical_operator)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="crawlState")
    def crawl_state(self) -> Optional[builtins.str]:
        """
        The state of the crawler to which this condition applies.
        """
        return pulumi.get(self, "crawl_state")

    @property
    @pulumi.getter(name="crawlerName")
    def crawler_name(self) -> Optional[builtins.str]:
        """
        The name of the crawler to which this condition applies.
        """
        return pulumi.get(self, "crawler_name")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[builtins.str]:
        """
        The name of the job whose JobRuns this condition applies to, and on which this trigger waits.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="logicalOperator")
    def logical_operator(self) -> Optional[builtins.str]:
        """
        A logical operator.
        """
        return pulumi.get(self, "logical_operator")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The condition state. Currently, the values supported are SUCCEEDED, STOPPED, TIMEOUT, and FAILED.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class TriggerEventBatchingCondition(dict):
    """
    Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSize":
            suggest = "batch_size"
        elif key == "batchWindow":
            suggest = "batch_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerEventBatchingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerEventBatchingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerEventBatchingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size: builtins.int,
                 batch_window: Optional[builtins.int] = None):
        """
        Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires.
        :param builtins.int batch_size: Number of events that must be received from Amazon EventBridge before EventBridge event trigger fires.
        :param builtins.int batch_window: Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received.
        """
        pulumi.set(__self__, "batch_size", batch_size)
        if batch_window is not None:
            pulumi.set(__self__, "batch_window", batch_window)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> builtins.int:
        """
        Number of events that must be received from Amazon EventBridge before EventBridge event trigger fires.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="batchWindow")
    def batch_window(self) -> Optional[builtins.int]:
        """
        Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received.
        """
        return pulumi.get(self, "batch_window")


@pulumi.output_type
class TriggerNotificationProperty(dict):
    """
    Specifies configuration properties of a job run notification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notifyDelayAfter":
            suggest = "notify_delay_after"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerNotificationProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerNotificationProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerNotificationProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notify_delay_after: Optional[builtins.int] = None):
        """
        Specifies configuration properties of a job run notification.
        :param builtins.int notify_delay_after: After a job run starts, the number of minutes to wait before sending a job run delay notification
        """
        if notify_delay_after is not None:
            pulumi.set(__self__, "notify_delay_after", notify_delay_after)

    @property
    @pulumi.getter(name="notifyDelayAfter")
    def notify_delay_after(self) -> Optional[builtins.int]:
        """
        After a job run starts, the number of minutes to wait before sending a job run delay notification
        """
        return pulumi.get(self, "notify_delay_after")


@pulumi.output_type
class TriggerPredicate(dict):
    """
    The predicate of this trigger, which defines when it will fire.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.TriggerCondition']] = None,
                 logical: Optional[builtins.str] = None):
        """
        The predicate of this trigger, which defines when it will fire.
        :param Sequence['TriggerCondition'] conditions: A list of the conditions that determine when the trigger will fire.
        :param builtins.str logical: An optional field if only one condition is listed. If multiple conditions are listed, then this field is required.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if logical is not None:
            pulumi.set(__self__, "logical", logical)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.TriggerCondition']]:
        """
        A list of the conditions that determine when the trigger will fire.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def logical(self) -> Optional[builtins.str]:
        """
        An optional field if only one condition is listed. If multiple conditions are listed, then this field is required.
        """
        return pulumi.get(self, "logical")


@pulumi.output_type
class UsageProfileConfigurationObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "defaultValue":
            suggest = "default_value"
        elif key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsageProfileConfigurationObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsageProfileConfigurationObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsageProfileConfigurationObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_values: Optional[Sequence[builtins.str]] = None,
                 default_value: Optional[builtins.str] = None,
                 max_value: Optional[builtins.str] = None,
                 min_value: Optional[builtins.str] = None):
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "min_value")


@pulumi.output_type
class UsageProfileProfileConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobConfiguration":
            suggest = "job_configuration"
        elif key == "sessionConfiguration":
            suggest = "session_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsageProfileProfileConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsageProfileProfileConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsageProfileProfileConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_configuration: Optional[Mapping[str, 'outputs.UsageProfileConfigurationObject']] = None,
                 session_configuration: Optional[Mapping[str, 'outputs.UsageProfileConfigurationObject']] = None):
        if job_configuration is not None:
            pulumi.set(__self__, "job_configuration", job_configuration)
        if session_configuration is not None:
            pulumi.set(__self__, "session_configuration", session_configuration)

    @property
    @pulumi.getter(name="jobConfiguration")
    def job_configuration(self) -> Optional[Mapping[str, 'outputs.UsageProfileConfigurationObject']]:
        return pulumi.get(self, "job_configuration")

    @property
    @pulumi.getter(name="sessionConfiguration")
    def session_configuration(self) -> Optional[Mapping[str, 'outputs.UsageProfileConfigurationObject']]:
        return pulumi.get(self, "session_configuration")


