# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 command: pulumi.Input['JobCommandArgs'],
                 role: pulumi.Input[builtins.str],
                 allocated_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 connections: Optional[pulumi.Input['JobConnectionsListArgs']] = None,
                 default_arguments: Optional[Any] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execution_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_property: Optional[pulumi.Input['JobExecutionPropertyArgs']] = None,
                 glue_version: Optional[pulumi.Input[builtins.str]] = None,
                 job_mode: Optional[pulumi.Input[builtins.str]] = None,
                 job_run_queuing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_uri: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 max_retries: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 non_overridable_arguments: Optional[Any] = None,
                 notification_property: Optional[pulumi.Input['JobNotificationPropertyArgs']] = None,
                 number_of_workers: Optional[pulumi.Input[builtins.int]] = None,
                 security_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[Any] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 worker_type: Optional[pulumi.Input['JobWorkerType']] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input['JobCommandArgs'] command: The code that executes a job.
        :param pulumi.Input[builtins.str] role: The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
        :param pulumi.Input[builtins.float] allocated_capacity: The number of capacity units that are allocated to this job.
        :param pulumi.Input['JobConnectionsListArgs'] connections: Specifies the connections used by a job
        :param Any default_arguments: The default arguments for this job, specified as name-value pairs.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] description: A description of the job.
        :param pulumi.Input[builtins.str] execution_class: Indicates whether the job is run with a standard or flexible execution class.
        :param pulumi.Input['JobExecutionPropertyArgs'] execution_property: The maximum number of concurrent runs that are allowed for this job.
        :param pulumi.Input[builtins.str] glue_version: Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
        :param pulumi.Input[builtins.str] job_mode: Property description not available.
        :param pulumi.Input[builtins.bool] job_run_queuing_enabled: Property description not available.
        :param pulumi.Input[builtins.str] log_uri: This field is reserved for future use.
        :param pulumi.Input[builtins.str] maintenance_window: Property description not available.
        :param pulumi.Input[builtins.float] max_capacity: The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
        :param pulumi.Input[builtins.float] max_retries: The maximum number of times to retry this job after a JobRun fails
        :param pulumi.Input[builtins.str] name: The name you assign to the job definition
        :param Any non_overridable_arguments: Non-overridable arguments for this job, specified as name-value pairs.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        :param pulumi.Input['JobNotificationPropertyArgs'] notification_property: Specifies configuration properties of a notification.
        :param pulumi.Input[builtins.int] number_of_workers: The number of workers of a defined workerType that are allocated when a job runs.
        :param pulumi.Input[builtins.str] security_configuration: The name of the SecurityConfiguration structure to be used with this job.
        :param Any tags: The tags to use with this job.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.int] timeout: The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
        :param pulumi.Input['JobWorkerType'] worker_type: TThe type of predefined worker that is allocated when a job runs.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "role", role)
        if allocated_capacity is not None:
            pulumi.set(__self__, "allocated_capacity", allocated_capacity)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if default_arguments is not None:
            pulumi.set(__self__, "default_arguments", default_arguments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_class is not None:
            pulumi.set(__self__, "execution_class", execution_class)
        if execution_property is not None:
            pulumi.set(__self__, "execution_property", execution_property)
        if glue_version is not None:
            pulumi.set(__self__, "glue_version", glue_version)
        if job_mode is not None:
            pulumi.set(__self__, "job_mode", job_mode)
        if job_run_queuing_enabled is not None:
            pulumi.set(__self__, "job_run_queuing_enabled", job_run_queuing_enabled)
        if log_uri is not None:
            pulumi.set(__self__, "log_uri", log_uri)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_overridable_arguments is not None:
            pulumi.set(__self__, "non_overridable_arguments", non_overridable_arguments)
        if notification_property is not None:
            pulumi.set(__self__, "notification_property", notification_property)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if worker_type is not None:
            pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter
    def command(self) -> pulumi.Input['JobCommandArgs']:
        """
        The code that executes a job.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input['JobCommandArgs']):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[builtins.str]:
        """
        The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="allocatedCapacity")
    def allocated_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of capacity units that are allocated to this job.
        """
        return pulumi.get(self, "allocated_capacity")

    @allocated_capacity.setter
    def allocated_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "allocated_capacity", value)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input['JobConnectionsListArgs']]:
        """
        Specifies the connections used by a job
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input['JobConnectionsListArgs']]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter(name="defaultArguments")
    def default_arguments(self) -> Optional[Any]:
        """
        The default arguments for this job, specified as name-value pairs.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "default_arguments")

    @default_arguments.setter
    def default_arguments(self, value: Optional[Any]):
        pulumi.set(self, "default_arguments", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionClass")
    def execution_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the job is run with a standard or flexible execution class.
        """
        return pulumi.get(self, "execution_class")

    @execution_class.setter
    def execution_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_class", value)

    @property
    @pulumi.getter(name="executionProperty")
    def execution_property(self) -> Optional[pulumi.Input['JobExecutionPropertyArgs']]:
        """
        The maximum number of concurrent runs that are allowed for this job.
        """
        return pulumi.get(self, "execution_property")

    @execution_property.setter
    def execution_property(self, value: Optional[pulumi.Input['JobExecutionPropertyArgs']]):
        pulumi.set(self, "execution_property", value)

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
        """
        return pulumi.get(self, "glue_version")

    @glue_version.setter
    def glue_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "glue_version", value)

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Property description not available.
        """
        return pulumi.get(self, "job_mode")

    @job_mode.setter
    def job_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_mode", value)

    @property
    @pulumi.getter(name="jobRunQueuingEnabled")
    def job_run_queuing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Property description not available.
        """
        return pulumi.get(self, "job_run_queuing_enabled")

    @job_run_queuing_enabled.setter
    def job_run_queuing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "job_run_queuing_enabled", value)

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field is reserved for future use.
        """
        return pulumi.get(self, "log_uri")

    @log_uri.setter
    def log_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_uri", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Property description not available.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The maximum number of times to retry this job after a JobRun fails
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name you assign to the job definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nonOverridableArguments")
    def non_overridable_arguments(self) -> Optional[Any]:
        """
        Non-overridable arguments for this job, specified as name-value pairs.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "non_overridable_arguments")

    @non_overridable_arguments.setter
    def non_overridable_arguments(self, value: Optional[Any]):
        pulumi.set(self, "non_overridable_arguments", value)

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> Optional[pulumi.Input['JobNotificationPropertyArgs']]:
        """
        Specifies configuration properties of a notification.
        """
        return pulumi.get(self, "notification_property")

    @notification_property.setter
    def notification_property(self, value: Optional[pulumi.Input['JobNotificationPropertyArgs']]):
        pulumi.set(self, "notification_property", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of workers of a defined workerType that are allocated when a job runs.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the SecurityConfiguration structure to be used with this job.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Any]:
        """
        The tags to use with this job.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Any]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> Optional[pulumi.Input['JobWorkerType']]:
        """
        TThe type of predefined worker that is allocated when a job runs.
        """
        return pulumi.get(self, "worker_type")

    @worker_type.setter
    def worker_type(self, value: Optional[pulumi.Input['JobWorkerType']]):
        pulumi.set(self, "worker_type", value)


@pulumi.type_token("aws-native:glue:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 command: Optional[pulumi.Input[Union['JobCommandArgs', 'JobCommandArgsDict']]] = None,
                 connections: Optional[pulumi.Input[Union['JobConnectionsListArgs', 'JobConnectionsListArgsDict']]] = None,
                 default_arguments: Optional[Any] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execution_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_property: Optional[pulumi.Input[Union['JobExecutionPropertyArgs', 'JobExecutionPropertyArgsDict']]] = None,
                 glue_version: Optional[pulumi.Input[builtins.str]] = None,
                 job_mode: Optional[pulumi.Input[builtins.str]] = None,
                 job_run_queuing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_uri: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 max_retries: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 non_overridable_arguments: Optional[Any] = None,
                 notification_property: Optional[pulumi.Input[Union['JobNotificationPropertyArgs', 'JobNotificationPropertyArgsDict']]] = None,
                 number_of_workers: Optional[pulumi.Input[builtins.int]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[Any] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 worker_type: Optional[pulumi.Input['JobWorkerType']] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Glue::Job

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.float] allocated_capacity: The number of capacity units that are allocated to this job.
        :param pulumi.Input[Union['JobCommandArgs', 'JobCommandArgsDict']] command: The code that executes a job.
        :param pulumi.Input[Union['JobConnectionsListArgs', 'JobConnectionsListArgsDict']] connections: Specifies the connections used by a job
        :param Any default_arguments: The default arguments for this job, specified as name-value pairs.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] description: A description of the job.
        :param pulumi.Input[builtins.str] execution_class: Indicates whether the job is run with a standard or flexible execution class.
        :param pulumi.Input[Union['JobExecutionPropertyArgs', 'JobExecutionPropertyArgsDict']] execution_property: The maximum number of concurrent runs that are allowed for this job.
        :param pulumi.Input[builtins.str] glue_version: Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
        :param pulumi.Input[builtins.str] job_mode: Property description not available.
        :param pulumi.Input[builtins.bool] job_run_queuing_enabled: Property description not available.
        :param pulumi.Input[builtins.str] log_uri: This field is reserved for future use.
        :param pulumi.Input[builtins.str] maintenance_window: Property description not available.
        :param pulumi.Input[builtins.float] max_capacity: The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
        :param pulumi.Input[builtins.float] max_retries: The maximum number of times to retry this job after a JobRun fails
        :param pulumi.Input[builtins.str] name: The name you assign to the job definition
        :param Any non_overridable_arguments: Non-overridable arguments for this job, specified as name-value pairs.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        :param pulumi.Input[Union['JobNotificationPropertyArgs', 'JobNotificationPropertyArgsDict']] notification_property: Specifies configuration properties of a notification.
        :param pulumi.Input[builtins.int] number_of_workers: The number of workers of a defined workerType that are allocated when a job runs.
        :param pulumi.Input[builtins.str] role: The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
        :param pulumi.Input[builtins.str] security_configuration: The name of the SecurityConfiguration structure to be used with this job.
        :param Any tags: The tags to use with this job.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.int] timeout: The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
        :param pulumi.Input['JobWorkerType'] worker_type: TThe type of predefined worker that is allocated when a job runs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Glue::Job

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 command: Optional[pulumi.Input[Union['JobCommandArgs', 'JobCommandArgsDict']]] = None,
                 connections: Optional[pulumi.Input[Union['JobConnectionsListArgs', 'JobConnectionsListArgsDict']]] = None,
                 default_arguments: Optional[Any] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execution_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_property: Optional[pulumi.Input[Union['JobExecutionPropertyArgs', 'JobExecutionPropertyArgsDict']]] = None,
                 glue_version: Optional[pulumi.Input[builtins.str]] = None,
                 job_mode: Optional[pulumi.Input[builtins.str]] = None,
                 job_run_queuing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_uri: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 max_retries: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 non_overridable_arguments: Optional[Any] = None,
                 notification_property: Optional[pulumi.Input[Union['JobNotificationPropertyArgs', 'JobNotificationPropertyArgsDict']]] = None,
                 number_of_workers: Optional[pulumi.Input[builtins.int]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[Any] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 worker_type: Optional[pulumi.Input['JobWorkerType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["allocated_capacity"] = allocated_capacity
            if command is None and not opts.urn:
                raise TypeError("Missing required property 'command'")
            __props__.__dict__["command"] = command
            __props__.__dict__["connections"] = connections
            __props__.__dict__["default_arguments"] = default_arguments
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_class"] = execution_class
            __props__.__dict__["execution_property"] = execution_property
            __props__.__dict__["glue_version"] = glue_version
            __props__.__dict__["job_mode"] = job_mode
            __props__.__dict__["job_run_queuing_enabled"] = job_run_queuing_enabled
            __props__.__dict__["log_uri"] = log_uri
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["max_capacity"] = max_capacity
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["name"] = name
            __props__.__dict__["non_overridable_arguments"] = non_overridable_arguments
            __props__.__dict__["notification_property"] = notification_property
            __props__.__dict__["number_of_workers"] = number_of_workers
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["security_configuration"] = security_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["worker_type"] = worker_type
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Job, __self__).__init__(
            'aws-native:glue:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = JobArgs.__new__(JobArgs)

        __props__.__dict__["allocated_capacity"] = None
        __props__.__dict__["command"] = None
        __props__.__dict__["connections"] = None
        __props__.__dict__["default_arguments"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["execution_class"] = None
        __props__.__dict__["execution_property"] = None
        __props__.__dict__["glue_version"] = None
        __props__.__dict__["job_mode"] = None
        __props__.__dict__["job_run_queuing_enabled"] = None
        __props__.__dict__["log_uri"] = None
        __props__.__dict__["maintenance_window"] = None
        __props__.__dict__["max_capacity"] = None
        __props__.__dict__["max_retries"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["non_overridable_arguments"] = None
        __props__.__dict__["notification_property"] = None
        __props__.__dict__["number_of_workers"] = None
        __props__.__dict__["role"] = None
        __props__.__dict__["security_configuration"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["timeout"] = None
        __props__.__dict__["worker_type"] = None
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedCapacity")
    def allocated_capacity(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The number of capacity units that are allocated to this job.
        """
        return pulumi.get(self, "allocated_capacity")

    @property
    @pulumi.getter
    def command(self) -> pulumi.Output['outputs.JobCommand']:
        """
        The code that executes a job.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def connections(self) -> pulumi.Output[Optional['outputs.JobConnectionsList']]:
        """
        Specifies the connections used by a job
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="defaultArguments")
    def default_arguments(self) -> pulumi.Output[Optional[Any]]:
        """
        The default arguments for this job, specified as name-value pairs.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "default_arguments")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionClass")
    def execution_class(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates whether the job is run with a standard or flexible execution class.
        """
        return pulumi.get(self, "execution_class")

    @property
    @pulumi.getter(name="executionProperty")
    def execution_property(self) -> pulumi.Output[Optional['outputs.JobExecutionProperty']]:
        """
        The maximum number of concurrent runs that are allowed for this job.
        """
        return pulumi.get(self, "execution_property")

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
        """
        return pulumi.get(self, "glue_version")

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Property description not available.
        """
        return pulumi.get(self, "job_mode")

    @property
    @pulumi.getter(name="jobRunQueuingEnabled")
    def job_run_queuing_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Property description not available.
        """
        return pulumi.get(self, "job_run_queuing_enabled")

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This field is reserved for future use.
        """
        return pulumi.get(self, "log_uri")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Property description not available.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The maximum number of times to retry this job after a JobRun fails
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name you assign to the job definition
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nonOverridableArguments")
    def non_overridable_arguments(self) -> pulumi.Output[Optional[Any]]:
        """
        Non-overridable arguments for this job, specified as name-value pairs.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "non_overridable_arguments")

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> pulumi.Output[Optional['outputs.JobNotificationProperty']]:
        """
        Specifies configuration properties of a notification.
        """
        return pulumi.get(self, "notification_property")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of workers of a defined workerType that are allocated when a job runs.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the SecurityConfiguration structure to be used with this job.
        """
        return pulumi.get(self, "security_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Any]]:
        """
        The tags to use with this job.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> pulumi.Output[Optional['JobWorkerType']]:
        """
        TThe type of predefined worker that is allocated when a job runs.
        """
        return pulumi.get(self, "worker_type")

