# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetJobResult',
    'AwaitableGetJobResult',
    'get_job',
    'get_job_output',
]

@pulumi.output_type
class GetJobResult:
    def __init__(__self__, allocated_capacity=None, command=None, connections=None, default_arguments=None, description=None, execution_class=None, execution_property=None, glue_version=None, job_mode=None, job_run_queuing_enabled=None, log_uri=None, maintenance_window=None, max_capacity=None, max_retries=None, non_overridable_arguments=None, notification_property=None, number_of_workers=None, role=None, security_configuration=None, tags=None, timeout=None, worker_type=None):
        if allocated_capacity and not isinstance(allocated_capacity, float):
            raise TypeError("Expected argument 'allocated_capacity' to be a float")
        pulumi.set(__self__, "allocated_capacity", allocated_capacity)
        if command and not isinstance(command, dict):
            raise TypeError("Expected argument 'command' to be a dict")
        pulumi.set(__self__, "command", command)
        if connections and not isinstance(connections, dict):
            raise TypeError("Expected argument 'connections' to be a dict")
        pulumi.set(__self__, "connections", connections)
        if default_arguments and not isinstance(default_arguments, dict):
            raise TypeError("Expected argument 'default_arguments' to be a dict")
        pulumi.set(__self__, "default_arguments", default_arguments)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if execution_class and not isinstance(execution_class, str):
            raise TypeError("Expected argument 'execution_class' to be a str")
        pulumi.set(__self__, "execution_class", execution_class)
        if execution_property and not isinstance(execution_property, dict):
            raise TypeError("Expected argument 'execution_property' to be a dict")
        pulumi.set(__self__, "execution_property", execution_property)
        if glue_version and not isinstance(glue_version, str):
            raise TypeError("Expected argument 'glue_version' to be a str")
        pulumi.set(__self__, "glue_version", glue_version)
        if job_mode and not isinstance(job_mode, str):
            raise TypeError("Expected argument 'job_mode' to be a str")
        pulumi.set(__self__, "job_mode", job_mode)
        if job_run_queuing_enabled and not isinstance(job_run_queuing_enabled, bool):
            raise TypeError("Expected argument 'job_run_queuing_enabled' to be a bool")
        pulumi.set(__self__, "job_run_queuing_enabled", job_run_queuing_enabled)
        if log_uri and not isinstance(log_uri, str):
            raise TypeError("Expected argument 'log_uri' to be a str")
        pulumi.set(__self__, "log_uri", log_uri)
        if maintenance_window and not isinstance(maintenance_window, str):
            raise TypeError("Expected argument 'maintenance_window' to be a str")
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        if max_capacity and not isinstance(max_capacity, float):
            raise TypeError("Expected argument 'max_capacity' to be a float")
        pulumi.set(__self__, "max_capacity", max_capacity)
        if max_retries and not isinstance(max_retries, float):
            raise TypeError("Expected argument 'max_retries' to be a float")
        pulumi.set(__self__, "max_retries", max_retries)
        if non_overridable_arguments and not isinstance(non_overridable_arguments, dict):
            raise TypeError("Expected argument 'non_overridable_arguments' to be a dict")
        pulumi.set(__self__, "non_overridable_arguments", non_overridable_arguments)
        if notification_property and not isinstance(notification_property, dict):
            raise TypeError("Expected argument 'notification_property' to be a dict")
        pulumi.set(__self__, "notification_property", notification_property)
        if number_of_workers and not isinstance(number_of_workers, int):
            raise TypeError("Expected argument 'number_of_workers' to be a int")
        pulumi.set(__self__, "number_of_workers", number_of_workers)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if security_configuration and not isinstance(security_configuration, str):
            raise TypeError("Expected argument 'security_configuration' to be a str")
        pulumi.set(__self__, "security_configuration", security_configuration)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)
        if worker_type and not isinstance(worker_type, str):
            raise TypeError("Expected argument 'worker_type' to be a str")
        pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter(name="allocatedCapacity")
    def allocated_capacity(self) -> Optional[builtins.float]:
        """
        The number of capacity units that are allocated to this job.
        """
        return pulumi.get(self, "allocated_capacity")

    @property
    @pulumi.getter
    def command(self) -> Optional['outputs.JobCommand']:
        """
        The code that executes a job.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def connections(self) -> Optional['outputs.JobConnectionsList']:
        """
        Specifies the connections used by a job
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="defaultArguments")
    def default_arguments(self) -> Optional[Any]:
        """
        The default arguments for this job, specified as name-value pairs.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "default_arguments")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionClass")
    def execution_class(self) -> Optional[builtins.str]:
        """
        Indicates whether the job is run with a standard or flexible execution class.
        """
        return pulumi.get(self, "execution_class")

    @property
    @pulumi.getter(name="executionProperty")
    def execution_property(self) -> Optional['outputs.JobExecutionProperty']:
        """
        The maximum number of concurrent runs that are allowed for this job.
        """
        return pulumi.get(self, "execution_property")

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> Optional[builtins.str]:
        """
        Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
        """
        return pulumi.get(self, "glue_version")

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> Optional[builtins.str]:
        """
        Property description not available.
        """
        return pulumi.get(self, "job_mode")

    @property
    @pulumi.getter(name="jobRunQueuingEnabled")
    def job_run_queuing_enabled(self) -> Optional[builtins.bool]:
        """
        Property description not available.
        """
        return pulumi.get(self, "job_run_queuing_enabled")

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> Optional[builtins.str]:
        """
        This field is reserved for future use.
        """
        return pulumi.get(self, "log_uri")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[builtins.str]:
        """
        Property description not available.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[builtins.float]:
        """
        The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[builtins.float]:
        """
        The maximum number of times to retry this job after a JobRun fails
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="nonOverridableArguments")
    def non_overridable_arguments(self) -> Optional[Any]:
        """
        Non-overridable arguments for this job, specified as name-value pairs.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "non_overridable_arguments")

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> Optional['outputs.JobNotificationProperty']:
        """
        Specifies configuration properties of a notification.
        """
        return pulumi.get(self, "notification_property")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[builtins.int]:
        """
        The number of workers of a defined workerType that are allocated when a job runs.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[builtins.str]:
        """
        The name of the SecurityConfiguration structure to be used with this job.
        """
        return pulumi.get(self, "security_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Any]:
        """
        The tags to use with this job.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Glue::Job` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.int]:
        """
        The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> Optional['JobWorkerType']:
        """
        TThe type of predefined worker that is allocated when a job runs.
        """
        return pulumi.get(self, "worker_type")


class AwaitableGetJobResult(GetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobResult(
            allocated_capacity=self.allocated_capacity,
            command=self.command,
            connections=self.connections,
            default_arguments=self.default_arguments,
            description=self.description,
            execution_class=self.execution_class,
            execution_property=self.execution_property,
            glue_version=self.glue_version,
            job_mode=self.job_mode,
            job_run_queuing_enabled=self.job_run_queuing_enabled,
            log_uri=self.log_uri,
            maintenance_window=self.maintenance_window,
            max_capacity=self.max_capacity,
            max_retries=self.max_retries,
            non_overridable_arguments=self.non_overridable_arguments,
            notification_property=self.notification_property,
            number_of_workers=self.number_of_workers,
            role=self.role,
            security_configuration=self.security_configuration,
            tags=self.tags,
            timeout=self.timeout,
            worker_type=self.worker_type)


def get_job(name: Optional[builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobResult:
    """
    Resource Type definition for AWS::Glue::Job


    :param builtins.str name: The name you assign to the job definition
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:glue:getJob', __args__, opts=opts, typ=GetJobResult).value

    return AwaitableGetJobResult(
        allocated_capacity=pulumi.get(__ret__, 'allocated_capacity'),
        command=pulumi.get(__ret__, 'command'),
        connections=pulumi.get(__ret__, 'connections'),
        default_arguments=pulumi.get(__ret__, 'default_arguments'),
        description=pulumi.get(__ret__, 'description'),
        execution_class=pulumi.get(__ret__, 'execution_class'),
        execution_property=pulumi.get(__ret__, 'execution_property'),
        glue_version=pulumi.get(__ret__, 'glue_version'),
        job_mode=pulumi.get(__ret__, 'job_mode'),
        job_run_queuing_enabled=pulumi.get(__ret__, 'job_run_queuing_enabled'),
        log_uri=pulumi.get(__ret__, 'log_uri'),
        maintenance_window=pulumi.get(__ret__, 'maintenance_window'),
        max_capacity=pulumi.get(__ret__, 'max_capacity'),
        max_retries=pulumi.get(__ret__, 'max_retries'),
        non_overridable_arguments=pulumi.get(__ret__, 'non_overridable_arguments'),
        notification_property=pulumi.get(__ret__, 'notification_property'),
        number_of_workers=pulumi.get(__ret__, 'number_of_workers'),
        role=pulumi.get(__ret__, 'role'),
        security_configuration=pulumi.get(__ret__, 'security_configuration'),
        tags=pulumi.get(__ret__, 'tags'),
        timeout=pulumi.get(__ret__, 'timeout'),
        worker_type=pulumi.get(__ret__, 'worker_type'))
def get_job_output(name: Optional[pulumi.Input[builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobResult]:
    """
    Resource Type definition for AWS::Glue::Job


    :param builtins.str name: The name you assign to the job definition
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:glue:getJob', __args__, opts=opts, typ=GetJobResult)
    return __ret__.apply(lambda __response__: GetJobResult(
        allocated_capacity=pulumi.get(__response__, 'allocated_capacity'),
        command=pulumi.get(__response__, 'command'),
        connections=pulumi.get(__response__, 'connections'),
        default_arguments=pulumi.get(__response__, 'default_arguments'),
        description=pulumi.get(__response__, 'description'),
        execution_class=pulumi.get(__response__, 'execution_class'),
        execution_property=pulumi.get(__response__, 'execution_property'),
        glue_version=pulumi.get(__response__, 'glue_version'),
        job_mode=pulumi.get(__response__, 'job_mode'),
        job_run_queuing_enabled=pulumi.get(__response__, 'job_run_queuing_enabled'),
        log_uri=pulumi.get(__response__, 'log_uri'),
        maintenance_window=pulumi.get(__response__, 'maintenance_window'),
        max_capacity=pulumi.get(__response__, 'max_capacity'),
        max_retries=pulumi.get(__response__, 'max_retries'),
        non_overridable_arguments=pulumi.get(__response__, 'non_overridable_arguments'),
        notification_property=pulumi.get(__response__, 'notification_property'),
        number_of_workers=pulumi.get(__response__, 'number_of_workers'),
        role=pulumi.get(__response__, 'role'),
        security_configuration=pulumi.get(__response__, 'security_configuration'),
        tags=pulumi.get(__response__, 'tags'),
        timeout=pulumi.get(__response__, 'timeout'),
        worker_type=pulumi.get(__response__, 'worker_type')))
