# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 catalog_id: pulumi.Input[builtins.str],
                 database_input: pulumi.Input['DatabaseInputArgs'],
                 database_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[builtins.str] catalog_id: The AWS account ID for the account in which to create the catalog object.
        :param pulumi.Input['DatabaseInputArgs'] database_input: The metadata for the database.
        :param pulumi.Input[builtins.str] database_name: The name of the database. For hive compatibility, this is folded to lowercase when it is store.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_input", database_input)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Input[builtins.str]:
        """
        The AWS account ID for the account in which to create the catalog object.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseInput")
    def database_input(self) -> pulumi.Input['DatabaseInputArgs']:
        """
        The metadata for the database.
        """
        return pulumi.get(self, "database_input")

    @database_input.setter
    def database_input(self, value: pulumi.Input['DatabaseInputArgs']):
        pulumi.set(self, "database_input", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database. For hive compatibility, this is folded to lowercase when it is store.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)


@pulumi.type_token("aws-native:glue:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_input: Optional[pulumi.Input[Union['DatabaseInputArgs', 'DatabaseInputArgsDict']]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Glue::Database

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] catalog_id: The AWS account ID for the account in which to create the catalog object.
        :param pulumi.Input[Union['DatabaseInputArgs', 'DatabaseInputArgsDict']] database_input: The metadata for the database.
        :param pulumi.Input[builtins.str] database_name: The name of the database. For hive compatibility, this is folded to lowercase when it is store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Glue::Database

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_input: Optional[pulumi.Input[Union['DatabaseInputArgs', 'DatabaseInputArgsDict']]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            if catalog_id is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_id'")
            __props__.__dict__["catalog_id"] = catalog_id
            if database_input is None and not opts.urn:
                raise TypeError("Missing required property 'database_input'")
            __props__.__dict__["database_input"] = database_input
            __props__.__dict__["database_name"] = database_name
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["databaseName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Database, __self__).__init__(
            'aws-native:glue:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DatabaseArgs.__new__(DatabaseArgs)

        __props__.__dict__["catalog_id"] = None
        __props__.__dict__["database_input"] = None
        __props__.__dict__["database_name"] = None
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS account ID for the account in which to create the catalog object.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseInput")
    def database_input(self) -> pulumi.Output['outputs.DatabaseInput']:
        """
        The metadata for the database.
        """
        return pulumi.get(self, "database_input")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the database. For hive compatibility, this is folded to lowercase when it is store.
        """
        return pulumi.get(self, "database_name")

