# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'CrossAccountAttachmentResource',
    'EndpointGroupEndpointConfiguration',
    'EndpointGroupPortOverride',
    'ListenerPortRange',
]

@pulumi.output_type
class CrossAccountAttachmentResource(dict):
    """
    ARN of resource to share.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrossAccountAttachmentResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrossAccountAttachmentResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrossAccountAttachmentResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: Optional[builtins.str] = None,
                 endpoint_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        ARN of resource to share.
        :param builtins.str cidr: An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and advertised in AWS Global Accelerator by following the bring your own IP address (BYOIP) process for Global Accelerator
               
               For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the AWS Global Accelerator Developer Guide.
        :param builtins.str endpoint_id: The endpoint ID for the endpoint that is specified as a AWS resource.
               
               An endpoint ID for the cross-account feature is the ARN of an AWS resource, such as a Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
        :param builtins.str region: The AWS Region where a shared endpoint resource is located.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[builtins.str]:
        """
        An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and advertised in AWS Global Accelerator by following the bring your own IP address (BYOIP) process for Global Accelerator

        For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the AWS Global Accelerator Developer Guide.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The endpoint ID for the endpoint that is specified as a AWS resource.

        An endpoint ID for the cross-account feature is the ARN of an AWS resource, such as a Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The AWS Region where a shared endpoint resource is located.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class EndpointGroupEndpointConfiguration(dict):
    """
    The configuration for a given endpoint
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"
        elif key == "attachmentArn":
            suggest = "attachment_arn"
        elif key == "clientIpPreservationEnabled":
            suggest = "client_ip_preservation_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointGroupEndpointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointGroupEndpointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointGroupEndpointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: builtins.str,
                 attachment_arn: Optional[builtins.str] = None,
                 client_ip_preservation_enabled: Optional[builtins.bool] = None,
                 weight: Optional[builtins.int] = None):
        """
        The configuration for a given endpoint
        :param builtins.str endpoint_id: Id of the endpoint. For Network/Application Load Balancer this value is the ARN.  For EIP, this value is the allocation ID.  For EC2 instances, this is the EC2 instance ID
        :param builtins.str attachment_arn: Attachment ARN that provides access control to the cross account endpoint. Not required for resources hosted in the same account as the endpoint group.
        :param builtins.bool client_ip_preservation_enabled: true if client ip should be preserved
        :param builtins.int weight: The weight for the endpoint.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        if attachment_arn is not None:
            pulumi.set(__self__, "attachment_arn", attachment_arn)
        if client_ip_preservation_enabled is not None:
            pulumi.set(__self__, "client_ip_preservation_enabled", client_ip_preservation_enabled)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> builtins.str:
        """
        Id of the endpoint. For Network/Application Load Balancer this value is the ARN.  For EIP, this value is the allocation ID.  For EC2 instances, this is the EC2 instance ID
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="attachmentArn")
    def attachment_arn(self) -> Optional[builtins.str]:
        """
        Attachment ARN that provides access control to the cross account endpoint. Not required for resources hosted in the same account as the endpoint group.
        """
        return pulumi.get(self, "attachment_arn")

    @property
    @pulumi.getter(name="clientIpPreservationEnabled")
    def client_ip_preservation_enabled(self) -> Optional[builtins.bool]:
        """
        true if client ip should be preserved
        """
        return pulumi.get(self, "client_ip_preservation_enabled")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The weight for the endpoint.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class EndpointGroupPortOverride(dict):
    """
    listener to endpoint port mapping.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointPort":
            suggest = "endpoint_port"
        elif key == "listenerPort":
            suggest = "listener_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointGroupPortOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointGroupPortOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointGroupPortOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_port: builtins.int,
                 listener_port: builtins.int):
        """
        listener to endpoint port mapping.
        :param builtins.int endpoint_port: The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
        :param builtins.int listener_port: The listener port that you want to map to a specific endpoint port. This is the port that user traffic arrives to the Global Accelerator on.
        """
        pulumi.set(__self__, "endpoint_port", endpoint_port)
        pulumi.set(__self__, "listener_port", listener_port)

    @property
    @pulumi.getter(name="endpointPort")
    def endpoint_port(self) -> builtins.int:
        """
        The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
        """
        return pulumi.get(self, "endpoint_port")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> builtins.int:
        """
        The listener port that you want to map to a specific endpoint port. This is the port that user traffic arrives to the Global Accelerator on.
        """
        return pulumi.get(self, "listener_port")


@pulumi.output_type
class ListenerPortRange(dict):
    """
    A port range to support for connections from  clients to your accelerator.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: builtins.int,
                 to_port: builtins.int):
        """
        A port range to support for connections from  clients to your accelerator.
        :param builtins.int from_port: The first port in the range of ports, inclusive.
        :param builtins.int to_port: The last port in the range of ports, inclusive.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> builtins.int:
        """
        The first port in the range of ports, inclusive.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> builtins.int:
        """
        The last port in the range of ports, inclusive.
        """
        return pulumi.get(self, "to_port")


