# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamGroupArgs', 'StreamGroup']

@pulumi.input_type
class StreamGroupArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 location_configurations: pulumi.Input[Sequence[pulumi.Input['StreamGroupLocationConfigurationArgs']]],
                 stream_class: pulumi.Input[builtins.str],
                 default_application: Optional[pulumi.Input['StreamGroupDefaultApplicationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a StreamGroup resource.
        :param pulumi.Input[builtins.str] description: A descriptive label for the stream group.
        :param pulumi.Input[Sequence[pulumi.Input['StreamGroupLocationConfigurationArgs']]] location_configurations: A set of one or more locations and the streaming capacity for each location. One of the locations MUST be your primary location, which is the AWS Region where you are specifying this resource.
        :param pulumi.Input[builtins.str] stream_class: The target stream quality for sessions that are hosted in this stream group. Set a stream class that is appropriate to the type of content that you're streaming. Stream class determines the type of computing resources Amazon GameLift Streams uses and impacts the cost of streaming. The following options are available:
               
               A stream class can be one of the following:
               
               - *`gen5n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
               - Tenancy: Supports 1 concurrent stream session
               - *`gen5n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA A10G Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
               - Tenancy: Supports up to 2 concurrent stream sessions
               - *`gen5n_ultra` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
               - Tenancy: Supports 1 concurrent stream session
               - *`gen4n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
               - Tenancy: Supports 1 concurrent stream session
               - *`gen4n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA T4 Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
               - Tenancy: Supports up to 2 concurrent stream sessions
               - *`gen4n_ultra` (NVIDIA, ultra)* Supports applications with high 3D scene complexity. Uses dedicated NVIDIA T4 Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
               - Tenancy: Supports 1 concurrent stream session
        :param pulumi.Input['StreamGroupDefaultApplicationArgs'] default_application: Object that identifies the Amazon GameLift Streams application to stream with this stream group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A list of labels to assign to the new stream group resource. Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management and cost allocation. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *AWS General Reference* .
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "location_configurations", location_configurations)
        pulumi.set(__self__, "stream_class", stream_class)
        if default_application is not None:
            pulumi.set(__self__, "default_application", default_application)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        A descriptive label for the stream group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="locationConfigurations")
    def location_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['StreamGroupLocationConfigurationArgs']]]:
        """
        A set of one or more locations and the streaming capacity for each location. One of the locations MUST be your primary location, which is the AWS Region where you are specifying this resource.
        """
        return pulumi.get(self, "location_configurations")

    @location_configurations.setter
    def location_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['StreamGroupLocationConfigurationArgs']]]):
        pulumi.set(self, "location_configurations", value)

    @property
    @pulumi.getter(name="streamClass")
    def stream_class(self) -> pulumi.Input[builtins.str]:
        """
        The target stream quality for sessions that are hosted in this stream group. Set a stream class that is appropriate to the type of content that you're streaming. Stream class determines the type of computing resources Amazon GameLift Streams uses and impacts the cost of streaming. The following options are available:

        A stream class can be one of the following:

        - *`gen5n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
        - Tenancy: Supports 1 concurrent stream session
        - *`gen5n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA A10G Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
        - Tenancy: Supports up to 2 concurrent stream sessions
        - *`gen5n_ultra` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
        - Tenancy: Supports 1 concurrent stream session
        - *`gen4n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
        - Tenancy: Supports 1 concurrent stream session
        - *`gen4n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA T4 Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
        - Tenancy: Supports up to 2 concurrent stream sessions
        - *`gen4n_ultra` (NVIDIA, ultra)* Supports applications with high 3D scene complexity. Uses dedicated NVIDIA T4 Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
        - Tenancy: Supports 1 concurrent stream session
        """
        return pulumi.get(self, "stream_class")

    @stream_class.setter
    def stream_class(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_class", value)

    @property
    @pulumi.getter(name="defaultApplication")
    def default_application(self) -> Optional[pulumi.Input['StreamGroupDefaultApplicationArgs']]:
        """
        Object that identifies the Amazon GameLift Streams application to stream with this stream group.
        """
        return pulumi.get(self, "default_application")

    @default_application.setter
    def default_application(self, value: Optional[pulumi.Input['StreamGroupDefaultApplicationArgs']]):
        pulumi.set(self, "default_application", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A list of labels to assign to the new stream group resource. Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management and cost allocation. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *AWS General Reference* .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:gameliftstreams:StreamGroup")
class StreamGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_application: Optional[pulumi.Input[Union['StreamGroupDefaultApplicationArgs', 'StreamGroupDefaultApplicationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamGroupLocationConfigurationArgs', 'StreamGroupLocationConfigurationArgsDict']]]]] = None,
                 stream_class: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::GameLiftStreams::StreamGroup Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StreamGroupDefaultApplicationArgs', 'StreamGroupDefaultApplicationArgsDict']] default_application: Object that identifies the Amazon GameLift Streams application to stream with this stream group.
        :param pulumi.Input[builtins.str] description: A descriptive label for the stream group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamGroupLocationConfigurationArgs', 'StreamGroupLocationConfigurationArgsDict']]]] location_configurations: A set of one or more locations and the streaming capacity for each location. One of the locations MUST be your primary location, which is the AWS Region where you are specifying this resource.
        :param pulumi.Input[builtins.str] stream_class: The target stream quality for sessions that are hosted in this stream group. Set a stream class that is appropriate to the type of content that you're streaming. Stream class determines the type of computing resources Amazon GameLift Streams uses and impacts the cost of streaming. The following options are available:
               
               A stream class can be one of the following:
               
               - *`gen5n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
               - Tenancy: Supports 1 concurrent stream session
               - *`gen5n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA A10G Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
               - Tenancy: Supports up to 2 concurrent stream sessions
               - *`gen5n_ultra` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
               - Tenancy: Supports 1 concurrent stream session
               - *`gen4n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
               - Tenancy: Supports 1 concurrent stream session
               - *`gen4n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA T4 Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
               - Tenancy: Supports up to 2 concurrent stream sessions
               - *`gen4n_ultra` (NVIDIA, ultra)* Supports applications with high 3D scene complexity. Uses dedicated NVIDIA T4 Tensor GPU.
               
               - Reference resolution: 1080p
               - Reference frame rate: 60 fps
               - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
               - Tenancy: Supports 1 concurrent stream session
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A list of labels to assign to the new stream group resource. Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management and cost allocation. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *AWS General Reference* .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::GameLiftStreams::StreamGroup Resource Type

        :param str resource_name: The name of the resource.
        :param StreamGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_application: Optional[pulumi.Input[Union['StreamGroupDefaultApplicationArgs', 'StreamGroupDefaultApplicationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamGroupLocationConfigurationArgs', 'StreamGroupLocationConfigurationArgsDict']]]]] = None,
                 stream_class: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamGroupArgs.__new__(StreamGroupArgs)

            __props__.__dict__["default_application"] = default_application
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if location_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'location_configurations'")
            __props__.__dict__["location_configurations"] = location_configurations
            if stream_class is None and not opts.urn:
                raise TypeError("Missing required property 'stream_class'")
            __props__.__dict__["stream_class"] = stream_class
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["defaultApplication.id", "streamClass"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(StreamGroup, __self__).__init__(
            'aws-native:gameliftstreams:StreamGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StreamGroup':
        """
        Get an existing StreamGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StreamGroupArgs.__new__(StreamGroupArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["default_application"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["location_configurations"] = None
        __props__.__dict__["stream_class"] = None
        __props__.__dict__["tags"] = None
        return StreamGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the stream group resource. For example: `arn:aws:gameliftstreams:us-west-2:123456789012:streamgroup/sg-1AB2C3De4` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        An ID that uniquely identifies the stream group resource. For example: `sg-1AB2C3De4` .
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="defaultApplication")
    def default_application(self) -> pulumi.Output[Optional['outputs.StreamGroupDefaultApplication']]:
        """
        Object that identifies the Amazon GameLift Streams application to stream with this stream group.
        """
        return pulumi.get(self, "default_application")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A descriptive label for the stream group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="locationConfigurations")
    def location_configurations(self) -> pulumi.Output[Sequence['outputs.StreamGroupLocationConfiguration']]:
        """
        A set of one or more locations and the streaming capacity for each location. One of the locations MUST be your primary location, which is the AWS Region where you are specifying this resource.
        """
        return pulumi.get(self, "location_configurations")

    @property
    @pulumi.getter(name="streamClass")
    def stream_class(self) -> pulumi.Output[builtins.str]:
        """
        The target stream quality for sessions that are hosted in this stream group. Set a stream class that is appropriate to the type of content that you're streaming. Stream class determines the type of computing resources Amazon GameLift Streams uses and impacts the cost of streaming. The following options are available:

        A stream class can be one of the following:

        - *`gen5n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
        - Tenancy: Supports 1 concurrent stream session
        - *`gen5n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA A10G Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
        - Tenancy: Supports up to 2 concurrent stream sessions
        - *`gen5n_ultra` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
        - Tenancy: Supports 1 concurrent stream session
        - *`gen4n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
        - Tenancy: Supports 1 concurrent stream session
        - *`gen4n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA T4 Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
        - Tenancy: Supports up to 2 concurrent stream sessions
        - *`gen4n_ultra` (NVIDIA, ultra)* Supports applications with high 3D scene complexity. Uses dedicated NVIDIA T4 Tensor GPU.

        - Reference resolution: 1080p
        - Reference frame rate: 60 fps
        - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
        - Tenancy: Supports 1 concurrent stream session
        """
        return pulumi.get(self, "stream_class")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A list of labels to assign to the new stream group resource. Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management and cost allocation. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *AWS General Reference* .
        """
        return pulumi.get(self, "tags")

