# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStreamGroupResult',
    'AwaitableGetStreamGroupResult',
    'get_stream_group',
    'get_stream_group_output',
]

@pulumi.output_type
class GetStreamGroupResult:
    def __init__(__self__, arn=None, default_application=None, description=None, id=None, location_configurations=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if default_application and not isinstance(default_application, dict):
            raise TypeError("Expected argument 'default_application' to be a dict")
        pulumi.set(__self__, "default_application", default_application)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location_configurations and not isinstance(location_configurations, list):
            raise TypeError("Expected argument 'location_configurations' to be a list")
        pulumi.set(__self__, "location_configurations", location_configurations)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the stream group resource. For example: `arn:aws:gameliftstreams:us-west-2:123456789012:streamgroup/sg-1AB2C3De4` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultApplication")
    def default_application(self) -> Optional['outputs.StreamGroupDefaultApplication']:
        """
        Object that identifies the Amazon GameLift Streams application to stream with this stream group.
        """
        return pulumi.get(self, "default_application")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A descriptive label for the stream group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        An ID that uniquely identifies the stream group resource. For example: `sg-1AB2C3De4` .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="locationConfigurations")
    def location_configurations(self) -> Optional[Sequence['outputs.StreamGroupLocationConfiguration']]:
        """
        A set of one or more locations and the streaming capacity for each location. One of the locations MUST be your primary location, which is the AWS Region where you are specifying this resource.
        """
        return pulumi.get(self, "location_configurations")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A list of labels to assign to the new stream group resource. Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management and cost allocation. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *AWS General Reference* .
        """
        return pulumi.get(self, "tags")


class AwaitableGetStreamGroupResult(GetStreamGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamGroupResult(
            arn=self.arn,
            default_application=self.default_application,
            description=self.description,
            id=self.id,
            location_configurations=self.location_configurations,
            tags=self.tags)


def get_stream_group(arn: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamGroupResult:
    """
    Definition of AWS::GameLiftStreams::StreamGroup Resource Type


    :param builtins.str arn: An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the stream group resource. For example: `arn:aws:gameliftstreams:us-west-2:123456789012:streamgroup/sg-1AB2C3De4` .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:gameliftstreams:getStreamGroup', __args__, opts=opts, typ=GetStreamGroupResult).value

    return AwaitableGetStreamGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        default_application=pulumi.get(__ret__, 'default_application'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        location_configurations=pulumi.get(__ret__, 'location_configurations'),
        tags=pulumi.get(__ret__, 'tags'))
def get_stream_group_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamGroupResult]:
    """
    Definition of AWS::GameLiftStreams::StreamGroup Resource Type


    :param builtins.str arn: An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the stream group resource. For example: `arn:aws:gameliftstreams:us-west-2:123456789012:streamgroup/sg-1AB2C3De4` .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:gameliftstreams:getStreamGroup', __args__, opts=opts, typ=GetStreamGroupResult)
    return __ret__.apply(lambda __response__: GetStreamGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        default_application=pulumi.get(__response__, 'default_application'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        location_configurations=pulumi.get(__response__, 'location_configurations'),
        tags=pulumi.get(__response__, 'tags')))
