# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ApplicationRuntimeEnvironmentArgs',
    'ApplicationRuntimeEnvironmentArgsDict',
    'StreamGroupDefaultApplicationArgs',
    'StreamGroupDefaultApplicationArgsDict',
    'StreamGroupLocationConfigurationArgs',
    'StreamGroupLocationConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class ApplicationRuntimeEnvironmentArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
        """
        version: pulumi.Input[builtins.str]
        """
        Versioned container environment for the application operating system.
        """
elif False:
    ApplicationRuntimeEnvironmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationRuntimeEnvironmentArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 version: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] type: The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
        :param pulumi.Input[builtins.str] version: Versioned container environment for the application operating system.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        Versioned container environment for the application operating system.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)


if not MYPY:
    class StreamGroupDefaultApplicationArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[builtins.str]]
        """
        An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the application resource. Example ARN: `arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6` .
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        An ID that uniquely identifies the application resource. Example ID: `a-9ZY8X7Wv6` .
        """
elif False:
    StreamGroupDefaultApplicationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamGroupDefaultApplicationArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] arn: An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the application resource. Example ARN: `arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6` .
        :param pulumi.Input[builtins.str] id: An ID that uniquely identifies the application resource. Example ID: `a-9ZY8X7Wv6` .
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the application resource. Example ARN: `arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6` .
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An ID that uniquely identifies the application resource. Example ID: `a-9ZY8X7Wv6` .
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class StreamGroupLocationConfigurationArgsDict(TypedDict):
        location_name: pulumi.Input[builtins.str]
        """
        A location's name. For example, `us-east-1` . For a complete list of locations that Amazon GameLift Streams supports, refer to [Regions, quotas, and limitations](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html) in the *Amazon GameLift Streams Developer Guide* .
        """
        always_on_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
        """
        on_demand_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater startup time (typically under 5 minutes).
        """
elif False:
    StreamGroupLocationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamGroupLocationConfigurationArgs:
    def __init__(__self__, *,
                 location_name: pulumi.Input[builtins.str],
                 always_on_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 on_demand_capacity: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] location_name: A location's name. For example, `us-east-1` . For a complete list of locations that Amazon GameLift Streams supports, refer to [Regions, quotas, and limitations](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html) in the *Amazon GameLift Streams Developer Guide* .
        :param pulumi.Input[builtins.int] always_on_capacity: The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
        :param pulumi.Input[builtins.int] on_demand_capacity: The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater startup time (typically under 5 minutes).
        """
        pulumi.set(__self__, "location_name", location_name)
        if always_on_capacity is not None:
            pulumi.set(__self__, "always_on_capacity", always_on_capacity)
        if on_demand_capacity is not None:
            pulumi.set(__self__, "on_demand_capacity", on_demand_capacity)

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> pulumi.Input[builtins.str]:
        """
        A location's name. For example, `us-east-1` . For a complete list of locations that Amazon GameLift Streams supports, refer to [Regions, quotas, and limitations](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html) in the *Amazon GameLift Streams Developer Guide* .
        """
        return pulumi.get(self, "location_name")

    @location_name.setter
    def location_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location_name", value)

    @property
    @pulumi.getter(name="alwaysOnCapacity")
    def always_on_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
        """
        return pulumi.get(self, "always_on_capacity")

    @always_on_capacity.setter
    def always_on_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "always_on_capacity", value)

    @property
    @pulumi.getter(name="onDemandCapacity")
    def on_demand_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater startup time (typically under 5 minutes).
        """
        return pulumi.get(self, "on_demand_capacity")

    @on_demand_capacity.setter
    def on_demand_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "on_demand_capacity", value)


