# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AliasRoutingStrategy',
    'BuildStorageLocation',
    'ContainerFleetConnectionPortRange',
    'ContainerFleetDeploymentConfiguration',
    'ContainerFleetDeploymentDetails',
    'ContainerFleetGameSessionCreationLimitPolicy',
    'ContainerFleetIpPermission',
    'ContainerFleetLocationCapacity',
    'ContainerFleetLocationConfiguration',
    'ContainerFleetLogConfiguration',
    'ContainerFleetScalingPolicy',
    'ContainerFleetTargetConfiguration',
    'ContainerGroupDefinitionContainerDependency',
    'ContainerGroupDefinitionContainerEnvironment',
    'ContainerGroupDefinitionContainerHealthCheck',
    'ContainerGroupDefinitionContainerMountPoint',
    'ContainerGroupDefinitionContainerPortRange',
    'ContainerGroupDefinitionGameServerContainerDefinition',
    'ContainerGroupDefinitionPortConfiguration',
    'ContainerGroupDefinitionSupportContainerDefinition',
    'FleetAnywhereConfiguration',
    'FleetCertificateConfiguration',
    'FleetIpPermission',
    'FleetLocationCapacity',
    'FleetLocationConfiguration',
    'FleetResourceCreationLimitPolicy',
    'FleetRuntimeConfiguration',
    'FleetScalingPolicy',
    'FleetServerProcess',
    'FleetTargetConfiguration',
    'GameServerGroupAutoScalingPolicy',
    'GameServerGroupInstanceDefinition',
    'GameServerGroupLaunchTemplate',
    'GameServerGroupTargetTrackingConfiguration',
    'GameSessionQueueDestination',
    'GameSessionQueueFilterConfiguration',
    'GameSessionQueuePlayerLatencyPolicy',
    'GameSessionQueuePriorityConfiguration',
    'MatchmakingConfigurationGameProperty',
    'ScriptS3Location',
]

@pulumi.output_type
class AliasRoutingStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fleetId":
            suggest = "fleet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasRoutingStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasRoutingStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasRoutingStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'AliasRoutingStrategyType',
                 fleet_id: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None):
        """
        :param 'AliasRoutingStrategyType' type: Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        :param builtins.str fleet_id: A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        :param builtins.str message: The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        pulumi.set(__self__, "type", type)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def type(self) -> 'AliasRoutingStrategyType':
        """
        Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class BuildStorageLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "objectVersion":
            suggest = "object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildStorageLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildStorageLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildStorageLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 key: builtins.str,
                 role_arn: builtins.str,
                 object_version: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        :param builtins.str key: The name of the zip file that contains the build files or script files.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        :param builtins.str object_version: The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The name of the zip file that contains the build files or script files.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[builtins.str]:
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        return pulumi.get(self, "object_version")


@pulumi.output_type
class ContainerFleetConnectionPortRange(dict):
    """
    Defines the range of ports on the instance that allow inbound traffic to connect with containers in a fleet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetConnectionPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetConnectionPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetConnectionPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: builtins.int,
                 to_port: builtins.int):
        """
        Defines the range of ports on the instance that allow inbound traffic to connect with containers in a fleet.
        :param builtins.int from_port: A starting value for a range of allowed port numbers.
        :param builtins.int to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> builtins.int:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> builtins.int:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class ContainerFleetDeploymentConfiguration(dict):
    """
    Provides details about how to drain old tasks and replace them with new updated tasks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "impairmentStrategy":
            suggest = "impairment_strategy"
        elif key == "minimumHealthyPercentage":
            suggest = "minimum_healthy_percentage"
        elif key == "protectionStrategy":
            suggest = "protection_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetDeploymentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetDeploymentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetDeploymentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 impairment_strategy: Optional['ContainerFleetDeploymentConfigurationImpairmentStrategy'] = None,
                 minimum_healthy_percentage: Optional[builtins.int] = None,
                 protection_strategy: Optional['ContainerFleetDeploymentConfigurationProtectionStrategy'] = None):
        """
        Provides details about how to drain old tasks and replace them with new updated tasks.
        :param 'ContainerFleetDeploymentConfigurationImpairmentStrategy' impairment_strategy: The strategy to apply in case of impairment; defaults to MAINTAIN.
        :param builtins.int minimum_healthy_percentage: The minimum percentage of healthy required; defaults to 75.
        :param 'ContainerFleetDeploymentConfigurationProtectionStrategy' protection_strategy: The protection strategy for deployment on the container fleet; defaults to WITH_PROTECTION.
        """
        if impairment_strategy is not None:
            pulumi.set(__self__, "impairment_strategy", impairment_strategy)
        if minimum_healthy_percentage is not None:
            pulumi.set(__self__, "minimum_healthy_percentage", minimum_healthy_percentage)
        if protection_strategy is not None:
            pulumi.set(__self__, "protection_strategy", protection_strategy)

    @property
    @pulumi.getter(name="impairmentStrategy")
    def impairment_strategy(self) -> Optional['ContainerFleetDeploymentConfigurationImpairmentStrategy']:
        """
        The strategy to apply in case of impairment; defaults to MAINTAIN.
        """
        return pulumi.get(self, "impairment_strategy")

    @property
    @pulumi.getter(name="minimumHealthyPercentage")
    def minimum_healthy_percentage(self) -> Optional[builtins.int]:
        """
        The minimum percentage of healthy required; defaults to 75.
        """
        return pulumi.get(self, "minimum_healthy_percentage")

    @property
    @pulumi.getter(name="protectionStrategy")
    def protection_strategy(self) -> Optional['ContainerFleetDeploymentConfigurationProtectionStrategy']:
        """
        The protection strategy for deployment on the container fleet; defaults to WITH_PROTECTION.
        """
        return pulumi.get(self, "protection_strategy")


@pulumi.output_type
class ContainerFleetDeploymentDetails(dict):
    """
    Provides information about the last deployment ID and its status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestDeploymentId":
            suggest = "latest_deployment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetDeploymentDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetDeploymentDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetDeploymentDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_deployment_id: Optional[builtins.str] = None):
        """
        Provides information about the last deployment ID and its status.
        :param builtins.str latest_deployment_id: The ID of the last deployment on the container fleet. This field will be empty if the container fleet does not have a ContainerGroupDefinition attached.
        """
        if latest_deployment_id is not None:
            pulumi.set(__self__, "latest_deployment_id", latest_deployment_id)

    @property
    @pulumi.getter(name="latestDeploymentId")
    def latest_deployment_id(self) -> Optional[builtins.str]:
        """
        The ID of the last deployment on the container fleet. This field will be empty if the container fleet does not have a ContainerGroupDefinition attached.
        """
        return pulumi.get(self, "latest_deployment_id")


@pulumi.output_type
class ContainerFleetGameSessionCreationLimitPolicy(dict):
    """
    A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

    The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newGameSessionsPerCreator":
            suggest = "new_game_sessions_per_creator"
        elif key == "policyPeriodInMinutes":
            suggest = "policy_period_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetGameSessionCreationLimitPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetGameSessionCreationLimitPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetGameSessionCreationLimitPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_game_sessions_per_creator: Optional[builtins.int] = None,
                 policy_period_in_minutes: Optional[builtins.int] = None):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        :param builtins.int new_game_sessions_per_creator: The maximum number of game sessions that an individual can create during the policy period.
        :param builtins.int policy_period_in_minutes: The time span used in evaluating the resource creation limit policy.
        """
        if new_game_sessions_per_creator is not None:
            pulumi.set(__self__, "new_game_sessions_per_creator", new_game_sessions_per_creator)
        if policy_period_in_minutes is not None:
            pulumi.set(__self__, "policy_period_in_minutes", policy_period_in_minutes)

    @property
    @pulumi.getter(name="newGameSessionsPerCreator")
    def new_game_sessions_per_creator(self) -> Optional[builtins.int]:
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        return pulumi.get(self, "new_game_sessions_per_creator")

    @property
    @pulumi.getter(name="policyPeriodInMinutes")
    def policy_period_in_minutes(self) -> Optional[builtins.int]:
        """
        The time span used in evaluating the resource creation limit policy.
        """
        return pulumi.get(self, "policy_period_in_minutes")


@pulumi.output_type
class ContainerFleetIpPermission(dict):
    """
    A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "ipRange":
            suggest = "ip_range"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetIpPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetIpPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetIpPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: builtins.int,
                 ip_range: builtins.str,
                 protocol: 'ContainerFleetIpPermissionProtocol',
                 to_port: builtins.int):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        :param builtins.int from_port: A starting value for a range of allowed port numbers.
        :param builtins.str ip_range: A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        :param 'ContainerFleetIpPermissionProtocol' protocol: The network communication protocol used by the fleet.
        :param builtins.int to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> builtins.int:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> builtins.str:
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def protocol(self) -> 'ContainerFleetIpPermissionProtocol':
        """
        The network communication protocol used by the fleet.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> builtins.int:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class ContainerFleetLocationCapacity(dict):
    """
    Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredEc2Instances":
            suggest = "desired_ec2_instances"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetLocationCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetLocationCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetLocationCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_ec2_instances: builtins.int,
                 max_size: builtins.int,
                 min_size: builtins.int):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        :param builtins.int desired_ec2_instances: The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        :param builtins.int max_size: The maximum value that is allowed for the fleet's instance count for a location.
        :param builtins.int min_size: The minimum value allowed for the fleet's instance count for a location.
        """
        pulumi.set(__self__, "desired_ec2_instances", desired_ec2_instances)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredEc2Instances")
    def desired_ec2_instances(self) -> builtins.int:
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.int:
        """
        The maximum value that is allowed for the fleet's instance count for a location.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.int:
        """
        The minimum value allowed for the fleet's instance count for a location.
        """
        return pulumi.get(self, "min_size")


@pulumi.output_type
class ContainerFleetLocationConfiguration(dict):
    """
    A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationCapacity":
            suggest = "location_capacity"
        elif key == "stoppedActions":
            suggest = "stopped_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetLocationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetLocationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetLocationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 location_capacity: Optional['outputs.ContainerFleetLocationCapacity'] = None,
                 stopped_actions: Optional[Sequence['ContainerFleetStoppedActionsItem']] = None):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        :param builtins.str location: An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        pulumi.set(__self__, "location", location)
        if location_capacity is not None:
            pulumi.set(__self__, "location_capacity", location_capacity)
        if stopped_actions is not None:
            pulumi.set(__self__, "stopped_actions", stopped_actions)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationCapacity")
    def location_capacity(self) -> Optional['outputs.ContainerFleetLocationCapacity']:
        return pulumi.get(self, "location_capacity")

    @property
    @pulumi.getter(name="stoppedActions")
    def stopped_actions(self) -> Optional[Sequence['ContainerFleetStoppedActionsItem']]:
        return pulumi.get(self, "stopped_actions")


@pulumi.output_type
class ContainerFleetLogConfiguration(dict):
    """
    A policy the location and provider of logs from the fleet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDestination":
            suggest = "log_destination"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_destination: Optional['ContainerFleetLogDestination'] = None,
                 s3_bucket_name: Optional[builtins.str] = None):
        """
        A policy the location and provider of logs from the fleet.
        :param 'ContainerFleetLogDestination' log_destination: The type of log collection to use for a fleet.
               
               - `CLOUDWATCH` -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
               - `S3` -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home AWS Region.
               - `NONE` -- Don't collect container logs.
        :param builtins.str s3_bucket_name: The name of the S3 bucket to pull logs from if S3 is the LogDestination
        """
        if log_destination is not None:
            pulumi.set(__self__, "log_destination", log_destination)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)

    @property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> Optional['ContainerFleetLogDestination']:
        """
        The type of log collection to use for a fleet.

        - `CLOUDWATCH` -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
        - `S3` -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home AWS Region.
        - `NONE` -- Don't collect container logs.
        """
        return pulumi.get(self, "log_destination")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[builtins.str]:
        """
        The name of the S3 bucket to pull logs from if S3 is the LogDestination
        """
        return pulumi.get(self, "s3_bucket_name")


@pulumi.output_type
class ContainerFleetScalingPolicy(dict):
    """
    Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "policyType":
            suggest = "policy_type"
        elif key == "scalingAdjustment":
            suggest = "scaling_adjustment"
        elif key == "scalingAdjustmentType":
            suggest = "scaling_adjustment_type"
        elif key == "targetConfiguration":
            suggest = "target_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: 'ContainerFleetScalingPolicyMetricName',
                 name: builtins.str,
                 comparison_operator: Optional['ContainerFleetScalingPolicyComparisonOperator'] = None,
                 evaluation_periods: Optional[builtins.int] = None,
                 policy_type: Optional['ContainerFleetScalingPolicyPolicyType'] = None,
                 scaling_adjustment: Optional[builtins.int] = None,
                 scaling_adjustment_type: Optional['ContainerFleetScalingPolicyScalingAdjustmentType'] = None,
                 target_configuration: Optional['outputs.ContainerFleetTargetConfiguration'] = None,
                 threshold: Optional[builtins.float] = None):
        """
        Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
        :param 'ContainerFleetScalingPolicyMetricName' metric_name: Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        :param builtins.str name: A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        :param 'ContainerFleetScalingPolicyComparisonOperator' comparison_operator: Comparison operator to use when measuring a metric against the threshold value.
        :param builtins.int evaluation_periods: Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        :param 'ContainerFleetScalingPolicyPolicyType' policy_type: The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        :param builtins.int scaling_adjustment: Amount of adjustment to make, based on the scaling adjustment type.
        :param 'ContainerFleetScalingPolicyScalingAdjustmentType' scaling_adjustment_type: The type of adjustment to make to a fleet's instance count.
        :param 'ContainerFleetTargetConfiguration' target_configuration: An object that contains settings for a target-based scaling policy.
        :param builtins.float threshold: Metric value used to trigger a scaling event.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if scaling_adjustment_type is not None:
            pulumi.set(__self__, "scaling_adjustment_type", scaling_adjustment_type)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> 'ContainerFleetScalingPolicyMetricName':
        """
        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional['ContainerFleetScalingPolicyComparisonOperator']:
        """
        Comparison operator to use when measuring a metric against the threshold value.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[builtins.int]:
        """
        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional['ContainerFleetScalingPolicyPolicyType']:
        """
        The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[builtins.int]:
        """
        Amount of adjustment to make, based on the scaling adjustment type.
        """
        return pulumi.get(self, "scaling_adjustment")

    @property
    @pulumi.getter(name="scalingAdjustmentType")
    def scaling_adjustment_type(self) -> Optional['ContainerFleetScalingPolicyScalingAdjustmentType']:
        """
        The type of adjustment to make to a fleet's instance count.
        """
        return pulumi.get(self, "scaling_adjustment_type")

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional['outputs.ContainerFleetTargetConfiguration']:
        """
        An object that contains settings for a target-based scaling policy.
        """
        return pulumi.get(self, "target_configuration")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[builtins.float]:
        """
        Metric value used to trigger a scaling event.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ContainerFleetTargetConfiguration(dict):
    """
    Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerFleetTargetConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerFleetTargetConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerFleetTargetConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: builtins.float):
        """
        Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
        :param builtins.float target_value: Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> builtins.float:
        """
        Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        return pulumi.get(self, "target_value")


@pulumi.output_type
class ContainerGroupDefinitionContainerDependency(dict):
    """
    A dependency that impacts a container's startup and shutdown.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionContainerDependency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionContainerDependency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionContainerDependency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: 'ContainerGroupDefinitionContainerDependencyCondition',
                 container_name: builtins.str):
        """
        A dependency that impacts a container's startup and shutdown.
        :param 'ContainerGroupDefinitionContainerDependencyCondition' condition: The type of dependency.
        :param builtins.str container_name: A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> 'ContainerGroupDefinitionContainerDependencyCondition':
        """
        The type of dependency.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
        return pulumi.get(self, "container_name")


@pulumi.output_type
class ContainerGroupDefinitionContainerEnvironment(dict):
    """
    An environment variable to set inside a container, in the form of a key-value pair.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        An environment variable to set inside a container, in the form of a key-value pair.
        :param builtins.str name: The environment variable name.
        :param builtins.str value: The environment variable value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The environment variable name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The environment variable value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerGroupDefinitionContainerHealthCheck(dict):
    """
    Specifies how the process manager checks the health of containers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startPeriod":
            suggest = "start_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionContainerHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionContainerHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionContainerHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Sequence[builtins.str],
                 interval: Optional[builtins.int] = None,
                 retries: Optional[builtins.int] = None,
                 start_period: Optional[builtins.int] = None,
                 timeout: Optional[builtins.int] = None):
        """
        Specifies how the process manager checks the health of containers.
        :param Sequence[builtins.str] command: A string array representing the command that the container runs to determine if it is healthy.
        :param builtins.int interval: How often (in seconds) the health is checked.
        :param builtins.int retries: How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        :param builtins.int start_period: The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        :param builtins.int timeout: How many seconds the process manager allows the command to run before canceling it.
        """
        pulumi.set(__self__, "command", command)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> Sequence[builtins.str]:
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def interval(self) -> Optional[builtins.int]:
        """
        How often (in seconds) the health is checked.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def retries(self) -> Optional[builtins.int]:
        """
        How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[builtins.int]:
        """
        The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        """
        return pulumi.get(self, "start_period")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.int]:
        """
        How many seconds the process manager allows the command to run before canceling it.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ContainerGroupDefinitionContainerMountPoint(dict):
    """
    Defines the mount point configuration within a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instancePath":
            suggest = "instance_path"
        elif key == "accessLevel":
            suggest = "access_level"
        elif key == "containerPath":
            suggest = "container_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionContainerMountPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionContainerMountPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionContainerMountPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_path: builtins.str,
                 access_level: Optional['ContainerGroupDefinitionContainerMountPointAccessLevel'] = None,
                 container_path: Optional[builtins.str] = None):
        """
        Defines the mount point configuration within a container.
        :param builtins.str instance_path: The path on the host that will be mounted in the container.
        :param 'ContainerGroupDefinitionContainerMountPointAccessLevel' access_level: The access permissions for the mounted path.
        :param builtins.str container_path: The path inside the container where the mount is accessible.
        """
        pulumi.set(__self__, "instance_path", instance_path)
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)

    @property
    @pulumi.getter(name="instancePath")
    def instance_path(self) -> builtins.str:
        """
        The path on the host that will be mounted in the container.
        """
        return pulumi.get(self, "instance_path")

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional['ContainerGroupDefinitionContainerMountPointAccessLevel']:
        """
        The access permissions for the mounted path.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[builtins.str]:
        """
        The path inside the container where the mount is accessible.
        """
        return pulumi.get(self, "container_path")


@pulumi.output_type
class ContainerGroupDefinitionContainerPortRange(dict):
    """
    A set of one or more port numbers that can be opened on the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionContainerPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionContainerPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionContainerPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: builtins.int,
                 protocol: 'ContainerGroupDefinitionContainerPortRangeProtocol',
                 to_port: builtins.int):
        """
        A set of one or more port numbers that can be opened on the container.
        :param builtins.int from_port: A starting value for the range of allowed port numbers.
        :param 'ContainerGroupDefinitionContainerPortRangeProtocol' protocol: Defines the protocol of these ports.
        :param builtins.int to_port: An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> builtins.int:
        """
        A starting value for the range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter
    def protocol(self) -> 'ContainerGroupDefinitionContainerPortRangeProtocol':
        """
        Defines the protocol of these ports.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> builtins.int:
        """
        An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class ContainerGroupDefinitionGameServerContainerDefinition(dict):
    """
    Specifies the information required to run game servers with this container group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "imageUri":
            suggest = "image_uri"
        elif key == "serverSdkVersion":
            suggest = "server_sdk_version"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "environmentOverride":
            suggest = "environment_override"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "portConfiguration":
            suggest = "port_configuration"
        elif key == "resolvedImageDigest":
            suggest = "resolved_image_digest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionGameServerContainerDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionGameServerContainerDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionGameServerContainerDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: builtins.str,
                 image_uri: builtins.str,
                 server_sdk_version: builtins.str,
                 depends_on: Optional[Sequence['outputs.ContainerGroupDefinitionContainerDependency']] = None,
                 environment_override: Optional[Sequence['outputs.ContainerGroupDefinitionContainerEnvironment']] = None,
                 mount_points: Optional[Sequence['outputs.ContainerGroupDefinitionContainerMountPoint']] = None,
                 port_configuration: Optional['outputs.ContainerGroupDefinitionPortConfiguration'] = None,
                 resolved_image_digest: Optional[builtins.str] = None):
        """
        Specifies the information required to run game servers with this container group
        :param builtins.str container_name: A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        :param builtins.str image_uri: Specifies the image URI of this container.
        :param builtins.str server_sdk_version: The version of the server SDK used in this container group
        :param Sequence['ContainerGroupDefinitionContainerDependency'] depends_on: A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        :param Sequence['ContainerGroupDefinitionContainerEnvironment'] environment_override: The environment variables to pass to a container.
        :param Sequence['ContainerGroupDefinitionContainerMountPoint'] mount_points: A list of mount point configurations to be used in a container.
        :param 'ContainerGroupDefinitionPortConfiguration' port_configuration: Defines the ports on the container.
        :param builtins.str resolved_image_digest: The digest of the container image.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "server_sdk_version", server_sdk_version)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if environment_override is not None:
            pulumi.set(__self__, "environment_override", environment_override)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if port_configuration is not None:
            pulumi.set(__self__, "port_configuration", port_configuration)
        if resolved_image_digest is not None:
            pulumi.set(__self__, "resolved_image_digest", resolved_image_digest)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> builtins.str:
        """
        Specifies the image URI of this container.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="serverSdkVersion")
    def server_sdk_version(self) -> builtins.str:
        """
        The version of the server SDK used in this container group
        """
        return pulumi.get(self, "server_sdk_version")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ContainerGroupDefinitionContainerDependency']]:
        """
        A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter(name="environmentOverride")
    def environment_override(self) -> Optional[Sequence['outputs.ContainerGroupDefinitionContainerEnvironment']]:
        """
        The environment variables to pass to a container.
        """
        return pulumi.get(self, "environment_override")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[Sequence['outputs.ContainerGroupDefinitionContainerMountPoint']]:
        """
        A list of mount point configurations to be used in a container.
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter(name="portConfiguration")
    def port_configuration(self) -> Optional['outputs.ContainerGroupDefinitionPortConfiguration']:
        """
        Defines the ports on the container.
        """
        return pulumi.get(self, "port_configuration")

    @property
    @pulumi.getter(name="resolvedImageDigest")
    def resolved_image_digest(self) -> Optional[builtins.str]:
        """
        The digest of the container image.
        """
        return pulumi.get(self, "resolved_image_digest")


@pulumi.output_type
class ContainerGroupDefinitionPortConfiguration(dict):
    """
    Defines the ports on a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPortRanges":
            suggest = "container_port_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionPortConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionPortConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionPortConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port_ranges: Sequence['outputs.ContainerGroupDefinitionContainerPortRange']):
        """
        Defines the ports on a container.
        :param Sequence['ContainerGroupDefinitionContainerPortRange'] container_port_ranges: Specifies one or more ranges of ports on a container.
        """
        pulumi.set(__self__, "container_port_ranges", container_port_ranges)

    @property
    @pulumi.getter(name="containerPortRanges")
    def container_port_ranges(self) -> Sequence['outputs.ContainerGroupDefinitionContainerPortRange']:
        """
        Specifies one or more ranges of ports on a container.
        """
        return pulumi.get(self, "container_port_ranges")


@pulumi.output_type
class ContainerGroupDefinitionSupportContainerDefinition(dict):
    """
    Supports the function of the main container group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "imageUri":
            suggest = "image_uri"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "environmentOverride":
            suggest = "environment_override"
        elif key == "healthCheck":
            suggest = "health_check"
        elif key == "memoryHardLimitMebibytes":
            suggest = "memory_hard_limit_mebibytes"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "portConfiguration":
            suggest = "port_configuration"
        elif key == "resolvedImageDigest":
            suggest = "resolved_image_digest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionSupportContainerDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionSupportContainerDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionSupportContainerDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: builtins.str,
                 image_uri: builtins.str,
                 depends_on: Optional[Sequence['outputs.ContainerGroupDefinitionContainerDependency']] = None,
                 environment_override: Optional[Sequence['outputs.ContainerGroupDefinitionContainerEnvironment']] = None,
                 essential: Optional[builtins.bool] = None,
                 health_check: Optional['outputs.ContainerGroupDefinitionContainerHealthCheck'] = None,
                 memory_hard_limit_mebibytes: Optional[builtins.int] = None,
                 mount_points: Optional[Sequence['outputs.ContainerGroupDefinitionContainerMountPoint']] = None,
                 port_configuration: Optional['outputs.ContainerGroupDefinitionPortConfiguration'] = None,
                 resolved_image_digest: Optional[builtins.str] = None,
                 vcpu: Optional[builtins.float] = None):
        """
        Supports the function of the main container group
        :param builtins.str container_name: A descriptive label for the container definition.
        :param builtins.str image_uri: Specifies the image URI of this container.
        :param Sequence['ContainerGroupDefinitionContainerDependency'] depends_on: A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        :param Sequence['ContainerGroupDefinitionContainerEnvironment'] environment_override: The environment variables to pass to a container.
        :param builtins.bool essential: Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        :param 'ContainerGroupDefinitionContainerHealthCheck' health_check: Specifies how the health of the containers will be checked.
        :param builtins.int memory_hard_limit_mebibytes: The total memory limit of container groups following this definition in MiB
        :param Sequence['ContainerGroupDefinitionContainerMountPoint'] mount_points: A list of mount point configurations to be used in a container.
        :param 'ContainerGroupDefinitionPortConfiguration' port_configuration: Defines the ports on the container.
        :param builtins.str resolved_image_digest: The digest of the container image.
        :param builtins.float vcpu: The number of virtual CPUs to give to the support group
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image_uri", image_uri)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if environment_override is not None:
            pulumi.set(__self__, "environment_override", environment_override)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if memory_hard_limit_mebibytes is not None:
            pulumi.set(__self__, "memory_hard_limit_mebibytes", memory_hard_limit_mebibytes)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if port_configuration is not None:
            pulumi.set(__self__, "port_configuration", port_configuration)
        if resolved_image_digest is not None:
            pulumi.set(__self__, "resolved_image_digest", resolved_image_digest)
        if vcpu is not None:
            pulumi.set(__self__, "vcpu", vcpu)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        A descriptive label for the container definition.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> builtins.str:
        """
        Specifies the image URI of this container.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ContainerGroupDefinitionContainerDependency']]:
        """
        A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter(name="environmentOverride")
    def environment_override(self) -> Optional[Sequence['outputs.ContainerGroupDefinitionContainerEnvironment']]:
        """
        The environment variables to pass to a container.
        """
        return pulumi.get(self, "environment_override")

    @property
    @pulumi.getter
    def essential(self) -> Optional[builtins.bool]:
        """
        Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        """
        return pulumi.get(self, "essential")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.ContainerGroupDefinitionContainerHealthCheck']:
        """
        Specifies how the health of the containers will be checked.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="memoryHardLimitMebibytes")
    def memory_hard_limit_mebibytes(self) -> Optional[builtins.int]:
        """
        The total memory limit of container groups following this definition in MiB
        """
        return pulumi.get(self, "memory_hard_limit_mebibytes")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[Sequence['outputs.ContainerGroupDefinitionContainerMountPoint']]:
        """
        A list of mount point configurations to be used in a container.
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter(name="portConfiguration")
    def port_configuration(self) -> Optional['outputs.ContainerGroupDefinitionPortConfiguration']:
        """
        Defines the ports on the container.
        """
        return pulumi.get(self, "port_configuration")

    @property
    @pulumi.getter(name="resolvedImageDigest")
    def resolved_image_digest(self) -> Optional[builtins.str]:
        """
        The digest of the container image.
        """
        return pulumi.get(self, "resolved_image_digest")

    @property
    @pulumi.getter
    def vcpu(self) -> Optional[builtins.float]:
        """
        The number of virtual CPUs to give to the support group
        """
        return pulumi.get(self, "vcpu")


@pulumi.output_type
class FleetAnywhereConfiguration(dict):
    """
    Configuration for Anywhere fleet.
    """
    def __init__(__self__, *,
                 cost: builtins.str):
        """
        Configuration for Anywhere fleet.
        :param builtins.str cost: Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
        pulumi.set(__self__, "cost", cost)

    @property
    @pulumi.getter
    def cost(self) -> builtins.str:
        """
        Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
        return pulumi.get(self, "cost")


@pulumi.output_type
class FleetCertificateConfiguration(dict):
    """
    Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateType":
            suggest = "certificate_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetCertificateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetCertificateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetCertificateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_type: 'FleetCertificateConfigurationCertificateType'):
        """
        Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
        :param 'FleetCertificateConfigurationCertificateType' certificate_type: Indicates whether a TLS/SSL certificate is generated for a fleet.
               
               Valid values include:
               
               - *GENERATED* - Generate a TLS/SSL certificate for this fleet.
               - *DISABLED* - (default) Do not generate a TLS/SSL certificate for this fleet.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> 'FleetCertificateConfigurationCertificateType':
        """
        Indicates whether a TLS/SSL certificate is generated for a fleet.

        Valid values include:

        - *GENERATED* - Generate a TLS/SSL certificate for this fleet.
        - *DISABLED* - (default) Do not generate a TLS/SSL certificate for this fleet.
        """
        return pulumi.get(self, "certificate_type")


@pulumi.output_type
class FleetIpPermission(dict):
    """
    A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "ipRange":
            suggest = "ip_range"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetIpPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetIpPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetIpPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: builtins.int,
                 ip_range: builtins.str,
                 protocol: 'FleetIpPermissionProtocol',
                 to_port: builtins.int):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        :param builtins.int from_port: A starting value for a range of allowed port numbers.
        :param builtins.str ip_range: A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        :param 'FleetIpPermissionProtocol' protocol: The network communication protocol used by the fleet.
        :param builtins.int to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> builtins.int:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> builtins.str:
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def protocol(self) -> 'FleetIpPermissionProtocol':
        """
        The network communication protocol used by the fleet.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> builtins.int:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class FleetLocationCapacity(dict):
    """
    Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredEc2Instances":
            suggest = "desired_ec2_instances"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetLocationCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetLocationCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetLocationCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_ec2_instances: builtins.int,
                 max_size: builtins.int,
                 min_size: builtins.int):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        :param builtins.int desired_ec2_instances: The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        :param builtins.int max_size: The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        :param builtins.int min_size: The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        pulumi.set(__self__, "desired_ec2_instances", desired_ec2_instances)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredEc2Instances")
    def desired_ec2_instances(self) -> builtins.int:
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.int:
        """
        The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.int:
        """
        The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        return pulumi.get(self, "min_size")


@pulumi.output_type
class FleetLocationConfiguration(dict):
    """
    A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationCapacity":
            suggest = "location_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetLocationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetLocationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetLocationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 location_capacity: Optional['outputs.FleetLocationCapacity'] = None):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        :param builtins.str location: An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        :param 'FleetLocationCapacity' location_capacity: Current resource capacity settings for managed EC2 fleets and managed container fleets. For multi-location fleets, location values might refer to a fleet's remote location or its home Region.
               
               *Returned by:* [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) , [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html) , [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
        """
        pulumi.set(__self__, "location", location)
        if location_capacity is not None:
            pulumi.set(__self__, "location_capacity", location_capacity)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationCapacity")
    def location_capacity(self) -> Optional['outputs.FleetLocationCapacity']:
        """
        Current resource capacity settings for managed EC2 fleets and managed container fleets. For multi-location fleets, location values might refer to a fleet's remote location or its home Region.

        *Returned by:* [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) , [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html) , [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
        """
        return pulumi.get(self, "location_capacity")


@pulumi.output_type
class FleetResourceCreationLimitPolicy(dict):
    """
    A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

    The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newGameSessionsPerCreator":
            suggest = "new_game_sessions_per_creator"
        elif key == "policyPeriodInMinutes":
            suggest = "policy_period_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetResourceCreationLimitPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetResourceCreationLimitPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetResourceCreationLimitPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_game_sessions_per_creator: Optional[builtins.int] = None,
                 policy_period_in_minutes: Optional[builtins.int] = None):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        :param builtins.int new_game_sessions_per_creator: The maximum number of game sessions that an individual can create during the policy period.
        :param builtins.int policy_period_in_minutes: The time span used in evaluating the resource creation limit policy.
        """
        if new_game_sessions_per_creator is not None:
            pulumi.set(__self__, "new_game_sessions_per_creator", new_game_sessions_per_creator)
        if policy_period_in_minutes is not None:
            pulumi.set(__self__, "policy_period_in_minutes", policy_period_in_minutes)

    @property
    @pulumi.getter(name="newGameSessionsPerCreator")
    def new_game_sessions_per_creator(self) -> Optional[builtins.int]:
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        return pulumi.get(self, "new_game_sessions_per_creator")

    @property
    @pulumi.getter(name="policyPeriodInMinutes")
    def policy_period_in_minutes(self) -> Optional[builtins.int]:
        """
        The time span used in evaluating the resource creation limit policy.
        """
        return pulumi.get(self, "policy_period_in_minutes")


@pulumi.output_type
class FleetRuntimeConfiguration(dict):
    """
    A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

    The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

    An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gameSessionActivationTimeoutSeconds":
            suggest = "game_session_activation_timeout_seconds"
        elif key == "maxConcurrentGameSessionActivations":
            suggest = "max_concurrent_game_session_activations"
        elif key == "serverProcesses":
            suggest = "server_processes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetRuntimeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetRuntimeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetRuntimeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 game_session_activation_timeout_seconds: Optional[builtins.int] = None,
                 max_concurrent_game_session_activations: Optional[builtins.int] = None,
                 server_processes: Optional[Sequence['outputs.FleetServerProcess']] = None):
        """
        A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

        The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

        An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
        :param builtins.int game_session_activation_timeout_seconds: The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        :param builtins.int max_concurrent_game_session_activations: The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        :param Sequence['FleetServerProcess'] server_processes: A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        if game_session_activation_timeout_seconds is not None:
            pulumi.set(__self__, "game_session_activation_timeout_seconds", game_session_activation_timeout_seconds)
        if max_concurrent_game_session_activations is not None:
            pulumi.set(__self__, "max_concurrent_game_session_activations", max_concurrent_game_session_activations)
        if server_processes is not None:
            pulumi.set(__self__, "server_processes", server_processes)

    @property
    @pulumi.getter(name="gameSessionActivationTimeoutSeconds")
    def game_session_activation_timeout_seconds(self) -> Optional[builtins.int]:
        """
        The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        """
        return pulumi.get(self, "game_session_activation_timeout_seconds")

    @property
    @pulumi.getter(name="maxConcurrentGameSessionActivations")
    def max_concurrent_game_session_activations(self) -> Optional[builtins.int]:
        """
        The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        """
        return pulumi.get(self, "max_concurrent_game_session_activations")

    @property
    @pulumi.getter(name="serverProcesses")
    def server_processes(self) -> Optional[Sequence['outputs.FleetServerProcess']]:
        """
        A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        return pulumi.get(self, "server_processes")


@pulumi.output_type
class FleetScalingPolicy(dict):
    """
    Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "policyType":
            suggest = "policy_type"
        elif key == "scalingAdjustment":
            suggest = "scaling_adjustment"
        elif key == "scalingAdjustmentType":
            suggest = "scaling_adjustment_type"
        elif key == "targetConfiguration":
            suggest = "target_configuration"
        elif key == "updateStatus":
            suggest = "update_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: 'FleetScalingPolicyMetricName',
                 name: builtins.str,
                 comparison_operator: Optional['FleetScalingPolicyComparisonOperator'] = None,
                 evaluation_periods: Optional[builtins.int] = None,
                 location: Optional[builtins.str] = None,
                 policy_type: Optional['FleetScalingPolicyPolicyType'] = None,
                 scaling_adjustment: Optional[builtins.int] = None,
                 scaling_adjustment_type: Optional['FleetScalingPolicyScalingAdjustmentType'] = None,
                 status: Optional['FleetScalingPolicyStatus'] = None,
                 target_configuration: Optional['outputs.FleetTargetConfiguration'] = None,
                 threshold: Optional[builtins.float] = None,
                 update_status: Optional['FleetScalingPolicyUpdateStatus'] = None):
        """
        Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
        :param 'FleetScalingPolicyMetricName' metric_name: Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        :param builtins.str name: A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        :param 'FleetScalingPolicyComparisonOperator' comparison_operator: Comparison operator to use when measuring a metric against the threshold value.
        :param builtins.int evaluation_periods: Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        :param builtins.str location: The fleet location.
        :param 'FleetScalingPolicyPolicyType' policy_type: The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        :param builtins.int scaling_adjustment: Amount of adjustment to make, based on the scaling adjustment type.
        :param 'FleetScalingPolicyScalingAdjustmentType' scaling_adjustment_type: The type of adjustment to make to a fleet's instance count.
        :param 'FleetScalingPolicyStatus' status: Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        :param 'FleetTargetConfiguration' target_configuration: An object that contains settings for a target-based scaling policy.
        :param builtins.float threshold: Metric value used to trigger a scaling event.
        :param 'FleetScalingPolicyUpdateStatus' update_status: The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if scaling_adjustment_type is not None:
            pulumi.set(__self__, "scaling_adjustment_type", scaling_adjustment_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if update_status is not None:
            pulumi.set(__self__, "update_status", update_status)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> 'FleetScalingPolicyMetricName':
        """
        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional['FleetScalingPolicyComparisonOperator']:
        """
        Comparison operator to use when measuring a metric against the threshold value.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[builtins.int]:
        """
        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The fleet location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional['FleetScalingPolicyPolicyType']:
        """
        The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[builtins.int]:
        """
        Amount of adjustment to make, based on the scaling adjustment type.
        """
        return pulumi.get(self, "scaling_adjustment")

    @property
    @pulumi.getter(name="scalingAdjustmentType")
    def scaling_adjustment_type(self) -> Optional['FleetScalingPolicyScalingAdjustmentType']:
        """
        The type of adjustment to make to a fleet's instance count.
        """
        return pulumi.get(self, "scaling_adjustment_type")

    @property
    @pulumi.getter
    def status(self) -> Optional['FleetScalingPolicyStatus']:
        """
        Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional['outputs.FleetTargetConfiguration']:
        """
        An object that contains settings for a target-based scaling policy.
        """
        return pulumi.get(self, "target_configuration")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[builtins.float]:
        """
        Metric value used to trigger a scaling event.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="updateStatus")
    def update_status(self) -> Optional['FleetScalingPolicyUpdateStatus']:
        """
        The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
        return pulumi.get(self, "update_status")


@pulumi.output_type
class FleetServerProcess(dict):
    """
    A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrentExecutions":
            suggest = "concurrent_executions"
        elif key == "launchPath":
            suggest = "launch_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetServerProcess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetServerProcess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetServerProcess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrent_executions: builtins.int,
                 launch_path: builtins.str,
                 parameters: Optional[builtins.str] = None):
        """
        A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
        :param builtins.int concurrent_executions: The number of server processes that use this configuration to run concurrently on an instance.
        :param builtins.str launch_path: The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:
               
               Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"
               
               Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        :param builtins.str parameters: An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        pulumi.set(__self__, "concurrent_executions", concurrent_executions)
        pulumi.set(__self__, "launch_path", launch_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="concurrentExecutions")
    def concurrent_executions(self) -> builtins.int:
        """
        The number of server processes that use this configuration to run concurrently on an instance.
        """
        return pulumi.get(self, "concurrent_executions")

    @property
    @pulumi.getter(name="launchPath")
    def launch_path(self) -> builtins.str:
        """
        The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:

        Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"

        Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        """
        return pulumi.get(self, "launch_path")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[builtins.str]:
        """
        An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class FleetTargetConfiguration(dict):
    """
    Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetTargetConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetTargetConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetTargetConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: builtins.float):
        """
        Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
        :param builtins.float target_value: Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> builtins.float:
        """
        Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        return pulumi.get(self, "target_value")


@pulumi.output_type
class GameServerGroupAutoScalingPolicy(dict):
    """
    Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetTrackingConfiguration":
            suggest = "target_tracking_configuration"
        elif key == "estimatedInstanceWarmup":
            suggest = "estimated_instance_warmup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupAutoScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupAutoScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupAutoScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_tracking_configuration: 'outputs.GameServerGroupTargetTrackingConfiguration',
                 estimated_instance_warmup: Optional[builtins.float] = None):
        """
        Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        :param 'GameServerGroupTargetTrackingConfiguration' target_tracking_configuration: Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric `PercentUtilizedGameServers` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
        :param builtins.float estimated_instance_warmup: Length of time, in seconds, it takes for a new instance to start new game server processes and register with Amazon GameLift Servers FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances.
        """
        pulumi.set(__self__, "target_tracking_configuration", target_tracking_configuration)
        if estimated_instance_warmup is not None:
            pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)

    @property
    @pulumi.getter(name="targetTrackingConfiguration")
    def target_tracking_configuration(self) -> 'outputs.GameServerGroupTargetTrackingConfiguration':
        """
        Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric `PercentUtilizedGameServers` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
        """
        return pulumi.get(self, "target_tracking_configuration")

    @property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> Optional[builtins.float]:
        """
        Length of time, in seconds, it takes for a new instance to start new game server processes and register with Amazon GameLift Servers FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances.
        """
        return pulumi.get(self, "estimated_instance_warmup")


@pulumi.output_type
class GameServerGroupInstanceDefinition(dict):
    """
    An allowed instance type for your game server group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupInstanceDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupInstanceDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupInstanceDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: builtins.str,
                 weighted_capacity: Optional[builtins.str] = None):
        """
        An allowed instance type for your game server group.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[builtins.str]:
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class GameServerGroupLaunchTemplate(dict):
    """
    The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupLaunchTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupLaunchTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupLaunchTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[builtins.str] = None,
                 launch_template_name: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        :param builtins.str launch_template_id: A unique identifier for an existing Amazon EC2 launch template.
        :param builtins.str launch_template_name: A readable identifier for an existing Amazon EC2 launch template.
        :param builtins.str version: The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for an existing Amazon EC2 launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[builtins.str]:
        """
        A readable identifier for an existing Amazon EC2 launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GameServerGroupTargetTrackingConfiguration(dict):
    """
    Settings for a target-based scaling policy applied to Auto Scaling group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupTargetTrackingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupTargetTrackingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupTargetTrackingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: builtins.float):
        """
        Settings for a target-based scaling policy applied to Auto Scaling group.
        :param builtins.float target_value: Desired value to use with a game server group target-based scaling policy.
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> builtins.float:
        """
        Desired value to use with a game server group target-based scaling policy.
        """
        return pulumi.get(self, "target_value")


@pulumi.output_type
class GameSessionQueueDestination(dict):
    """
    A fleet or alias designated in a game session queue.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueueDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueueDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueueDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: Optional[builtins.str] = None):
        """
        A fleet or alias designated in a game session queue.
        :param builtins.str destination_arn: The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions.
        """
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions.
        """
        return pulumi.get(self, "destination_arn")


@pulumi.output_type
class GameSessionQueueFilterConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedLocations":
            suggest = "allowed_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueueFilterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueueFilterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueueFilterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_locations: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] allowed_locations: A list of locations to allow game session placement in, in the form of AWS Region codes such as `us-west-2` .
        """
        if allowed_locations is not None:
            pulumi.set(__self__, "allowed_locations", allowed_locations)

    @property
    @pulumi.getter(name="allowedLocations")
    def allowed_locations(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of locations to allow game session placement in, in the form of AWS Region codes such as `us-west-2` .
        """
        return pulumi.get(self, "allowed_locations")


@pulumi.output_type
class GameSessionQueuePlayerLatencyPolicy(dict):
    """
    Sets a latency cap for individual players when placing a game session.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumIndividualPlayerLatencyMilliseconds":
            suggest = "maximum_individual_player_latency_milliseconds"
        elif key == "policyDurationSeconds":
            suggest = "policy_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueuePlayerLatencyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueuePlayerLatencyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueuePlayerLatencyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_individual_player_latency_milliseconds: Optional[builtins.int] = None,
                 policy_duration_seconds: Optional[builtins.int] = None):
        """
        Sets a latency cap for individual players when placing a game session.
        :param builtins.int maximum_individual_player_latency_milliseconds: The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        :param builtins.int policy_duration_seconds: The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
        if maximum_individual_player_latency_milliseconds is not None:
            pulumi.set(__self__, "maximum_individual_player_latency_milliseconds", maximum_individual_player_latency_milliseconds)
        if policy_duration_seconds is not None:
            pulumi.set(__self__, "policy_duration_seconds", policy_duration_seconds)

    @property
    @pulumi.getter(name="maximumIndividualPlayerLatencyMilliseconds")
    def maximum_individual_player_latency_milliseconds(self) -> Optional[builtins.int]:
        """
        The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        """
        return pulumi.get(self, "maximum_individual_player_latency_milliseconds")

    @property
    @pulumi.getter(name="policyDurationSeconds")
    def policy_duration_seconds(self) -> Optional[builtins.int]:
        """
        The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
        return pulumi.get(self, "policy_duration_seconds")


@pulumi.output_type
class GameSessionQueuePriorityConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationOrder":
            suggest = "location_order"
        elif key == "priorityOrder":
            suggest = "priority_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueuePriorityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueuePriorityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueuePriorityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location_order: Optional[Sequence[builtins.str]] = None,
                 priority_order: Optional[Sequence['GameSessionQueuePriorityOrderItem']] = None):
        """
        :param Sequence[builtins.str] location_order: The prioritization order to use for fleet locations, when the `PriorityOrder` property includes `LOCATION` . Locations can include AWS Region codes (such as `us-west-2` ), local zones, and custom locations (for Anywhere fleets). Each location must be listed only once. For details, see [Amazon GameLift Servers service locations.](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
        :param Sequence['GameSessionQueuePriorityOrderItem'] priority_order: A custom sequence to use when prioritizing where to place new game sessions. Each priority type is listed once.
               
               - `LATENCY` -- Amazon GameLift Servers prioritizes locations where the average player latency is lowest. Player latency data is provided in each game session placement request.
               - `COST` -- Amazon GameLift Servers prioritizes queue destinations with the lowest current hosting costs. Cost is evaluated based on the destination's location, instance type, and fleet type (Spot or On-Demand).
               - `DESTINATION` -- Amazon GameLift Servers prioritizes based on the list order of destinations in the queue configuration.
               - `LOCATION` -- Amazon GameLift Servers prioritizes based on the provided order of locations, as defined in `LocationOrder` .
        """
        if location_order is not None:
            pulumi.set(__self__, "location_order", location_order)
        if priority_order is not None:
            pulumi.set(__self__, "priority_order", priority_order)

    @property
    @pulumi.getter(name="locationOrder")
    def location_order(self) -> Optional[Sequence[builtins.str]]:
        """
        The prioritization order to use for fleet locations, when the `PriorityOrder` property includes `LOCATION` . Locations can include AWS Region codes (such as `us-west-2` ), local zones, and custom locations (for Anywhere fleets). Each location must be listed only once. For details, see [Amazon GameLift Servers service locations.](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
        """
        return pulumi.get(self, "location_order")

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[Sequence['GameSessionQueuePriorityOrderItem']]:
        """
        A custom sequence to use when prioritizing where to place new game sessions. Each priority type is listed once.

        - `LATENCY` -- Amazon GameLift Servers prioritizes locations where the average player latency is lowest. Player latency data is provided in each game session placement request.
        - `COST` -- Amazon GameLift Servers prioritizes queue destinations with the lowest current hosting costs. Cost is evaluated based on the destination's location, instance type, and fleet type (Spot or On-Demand).
        - `DESTINATION` -- Amazon GameLift Servers prioritizes based on the list order of destinations in the queue configuration.
        - `LOCATION` -- Amazon GameLift Servers prioritizes based on the provided order of locations, as defined in `LocationOrder` .
        """
        return pulumi.get(self, "priority_order")


@pulumi.output_type
class MatchmakingConfigurationGameProperty(dict):
    """
    A key-value pair that contains information about a game session.
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        A key-value pair that contains information about a game session.
        :param builtins.str key: The game property identifier.
        :param builtins.str value: The game property value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The game property identifier.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The game property value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScriptS3Location(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "objectVersion":
            suggest = "object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 key: builtins.str,
                 role_arn: builtins.str,
                 object_version: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        :param builtins.str key: The name of the zip file that contains the script files.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        :param builtins.str object_version: The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The name of the zip file that contains the script files.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[builtins.str]:
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        return pulumi.get(self, "object_version")


