# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetGameSessionQueueResult',
    'AwaitableGetGameSessionQueueResult',
    'get_game_session_queue',
    'get_game_session_queue_output',
]

@pulumi.output_type
class GetGameSessionQueueResult:
    def __init__(__self__, arn=None, custom_event_data=None, destinations=None, filter_configuration=None, notification_target=None, player_latency_policies=None, priority_configuration=None, tags=None, timeout_in_seconds=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if custom_event_data and not isinstance(custom_event_data, str):
            raise TypeError("Expected argument 'custom_event_data' to be a str")
        pulumi.set(__self__, "custom_event_data", custom_event_data)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if filter_configuration and not isinstance(filter_configuration, dict):
            raise TypeError("Expected argument 'filter_configuration' to be a dict")
        pulumi.set(__self__, "filter_configuration", filter_configuration)
        if notification_target and not isinstance(notification_target, str):
            raise TypeError("Expected argument 'notification_target' to be a str")
        pulumi.set(__self__, "notification_target", notification_target)
        if player_latency_policies and not isinstance(player_latency_policies, list):
            raise TypeError("Expected argument 'player_latency_policies' to be a list")
        pulumi.set(__self__, "player_latency_policies", player_latency_policies)
        if priority_configuration and not isinstance(priority_configuration, dict):
            raise TypeError("Expected argument 'priority_configuration' to be a dict")
        pulumi.set(__self__, "priority_configuration", priority_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if timeout_in_seconds and not isinstance(timeout_in_seconds, int):
            raise TypeError("Expected argument 'timeout_in_seconds' to be a int")
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) that is assigned to a Amazon GameLift game session queue resource and uniquely identifies it.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="customEventData")
    def custom_event_data(self) -> Optional[builtins.str]:
        """
        Information that is added to all events that are related to this game session queue.
        """
        return pulumi.get(self, "custom_event_data")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.GameSessionQueueDestination']]:
        """
        A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.GameSessionQueueFilterConfiguration']:
        """
        A list of locations where a queue is allowed to place new game sessions.
        """
        return pulumi.get(self, "filter_configuration")

    @property
    @pulumi.getter(name="notificationTarget")
    def notification_target(self) -> Optional[builtins.str]:
        """
        An SNS topic ARN that is set up to receive game session placement notifications.
        """
        return pulumi.get(self, "notification_target")

    @property
    @pulumi.getter(name="playerLatencyPolicies")
    def player_latency_policies(self) -> Optional[Sequence['outputs.GameSessionQueuePlayerLatencyPolicy']]:
        """
        A set of policies that act as a sliding cap on player latency.
        """
        return pulumi.get(self, "player_latency_policies")

    @property
    @pulumi.getter(name="priorityConfiguration")
    def priority_configuration(self) -> Optional['outputs.GameSessionQueuePriorityConfiguration']:
        """
        Custom settings to use when prioritizing destinations and locations for game session placements.
        """
        return pulumi.get(self, "priority_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum time, in seconds, that a new game session placement request remains in the queue.
        """
        return pulumi.get(self, "timeout_in_seconds")


class AwaitableGetGameSessionQueueResult(GetGameSessionQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGameSessionQueueResult(
            arn=self.arn,
            custom_event_data=self.custom_event_data,
            destinations=self.destinations,
            filter_configuration=self.filter_configuration,
            notification_target=self.notification_target,
            player_latency_policies=self.player_latency_policies,
            priority_configuration=self.priority_configuration,
            tags=self.tags,
            timeout_in_seconds=self.timeout_in_seconds)


def get_game_session_queue(name: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGameSessionQueueResult:
    """
    The AWS::GameLift::GameSessionQueue resource creates an Amazon GameLift (GameLift) game session queue.


    :param builtins.str name: A descriptive label that is associated with game session queue. Queue names must be unique within each Region.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:gamelift:getGameSessionQueue', __args__, opts=opts, typ=GetGameSessionQueueResult).value

    return AwaitableGetGameSessionQueueResult(
        arn=pulumi.get(__ret__, 'arn'),
        custom_event_data=pulumi.get(__ret__, 'custom_event_data'),
        destinations=pulumi.get(__ret__, 'destinations'),
        filter_configuration=pulumi.get(__ret__, 'filter_configuration'),
        notification_target=pulumi.get(__ret__, 'notification_target'),
        player_latency_policies=pulumi.get(__ret__, 'player_latency_policies'),
        priority_configuration=pulumi.get(__ret__, 'priority_configuration'),
        tags=pulumi.get(__ret__, 'tags'),
        timeout_in_seconds=pulumi.get(__ret__, 'timeout_in_seconds'))
def get_game_session_queue_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGameSessionQueueResult]:
    """
    The AWS::GameLift::GameSessionQueue resource creates an Amazon GameLift (GameLift) game session queue.


    :param builtins.str name: A descriptive label that is associated with game session queue. Queue names must be unique within each Region.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:gamelift:getGameSessionQueue', __args__, opts=opts, typ=GetGameSessionQueueResult)
    return __ret__.apply(lambda __response__: GetGameSessionQueueResult(
        arn=pulumi.get(__response__, 'arn'),
        custom_event_data=pulumi.get(__response__, 'custom_event_data'),
        destinations=pulumi.get(__response__, 'destinations'),
        filter_configuration=pulumi.get(__response__, 'filter_configuration'),
        notification_target=pulumi.get(__response__, 'notification_target'),
        player_latency_policies=pulumi.get(__response__, 'player_latency_policies'),
        priority_configuration=pulumi.get(__response__, 'priority_configuration'),
        tags=pulumi.get(__response__, 'tags'),
        timeout_in_seconds=pulumi.get(__response__, 'timeout_in_seconds')))
