# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetContainerFleetResult',
    'AwaitableGetContainerFleetResult',
    'get_container_fleet',
    'get_container_fleet_output',
]

@pulumi.output_type
class GetContainerFleetResult:
    def __init__(__self__, creation_time=None, deployment_details=None, description=None, fleet_arn=None, fleet_id=None, fleet_role_arn=None, game_server_container_group_definition_arn=None, game_session_creation_limit_policy=None, instance_connection_port_range=None, instance_inbound_permissions=None, locations=None, log_configuration=None, maximum_game_server_container_groups_per_instance=None, metric_groups=None, new_game_session_protection_policy=None, per_instance_container_group_definition_arn=None, scaling_policies=None, status=None, tags=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if deployment_details and not isinstance(deployment_details, dict):
            raise TypeError("Expected argument 'deployment_details' to be a dict")
        pulumi.set(__self__, "deployment_details", deployment_details)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if fleet_arn and not isinstance(fleet_arn, str):
            raise TypeError("Expected argument 'fleet_arn' to be a str")
        pulumi.set(__self__, "fleet_arn", fleet_arn)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if fleet_role_arn and not isinstance(fleet_role_arn, str):
            raise TypeError("Expected argument 'fleet_role_arn' to be a str")
        pulumi.set(__self__, "fleet_role_arn", fleet_role_arn)
        if game_server_container_group_definition_arn and not isinstance(game_server_container_group_definition_arn, str):
            raise TypeError("Expected argument 'game_server_container_group_definition_arn' to be a str")
        pulumi.set(__self__, "game_server_container_group_definition_arn", game_server_container_group_definition_arn)
        if game_session_creation_limit_policy and not isinstance(game_session_creation_limit_policy, dict):
            raise TypeError("Expected argument 'game_session_creation_limit_policy' to be a dict")
        pulumi.set(__self__, "game_session_creation_limit_policy", game_session_creation_limit_policy)
        if instance_connection_port_range and not isinstance(instance_connection_port_range, dict):
            raise TypeError("Expected argument 'instance_connection_port_range' to be a dict")
        pulumi.set(__self__, "instance_connection_port_range", instance_connection_port_range)
        if instance_inbound_permissions and not isinstance(instance_inbound_permissions, list):
            raise TypeError("Expected argument 'instance_inbound_permissions' to be a list")
        pulumi.set(__self__, "instance_inbound_permissions", instance_inbound_permissions)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if log_configuration and not isinstance(log_configuration, dict):
            raise TypeError("Expected argument 'log_configuration' to be a dict")
        pulumi.set(__self__, "log_configuration", log_configuration)
        if maximum_game_server_container_groups_per_instance and not isinstance(maximum_game_server_container_groups_per_instance, int):
            raise TypeError("Expected argument 'maximum_game_server_container_groups_per_instance' to be a int")
        pulumi.set(__self__, "maximum_game_server_container_groups_per_instance", maximum_game_server_container_groups_per_instance)
        if metric_groups and not isinstance(metric_groups, list):
            raise TypeError("Expected argument 'metric_groups' to be a list")
        pulumi.set(__self__, "metric_groups", metric_groups)
        if new_game_session_protection_policy and not isinstance(new_game_session_protection_policy, str):
            raise TypeError("Expected argument 'new_game_session_protection_policy' to be a str")
        pulumi.set(__self__, "new_game_session_protection_policy", new_game_session_protection_policy)
        if per_instance_container_group_definition_arn and not isinstance(per_instance_container_group_definition_arn, str):
            raise TypeError("Expected argument 'per_instance_container_group_definition_arn' to be a str")
        pulumi.set(__self__, "per_instance_container_group_definition_arn", per_instance_container_group_definition_arn)
        if scaling_policies and not isinstance(scaling_policies, list):
            raise TypeError("Expected argument 'scaling_policies' to be a list")
        pulumi.set(__self__, "scaling_policies", scaling_policies)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.str]:
        """
        A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deploymentDetails")
    def deployment_details(self) -> Optional['outputs.ContainerFleetDeploymentDetails']:
        return pulumi.get(self, "deployment_details")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A human-readable description of a fleet.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fleetArn")
    def fleet_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) that is assigned to a Amazon GameLift container fleet resource and uniquely identifies it across all AWS Regions.
        """
        return pulumi.get(self, "fleet_arn")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[builtins.str]:
        """
        Unique fleet ID
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="fleetRoleArn")
    def fleet_role_arn(self) -> Optional[builtins.str]:
        """
        A unique identifier for an AWS IAM role that manages access to your AWS services. Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        """
        return pulumi.get(self, "fleet_role_arn")

    @property
    @pulumi.getter(name="gameServerContainerGroupDefinitionArn")
    def game_server_container_group_definition_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the game server container group definition. This field will be empty if GameServerContainerGroupDefinitionName is not specified.
        """
        return pulumi.get(self, "game_server_container_group_definition_arn")

    @property
    @pulumi.getter(name="gameSessionCreationLimitPolicy")
    def game_session_creation_limit_policy(self) -> Optional['outputs.ContainerFleetGameSessionCreationLimitPolicy']:
        """
        A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        """
        return pulumi.get(self, "game_session_creation_limit_policy")

    @property
    @pulumi.getter(name="instanceConnectionPortRange")
    def instance_connection_port_range(self) -> Optional['outputs.ContainerFleetConnectionPortRange']:
        """
        The set of port numbers to open on each instance in a container fleet. Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
        """
        return pulumi.get(self, "instance_connection_port_range")

    @property
    @pulumi.getter(name="instanceInboundPermissions")
    def instance_inbound_permissions(self) -> Optional[Sequence['outputs.ContainerFleetIpPermission']]:
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        """
        return pulumi.get(self, "instance_inbound_permissions")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence['outputs.ContainerFleetLocationConfiguration']]:
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ContainerFleetLogConfiguration']:
        """
        The method that is used to collect container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.

        - `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
        - `S3` -- Store logs in an Amazon S3 bucket that you define.
        - `NONE` -- Don't collect container logs.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter(name="maximumGameServerContainerGroupsPerInstance")
    def maximum_game_server_container_groups_per_instance(self) -> Optional[builtins.int]:
        """
        The maximum number of game server container groups per instance, a number between 1-5000.
        """
        return pulumi.get(self, "maximum_game_server_container_groups_per_instance")

    @property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        """
        return pulumi.get(self, "metric_groups")

    @property
    @pulumi.getter(name="newGameSessionProtectionPolicy")
    def new_game_session_protection_policy(self) -> Optional['ContainerFleetNewGameSessionProtectionPolicy']:
        """
        A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        """
        return pulumi.get(self, "new_game_session_protection_policy")

    @property
    @pulumi.getter(name="perInstanceContainerGroupDefinitionArn")
    def per_instance_container_group_definition_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the per instance container group definition. This field will be empty if PerInstanceContainerGroupDefinitionName is not specified.
        """
        return pulumi.get(self, "per_instance_container_group_definition_arn")

    @property
    @pulumi.getter(name="scalingPolicies")
    def scaling_policies(self) -> Optional[Sequence['outputs.ContainerFleetScalingPolicy']]:
        """
        A list of rules that control how a fleet is scaled.
        """
        return pulumi.get(self, "scaling_policies")

    @property
    @pulumi.getter
    def status(self) -> Optional['ContainerFleetStatus']:
        """
        The current status of the container fleet.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetContainerFleetResult(GetContainerFleetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerFleetResult(
            creation_time=self.creation_time,
            deployment_details=self.deployment_details,
            description=self.description,
            fleet_arn=self.fleet_arn,
            fleet_id=self.fleet_id,
            fleet_role_arn=self.fleet_role_arn,
            game_server_container_group_definition_arn=self.game_server_container_group_definition_arn,
            game_session_creation_limit_policy=self.game_session_creation_limit_policy,
            instance_connection_port_range=self.instance_connection_port_range,
            instance_inbound_permissions=self.instance_inbound_permissions,
            locations=self.locations,
            log_configuration=self.log_configuration,
            maximum_game_server_container_groups_per_instance=self.maximum_game_server_container_groups_per_instance,
            metric_groups=self.metric_groups,
            new_game_session_protection_policy=self.new_game_session_protection_policy,
            per_instance_container_group_definition_arn=self.per_instance_container_group_definition_arn,
            scaling_policies=self.scaling_policies,
            status=self.status,
            tags=self.tags)


def get_container_fleet(fleet_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerFleetResult:
    """
    The AWS::GameLift::ContainerFleet resource creates an Amazon GameLift (GameLift) container fleet to host game servers.


    :param builtins.str fleet_id: Unique fleet ID
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:gamelift:getContainerFleet', __args__, opts=opts, typ=GetContainerFleetResult).value

    return AwaitableGetContainerFleetResult(
        creation_time=pulumi.get(__ret__, 'creation_time'),
        deployment_details=pulumi.get(__ret__, 'deployment_details'),
        description=pulumi.get(__ret__, 'description'),
        fleet_arn=pulumi.get(__ret__, 'fleet_arn'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        fleet_role_arn=pulumi.get(__ret__, 'fleet_role_arn'),
        game_server_container_group_definition_arn=pulumi.get(__ret__, 'game_server_container_group_definition_arn'),
        game_session_creation_limit_policy=pulumi.get(__ret__, 'game_session_creation_limit_policy'),
        instance_connection_port_range=pulumi.get(__ret__, 'instance_connection_port_range'),
        instance_inbound_permissions=pulumi.get(__ret__, 'instance_inbound_permissions'),
        locations=pulumi.get(__ret__, 'locations'),
        log_configuration=pulumi.get(__ret__, 'log_configuration'),
        maximum_game_server_container_groups_per_instance=pulumi.get(__ret__, 'maximum_game_server_container_groups_per_instance'),
        metric_groups=pulumi.get(__ret__, 'metric_groups'),
        new_game_session_protection_policy=pulumi.get(__ret__, 'new_game_session_protection_policy'),
        per_instance_container_group_definition_arn=pulumi.get(__ret__, 'per_instance_container_group_definition_arn'),
        scaling_policies=pulumi.get(__ret__, 'scaling_policies'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_container_fleet_output(fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerFleetResult]:
    """
    The AWS::GameLift::ContainerFleet resource creates an Amazon GameLift (GameLift) container fleet to host game servers.


    :param builtins.str fleet_id: Unique fleet ID
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:gamelift:getContainerFleet', __args__, opts=opts, typ=GetContainerFleetResult)
    return __ret__.apply(lambda __response__: GetContainerFleetResult(
        creation_time=pulumi.get(__response__, 'creation_time'),
        deployment_details=pulumi.get(__response__, 'deployment_details'),
        description=pulumi.get(__response__, 'description'),
        fleet_arn=pulumi.get(__response__, 'fleet_arn'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        fleet_role_arn=pulumi.get(__response__, 'fleet_role_arn'),
        game_server_container_group_definition_arn=pulumi.get(__response__, 'game_server_container_group_definition_arn'),
        game_session_creation_limit_policy=pulumi.get(__response__, 'game_session_creation_limit_policy'),
        instance_connection_port_range=pulumi.get(__response__, 'instance_connection_port_range'),
        instance_inbound_permissions=pulumi.get(__response__, 'instance_inbound_permissions'),
        locations=pulumi.get(__response__, 'locations'),
        log_configuration=pulumi.get(__response__, 'log_configuration'),
        maximum_game_server_container_groups_per_instance=pulumi.get(__response__, 'maximum_game_server_container_groups_per_instance'),
        metric_groups=pulumi.get(__response__, 'metric_groups'),
        new_game_session_protection_policy=pulumi.get(__response__, 'new_game_session_protection_policy'),
        per_instance_container_group_definition_arn=pulumi.get(__response__, 'per_instance_container_group_definition_arn'),
        scaling_policies=pulumi.get(__response__, 'scaling_policies'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
