# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ContainerFleetArgs', 'ContainerFleet']

@pulumi.input_type
class ContainerFleetArgs:
    def __init__(__self__, *,
                 fleet_role_arn: pulumi.Input[builtins.str],
                 billing_type: Optional[pulumi.Input['ContainerFleetBillingType']] = None,
                 deployment_configuration: Optional[pulumi.Input['ContainerFleetDeploymentConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 game_server_container_group_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 game_server_container_groups_per_instance: Optional[pulumi.Input[builtins.int]] = None,
                 game_session_creation_limit_policy: Optional[pulumi.Input['ContainerFleetGameSessionCreationLimitPolicyArgs']] = None,
                 instance_connection_port_range: Optional[pulumi.Input['ContainerFleetConnectionPortRangeArgs']] = None,
                 instance_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetIpPermissionArgs']]]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetLocationConfigurationArgs']]]] = None,
                 log_configuration: Optional[pulumi.Input['ContainerFleetLogConfigurationArgs']] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input['ContainerFleetNewGameSessionProtectionPolicy']] = None,
                 per_instance_container_group_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetScalingPolicyArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ContainerFleet resource.
        :param pulumi.Input[builtins.str] fleet_role_arn: A unique identifier for an AWS IAM role that manages access to your AWS services. Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        :param pulumi.Input['ContainerFleetBillingType'] billing_type: Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
        :param pulumi.Input['ContainerFleetDeploymentConfigurationArgs'] deployment_configuration: Set of rules for processing a deployment for a container fleet update.
        :param pulumi.Input[builtins.str] description: A human-readable description of a fleet.
        :param pulumi.Input[builtins.str] game_server_container_group_definition_name: The name of the container group definition that will be created per game server. You must specify GAME_SERVER container group. You have the option to also specify one PER_INSTANCE container group.
        :param pulumi.Input[builtins.int] game_server_container_groups_per_instance: The number of desired game server container groups per instance, a number between 1-5000.
        :param pulumi.Input['ContainerFleetGameSessionCreationLimitPolicyArgs'] game_session_creation_limit_policy: A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        :param pulumi.Input['ContainerFleetConnectionPortRangeArgs'] instance_connection_port_range: The set of port numbers to open on each instance in a container fleet. Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerFleetIpPermissionArgs']]] instance_inbound_permissions: A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        :param pulumi.Input[builtins.str] instance_type: The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See Amazon EC2 Instance Types for detailed descriptions.
        :param pulumi.Input['ContainerFleetLogConfigurationArgs'] log_configuration: The method that is used to collect container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
               
               - `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
               - `S3` -- Store logs in an Amazon S3 bucket that you define.
               - `NONE` -- Don't collect container logs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] metric_groups: The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        :param pulumi.Input['ContainerFleetNewGameSessionProtectionPolicy'] new_game_session_protection_policy: A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        :param pulumi.Input[builtins.str] per_instance_container_group_definition_name: The name of the container group definition that will be created per instance. This field is optional if you specify GameServerContainerGroupDefinitionName.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerFleetScalingPolicyArgs']]] scaling_policies: A list of rules that control how a fleet is scaled.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "fleet_role_arn", fleet_role_arn)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if deployment_configuration is not None:
            pulumi.set(__self__, "deployment_configuration", deployment_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if game_server_container_group_definition_name is not None:
            pulumi.set(__self__, "game_server_container_group_definition_name", game_server_container_group_definition_name)
        if game_server_container_groups_per_instance is not None:
            pulumi.set(__self__, "game_server_container_groups_per_instance", game_server_container_groups_per_instance)
        if game_session_creation_limit_policy is not None:
            pulumi.set(__self__, "game_session_creation_limit_policy", game_session_creation_limit_policy)
        if instance_connection_port_range is not None:
            pulumi.set(__self__, "instance_connection_port_range", instance_connection_port_range)
        if instance_inbound_permissions is not None:
            pulumi.set(__self__, "instance_inbound_permissions", instance_inbound_permissions)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if metric_groups is not None:
            pulumi.set(__self__, "metric_groups", metric_groups)
        if new_game_session_protection_policy is not None:
            pulumi.set(__self__, "new_game_session_protection_policy", new_game_session_protection_policy)
        if per_instance_container_group_definition_name is not None:
            pulumi.set(__self__, "per_instance_container_group_definition_name", per_instance_container_group_definition_name)
        if scaling_policies is not None:
            pulumi.set(__self__, "scaling_policies", scaling_policies)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="fleetRoleArn")
    def fleet_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        A unique identifier for an AWS IAM role that manages access to your AWS services. Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        """
        return pulumi.get(self, "fleet_role_arn")

    @fleet_role_arn.setter
    def fleet_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "fleet_role_arn", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input['ContainerFleetBillingType']]:
        """
        Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input['ContainerFleetBillingType']]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter(name="deploymentConfiguration")
    def deployment_configuration(self) -> Optional[pulumi.Input['ContainerFleetDeploymentConfigurationArgs']]:
        """
        Set of rules for processing a deployment for a container fleet update.
        """
        return pulumi.get(self, "deployment_configuration")

    @deployment_configuration.setter
    def deployment_configuration(self, value: Optional[pulumi.Input['ContainerFleetDeploymentConfigurationArgs']]):
        pulumi.set(self, "deployment_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of a fleet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gameServerContainerGroupDefinitionName")
    def game_server_container_group_definition_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the container group definition that will be created per game server. You must specify GAME_SERVER container group. You have the option to also specify one PER_INSTANCE container group.
        """
        return pulumi.get(self, "game_server_container_group_definition_name")

    @game_server_container_group_definition_name.setter
    def game_server_container_group_definition_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "game_server_container_group_definition_name", value)

    @property
    @pulumi.getter(name="gameServerContainerGroupsPerInstance")
    def game_server_container_groups_per_instance(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of desired game server container groups per instance, a number between 1-5000.
        """
        return pulumi.get(self, "game_server_container_groups_per_instance")

    @game_server_container_groups_per_instance.setter
    def game_server_container_groups_per_instance(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "game_server_container_groups_per_instance", value)

    @property
    @pulumi.getter(name="gameSessionCreationLimitPolicy")
    def game_session_creation_limit_policy(self) -> Optional[pulumi.Input['ContainerFleetGameSessionCreationLimitPolicyArgs']]:
        """
        A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        """
        return pulumi.get(self, "game_session_creation_limit_policy")

    @game_session_creation_limit_policy.setter
    def game_session_creation_limit_policy(self, value: Optional[pulumi.Input['ContainerFleetGameSessionCreationLimitPolicyArgs']]):
        pulumi.set(self, "game_session_creation_limit_policy", value)

    @property
    @pulumi.getter(name="instanceConnectionPortRange")
    def instance_connection_port_range(self) -> Optional[pulumi.Input['ContainerFleetConnectionPortRangeArgs']]:
        """
        The set of port numbers to open on each instance in a container fleet. Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
        """
        return pulumi.get(self, "instance_connection_port_range")

    @instance_connection_port_range.setter
    def instance_connection_port_range(self, value: Optional[pulumi.Input['ContainerFleetConnectionPortRangeArgs']]):
        pulumi.set(self, "instance_connection_port_range", value)

    @property
    @pulumi.getter(name="instanceInboundPermissions")
    def instance_inbound_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetIpPermissionArgs']]]]:
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        """
        return pulumi.get(self, "instance_inbound_permissions")

    @instance_inbound_permissions.setter
    def instance_inbound_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetIpPermissionArgs']]]]):
        pulumi.set(self, "instance_inbound_permissions", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See Amazon EC2 Instance Types for detailed descriptions.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetLocationConfigurationArgs']]]]:
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetLocationConfigurationArgs']]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['ContainerFleetLogConfigurationArgs']]:
        """
        The method that is used to collect container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.

        - `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
        - `S3` -- Store logs in an Amazon S3 bucket that you define.
        - `NONE` -- Don't collect container logs.
        """
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['ContainerFleetLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        """
        return pulumi.get(self, "metric_groups")

    @metric_groups.setter
    def metric_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metric_groups", value)

    @property
    @pulumi.getter(name="newGameSessionProtectionPolicy")
    def new_game_session_protection_policy(self) -> Optional[pulumi.Input['ContainerFleetNewGameSessionProtectionPolicy']]:
        """
        A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        """
        return pulumi.get(self, "new_game_session_protection_policy")

    @new_game_session_protection_policy.setter
    def new_game_session_protection_policy(self, value: Optional[pulumi.Input['ContainerFleetNewGameSessionProtectionPolicy']]):
        pulumi.set(self, "new_game_session_protection_policy", value)

    @property
    @pulumi.getter(name="perInstanceContainerGroupDefinitionName")
    def per_instance_container_group_definition_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the container group definition that will be created per instance. This field is optional if you specify GameServerContainerGroupDefinitionName.
        """
        return pulumi.get(self, "per_instance_container_group_definition_name")

    @per_instance_container_group_definition_name.setter
    def per_instance_container_group_definition_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "per_instance_container_group_definition_name", value)

    @property
    @pulumi.getter(name="scalingPolicies")
    def scaling_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetScalingPolicyArgs']]]]:
        """
        A list of rules that control how a fleet is scaled.
        """
        return pulumi.get(self, "scaling_policies")

    @scaling_policies.setter
    def scaling_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetScalingPolicyArgs']]]]):
        pulumi.set(self, "scaling_policies", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:gamelift:ContainerFleet")
class ContainerFleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_type: Optional[pulumi.Input['ContainerFleetBillingType']] = None,
                 deployment_configuration: Optional[pulumi.Input[Union['ContainerFleetDeploymentConfigurationArgs', 'ContainerFleetDeploymentConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 game_server_container_group_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 game_server_container_groups_per_instance: Optional[pulumi.Input[builtins.int]] = None,
                 game_session_creation_limit_policy: Optional[pulumi.Input[Union['ContainerFleetGameSessionCreationLimitPolicyArgs', 'ContainerFleetGameSessionCreationLimitPolicyArgsDict']]] = None,
                 instance_connection_port_range: Optional[pulumi.Input[Union['ContainerFleetConnectionPortRangeArgs', 'ContainerFleetConnectionPortRangeArgsDict']]] = None,
                 instance_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerFleetIpPermissionArgs', 'ContainerFleetIpPermissionArgsDict']]]]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerFleetLocationConfigurationArgs', 'ContainerFleetLocationConfigurationArgsDict']]]]] = None,
                 log_configuration: Optional[pulumi.Input[Union['ContainerFleetLogConfigurationArgs', 'ContainerFleetLogConfigurationArgsDict']]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input['ContainerFleetNewGameSessionProtectionPolicy']] = None,
                 per_instance_container_group_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerFleetScalingPolicyArgs', 'ContainerFleetScalingPolicyArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::GameLift::ContainerFleet resource creates an Amazon GameLift (GameLift) container fleet to host game servers.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['ContainerFleetBillingType'] billing_type: Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
        :param pulumi.Input[Union['ContainerFleetDeploymentConfigurationArgs', 'ContainerFleetDeploymentConfigurationArgsDict']] deployment_configuration: Set of rules for processing a deployment for a container fleet update.
        :param pulumi.Input[builtins.str] description: A human-readable description of a fleet.
        :param pulumi.Input[builtins.str] fleet_role_arn: A unique identifier for an AWS IAM role that manages access to your AWS services. Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        :param pulumi.Input[builtins.str] game_server_container_group_definition_name: The name of the container group definition that will be created per game server. You must specify GAME_SERVER container group. You have the option to also specify one PER_INSTANCE container group.
        :param pulumi.Input[builtins.int] game_server_container_groups_per_instance: The number of desired game server container groups per instance, a number between 1-5000.
        :param pulumi.Input[Union['ContainerFleetGameSessionCreationLimitPolicyArgs', 'ContainerFleetGameSessionCreationLimitPolicyArgsDict']] game_session_creation_limit_policy: A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        :param pulumi.Input[Union['ContainerFleetConnectionPortRangeArgs', 'ContainerFleetConnectionPortRangeArgsDict']] instance_connection_port_range: The set of port numbers to open on each instance in a container fleet. Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerFleetIpPermissionArgs', 'ContainerFleetIpPermissionArgsDict']]]] instance_inbound_permissions: A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        :param pulumi.Input[builtins.str] instance_type: The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See Amazon EC2 Instance Types for detailed descriptions.
        :param pulumi.Input[Union['ContainerFleetLogConfigurationArgs', 'ContainerFleetLogConfigurationArgsDict']] log_configuration: The method that is used to collect container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
               
               - `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
               - `S3` -- Store logs in an Amazon S3 bucket that you define.
               - `NONE` -- Don't collect container logs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] metric_groups: The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        :param pulumi.Input['ContainerFleetNewGameSessionProtectionPolicy'] new_game_session_protection_policy: A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        :param pulumi.Input[builtins.str] per_instance_container_group_definition_name: The name of the container group definition that will be created per instance. This field is optional if you specify GameServerContainerGroupDefinitionName.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerFleetScalingPolicyArgs', 'ContainerFleetScalingPolicyArgsDict']]]] scaling_policies: A list of rules that control how a fleet is scaled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerFleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::GameLift::ContainerFleet resource creates an Amazon GameLift (GameLift) container fleet to host game servers.

        :param str resource_name: The name of the resource.
        :param ContainerFleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerFleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_type: Optional[pulumi.Input['ContainerFleetBillingType']] = None,
                 deployment_configuration: Optional[pulumi.Input[Union['ContainerFleetDeploymentConfigurationArgs', 'ContainerFleetDeploymentConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 game_server_container_group_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 game_server_container_groups_per_instance: Optional[pulumi.Input[builtins.int]] = None,
                 game_session_creation_limit_policy: Optional[pulumi.Input[Union['ContainerFleetGameSessionCreationLimitPolicyArgs', 'ContainerFleetGameSessionCreationLimitPolicyArgsDict']]] = None,
                 instance_connection_port_range: Optional[pulumi.Input[Union['ContainerFleetConnectionPortRangeArgs', 'ContainerFleetConnectionPortRangeArgsDict']]] = None,
                 instance_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerFleetIpPermissionArgs', 'ContainerFleetIpPermissionArgsDict']]]]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerFleetLocationConfigurationArgs', 'ContainerFleetLocationConfigurationArgsDict']]]]] = None,
                 log_configuration: Optional[pulumi.Input[Union['ContainerFleetLogConfigurationArgs', 'ContainerFleetLogConfigurationArgsDict']]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input['ContainerFleetNewGameSessionProtectionPolicy']] = None,
                 per_instance_container_group_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerFleetScalingPolicyArgs', 'ContainerFleetScalingPolicyArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerFleetArgs.__new__(ContainerFleetArgs)

            __props__.__dict__["billing_type"] = billing_type
            __props__.__dict__["deployment_configuration"] = deployment_configuration
            __props__.__dict__["description"] = description
            if fleet_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_role_arn'")
            __props__.__dict__["fleet_role_arn"] = fleet_role_arn
            __props__.__dict__["game_server_container_group_definition_name"] = game_server_container_group_definition_name
            __props__.__dict__["game_server_container_groups_per_instance"] = game_server_container_groups_per_instance
            __props__.__dict__["game_session_creation_limit_policy"] = game_session_creation_limit_policy
            __props__.__dict__["instance_connection_port_range"] = instance_connection_port_range
            __props__.__dict__["instance_inbound_permissions"] = instance_inbound_permissions
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["locations"] = locations
            __props__.__dict__["log_configuration"] = log_configuration
            __props__.__dict__["metric_groups"] = metric_groups
            __props__.__dict__["new_game_session_protection_policy"] = new_game_session_protection_policy
            __props__.__dict__["per_instance_container_group_definition_name"] = per_instance_container_group_definition_name
            __props__.__dict__["scaling_policies"] = scaling_policies
            __props__.__dict__["tags"] = tags
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["deployment_details"] = None
            __props__.__dict__["fleet_arn"] = None
            __props__.__dict__["fleet_id"] = None
            __props__.__dict__["game_server_container_group_definition_arn"] = None
            __props__.__dict__["maximum_game_server_container_groups_per_instance"] = None
            __props__.__dict__["per_instance_container_group_definition_arn"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["billingType", "instanceType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ContainerFleet, __self__).__init__(
            'aws-native:gamelift:ContainerFleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ContainerFleet':
        """
        Get an existing ContainerFleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ContainerFleetArgs.__new__(ContainerFleetArgs)

        __props__.__dict__["billing_type"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["deployment_configuration"] = None
        __props__.__dict__["deployment_details"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["fleet_arn"] = None
        __props__.__dict__["fleet_id"] = None
        __props__.__dict__["fleet_role_arn"] = None
        __props__.__dict__["game_server_container_group_definition_arn"] = None
        __props__.__dict__["game_server_container_group_definition_name"] = None
        __props__.__dict__["game_server_container_groups_per_instance"] = None
        __props__.__dict__["game_session_creation_limit_policy"] = None
        __props__.__dict__["instance_connection_port_range"] = None
        __props__.__dict__["instance_inbound_permissions"] = None
        __props__.__dict__["instance_type"] = None
        __props__.__dict__["locations"] = None
        __props__.__dict__["log_configuration"] = None
        __props__.__dict__["maximum_game_server_container_groups_per_instance"] = None
        __props__.__dict__["metric_groups"] = None
        __props__.__dict__["new_game_session_protection_policy"] = None
        __props__.__dict__["per_instance_container_group_definition_arn"] = None
        __props__.__dict__["per_instance_container_group_definition_name"] = None
        __props__.__dict__["scaling_policies"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return ContainerFleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Output[Optional['ContainerFleetBillingType']]:
        """
        Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deploymentConfiguration")
    def deployment_configuration(self) -> pulumi.Output[Optional['outputs.ContainerFleetDeploymentConfiguration']]:
        """
        Set of rules for processing a deployment for a container fleet update.
        """
        return pulumi.get(self, "deployment_configuration")

    @property
    @pulumi.getter(name="deploymentDetails")
    def deployment_details(self) -> pulumi.Output['outputs.ContainerFleetDeploymentDetails']:
        return pulumi.get(self, "deployment_details")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human-readable description of a fleet.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fleetArn")
    def fleet_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) that is assigned to a Amazon GameLift container fleet resource and uniquely identifies it across all AWS Regions.
        """
        return pulumi.get(self, "fleet_arn")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique fleet ID
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="fleetRoleArn")
    def fleet_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for an AWS IAM role that manages access to your AWS services. Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        """
        return pulumi.get(self, "fleet_role_arn")

    @property
    @pulumi.getter(name="gameServerContainerGroupDefinitionArn")
    def game_server_container_group_definition_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the game server container group definition. This field will be empty if GameServerContainerGroupDefinitionName is not specified.
        """
        return pulumi.get(self, "game_server_container_group_definition_arn")

    @property
    @pulumi.getter(name="gameServerContainerGroupDefinitionName")
    def game_server_container_group_definition_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the container group definition that will be created per game server. You must specify GAME_SERVER container group. You have the option to also specify one PER_INSTANCE container group.
        """
        return pulumi.get(self, "game_server_container_group_definition_name")

    @property
    @pulumi.getter(name="gameServerContainerGroupsPerInstance")
    def game_server_container_groups_per_instance(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of desired game server container groups per instance, a number between 1-5000.
        """
        return pulumi.get(self, "game_server_container_groups_per_instance")

    @property
    @pulumi.getter(name="gameSessionCreationLimitPolicy")
    def game_session_creation_limit_policy(self) -> pulumi.Output[Optional['outputs.ContainerFleetGameSessionCreationLimitPolicy']]:
        """
        A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        """
        return pulumi.get(self, "game_session_creation_limit_policy")

    @property
    @pulumi.getter(name="instanceConnectionPortRange")
    def instance_connection_port_range(self) -> pulumi.Output[Optional['outputs.ContainerFleetConnectionPortRange']]:
        """
        The set of port numbers to open on each instance in a container fleet. Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
        """
        return pulumi.get(self, "instance_connection_port_range")

    @property
    @pulumi.getter(name="instanceInboundPermissions")
    def instance_inbound_permissions(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerFleetIpPermission']]]:
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        """
        return pulumi.get(self, "instance_inbound_permissions")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See Amazon EC2 Instance Types for detailed descriptions.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerFleetLocationConfiguration']]]:
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> pulumi.Output[Optional['outputs.ContainerFleetLogConfiguration']]:
        """
        The method that is used to collect container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.

        - `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
        - `S3` -- Store logs in an Amazon S3 bucket that you define.
        - `NONE` -- Don't collect container logs.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter(name="maximumGameServerContainerGroupsPerInstance")
    def maximum_game_server_container_groups_per_instance(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of game server container groups per instance, a number between 1-5000.
        """
        return pulumi.get(self, "maximum_game_server_container_groups_per_instance")

    @property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        """
        return pulumi.get(self, "metric_groups")

    @property
    @pulumi.getter(name="newGameSessionProtectionPolicy")
    def new_game_session_protection_policy(self) -> pulumi.Output[Optional['ContainerFleetNewGameSessionProtectionPolicy']]:
        """
        A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        """
        return pulumi.get(self, "new_game_session_protection_policy")

    @property
    @pulumi.getter(name="perInstanceContainerGroupDefinitionArn")
    def per_instance_container_group_definition_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the per instance container group definition. This field will be empty if PerInstanceContainerGroupDefinitionName is not specified.
        """
        return pulumi.get(self, "per_instance_container_group_definition_arn")

    @property
    @pulumi.getter(name="perInstanceContainerGroupDefinitionName")
    def per_instance_container_group_definition_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the container group definition that will be created per instance. This field is optional if you specify GameServerContainerGroupDefinitionName.
        """
        return pulumi.get(self, "per_instance_container_group_definition_name")

    @property
    @pulumi.getter(name="scalingPolicies")
    def scaling_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerFleetScalingPolicy']]]:
        """
        A list of rules that control how a fleet is scaled.
        """
        return pulumi.get(self, "scaling_policies")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['ContainerFleetStatus']:
        """
        The current status of the container fleet.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

