# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AliasRoutingStrategyArgs',
    'AliasRoutingStrategyArgsDict',
    'BuildStorageLocationArgs',
    'BuildStorageLocationArgsDict',
    'ContainerFleetConnectionPortRangeArgs',
    'ContainerFleetConnectionPortRangeArgsDict',
    'ContainerFleetDeploymentConfigurationArgs',
    'ContainerFleetDeploymentConfigurationArgsDict',
    'ContainerFleetGameSessionCreationLimitPolicyArgs',
    'ContainerFleetGameSessionCreationLimitPolicyArgsDict',
    'ContainerFleetIpPermissionArgs',
    'ContainerFleetIpPermissionArgsDict',
    'ContainerFleetLocationCapacityArgs',
    'ContainerFleetLocationCapacityArgsDict',
    'ContainerFleetLocationConfigurationArgs',
    'ContainerFleetLocationConfigurationArgsDict',
    'ContainerFleetLogConfigurationArgs',
    'ContainerFleetLogConfigurationArgsDict',
    'ContainerFleetScalingPolicyArgs',
    'ContainerFleetScalingPolicyArgsDict',
    'ContainerFleetTargetConfigurationArgs',
    'ContainerFleetTargetConfigurationArgsDict',
    'ContainerGroupDefinitionContainerDependencyArgs',
    'ContainerGroupDefinitionContainerDependencyArgsDict',
    'ContainerGroupDefinitionContainerEnvironmentArgs',
    'ContainerGroupDefinitionContainerEnvironmentArgsDict',
    'ContainerGroupDefinitionContainerHealthCheckArgs',
    'ContainerGroupDefinitionContainerHealthCheckArgsDict',
    'ContainerGroupDefinitionContainerMountPointArgs',
    'ContainerGroupDefinitionContainerMountPointArgsDict',
    'ContainerGroupDefinitionContainerPortRangeArgs',
    'ContainerGroupDefinitionContainerPortRangeArgsDict',
    'ContainerGroupDefinitionGameServerContainerDefinitionArgs',
    'ContainerGroupDefinitionGameServerContainerDefinitionArgsDict',
    'ContainerGroupDefinitionPortConfigurationArgs',
    'ContainerGroupDefinitionPortConfigurationArgsDict',
    'ContainerGroupDefinitionSupportContainerDefinitionArgs',
    'ContainerGroupDefinitionSupportContainerDefinitionArgsDict',
    'FleetAnywhereConfigurationArgs',
    'FleetAnywhereConfigurationArgsDict',
    'FleetCertificateConfigurationArgs',
    'FleetCertificateConfigurationArgsDict',
    'FleetIpPermissionArgs',
    'FleetIpPermissionArgsDict',
    'FleetLocationCapacityArgs',
    'FleetLocationCapacityArgsDict',
    'FleetLocationConfigurationArgs',
    'FleetLocationConfigurationArgsDict',
    'FleetResourceCreationLimitPolicyArgs',
    'FleetResourceCreationLimitPolicyArgsDict',
    'FleetRuntimeConfigurationArgs',
    'FleetRuntimeConfigurationArgsDict',
    'FleetScalingPolicyArgs',
    'FleetScalingPolicyArgsDict',
    'FleetServerProcessArgs',
    'FleetServerProcessArgsDict',
    'FleetTargetConfigurationArgs',
    'FleetTargetConfigurationArgsDict',
    'GameServerGroupAutoScalingPolicyArgs',
    'GameServerGroupAutoScalingPolicyArgsDict',
    'GameServerGroupInstanceDefinitionArgs',
    'GameServerGroupInstanceDefinitionArgsDict',
    'GameServerGroupLaunchTemplateArgs',
    'GameServerGroupLaunchTemplateArgsDict',
    'GameServerGroupTargetTrackingConfigurationArgs',
    'GameServerGroupTargetTrackingConfigurationArgsDict',
    'GameSessionQueueDestinationArgs',
    'GameSessionQueueDestinationArgsDict',
    'GameSessionQueueFilterConfigurationArgs',
    'GameSessionQueueFilterConfigurationArgsDict',
    'GameSessionQueuePlayerLatencyPolicyArgs',
    'GameSessionQueuePlayerLatencyPolicyArgsDict',
    'GameSessionQueuePriorityConfigurationArgs',
    'GameSessionQueuePriorityConfigurationArgsDict',
    'MatchmakingConfigurationGamePropertyArgs',
    'MatchmakingConfigurationGamePropertyArgsDict',
    'ScriptS3LocationArgs',
    'ScriptS3LocationArgsDict',
]

MYPY = False

if not MYPY:
    class AliasRoutingStrategyArgsDict(TypedDict):
        type: pulumi.Input['AliasRoutingStrategyType']
        """
        Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        """
        fleet_id: NotRequired[pulumi.Input[builtins.str]]
        """
        A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
elif False:
    AliasRoutingStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AliasRoutingStrategyArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['AliasRoutingStrategyType'],
                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['AliasRoutingStrategyType'] type: Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        :param pulumi.Input[builtins.str] fleet_id: A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        :param pulumi.Input[builtins.str] message: The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        pulumi.set(__self__, "type", type)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['AliasRoutingStrategyType']:
        """
        Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['AliasRoutingStrategyType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)


if not MYPY:
    class BuildStorageLocationArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        key: pulumi.Input[builtins.str]
        """
        The name of the zip file that contains the build files or script files.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        object_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
elif False:
    BuildStorageLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BuildStorageLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 object_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        :param pulumi.Input[builtins.str] key: The name of the zip file that contains the build files or script files.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        :param pulumi.Input[builtins.str] object_version: The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The name of the zip file that contains the build files or script files.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_version", value)


if not MYPY:
    class ContainerFleetConnectionPortRangeArgsDict(TypedDict):
        """
        Defines the range of ports on the instance that allow inbound traffic to connect with containers in a fleet.
        """
        from_port: pulumi.Input[builtins.int]
        """
        A starting value for a range of allowed port numbers.
        """
        to_port: pulumi.Input[builtins.int]
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
elif False:
    ContainerFleetConnectionPortRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetConnectionPortRangeArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[builtins.int],
                 to_port: pulumi.Input[builtins.int]):
        """
        Defines the range of ports on the instance that allow inbound traffic to connect with containers in a fleet.
        :param pulumi.Input[builtins.int] from_port: A starting value for a range of allowed port numbers.
        :param pulumi.Input[builtins.int] to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[builtins.int]:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[builtins.int]:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "to_port", value)


if not MYPY:
    class ContainerFleetDeploymentConfigurationArgsDict(TypedDict):
        """
        Provides details about how to drain old tasks and replace them with new updated tasks.
        """
        impairment_strategy: NotRequired[pulumi.Input['ContainerFleetDeploymentConfigurationImpairmentStrategy']]
        """
        The strategy to apply in case of impairment; defaults to MAINTAIN.
        """
        minimum_healthy_percentage: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum percentage of healthy required; defaults to 75.
        """
        protection_strategy: NotRequired[pulumi.Input['ContainerFleetDeploymentConfigurationProtectionStrategy']]
        """
        The protection strategy for deployment on the container fleet; defaults to WITH_PROTECTION.
        """
elif False:
    ContainerFleetDeploymentConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetDeploymentConfigurationArgs:
    def __init__(__self__, *,
                 impairment_strategy: Optional[pulumi.Input['ContainerFleetDeploymentConfigurationImpairmentStrategy']] = None,
                 minimum_healthy_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 protection_strategy: Optional[pulumi.Input['ContainerFleetDeploymentConfigurationProtectionStrategy']] = None):
        """
        Provides details about how to drain old tasks and replace them with new updated tasks.
        :param pulumi.Input['ContainerFleetDeploymentConfigurationImpairmentStrategy'] impairment_strategy: The strategy to apply in case of impairment; defaults to MAINTAIN.
        :param pulumi.Input[builtins.int] minimum_healthy_percentage: The minimum percentage of healthy required; defaults to 75.
        :param pulumi.Input['ContainerFleetDeploymentConfigurationProtectionStrategy'] protection_strategy: The protection strategy for deployment on the container fleet; defaults to WITH_PROTECTION.
        """
        if impairment_strategy is not None:
            pulumi.set(__self__, "impairment_strategy", impairment_strategy)
        if minimum_healthy_percentage is not None:
            pulumi.set(__self__, "minimum_healthy_percentage", minimum_healthy_percentage)
        if protection_strategy is not None:
            pulumi.set(__self__, "protection_strategy", protection_strategy)

    @property
    @pulumi.getter(name="impairmentStrategy")
    def impairment_strategy(self) -> Optional[pulumi.Input['ContainerFleetDeploymentConfigurationImpairmentStrategy']]:
        """
        The strategy to apply in case of impairment; defaults to MAINTAIN.
        """
        return pulumi.get(self, "impairment_strategy")

    @impairment_strategy.setter
    def impairment_strategy(self, value: Optional[pulumi.Input['ContainerFleetDeploymentConfigurationImpairmentStrategy']]):
        pulumi.set(self, "impairment_strategy", value)

    @property
    @pulumi.getter(name="minimumHealthyPercentage")
    def minimum_healthy_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum percentage of healthy required; defaults to 75.
        """
        return pulumi.get(self, "minimum_healthy_percentage")

    @minimum_healthy_percentage.setter
    def minimum_healthy_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_healthy_percentage", value)

    @property
    @pulumi.getter(name="protectionStrategy")
    def protection_strategy(self) -> Optional[pulumi.Input['ContainerFleetDeploymentConfigurationProtectionStrategy']]:
        """
        The protection strategy for deployment on the container fleet; defaults to WITH_PROTECTION.
        """
        return pulumi.get(self, "protection_strategy")

    @protection_strategy.setter
    def protection_strategy(self, value: Optional[pulumi.Input['ContainerFleetDeploymentConfigurationProtectionStrategy']]):
        pulumi.set(self, "protection_strategy", value)


if not MYPY:
    class ContainerFleetGameSessionCreationLimitPolicyArgsDict(TypedDict):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        """
        new_game_sessions_per_creator: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        policy_period_in_minutes: NotRequired[pulumi.Input[builtins.int]]
        """
        The time span used in evaluating the resource creation limit policy.
        """
elif False:
    ContainerFleetGameSessionCreationLimitPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetGameSessionCreationLimitPolicyArgs:
    def __init__(__self__, *,
                 new_game_sessions_per_creator: Optional[pulumi.Input[builtins.int]] = None,
                 policy_period_in_minutes: Optional[pulumi.Input[builtins.int]] = None):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        :param pulumi.Input[builtins.int] new_game_sessions_per_creator: The maximum number of game sessions that an individual can create during the policy period.
        :param pulumi.Input[builtins.int] policy_period_in_minutes: The time span used in evaluating the resource creation limit policy.
        """
        if new_game_sessions_per_creator is not None:
            pulumi.set(__self__, "new_game_sessions_per_creator", new_game_sessions_per_creator)
        if policy_period_in_minutes is not None:
            pulumi.set(__self__, "policy_period_in_minutes", policy_period_in_minutes)

    @property
    @pulumi.getter(name="newGameSessionsPerCreator")
    def new_game_sessions_per_creator(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        return pulumi.get(self, "new_game_sessions_per_creator")

    @new_game_sessions_per_creator.setter
    def new_game_sessions_per_creator(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "new_game_sessions_per_creator", value)

    @property
    @pulumi.getter(name="policyPeriodInMinutes")
    def policy_period_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time span used in evaluating the resource creation limit policy.
        """
        return pulumi.get(self, "policy_period_in_minutes")

    @policy_period_in_minutes.setter
    def policy_period_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "policy_period_in_minutes", value)


if not MYPY:
    class ContainerFleetIpPermissionArgsDict(TypedDict):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        """
        from_port: pulumi.Input[builtins.int]
        """
        A starting value for a range of allowed port numbers.
        """
        ip_range: pulumi.Input[builtins.str]
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        protocol: pulumi.Input['ContainerFleetIpPermissionProtocol']
        """
        The network communication protocol used by the fleet.
        """
        to_port: pulumi.Input[builtins.int]
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
elif False:
    ContainerFleetIpPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetIpPermissionArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[builtins.int],
                 ip_range: pulumi.Input[builtins.str],
                 protocol: pulumi.Input['ContainerFleetIpPermissionProtocol'],
                 to_port: pulumi.Input[builtins.int]):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        :param pulumi.Input[builtins.int] from_port: A starting value for a range of allowed port numbers.
        :param pulumi.Input[builtins.str] ip_range: A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        :param pulumi.Input['ContainerFleetIpPermissionProtocol'] protocol: The network communication protocol used by the fleet.
        :param pulumi.Input[builtins.int] to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[builtins.int]:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Input[builtins.str]:
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['ContainerFleetIpPermissionProtocol']:
        """
        The network communication protocol used by the fleet.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['ContainerFleetIpPermissionProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[builtins.int]:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "to_port", value)


if not MYPY:
    class ContainerFleetLocationCapacityArgsDict(TypedDict):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        """
        desired_ec2_instances: pulumi.Input[builtins.int]
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        max_size: pulumi.Input[builtins.int]
        """
        The maximum value that is allowed for the fleet's instance count for a location.
        """
        min_size: pulumi.Input[builtins.int]
        """
        The minimum value allowed for the fleet's instance count for a location.
        """
elif False:
    ContainerFleetLocationCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetLocationCapacityArgs:
    def __init__(__self__, *,
                 desired_ec2_instances: pulumi.Input[builtins.int],
                 max_size: pulumi.Input[builtins.int],
                 min_size: pulumi.Input[builtins.int]):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        :param pulumi.Input[builtins.int] desired_ec2_instances: The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        :param pulumi.Input[builtins.int] max_size: The maximum value that is allowed for the fleet's instance count for a location.
        :param pulumi.Input[builtins.int] min_size: The minimum value allowed for the fleet's instance count for a location.
        """
        pulumi.set(__self__, "desired_ec2_instances", desired_ec2_instances)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredEc2Instances")
    def desired_ec2_instances(self) -> pulumi.Input[builtins.int]:
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @desired_ec2_instances.setter
    def desired_ec2_instances(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "desired_ec2_instances", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[builtins.int]:
        """
        The maximum value that is allowed for the fleet's instance count for a location.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[builtins.int]:
        """
        The minimum value allowed for the fleet's instance count for a location.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_size", value)


if not MYPY:
    class ContainerFleetLocationConfigurationArgsDict(TypedDict):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        """
        location: pulumi.Input[builtins.str]
        """
        An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        location_capacity: NotRequired[pulumi.Input['ContainerFleetLocationCapacityArgsDict']]
        stopped_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ContainerFleetStoppedActionsItem']]]]
elif False:
    ContainerFleetLocationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetLocationConfigurationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 location_capacity: Optional[pulumi.Input['ContainerFleetLocationCapacityArgs']] = None,
                 stopped_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetStoppedActionsItem']]]] = None):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        :param pulumi.Input[builtins.str] location: An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        pulumi.set(__self__, "location", location)
        if location_capacity is not None:
            pulumi.set(__self__, "location_capacity", location_capacity)
        if stopped_actions is not None:
            pulumi.set(__self__, "stopped_actions", stopped_actions)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationCapacity")
    def location_capacity(self) -> Optional[pulumi.Input['ContainerFleetLocationCapacityArgs']]:
        return pulumi.get(self, "location_capacity")

    @location_capacity.setter
    def location_capacity(self, value: Optional[pulumi.Input['ContainerFleetLocationCapacityArgs']]):
        pulumi.set(self, "location_capacity", value)

    @property
    @pulumi.getter(name="stoppedActions")
    def stopped_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetStoppedActionsItem']]]]:
        return pulumi.get(self, "stopped_actions")

    @stopped_actions.setter
    def stopped_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerFleetStoppedActionsItem']]]]):
        pulumi.set(self, "stopped_actions", value)


if not MYPY:
    class ContainerFleetLogConfigurationArgsDict(TypedDict):
        """
        A policy the location and provider of logs from the fleet.
        """
        log_destination: NotRequired[pulumi.Input['ContainerFleetLogDestination']]
        """
        The type of log collection to use for a fleet.

        - `CLOUDWATCH` -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
        - `S3` -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home AWS Region.
        - `NONE` -- Don't collect container logs.
        """
        s3_bucket_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the S3 bucket to pull logs from if S3 is the LogDestination
        """
elif False:
    ContainerFleetLogConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetLogConfigurationArgs:
    def __init__(__self__, *,
                 log_destination: Optional[pulumi.Input['ContainerFleetLogDestination']] = None,
                 s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        A policy the location and provider of logs from the fleet.
        :param pulumi.Input['ContainerFleetLogDestination'] log_destination: The type of log collection to use for a fleet.
               
               - `CLOUDWATCH` -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
               - `S3` -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home AWS Region.
               - `NONE` -- Don't collect container logs.
        :param pulumi.Input[builtins.str] s3_bucket_name: The name of the S3 bucket to pull logs from if S3 is the LogDestination
        """
        if log_destination is not None:
            pulumi.set(__self__, "log_destination", log_destination)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)

    @property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> Optional[pulumi.Input['ContainerFleetLogDestination']]:
        """
        The type of log collection to use for a fleet.

        - `CLOUDWATCH` -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
        - `S3` -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home AWS Region.
        - `NONE` -- Don't collect container logs.
        """
        return pulumi.get(self, "log_destination")

    @log_destination.setter
    def log_destination(self, value: Optional[pulumi.Input['ContainerFleetLogDestination']]):
        pulumi.set(self, "log_destination", value)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the S3 bucket to pull logs from if S3 is the LogDestination
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket_name", value)


if not MYPY:
    class ContainerFleetScalingPolicyArgsDict(TypedDict):
        """
        Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
        """
        metric_name: pulumi.Input['ContainerFleetScalingPolicyMetricName']
        """
        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        """
        name: pulumi.Input[builtins.str]
        """
        A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        """
        comparison_operator: NotRequired[pulumi.Input['ContainerFleetScalingPolicyComparisonOperator']]
        """
        Comparison operator to use when measuring a metric against the threshold value.
        """
        evaluation_periods: NotRequired[pulumi.Input[builtins.int]]
        """
        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        """
        policy_type: NotRequired[pulumi.Input['ContainerFleetScalingPolicyPolicyType']]
        """
        The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        """
        scaling_adjustment: NotRequired[pulumi.Input[builtins.int]]
        """
        Amount of adjustment to make, based on the scaling adjustment type.
        """
        scaling_adjustment_type: NotRequired[pulumi.Input['ContainerFleetScalingPolicyScalingAdjustmentType']]
        """
        The type of adjustment to make to a fleet's instance count.
        """
        target_configuration: NotRequired[pulumi.Input['ContainerFleetTargetConfigurationArgsDict']]
        """
        An object that contains settings for a target-based scaling policy.
        """
        threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        Metric value used to trigger a scaling event.
        """
elif False:
    ContainerFleetScalingPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetScalingPolicyArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input['ContainerFleetScalingPolicyMetricName'],
                 name: pulumi.Input[builtins.str],
                 comparison_operator: Optional[pulumi.Input['ContainerFleetScalingPolicyComparisonOperator']] = None,
                 evaluation_periods: Optional[pulumi.Input[builtins.int]] = None,
                 policy_type: Optional[pulumi.Input['ContainerFleetScalingPolicyPolicyType']] = None,
                 scaling_adjustment: Optional[pulumi.Input[builtins.int]] = None,
                 scaling_adjustment_type: Optional[pulumi.Input['ContainerFleetScalingPolicyScalingAdjustmentType']] = None,
                 target_configuration: Optional[pulumi.Input['ContainerFleetTargetConfigurationArgs']] = None,
                 threshold: Optional[pulumi.Input[builtins.float]] = None):
        """
        Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
        :param pulumi.Input['ContainerFleetScalingPolicyMetricName'] metric_name: Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        :param pulumi.Input[builtins.str] name: A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        :param pulumi.Input['ContainerFleetScalingPolicyComparisonOperator'] comparison_operator: Comparison operator to use when measuring a metric against the threshold value.
        :param pulumi.Input[builtins.int] evaluation_periods: Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        :param pulumi.Input['ContainerFleetScalingPolicyPolicyType'] policy_type: The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        :param pulumi.Input[builtins.int] scaling_adjustment: Amount of adjustment to make, based on the scaling adjustment type.
        :param pulumi.Input['ContainerFleetScalingPolicyScalingAdjustmentType'] scaling_adjustment_type: The type of adjustment to make to a fleet's instance count.
        :param pulumi.Input['ContainerFleetTargetConfigurationArgs'] target_configuration: An object that contains settings for a target-based scaling policy.
        :param pulumi.Input[builtins.float] threshold: Metric value used to trigger a scaling event.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if scaling_adjustment_type is not None:
            pulumi.set(__self__, "scaling_adjustment_type", scaling_adjustment_type)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input['ContainerFleetScalingPolicyMetricName']:
        """
        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input['ContainerFleetScalingPolicyMetricName']):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[pulumi.Input['ContainerFleetScalingPolicyComparisonOperator']]:
        """
        Comparison operator to use when measuring a metric against the threshold value.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: Optional[pulumi.Input['ContainerFleetScalingPolicyComparisonOperator']]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input['ContainerFleetScalingPolicyPolicyType']]:
        """
        The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input['ContainerFleetScalingPolicyPolicyType']]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of adjustment to make, based on the scaling adjustment type.
        """
        return pulumi.get(self, "scaling_adjustment")

    @scaling_adjustment.setter
    def scaling_adjustment(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "scaling_adjustment", value)

    @property
    @pulumi.getter(name="scalingAdjustmentType")
    def scaling_adjustment_type(self) -> Optional[pulumi.Input['ContainerFleetScalingPolicyScalingAdjustmentType']]:
        """
        The type of adjustment to make to a fleet's instance count.
        """
        return pulumi.get(self, "scaling_adjustment_type")

    @scaling_adjustment_type.setter
    def scaling_adjustment_type(self, value: Optional[pulumi.Input['ContainerFleetScalingPolicyScalingAdjustmentType']]):
        pulumi.set(self, "scaling_adjustment_type", value)

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional[pulumi.Input['ContainerFleetTargetConfigurationArgs']]:
        """
        An object that contains settings for a target-based scaling policy.
        """
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: Optional[pulumi.Input['ContainerFleetTargetConfigurationArgs']]):
        pulumi.set(self, "target_configuration", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Metric value used to trigger a scaling event.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class ContainerFleetTargetConfigurationArgsDict(TypedDict):
        """
        Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
        """
        target_value: pulumi.Input[builtins.float]
        """
        Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
elif False:
    ContainerFleetTargetConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerFleetTargetConfigurationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[builtins.float]):
        """
        Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
        :param pulumi.Input[builtins.float] target_value: Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[builtins.float]:
        """
        Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "target_value", value)


if not MYPY:
    class ContainerGroupDefinitionContainerDependencyArgsDict(TypedDict):
        """
        A dependency that impacts a container's startup and shutdown.
        """
        condition: pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition']
        """
        The type of dependency.
        """
        container_name: pulumi.Input[builtins.str]
        """
        A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
elif False:
    ContainerGroupDefinitionContainerDependencyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerGroupDefinitionContainerDependencyArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition'],
                 container_name: pulumi.Input[builtins.str]):
        """
        A dependency that impacts a container's startup and shutdown.
        :param pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition'] condition: The type of dependency.
        :param pulumi.Input[builtins.str] container_name: A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition']:
        """
        The type of dependency.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition']):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[builtins.str]:
        """
        A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_name", value)


if not MYPY:
    class ContainerGroupDefinitionContainerEnvironmentArgsDict(TypedDict):
        """
        An environment variable to set inside a container, in the form of a key-value pair.
        """
        name: pulumi.Input[builtins.str]
        """
        The environment variable name.
        """
        value: pulumi.Input[builtins.str]
        """
        The environment variable value.
        """
elif False:
    ContainerGroupDefinitionContainerEnvironmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerGroupDefinitionContainerEnvironmentArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        An environment variable to set inside a container, in the form of a key-value pair.
        :param pulumi.Input[builtins.str] name: The environment variable name.
        :param pulumi.Input[builtins.str] value: The environment variable value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The environment variable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The environment variable value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ContainerGroupDefinitionContainerHealthCheckArgsDict(TypedDict):
        """
        Specifies how the process manager checks the health of containers.
        """
        command: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        interval: NotRequired[pulumi.Input[builtins.int]]
        """
        How often (in seconds) the health is checked.
        """
        retries: NotRequired[pulumi.Input[builtins.int]]
        """
        How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        """
        start_period: NotRequired[pulumi.Input[builtins.int]]
        """
        The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        """
        timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        How many seconds the process manager allows the command to run before canceling it.
        """
elif False:
    ContainerGroupDefinitionContainerHealthCheckArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerGroupDefinitionContainerHealthCheckArgs:
    def __init__(__self__, *,
                 command: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 start_period: Optional[pulumi.Input[builtins.int]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        Specifies how the process manager checks the health of containers.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] command: A string array representing the command that the container runs to determine if it is healthy.
        :param pulumi.Input[builtins.int] interval: How often (in seconds) the health is checked.
        :param pulumi.Input[builtins.int] retries: How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        :param pulumi.Input[builtins.int] start_period: The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        :param pulumi.Input[builtins.int] timeout: How many seconds the process manager allows the command to run before canceling it.
        """
        pulumi.set(__self__, "command", command)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        How often (in seconds) the health is checked.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        """
        return pulumi.get(self, "start_period")

    @start_period.setter
    def start_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start_period", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        How many seconds the process manager allows the command to run before canceling it.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class ContainerGroupDefinitionContainerMountPointArgsDict(TypedDict):
        """
        Defines the mount point configuration within a container.
        """
        instance_path: pulumi.Input[builtins.str]
        """
        The path on the host that will be mounted in the container.
        """
        access_level: NotRequired[pulumi.Input['ContainerGroupDefinitionContainerMountPointAccessLevel']]
        """
        The access permissions for the mounted path.
        """
        container_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path inside the container where the mount is accessible.
        """
elif False:
    ContainerGroupDefinitionContainerMountPointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerGroupDefinitionContainerMountPointArgs:
    def __init__(__self__, *,
                 instance_path: pulumi.Input[builtins.str],
                 access_level: Optional[pulumi.Input['ContainerGroupDefinitionContainerMountPointAccessLevel']] = None,
                 container_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        Defines the mount point configuration within a container.
        :param pulumi.Input[builtins.str] instance_path: The path on the host that will be mounted in the container.
        :param pulumi.Input['ContainerGroupDefinitionContainerMountPointAccessLevel'] access_level: The access permissions for the mounted path.
        :param pulumi.Input[builtins.str] container_path: The path inside the container where the mount is accessible.
        """
        pulumi.set(__self__, "instance_path", instance_path)
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)

    @property
    @pulumi.getter(name="instancePath")
    def instance_path(self) -> pulumi.Input[builtins.str]:
        """
        The path on the host that will be mounted in the container.
        """
        return pulumi.get(self, "instance_path")

    @instance_path.setter
    def instance_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_path", value)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input['ContainerGroupDefinitionContainerMountPointAccessLevel']]:
        """
        The access permissions for the mounted path.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input['ContainerGroupDefinitionContainerMountPointAccessLevel']]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path inside the container where the mount is accessible.
        """
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_path", value)


if not MYPY:
    class ContainerGroupDefinitionContainerPortRangeArgsDict(TypedDict):
        """
        A set of one or more port numbers that can be opened on the container.
        """
        from_port: pulumi.Input[builtins.int]
        """
        A starting value for the range of allowed port numbers.
        """
        protocol: pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol']
        """
        Defines the protocol of these ports.
        """
        to_port: pulumi.Input[builtins.int]
        """
        An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
elif False:
    ContainerGroupDefinitionContainerPortRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerGroupDefinitionContainerPortRangeArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[builtins.int],
                 protocol: pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol'],
                 to_port: pulumi.Input[builtins.int]):
        """
        A set of one or more port numbers that can be opened on the container.
        :param pulumi.Input[builtins.int] from_port: A starting value for the range of allowed port numbers.
        :param pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol'] protocol: Defines the protocol of these ports.
        :param pulumi.Input[builtins.int] to_port: An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[builtins.int]:
        """
        A starting value for the range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol']:
        """
        Defines the protocol of these ports.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[builtins.int]:
        """
        An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "to_port", value)


if not MYPY:
    class ContainerGroupDefinitionGameServerContainerDefinitionArgsDict(TypedDict):
        """
        Specifies the information required to run game servers with this container group
        """
        container_name: pulumi.Input[builtins.str]
        """
        A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        """
        image_uri: pulumi.Input[builtins.str]
        """
        Specifies the image URI of this container.
        """
        server_sdk_version: pulumi.Input[builtins.str]
        """
        The version of the server SDK used in this container group
        """
        depends_on: NotRequired[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgsDict']]]]
        """
        A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        """
        environment_override: NotRequired[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgsDict']]]]
        """
        The environment variables to pass to a container.
        """
        mount_points: NotRequired[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgsDict']]]]
        """
        A list of mount point configurations to be used in a container.
        """
        port_configuration: NotRequired[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgsDict']]
        """
        Defines the ports on the container.
        """
        resolved_image_digest: NotRequired[pulumi.Input[builtins.str]]
        """
        The digest of the container image.
        """
elif False:
    ContainerGroupDefinitionGameServerContainerDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerGroupDefinitionGameServerContainerDefinitionArgs:
    def __init__(__self__, *,
                 container_name: pulumi.Input[builtins.str],
                 image_uri: pulumi.Input[builtins.str],
                 server_sdk_version: pulumi.Input[builtins.str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]] = None,
                 environment_override: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]] = None,
                 mount_points: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgs']]]] = None,
                 port_configuration: Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']] = None,
                 resolved_image_digest: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies the information required to run game servers with this container group
        :param pulumi.Input[builtins.str] container_name: A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        :param pulumi.Input[builtins.str] image_uri: Specifies the image URI of this container.
        :param pulumi.Input[builtins.str] server_sdk_version: The version of the server SDK used in this container group
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]] depends_on: A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]] environment_override: The environment variables to pass to a container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgs']]] mount_points: A list of mount point configurations to be used in a container.
        :param pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs'] port_configuration: Defines the ports on the container.
        :param pulumi.Input[builtins.str] resolved_image_digest: The digest of the container image.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "server_sdk_version", server_sdk_version)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if environment_override is not None:
            pulumi.set(__self__, "environment_override", environment_override)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if port_configuration is not None:
            pulumi.set(__self__, "port_configuration", port_configuration)
        if resolved_image_digest is not None:
            pulumi.set(__self__, "resolved_image_digest", resolved_image_digest)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[builtins.str]:
        """
        A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the image URI of this container.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="serverSdkVersion")
    def server_sdk_version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the server SDK used in this container group
        """
        return pulumi.get(self, "server_sdk_version")

    @server_sdk_version.setter
    def server_sdk_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server_sdk_version", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]]:
        """
        A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter(name="environmentOverride")
    def environment_override(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]]:
        """
        The environment variables to pass to a container.
        """
        return pulumi.get(self, "environment_override")

    @environment_override.setter
    def environment_override(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]]):
        pulumi.set(self, "environment_override", value)

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgs']]]]:
        """
        A list of mount point configurations to be used in a container.
        """
        return pulumi.get(self, "mount_points")

    @mount_points.setter
    def mount_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgs']]]]):
        pulumi.set(self, "mount_points", value)

    @property
    @pulumi.getter(name="portConfiguration")
    def port_configuration(self) -> Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']]:
        """
        Defines the ports on the container.
        """
        return pulumi.get(self, "port_configuration")

    @port_configuration.setter
    def port_configuration(self, value: Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']]):
        pulumi.set(self, "port_configuration", value)

    @property
    @pulumi.getter(name="resolvedImageDigest")
    def resolved_image_digest(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The digest of the container image.
        """
        return pulumi.get(self, "resolved_image_digest")

    @resolved_image_digest.setter
    def resolved_image_digest(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resolved_image_digest", value)


if not MYPY:
    class ContainerGroupDefinitionPortConfigurationArgsDict(TypedDict):
        """
        Defines the ports on a container.
        """
        container_port_ranges: pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgsDict']]]
        """
        Specifies one or more ranges of ports on a container.
        """
elif False:
    ContainerGroupDefinitionPortConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerGroupDefinitionPortConfigurationArgs:
    def __init__(__self__, *,
                 container_port_ranges: pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgs']]]):
        """
        Defines the ports on a container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgs']]] container_port_ranges: Specifies one or more ranges of ports on a container.
        """
        pulumi.set(__self__, "container_port_ranges", container_port_ranges)

    @property
    @pulumi.getter(name="containerPortRanges")
    def container_port_ranges(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgs']]]:
        """
        Specifies one or more ranges of ports on a container.
        """
        return pulumi.get(self, "container_port_ranges")

    @container_port_ranges.setter
    def container_port_ranges(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgs']]]):
        pulumi.set(self, "container_port_ranges", value)


if not MYPY:
    class ContainerGroupDefinitionSupportContainerDefinitionArgsDict(TypedDict):
        """
        Supports the function of the main container group
        """
        container_name: pulumi.Input[builtins.str]
        """
        A descriptive label for the container definition.
        """
        image_uri: pulumi.Input[builtins.str]
        """
        Specifies the image URI of this container.
        """
        depends_on: NotRequired[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgsDict']]]]
        """
        A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        """
        environment_override: NotRequired[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgsDict']]]]
        """
        The environment variables to pass to a container.
        """
        essential: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        """
        health_check: NotRequired[pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgsDict']]
        """
        Specifies how the health of the containers will be checked.
        """
        memory_hard_limit_mebibytes: NotRequired[pulumi.Input[builtins.int]]
        """
        The total memory limit of container groups following this definition in MiB
        """
        mount_points: NotRequired[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgsDict']]]]
        """
        A list of mount point configurations to be used in a container.
        """
        port_configuration: NotRequired[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgsDict']]
        """
        Defines the ports on the container.
        """
        resolved_image_digest: NotRequired[pulumi.Input[builtins.str]]
        """
        The digest of the container image.
        """
        vcpu: NotRequired[pulumi.Input[builtins.float]]
        """
        The number of virtual CPUs to give to the support group
        """
elif False:
    ContainerGroupDefinitionSupportContainerDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerGroupDefinitionSupportContainerDefinitionArgs:
    def __init__(__self__, *,
                 container_name: pulumi.Input[builtins.str],
                 image_uri: pulumi.Input[builtins.str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]] = None,
                 environment_override: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]] = None,
                 essential: Optional[pulumi.Input[builtins.bool]] = None,
                 health_check: Optional[pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgs']] = None,
                 memory_hard_limit_mebibytes: Optional[pulumi.Input[builtins.int]] = None,
                 mount_points: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgs']]]] = None,
                 port_configuration: Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']] = None,
                 resolved_image_digest: Optional[pulumi.Input[builtins.str]] = None,
                 vcpu: Optional[pulumi.Input[builtins.float]] = None):
        """
        Supports the function of the main container group
        :param pulumi.Input[builtins.str] container_name: A descriptive label for the container definition.
        :param pulumi.Input[builtins.str] image_uri: Specifies the image URI of this container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]] depends_on: A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]] environment_override: The environment variables to pass to a container.
        :param pulumi.Input[builtins.bool] essential: Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        :param pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgs'] health_check: Specifies how the health of the containers will be checked.
        :param pulumi.Input[builtins.int] memory_hard_limit_mebibytes: The total memory limit of container groups following this definition in MiB
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgs']]] mount_points: A list of mount point configurations to be used in a container.
        :param pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs'] port_configuration: Defines the ports on the container.
        :param pulumi.Input[builtins.str] resolved_image_digest: The digest of the container image.
        :param pulumi.Input[builtins.float] vcpu: The number of virtual CPUs to give to the support group
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image_uri", image_uri)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if environment_override is not None:
            pulumi.set(__self__, "environment_override", environment_override)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if memory_hard_limit_mebibytes is not None:
            pulumi.set(__self__, "memory_hard_limit_mebibytes", memory_hard_limit_mebibytes)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if port_configuration is not None:
            pulumi.set(__self__, "port_configuration", port_configuration)
        if resolved_image_digest is not None:
            pulumi.set(__self__, "resolved_image_digest", resolved_image_digest)
        if vcpu is not None:
            pulumi.set(__self__, "vcpu", vcpu)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[builtins.str]:
        """
        A descriptive label for the container definition.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the image URI of this container.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]]:
        """
        A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter(name="environmentOverride")
    def environment_override(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]]:
        """
        The environment variables to pass to a container.
        """
        return pulumi.get(self, "environment_override")

    @environment_override.setter
    def environment_override(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]]):
        pulumi.set(self, "environment_override", value)

    @property
    @pulumi.getter
    def essential(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        """
        return pulumi.get(self, "essential")

    @essential.setter
    def essential(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "essential", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgs']]:
        """
        Specifies how the health of the containers will be checked.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="memoryHardLimitMebibytes")
    def memory_hard_limit_mebibytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The total memory limit of container groups following this definition in MiB
        """
        return pulumi.get(self, "memory_hard_limit_mebibytes")

    @memory_hard_limit_mebibytes.setter
    def memory_hard_limit_mebibytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_hard_limit_mebibytes", value)

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgs']]]]:
        """
        A list of mount point configurations to be used in a container.
        """
        return pulumi.get(self, "mount_points")

    @mount_points.setter
    def mount_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerMountPointArgs']]]]):
        pulumi.set(self, "mount_points", value)

    @property
    @pulumi.getter(name="portConfiguration")
    def port_configuration(self) -> Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']]:
        """
        Defines the ports on the container.
        """
        return pulumi.get(self, "port_configuration")

    @port_configuration.setter
    def port_configuration(self, value: Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']]):
        pulumi.set(self, "port_configuration", value)

    @property
    @pulumi.getter(name="resolvedImageDigest")
    def resolved_image_digest(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The digest of the container image.
        """
        return pulumi.get(self, "resolved_image_digest")

    @resolved_image_digest.setter
    def resolved_image_digest(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resolved_image_digest", value)

    @property
    @pulumi.getter
    def vcpu(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of virtual CPUs to give to the support group
        """
        return pulumi.get(self, "vcpu")

    @vcpu.setter
    def vcpu(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "vcpu", value)


if not MYPY:
    class FleetAnywhereConfigurationArgsDict(TypedDict):
        """
        Configuration for Anywhere fleet.
        """
        cost: pulumi.Input[builtins.str]
        """
        Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
elif False:
    FleetAnywhereConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetAnywhereConfigurationArgs:
    def __init__(__self__, *,
                 cost: pulumi.Input[builtins.str]):
        """
        Configuration for Anywhere fleet.
        :param pulumi.Input[builtins.str] cost: Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
        pulumi.set(__self__, "cost", cost)

    @property
    @pulumi.getter
    def cost(self) -> pulumi.Input[builtins.str]:
        """
        Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
        return pulumi.get(self, "cost")

    @cost.setter
    def cost(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cost", value)


if not MYPY:
    class FleetCertificateConfigurationArgsDict(TypedDict):
        """
        Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
        """
        certificate_type: pulumi.Input['FleetCertificateConfigurationCertificateType']
        """
        Indicates whether a TLS/SSL certificate is generated for a fleet.

        Valid values include:

        - *GENERATED* - Generate a TLS/SSL certificate for this fleet.
        - *DISABLED* - (default) Do not generate a TLS/SSL certificate for this fleet.
        """
elif False:
    FleetCertificateConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetCertificateConfigurationArgs:
    def __init__(__self__, *,
                 certificate_type: pulumi.Input['FleetCertificateConfigurationCertificateType']):
        """
        Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
        :param pulumi.Input['FleetCertificateConfigurationCertificateType'] certificate_type: Indicates whether a TLS/SSL certificate is generated for a fleet.
               
               Valid values include:
               
               - *GENERATED* - Generate a TLS/SSL certificate for this fleet.
               - *DISABLED* - (default) Do not generate a TLS/SSL certificate for this fleet.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> pulumi.Input['FleetCertificateConfigurationCertificateType']:
        """
        Indicates whether a TLS/SSL certificate is generated for a fleet.

        Valid values include:

        - *GENERATED* - Generate a TLS/SSL certificate for this fleet.
        - *DISABLED* - (default) Do not generate a TLS/SSL certificate for this fleet.
        """
        return pulumi.get(self, "certificate_type")

    @certificate_type.setter
    def certificate_type(self, value: pulumi.Input['FleetCertificateConfigurationCertificateType']):
        pulumi.set(self, "certificate_type", value)


if not MYPY:
    class FleetIpPermissionArgsDict(TypedDict):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        """
        from_port: pulumi.Input[builtins.int]
        """
        A starting value for a range of allowed port numbers.
        """
        ip_range: pulumi.Input[builtins.str]
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        protocol: pulumi.Input['FleetIpPermissionProtocol']
        """
        The network communication protocol used by the fleet.
        """
        to_port: pulumi.Input[builtins.int]
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
elif False:
    FleetIpPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetIpPermissionArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[builtins.int],
                 ip_range: pulumi.Input[builtins.str],
                 protocol: pulumi.Input['FleetIpPermissionProtocol'],
                 to_port: pulumi.Input[builtins.int]):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        :param pulumi.Input[builtins.int] from_port: A starting value for a range of allowed port numbers.
        :param pulumi.Input[builtins.str] ip_range: A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        :param pulumi.Input['FleetIpPermissionProtocol'] protocol: The network communication protocol used by the fleet.
        :param pulumi.Input[builtins.int] to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[builtins.int]:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Input[builtins.str]:
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['FleetIpPermissionProtocol']:
        """
        The network communication protocol used by the fleet.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['FleetIpPermissionProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[builtins.int]:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "to_port", value)


if not MYPY:
    class FleetLocationCapacityArgsDict(TypedDict):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        """
        desired_ec2_instances: pulumi.Input[builtins.int]
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        max_size: pulumi.Input[builtins.int]
        """
        The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        """
        min_size: pulumi.Input[builtins.int]
        """
        The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
elif False:
    FleetLocationCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetLocationCapacityArgs:
    def __init__(__self__, *,
                 desired_ec2_instances: pulumi.Input[builtins.int],
                 max_size: pulumi.Input[builtins.int],
                 min_size: pulumi.Input[builtins.int]):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        :param pulumi.Input[builtins.int] desired_ec2_instances: The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        :param pulumi.Input[builtins.int] max_size: The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        :param pulumi.Input[builtins.int] min_size: The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        pulumi.set(__self__, "desired_ec2_instances", desired_ec2_instances)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredEc2Instances")
    def desired_ec2_instances(self) -> pulumi.Input[builtins.int]:
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @desired_ec2_instances.setter
    def desired_ec2_instances(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "desired_ec2_instances", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[builtins.int]:
        """
        The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[builtins.int]:
        """
        The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_size", value)


if not MYPY:
    class FleetLocationConfigurationArgsDict(TypedDict):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        """
        location: pulumi.Input[builtins.str]
        """
        An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        location_capacity: NotRequired[pulumi.Input['FleetLocationCapacityArgsDict']]
        """
        Current resource capacity settings for managed EC2 fleets and managed container fleets. For multi-location fleets, location values might refer to a fleet's remote location or its home Region.

        *Returned by:* [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) , [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html) , [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
        """
elif False:
    FleetLocationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetLocationConfigurationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 location_capacity: Optional[pulumi.Input['FleetLocationCapacityArgs']] = None):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        :param pulumi.Input[builtins.str] location: An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        :param pulumi.Input['FleetLocationCapacityArgs'] location_capacity: Current resource capacity settings for managed EC2 fleets and managed container fleets. For multi-location fleets, location values might refer to a fleet's remote location or its home Region.
               
               *Returned by:* [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) , [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html) , [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
        """
        pulumi.set(__self__, "location", location)
        if location_capacity is not None:
            pulumi.set(__self__, "location_capacity", location_capacity)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationCapacity")
    def location_capacity(self) -> Optional[pulumi.Input['FleetLocationCapacityArgs']]:
        """
        Current resource capacity settings for managed EC2 fleets and managed container fleets. For multi-location fleets, location values might refer to a fleet's remote location or its home Region.

        *Returned by:* [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) , [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html) , [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
        """
        return pulumi.get(self, "location_capacity")

    @location_capacity.setter
    def location_capacity(self, value: Optional[pulumi.Input['FleetLocationCapacityArgs']]):
        pulumi.set(self, "location_capacity", value)


if not MYPY:
    class FleetResourceCreationLimitPolicyArgsDict(TypedDict):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        """
        new_game_sessions_per_creator: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        policy_period_in_minutes: NotRequired[pulumi.Input[builtins.int]]
        """
        The time span used in evaluating the resource creation limit policy.
        """
elif False:
    FleetResourceCreationLimitPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetResourceCreationLimitPolicyArgs:
    def __init__(__self__, *,
                 new_game_sessions_per_creator: Optional[pulumi.Input[builtins.int]] = None,
                 policy_period_in_minutes: Optional[pulumi.Input[builtins.int]] = None):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        :param pulumi.Input[builtins.int] new_game_sessions_per_creator: The maximum number of game sessions that an individual can create during the policy period.
        :param pulumi.Input[builtins.int] policy_period_in_minutes: The time span used in evaluating the resource creation limit policy.
        """
        if new_game_sessions_per_creator is not None:
            pulumi.set(__self__, "new_game_sessions_per_creator", new_game_sessions_per_creator)
        if policy_period_in_minutes is not None:
            pulumi.set(__self__, "policy_period_in_minutes", policy_period_in_minutes)

    @property
    @pulumi.getter(name="newGameSessionsPerCreator")
    def new_game_sessions_per_creator(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        return pulumi.get(self, "new_game_sessions_per_creator")

    @new_game_sessions_per_creator.setter
    def new_game_sessions_per_creator(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "new_game_sessions_per_creator", value)

    @property
    @pulumi.getter(name="policyPeriodInMinutes")
    def policy_period_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time span used in evaluating the resource creation limit policy.
        """
        return pulumi.get(self, "policy_period_in_minutes")

    @policy_period_in_minutes.setter
    def policy_period_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "policy_period_in_minutes", value)


if not MYPY:
    class FleetRuntimeConfigurationArgsDict(TypedDict):
        """
        A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

        The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

        An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
        """
        game_session_activation_timeout_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        """
        max_concurrent_game_session_activations: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        """
        server_processes: NotRequired[pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgsDict']]]]
        """
        A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
elif False:
    FleetRuntimeConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetRuntimeConfigurationArgs:
    def __init__(__self__, *,
                 game_session_activation_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrent_game_session_activations: Optional[pulumi.Input[builtins.int]] = None,
                 server_processes: Optional[pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgs']]]] = None):
        """
        A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

        The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

        An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
        :param pulumi.Input[builtins.int] game_session_activation_timeout_seconds: The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        :param pulumi.Input[builtins.int] max_concurrent_game_session_activations: The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        :param pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgs']]] server_processes: A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        if game_session_activation_timeout_seconds is not None:
            pulumi.set(__self__, "game_session_activation_timeout_seconds", game_session_activation_timeout_seconds)
        if max_concurrent_game_session_activations is not None:
            pulumi.set(__self__, "max_concurrent_game_session_activations", max_concurrent_game_session_activations)
        if server_processes is not None:
            pulumi.set(__self__, "server_processes", server_processes)

    @property
    @pulumi.getter(name="gameSessionActivationTimeoutSeconds")
    def game_session_activation_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        """
        return pulumi.get(self, "game_session_activation_timeout_seconds")

    @game_session_activation_timeout_seconds.setter
    def game_session_activation_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "game_session_activation_timeout_seconds", value)

    @property
    @pulumi.getter(name="maxConcurrentGameSessionActivations")
    def max_concurrent_game_session_activations(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        """
        return pulumi.get(self, "max_concurrent_game_session_activations")

    @max_concurrent_game_session_activations.setter
    def max_concurrent_game_session_activations(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_concurrent_game_session_activations", value)

    @property
    @pulumi.getter(name="serverProcesses")
    def server_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgs']]]]:
        """
        A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        return pulumi.get(self, "server_processes")

    @server_processes.setter
    def server_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgs']]]]):
        pulumi.set(self, "server_processes", value)


if not MYPY:
    class FleetScalingPolicyArgsDict(TypedDict):
        """
        Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
        """
        metric_name: pulumi.Input['FleetScalingPolicyMetricName']
        """
        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        """
        name: pulumi.Input[builtins.str]
        """
        A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        """
        comparison_operator: NotRequired[pulumi.Input['FleetScalingPolicyComparisonOperator']]
        """
        Comparison operator to use when measuring a metric against the threshold value.
        """
        evaluation_periods: NotRequired[pulumi.Input[builtins.int]]
        """
        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        """
        location: NotRequired[pulumi.Input[builtins.str]]
        """
        The fleet location.
        """
        policy_type: NotRequired[pulumi.Input['FleetScalingPolicyPolicyType']]
        """
        The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        """
        scaling_adjustment: NotRequired[pulumi.Input[builtins.int]]
        """
        Amount of adjustment to make, based on the scaling adjustment type.
        """
        scaling_adjustment_type: NotRequired[pulumi.Input['FleetScalingPolicyScalingAdjustmentType']]
        """
        The type of adjustment to make to a fleet's instance count.
        """
        status: NotRequired[pulumi.Input['FleetScalingPolicyStatus']]
        """
        Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        """
        target_configuration: NotRequired[pulumi.Input['FleetTargetConfigurationArgsDict']]
        """
        An object that contains settings for a target-based scaling policy.
        """
        threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        Metric value used to trigger a scaling event.
        """
        update_status: NotRequired[pulumi.Input['FleetScalingPolicyUpdateStatus']]
        """
        The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
elif False:
    FleetScalingPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetScalingPolicyArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input['FleetScalingPolicyMetricName'],
                 name: pulumi.Input[builtins.str],
                 comparison_operator: Optional[pulumi.Input['FleetScalingPolicyComparisonOperator']] = None,
                 evaluation_periods: Optional[pulumi.Input[builtins.int]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 policy_type: Optional[pulumi.Input['FleetScalingPolicyPolicyType']] = None,
                 scaling_adjustment: Optional[pulumi.Input[builtins.int]] = None,
                 scaling_adjustment_type: Optional[pulumi.Input['FleetScalingPolicyScalingAdjustmentType']] = None,
                 status: Optional[pulumi.Input['FleetScalingPolicyStatus']] = None,
                 target_configuration: Optional[pulumi.Input['FleetTargetConfigurationArgs']] = None,
                 threshold: Optional[pulumi.Input[builtins.float]] = None,
                 update_status: Optional[pulumi.Input['FleetScalingPolicyUpdateStatus']] = None):
        """
        Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
        :param pulumi.Input['FleetScalingPolicyMetricName'] metric_name: Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        :param pulumi.Input[builtins.str] name: A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        :param pulumi.Input['FleetScalingPolicyComparisonOperator'] comparison_operator: Comparison operator to use when measuring a metric against the threshold value.
        :param pulumi.Input[builtins.int] evaluation_periods: Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        :param pulumi.Input[builtins.str] location: The fleet location.
        :param pulumi.Input['FleetScalingPolicyPolicyType'] policy_type: The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        :param pulumi.Input[builtins.int] scaling_adjustment: Amount of adjustment to make, based on the scaling adjustment type.
        :param pulumi.Input['FleetScalingPolicyScalingAdjustmentType'] scaling_adjustment_type: The type of adjustment to make to a fleet's instance count.
        :param pulumi.Input['FleetScalingPolicyStatus'] status: Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        :param pulumi.Input['FleetTargetConfigurationArgs'] target_configuration: An object that contains settings for a target-based scaling policy.
        :param pulumi.Input[builtins.float] threshold: Metric value used to trigger a scaling event.
        :param pulumi.Input['FleetScalingPolicyUpdateStatus'] update_status: The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if scaling_adjustment_type is not None:
            pulumi.set(__self__, "scaling_adjustment_type", scaling_adjustment_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if update_status is not None:
            pulumi.set(__self__, "update_status", update_status)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input['FleetScalingPolicyMetricName']:
        """
        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input['FleetScalingPolicyMetricName']):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[pulumi.Input['FleetScalingPolicyComparisonOperator']]:
        """
        Comparison operator to use when measuring a metric against the threshold value.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: Optional[pulumi.Input['FleetScalingPolicyComparisonOperator']]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fleet location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input['FleetScalingPolicyPolicyType']]:
        """
        The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input['FleetScalingPolicyPolicyType']]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of adjustment to make, based on the scaling adjustment type.
        """
        return pulumi.get(self, "scaling_adjustment")

    @scaling_adjustment.setter
    def scaling_adjustment(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "scaling_adjustment", value)

    @property
    @pulumi.getter(name="scalingAdjustmentType")
    def scaling_adjustment_type(self) -> Optional[pulumi.Input['FleetScalingPolicyScalingAdjustmentType']]:
        """
        The type of adjustment to make to a fleet's instance count.
        """
        return pulumi.get(self, "scaling_adjustment_type")

    @scaling_adjustment_type.setter
    def scaling_adjustment_type(self, value: Optional[pulumi.Input['FleetScalingPolicyScalingAdjustmentType']]):
        pulumi.set(self, "scaling_adjustment_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['FleetScalingPolicyStatus']]:
        """
        Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['FleetScalingPolicyStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional[pulumi.Input['FleetTargetConfigurationArgs']]:
        """
        An object that contains settings for a target-based scaling policy.
        """
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: Optional[pulumi.Input['FleetTargetConfigurationArgs']]):
        pulumi.set(self, "target_configuration", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Metric value used to trigger a scaling event.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="updateStatus")
    def update_status(self) -> Optional[pulumi.Input['FleetScalingPolicyUpdateStatus']]:
        """
        The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
        return pulumi.get(self, "update_status")

    @update_status.setter
    def update_status(self, value: Optional[pulumi.Input['FleetScalingPolicyUpdateStatus']]):
        pulumi.set(self, "update_status", value)


if not MYPY:
    class FleetServerProcessArgsDict(TypedDict):
        """
        A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
        """
        concurrent_executions: pulumi.Input[builtins.int]
        """
        The number of server processes that use this configuration to run concurrently on an instance.
        """
        launch_path: pulumi.Input[builtins.str]
        """
        The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:

        Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"

        Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        """
        parameters: NotRequired[pulumi.Input[builtins.str]]
        """
        An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
elif False:
    FleetServerProcessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetServerProcessArgs:
    def __init__(__self__, *,
                 concurrent_executions: pulumi.Input[builtins.int],
                 launch_path: pulumi.Input[builtins.str],
                 parameters: Optional[pulumi.Input[builtins.str]] = None):
        """
        A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
        :param pulumi.Input[builtins.int] concurrent_executions: The number of server processes that use this configuration to run concurrently on an instance.
        :param pulumi.Input[builtins.str] launch_path: The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:
               
               Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"
               
               Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        :param pulumi.Input[builtins.str] parameters: An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        pulumi.set(__self__, "concurrent_executions", concurrent_executions)
        pulumi.set(__self__, "launch_path", launch_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="concurrentExecutions")
    def concurrent_executions(self) -> pulumi.Input[builtins.int]:
        """
        The number of server processes that use this configuration to run concurrently on an instance.
        """
        return pulumi.get(self, "concurrent_executions")

    @concurrent_executions.setter
    def concurrent_executions(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "concurrent_executions", value)

    @property
    @pulumi.getter(name="launchPath")
    def launch_path(self) -> pulumi.Input[builtins.str]:
        """
        The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:

        Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"

        Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        """
        return pulumi.get(self, "launch_path")

    @launch_path.setter
    def launch_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "launch_path", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class FleetTargetConfigurationArgsDict(TypedDict):
        """
        Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
        """
        target_value: pulumi.Input[builtins.float]
        """
        Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
elif False:
    FleetTargetConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetTargetConfigurationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[builtins.float]):
        """
        Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
        :param pulumi.Input[builtins.float] target_value: Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[builtins.float]:
        """
        Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "target_value", value)


if not MYPY:
    class GameServerGroupAutoScalingPolicyArgsDict(TypedDict):
        """
        Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        """
        target_tracking_configuration: pulumi.Input['GameServerGroupTargetTrackingConfigurationArgsDict']
        """
        Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric `PercentUtilizedGameServers` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
        """
        estimated_instance_warmup: NotRequired[pulumi.Input[builtins.float]]
        """
        Length of time, in seconds, it takes for a new instance to start new game server processes and register with Amazon GameLift Servers FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances.
        """
elif False:
    GameServerGroupAutoScalingPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GameServerGroupAutoScalingPolicyArgs:
    def __init__(__self__, *,
                 target_tracking_configuration: pulumi.Input['GameServerGroupTargetTrackingConfigurationArgs'],
                 estimated_instance_warmup: Optional[pulumi.Input[builtins.float]] = None):
        """
        Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        :param pulumi.Input['GameServerGroupTargetTrackingConfigurationArgs'] target_tracking_configuration: Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric `PercentUtilizedGameServers` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
        :param pulumi.Input[builtins.float] estimated_instance_warmup: Length of time, in seconds, it takes for a new instance to start new game server processes and register with Amazon GameLift Servers FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances.
        """
        pulumi.set(__self__, "target_tracking_configuration", target_tracking_configuration)
        if estimated_instance_warmup is not None:
            pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)

    @property
    @pulumi.getter(name="targetTrackingConfiguration")
    def target_tracking_configuration(self) -> pulumi.Input['GameServerGroupTargetTrackingConfigurationArgs']:
        """
        Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric `PercentUtilizedGameServers` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
        """
        return pulumi.get(self, "target_tracking_configuration")

    @target_tracking_configuration.setter
    def target_tracking_configuration(self, value: pulumi.Input['GameServerGroupTargetTrackingConfigurationArgs']):
        pulumi.set(self, "target_tracking_configuration", value)

    @property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Length of time, in seconds, it takes for a new instance to start new game server processes and register with Amazon GameLift Servers FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances.
        """
        return pulumi.get(self, "estimated_instance_warmup")

    @estimated_instance_warmup.setter
    def estimated_instance_warmup(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "estimated_instance_warmup", value)


if not MYPY:
    class GameServerGroupInstanceDefinitionArgsDict(TypedDict):
        """
        An allowed instance type for your game server group.
        """
        instance_type: pulumi.Input[builtins.str]
        weighted_capacity: NotRequired[pulumi.Input[builtins.str]]
elif False:
    GameServerGroupInstanceDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GameServerGroupInstanceDefinitionArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[builtins.str],
                 weighted_capacity: Optional[pulumi.Input[builtins.str]] = None):
        """
        An allowed instance type for your game server group.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "weighted_capacity")

    @weighted_capacity.setter
    def weighted_capacity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "weighted_capacity", value)


if not MYPY:
    class GameServerGroupLaunchTemplateArgsDict(TypedDict):
        """
        The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        """
        launch_template_id: NotRequired[pulumi.Input[builtins.str]]
        """
        A unique identifier for an existing Amazon EC2 launch template.
        """
        launch_template_name: NotRequired[pulumi.Input[builtins.str]]
        """
        A readable identifier for an existing Amazon EC2 launch template.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.
        """
elif False:
    GameServerGroupLaunchTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GameServerGroupLaunchTemplateArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        :param pulumi.Input[builtins.str] launch_template_id: A unique identifier for an existing Amazon EC2 launch template.
        :param pulumi.Input[builtins.str] launch_template_name: A readable identifier for an existing Amazon EC2 launch template.
        :param pulumi.Input[builtins.str] version: The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for an existing Amazon EC2 launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A readable identifier for an existing Amazon EC2 launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class GameServerGroupTargetTrackingConfigurationArgsDict(TypedDict):
        """
        Settings for a target-based scaling policy applied to Auto Scaling group.
        """
        target_value: pulumi.Input[builtins.float]
        """
        Desired value to use with a game server group target-based scaling policy.
        """
elif False:
    GameServerGroupTargetTrackingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GameServerGroupTargetTrackingConfigurationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[builtins.float]):
        """
        Settings for a target-based scaling policy applied to Auto Scaling group.
        :param pulumi.Input[builtins.float] target_value: Desired value to use with a game server group target-based scaling policy.
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[builtins.float]:
        """
        Desired value to use with a game server group target-based scaling policy.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "target_value", value)


if not MYPY:
    class GameSessionQueueDestinationArgsDict(TypedDict):
        """
        A fleet or alias designated in a game session queue.
        """
        destination_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions.
        """
elif False:
    GameSessionQueueDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GameSessionQueueDestinationArgs:
    def __init__(__self__, *,
                 destination_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        A fleet or alias designated in a game session queue.
        :param pulumi.Input[builtins.str] destination_arn: The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions.
        """
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions.
        """
        return pulumi.get(self, "destination_arn")

    @destination_arn.setter
    def destination_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_arn", value)


if not MYPY:
    class GameSessionQueueFilterConfigurationArgsDict(TypedDict):
        allowed_locations: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of locations to allow game session placement in, in the form of AWS Region codes such as `us-west-2` .
        """
elif False:
    GameSessionQueueFilterConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GameSessionQueueFilterConfigurationArgs:
    def __init__(__self__, *,
                 allowed_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_locations: A list of locations to allow game session placement in, in the form of AWS Region codes such as `us-west-2` .
        """
        if allowed_locations is not None:
            pulumi.set(__self__, "allowed_locations", allowed_locations)

    @property
    @pulumi.getter(name="allowedLocations")
    def allowed_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of locations to allow game session placement in, in the form of AWS Region codes such as `us-west-2` .
        """
        return pulumi.get(self, "allowed_locations")

    @allowed_locations.setter
    def allowed_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_locations", value)


if not MYPY:
    class GameSessionQueuePlayerLatencyPolicyArgsDict(TypedDict):
        """
        Sets a latency cap for individual players when placing a game session.
        """
        maximum_individual_player_latency_milliseconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        """
        policy_duration_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
elif False:
    GameSessionQueuePlayerLatencyPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GameSessionQueuePlayerLatencyPolicyArgs:
    def __init__(__self__, *,
                 maximum_individual_player_latency_milliseconds: Optional[pulumi.Input[builtins.int]] = None,
                 policy_duration_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        Sets a latency cap for individual players when placing a game session.
        :param pulumi.Input[builtins.int] maximum_individual_player_latency_milliseconds: The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        :param pulumi.Input[builtins.int] policy_duration_seconds: The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
        if maximum_individual_player_latency_milliseconds is not None:
            pulumi.set(__self__, "maximum_individual_player_latency_milliseconds", maximum_individual_player_latency_milliseconds)
        if policy_duration_seconds is not None:
            pulumi.set(__self__, "policy_duration_seconds", policy_duration_seconds)

    @property
    @pulumi.getter(name="maximumIndividualPlayerLatencyMilliseconds")
    def maximum_individual_player_latency_milliseconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        """
        return pulumi.get(self, "maximum_individual_player_latency_milliseconds")

    @maximum_individual_player_latency_milliseconds.setter
    def maximum_individual_player_latency_milliseconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_individual_player_latency_milliseconds", value)

    @property
    @pulumi.getter(name="policyDurationSeconds")
    def policy_duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
        return pulumi.get(self, "policy_duration_seconds")

    @policy_duration_seconds.setter
    def policy_duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "policy_duration_seconds", value)


if not MYPY:
    class GameSessionQueuePriorityConfigurationArgsDict(TypedDict):
        location_order: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The prioritization order to use for fleet locations, when the `PriorityOrder` property includes `LOCATION` . Locations can include AWS Region codes (such as `us-west-2` ), local zones, and custom locations (for Anywhere fleets). Each location must be listed only once. For details, see [Amazon GameLift Servers service locations.](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
        """
        priority_order: NotRequired[pulumi.Input[Sequence[pulumi.Input['GameSessionQueuePriorityOrderItem']]]]
        """
        A custom sequence to use when prioritizing where to place new game sessions. Each priority type is listed once.

        - `LATENCY` -- Amazon GameLift Servers prioritizes locations where the average player latency is lowest. Player latency data is provided in each game session placement request.
        - `COST` -- Amazon GameLift Servers prioritizes queue destinations with the lowest current hosting costs. Cost is evaluated based on the destination's location, instance type, and fleet type (Spot or On-Demand).
        - `DESTINATION` -- Amazon GameLift Servers prioritizes based on the list order of destinations in the queue configuration.
        - `LOCATION` -- Amazon GameLift Servers prioritizes based on the provided order of locations, as defined in `LocationOrder` .
        """
elif False:
    GameSessionQueuePriorityConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GameSessionQueuePriorityConfigurationArgs:
    def __init__(__self__, *,
                 location_order: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 priority_order: Optional[pulumi.Input[Sequence[pulumi.Input['GameSessionQueuePriorityOrderItem']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] location_order: The prioritization order to use for fleet locations, when the `PriorityOrder` property includes `LOCATION` . Locations can include AWS Region codes (such as `us-west-2` ), local zones, and custom locations (for Anywhere fleets). Each location must be listed only once. For details, see [Amazon GameLift Servers service locations.](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
        :param pulumi.Input[Sequence[pulumi.Input['GameSessionQueuePriorityOrderItem']]] priority_order: A custom sequence to use when prioritizing where to place new game sessions. Each priority type is listed once.
               
               - `LATENCY` -- Amazon GameLift Servers prioritizes locations where the average player latency is lowest. Player latency data is provided in each game session placement request.
               - `COST` -- Amazon GameLift Servers prioritizes queue destinations with the lowest current hosting costs. Cost is evaluated based on the destination's location, instance type, and fleet type (Spot or On-Demand).
               - `DESTINATION` -- Amazon GameLift Servers prioritizes based on the list order of destinations in the queue configuration.
               - `LOCATION` -- Amazon GameLift Servers prioritizes based on the provided order of locations, as defined in `LocationOrder` .
        """
        if location_order is not None:
            pulumi.set(__self__, "location_order", location_order)
        if priority_order is not None:
            pulumi.set(__self__, "priority_order", priority_order)

    @property
    @pulumi.getter(name="locationOrder")
    def location_order(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The prioritization order to use for fleet locations, when the `PriorityOrder` property includes `LOCATION` . Locations can include AWS Region codes (such as `us-west-2` ), local zones, and custom locations (for Anywhere fleets). Each location must be listed only once. For details, see [Amazon GameLift Servers service locations.](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
        """
        return pulumi.get(self, "location_order")

    @location_order.setter
    def location_order(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "location_order", value)

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GameSessionQueuePriorityOrderItem']]]]:
        """
        A custom sequence to use when prioritizing where to place new game sessions. Each priority type is listed once.

        - `LATENCY` -- Amazon GameLift Servers prioritizes locations where the average player latency is lowest. Player latency data is provided in each game session placement request.
        - `COST` -- Amazon GameLift Servers prioritizes queue destinations with the lowest current hosting costs. Cost is evaluated based on the destination's location, instance type, and fleet type (Spot or On-Demand).
        - `DESTINATION` -- Amazon GameLift Servers prioritizes based on the list order of destinations in the queue configuration.
        - `LOCATION` -- Amazon GameLift Servers prioritizes based on the provided order of locations, as defined in `LocationOrder` .
        """
        return pulumi.get(self, "priority_order")

    @priority_order.setter
    def priority_order(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GameSessionQueuePriorityOrderItem']]]]):
        pulumi.set(self, "priority_order", value)


if not MYPY:
    class MatchmakingConfigurationGamePropertyArgsDict(TypedDict):
        """
        A key-value pair that contains information about a game session.
        """
        key: pulumi.Input[builtins.str]
        """
        The game property identifier.
        """
        value: pulumi.Input[builtins.str]
        """
        The game property value.
        """
elif False:
    MatchmakingConfigurationGamePropertyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MatchmakingConfigurationGamePropertyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        A key-value pair that contains information about a game session.
        :param pulumi.Input[builtins.str] key: The game property identifier.
        :param pulumi.Input[builtins.str] value: The game property value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The game property identifier.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The game property value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ScriptS3LocationArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        key: pulumi.Input[builtins.str]
        """
        The name of the zip file that contains the script files.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        object_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
elif False:
    ScriptS3LocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScriptS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 object_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        :param pulumi.Input[builtins.str] key: The name of the zip file that contains the script files.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        :param pulumi.Input[builtins.str] object_version: The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The name of the zip file that contains the script files.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_version", value)


